# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class WDADatasetInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'server_name': 'str',
        'agent_name': 'str',
        'conn_profile_name': 'str',
        'dataset_query': 'str'
    }

    attribute_map = {
        'server_name': 'serverName',
        'agent_name': 'agentName',
        'conn_profile_name': 'connProfileName',
        'dataset_query': 'datasetQuery'
    }

    def __init__(self, server_name=None, agent_name=None, conn_profile_name=None, dataset_query=None, local_vars_configuration=None):  # noqa: E501
        """WDADatasetInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._server_name = None
        self._agent_name = None
        self._conn_profile_name = None
        self._dataset_query = None
        self.discriminator = None

        if server_name is not None:
            self.server_name = server_name
        if agent_name is not None:
            self.agent_name = agent_name
        if conn_profile_name is not None:
            self.conn_profile_name = conn_profile_name
        if dataset_query is not None:
            self.dataset_query = dataset_query

    @property
    def server_name(self):
        """Gets the server_name of this WDADatasetInput.  # noqa: E501

        Server name  # noqa: E501

        :return: The server_name of this WDADatasetInput.  # noqa: E501
        :rtype: str
        """
        return self._server_name

    @server_name.setter
    def server_name(self, server_name):
        """Sets the server_name of this WDADatasetInput.

        Server name  # noqa: E501

        :param server_name: The server_name of this WDADatasetInput.  # noqa: E501
        :type server_name: str
        """

        self._server_name = server_name

    @property
    def agent_name(self):
        """Gets the agent_name of this WDADatasetInput.  # noqa: E501

        Agent name  # noqa: E501

        :return: The agent_name of this WDADatasetInput.  # noqa: E501
        :rtype: str
        """
        return self._agent_name

    @agent_name.setter
    def agent_name(self, agent_name):
        """Sets the agent_name of this WDADatasetInput.

        Agent name  # noqa: E501

        :param agent_name: The agent_name of this WDADatasetInput.  # noqa: E501
        :type agent_name: str
        """

        self._agent_name = agent_name

    @property
    def conn_profile_name(self):
        """Gets the conn_profile_name of this WDADatasetInput.  # noqa: E501

        Connection profile name  # noqa: E501

        :return: The conn_profile_name of this WDADatasetInput.  # noqa: E501
        :rtype: str
        """
        return self._conn_profile_name

    @conn_profile_name.setter
    def conn_profile_name(self, conn_profile_name):
        """Sets the conn_profile_name of this WDADatasetInput.

        Connection profile name  # noqa: E501

        :param conn_profile_name: The conn_profile_name of this WDADatasetInput.  # noqa: E501
        :type conn_profile_name: str
        """

        self._conn_profile_name = conn_profile_name

    @property
    def dataset_query(self):
        """Gets the dataset_query of this WDADatasetInput.  # noqa: E501

        Dataset Query  # noqa: E501

        :return: The dataset_query of this WDADatasetInput.  # noqa: E501
        :rtype: str
        """
        return self._dataset_query

    @dataset_query.setter
    def dataset_query(self, dataset_query):
        """Sets the dataset_query of this WDADatasetInput.

        Dataset Query  # noqa: E501

        :param dataset_query: The dataset_query of this WDADatasetInput.  # noqa: E501
        :type dataset_query: str
        """

        self._dataset_query = dataset_query

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WDADatasetInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WDADatasetInput):
            return True

        return self.to_dict() != other.to_dict()
