# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class WorkbenchImportResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'deployment_file': 'str',
        'poll_id': 'str',
        'deployment_state': 'str',
        'deployment_status': 'str',
        'successful_folders_count': 'int',
        'successful_smart_folders_count': 'int',
        'successful_sub_folders_count': 'int',
        'successful_jobs_count': 'int',
        'successful_connection_profiles_count': 'int',
        'successful_drivers_count': 'int',
        'successful_calendars_count': 'int',
        'successful_site_standards_count': 'int',
        'is_deploy_descriptor_valid': 'bool',
        'deployed_folders': 'list[str]',
        'deployed_jobs': 'list[str]',
        'deployed_sub_folders': 'list[str]',
        'deployed_drivers': 'list[str]',
        'deployed_connection_profiles': 'list[str]',
        'deployed_calendars': 'list[str]',
        'deployed_site_standards': 'list[str]',
        'deployed_ai_plugins': 'list[str]',
        'errors': 'list[DeploymentFileError]',
        'warnings': 'list[WarningData]'
    }

    attribute_map = {
        'deployment_file': 'deploymentFile',
        'poll_id': 'pollId',
        'deployment_state': 'deploymentState',
        'deployment_status': 'deploymentStatus',
        'successful_folders_count': 'successfulFoldersCount',
        'successful_smart_folders_count': 'successfulSmartFoldersCount',
        'successful_sub_folders_count': 'successfulSubFoldersCount',
        'successful_jobs_count': 'successfulJobsCount',
        'successful_connection_profiles_count': 'successfulConnectionProfilesCount',
        'successful_drivers_count': 'successfulDriversCount',
        'successful_calendars_count': 'successfulCalendarsCount',
        'successful_site_standards_count': 'successfulSiteStandardsCount',
        'is_deploy_descriptor_valid': 'isDeployDescriptorValid',
        'deployed_folders': 'deployedFolders',
        'deployed_jobs': 'deployedJobs',
        'deployed_sub_folders': 'deployedSubFolders',
        'deployed_drivers': 'deployedDrivers',
        'deployed_connection_profiles': 'deployedConnectionProfiles',
        'deployed_calendars': 'deployedCalendars',
        'deployed_site_standards': 'deployedSiteStandards',
        'deployed_ai_plugins': 'deployedAIPlugins',
        'errors': 'errors',
        'warnings': 'warnings'
    }

    def __init__(self, deployment_file=None, poll_id=None, deployment_state=None, deployment_status=None, successful_folders_count=None, successful_smart_folders_count=None, successful_sub_folders_count=None, successful_jobs_count=None, successful_connection_profiles_count=None, successful_drivers_count=None, successful_calendars_count=None, successful_site_standards_count=None, is_deploy_descriptor_valid=None, deployed_folders=None, deployed_jobs=None, deployed_sub_folders=None, deployed_drivers=None, deployed_connection_profiles=None, deployed_calendars=None, deployed_site_standards=None, deployed_ai_plugins=None, errors=None, warnings=None, local_vars_configuration=None):  # noqa: E501
        """WorkbenchImportResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._deployment_file = None
        self._poll_id = None
        self._deployment_state = None
        self._deployment_status = None
        self._successful_folders_count = None
        self._successful_smart_folders_count = None
        self._successful_sub_folders_count = None
        self._successful_jobs_count = None
        self._successful_connection_profiles_count = None
        self._successful_drivers_count = None
        self._successful_calendars_count = None
        self._successful_site_standards_count = None
        self._is_deploy_descriptor_valid = None
        self._deployed_folders = None
        self._deployed_jobs = None
        self._deployed_sub_folders = None
        self._deployed_drivers = None
        self._deployed_connection_profiles = None
        self._deployed_calendars = None
        self._deployed_site_standards = None
        self._deployed_ai_plugins = None
        self._errors = None
        self._warnings = None
        self.discriminator = None

        if deployment_file is not None:
            self.deployment_file = deployment_file
        if poll_id is not None:
            self.poll_id = poll_id
        if deployment_state is not None:
            self.deployment_state = deployment_state
        if deployment_status is not None:
            self.deployment_status = deployment_status
        if successful_folders_count is not None:
            self.successful_folders_count = successful_folders_count
        if successful_smart_folders_count is not None:
            self.successful_smart_folders_count = successful_smart_folders_count
        if successful_sub_folders_count is not None:
            self.successful_sub_folders_count = successful_sub_folders_count
        if successful_jobs_count is not None:
            self.successful_jobs_count = successful_jobs_count
        if successful_connection_profiles_count is not None:
            self.successful_connection_profiles_count = successful_connection_profiles_count
        if successful_drivers_count is not None:
            self.successful_drivers_count = successful_drivers_count
        if successful_calendars_count is not None:
            self.successful_calendars_count = successful_calendars_count
        if successful_site_standards_count is not None:
            self.successful_site_standards_count = successful_site_standards_count
        if is_deploy_descriptor_valid is not None:
            self.is_deploy_descriptor_valid = is_deploy_descriptor_valid
        if deployed_folders is not None:
            self.deployed_folders = deployed_folders
        if deployed_jobs is not None:
            self.deployed_jobs = deployed_jobs
        if deployed_sub_folders is not None:
            self.deployed_sub_folders = deployed_sub_folders
        if deployed_drivers is not None:
            self.deployed_drivers = deployed_drivers
        if deployed_connection_profiles is not None:
            self.deployed_connection_profiles = deployed_connection_profiles
        if deployed_calendars is not None:
            self.deployed_calendars = deployed_calendars
        if deployed_site_standards is not None:
            self.deployed_site_standards = deployed_site_standards
        if deployed_ai_plugins is not None:
            self.deployed_ai_plugins = deployed_ai_plugins
        if errors is not None:
            self.errors = errors
        if warnings is not None:
            self.warnings = warnings

    @property
    def deployment_file(self):
        """Gets the deployment_file of this WorkbenchImportResult.  # noqa: E501

        The name of a specific deployment file.  # noqa: E501

        :return: The deployment_file of this WorkbenchImportResult.  # noqa: E501
        :rtype: str
        """
        return self._deployment_file

    @deployment_file.setter
    def deployment_file(self, deployment_file):
        """Sets the deployment_file of this WorkbenchImportResult.

        The name of a specific deployment file.  # noqa: E501

        :param deployment_file: The deployment_file of this WorkbenchImportResult.  # noqa: E501
        :type deployment_file: str
        """

        self._deployment_file = deployment_file

    @property
    def poll_id(self):
        """Gets the poll_id of this WorkbenchImportResult.  # noqa: E501

        Poll id in case of a long deploy process  # noqa: E501

        :return: The poll_id of this WorkbenchImportResult.  # noqa: E501
        :rtype: str
        """
        return self._poll_id

    @poll_id.setter
    def poll_id(self, poll_id):
        """Sets the poll_id of this WorkbenchImportResult.

        Poll id in case of a long deploy process  # noqa: E501

        :param poll_id: The poll_id of this WorkbenchImportResult.  # noqa: E501
        :type poll_id: str
        """

        self._poll_id = poll_id

    @property
    def deployment_state(self):
        """Gets the deployment_state of this WorkbenchImportResult.  # noqa: E501

        Current deployment step and state. CALENDARS_DEPLOYED, CONNECTION_PROFILES_DEPLOYED, DEPLOYING_FOLDERS, folders deployed, etc.  # noqa: E501

        :return: The deployment_state of this WorkbenchImportResult.  # noqa: E501
        :rtype: str
        """
        return self._deployment_state

    @deployment_state.setter
    def deployment_state(self, deployment_state):
        """Sets the deployment_state of this WorkbenchImportResult.

        Current deployment step and state. CALENDARS_DEPLOYED, CONNECTION_PROFILES_DEPLOYED, DEPLOYING_FOLDERS, folders deployed, etc.  # noqa: E501

        :param deployment_state: The deployment_state of this WorkbenchImportResult.  # noqa: E501
        :type deployment_state: str
        """

        self._deployment_state = deployment_state

    @property
    def deployment_status(self):
        """Gets the deployment_status of this WorkbenchImportResult.  # noqa: E501

        Currently deployment status. ENDED_OK, ENDED_NOT_OK, PARTIAL_RESULTS, UNKNOWN  # noqa: E501

        :return: The deployment_status of this WorkbenchImportResult.  # noqa: E501
        :rtype: str
        """
        return self._deployment_status

    @deployment_status.setter
    def deployment_status(self, deployment_status):
        """Sets the deployment_status of this WorkbenchImportResult.

        Currently deployment status. ENDED_OK, ENDED_NOT_OK, PARTIAL_RESULTS, UNKNOWN  # noqa: E501

        :param deployment_status: The deployment_status of this WorkbenchImportResult.  # noqa: E501
        :type deployment_status: str
        """

        self._deployment_status = deployment_status

    @property
    def successful_folders_count(self):
        """Gets the successful_folders_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed simple folders.  # noqa: E501

        :return: The successful_folders_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_folders_count

    @successful_folders_count.setter
    def successful_folders_count(self, successful_folders_count):
        """Sets the successful_folders_count of this WorkbenchImportResult.

        Determines the number of successfully deployed simple folders.  # noqa: E501

        :param successful_folders_count: The successful_folders_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_folders_count: int
        """

        self._successful_folders_count = successful_folders_count

    @property
    def successful_smart_folders_count(self):
        """Gets the successful_smart_folders_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed smart folders.  # noqa: E501

        :return: The successful_smart_folders_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_smart_folders_count

    @successful_smart_folders_count.setter
    def successful_smart_folders_count(self, successful_smart_folders_count):
        """Sets the successful_smart_folders_count of this WorkbenchImportResult.

        Determines the number of successfully deployed smart folders.  # noqa: E501

        :param successful_smart_folders_count: The successful_smart_folders_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_smart_folders_count: int
        """

        self._successful_smart_folders_count = successful_smart_folders_count

    @property
    def successful_sub_folders_count(self):
        """Gets the successful_sub_folders_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :return: The successful_sub_folders_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_sub_folders_count

    @successful_sub_folders_count.setter
    def successful_sub_folders_count(self, successful_sub_folders_count):
        """Sets the successful_sub_folders_count of this WorkbenchImportResult.

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :param successful_sub_folders_count: The successful_sub_folders_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_sub_folders_count: int
        """

        self._successful_sub_folders_count = successful_sub_folders_count

    @property
    def successful_jobs_count(self):
        """Gets the successful_jobs_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :return: The successful_jobs_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_jobs_count

    @successful_jobs_count.setter
    def successful_jobs_count(self, successful_jobs_count):
        """Sets the successful_jobs_count of this WorkbenchImportResult.

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :param successful_jobs_count: The successful_jobs_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_jobs_count: int
        """

        self._successful_jobs_count = successful_jobs_count

    @property
    def successful_connection_profiles_count(self):
        """Gets the successful_connection_profiles_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :return: The successful_connection_profiles_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_connection_profiles_count

    @successful_connection_profiles_count.setter
    def successful_connection_profiles_count(self, successful_connection_profiles_count):
        """Sets the successful_connection_profiles_count of this WorkbenchImportResult.

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :param successful_connection_profiles_count: The successful_connection_profiles_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_connection_profiles_count: int
        """

        self._successful_connection_profiles_count = successful_connection_profiles_count

    @property
    def successful_drivers_count(self):
        """Gets the successful_drivers_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :return: The successful_drivers_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_drivers_count

    @successful_drivers_count.setter
    def successful_drivers_count(self, successful_drivers_count):
        """Sets the successful_drivers_count of this WorkbenchImportResult.

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :param successful_drivers_count: The successful_drivers_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_drivers_count: int
        """

        self._successful_drivers_count = successful_drivers_count

    @property
    def successful_calendars_count(self):
        """Gets the successful_calendars_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :return: The successful_calendars_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_calendars_count

    @successful_calendars_count.setter
    def successful_calendars_count(self, successful_calendars_count):
        """Sets the successful_calendars_count of this WorkbenchImportResult.

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :param successful_calendars_count: The successful_calendars_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_calendars_count: int
        """

        self._successful_calendars_count = successful_calendars_count

    @property
    def successful_site_standards_count(self):
        """Gets the successful_site_standards_count of this WorkbenchImportResult.  # noqa: E501

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :return: The successful_site_standards_count of this WorkbenchImportResult.  # noqa: E501
        :rtype: int
        """
        return self._successful_site_standards_count

    @successful_site_standards_count.setter
    def successful_site_standards_count(self, successful_site_standards_count):
        """Sets the successful_site_standards_count of this WorkbenchImportResult.

        Determines the number of successfully deployed sub folders.  # noqa: E501

        :param successful_site_standards_count: The successful_site_standards_count of this WorkbenchImportResult.  # noqa: E501
        :type successful_site_standards_count: int
        """

        self._successful_site_standards_count = successful_site_standards_count

    @property
    def is_deploy_descriptor_valid(self):
        """Gets the is_deploy_descriptor_valid of this WorkbenchImportResult.  # noqa: E501

        Determines if the deployment file is a valid deploy descriptor file.  # noqa: E501

        :return: The is_deploy_descriptor_valid of this WorkbenchImportResult.  # noqa: E501
        :rtype: bool
        """
        return self._is_deploy_descriptor_valid

    @is_deploy_descriptor_valid.setter
    def is_deploy_descriptor_valid(self, is_deploy_descriptor_valid):
        """Sets the is_deploy_descriptor_valid of this WorkbenchImportResult.

        Determines if the deployment file is a valid deploy descriptor file.  # noqa: E501

        :param is_deploy_descriptor_valid: The is_deploy_descriptor_valid of this WorkbenchImportResult.  # noqa: E501
        :type is_deploy_descriptor_valid: bool
        """

        self._is_deploy_descriptor_valid = is_deploy_descriptor_valid

    @property
    def deployed_folders(self):
        """Gets the deployed_folders of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_folders of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_folders

    @deployed_folders.setter
    def deployed_folders(self, deployed_folders):
        """Sets the deployed_folders of this WorkbenchImportResult.


        :param deployed_folders: The deployed_folders of this WorkbenchImportResult.  # noqa: E501
        :type deployed_folders: list[str]
        """

        self._deployed_folders = deployed_folders

    @property
    def deployed_jobs(self):
        """Gets the deployed_jobs of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_jobs of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_jobs

    @deployed_jobs.setter
    def deployed_jobs(self, deployed_jobs):
        """Sets the deployed_jobs of this WorkbenchImportResult.


        :param deployed_jobs: The deployed_jobs of this WorkbenchImportResult.  # noqa: E501
        :type deployed_jobs: list[str]
        """

        self._deployed_jobs = deployed_jobs

    @property
    def deployed_sub_folders(self):
        """Gets the deployed_sub_folders of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_sub_folders of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_sub_folders

    @deployed_sub_folders.setter
    def deployed_sub_folders(self, deployed_sub_folders):
        """Sets the deployed_sub_folders of this WorkbenchImportResult.


        :param deployed_sub_folders: The deployed_sub_folders of this WorkbenchImportResult.  # noqa: E501
        :type deployed_sub_folders: list[str]
        """

        self._deployed_sub_folders = deployed_sub_folders

    @property
    def deployed_drivers(self):
        """Gets the deployed_drivers of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_drivers of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_drivers

    @deployed_drivers.setter
    def deployed_drivers(self, deployed_drivers):
        """Sets the deployed_drivers of this WorkbenchImportResult.


        :param deployed_drivers: The deployed_drivers of this WorkbenchImportResult.  # noqa: E501
        :type deployed_drivers: list[str]
        """

        self._deployed_drivers = deployed_drivers

    @property
    def deployed_connection_profiles(self):
        """Gets the deployed_connection_profiles of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_connection_profiles of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_connection_profiles

    @deployed_connection_profiles.setter
    def deployed_connection_profiles(self, deployed_connection_profiles):
        """Sets the deployed_connection_profiles of this WorkbenchImportResult.


        :param deployed_connection_profiles: The deployed_connection_profiles of this WorkbenchImportResult.  # noqa: E501
        :type deployed_connection_profiles: list[str]
        """

        self._deployed_connection_profiles = deployed_connection_profiles

    @property
    def deployed_calendars(self):
        """Gets the deployed_calendars of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_calendars of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_calendars

    @deployed_calendars.setter
    def deployed_calendars(self, deployed_calendars):
        """Sets the deployed_calendars of this WorkbenchImportResult.


        :param deployed_calendars: The deployed_calendars of this WorkbenchImportResult.  # noqa: E501
        :type deployed_calendars: list[str]
        """

        self._deployed_calendars = deployed_calendars

    @property
    def deployed_site_standards(self):
        """Gets the deployed_site_standards of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_site_standards of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_site_standards

    @deployed_site_standards.setter
    def deployed_site_standards(self, deployed_site_standards):
        """Sets the deployed_site_standards of this WorkbenchImportResult.


        :param deployed_site_standards: The deployed_site_standards of this WorkbenchImportResult.  # noqa: E501
        :type deployed_site_standards: list[str]
        """

        self._deployed_site_standards = deployed_site_standards

    @property
    def deployed_ai_plugins(self):
        """Gets the deployed_ai_plugins of this WorkbenchImportResult.  # noqa: E501


        :return: The deployed_ai_plugins of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._deployed_ai_plugins

    @deployed_ai_plugins.setter
    def deployed_ai_plugins(self, deployed_ai_plugins):
        """Sets the deployed_ai_plugins of this WorkbenchImportResult.


        :param deployed_ai_plugins: The deployed_ai_plugins of this WorkbenchImportResult.  # noqa: E501
        :type deployed_ai_plugins: list[str]
        """

        self._deployed_ai_plugins = deployed_ai_plugins

    @property
    def errors(self):
        """Gets the errors of this WorkbenchImportResult.  # noqa: E501


        :return: The errors of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[DeploymentFileError]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this WorkbenchImportResult.


        :param errors: The errors of this WorkbenchImportResult.  # noqa: E501
        :type errors: list[DeploymentFileError]
        """

        self._errors = errors

    @property
    def warnings(self):
        """Gets the warnings of this WorkbenchImportResult.  # noqa: E501


        :return: The warnings of this WorkbenchImportResult.  # noqa: E501
        :rtype: list[WarningData]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this WorkbenchImportResult.


        :param warnings: The warnings of this WorkbenchImportResult.  # noqa: E501
        :type warnings: list[WarningData]
        """

        self._warnings = warnings

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkbenchImportResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkbenchImportResult):
            return True

        return self.to_dict() != other.to_dict()
