# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient
from clients.ctm_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BuildApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def build_file(self, definitions_file, **kwargs):  # noqa: E501
        """Compile definitions file to check its validity  # noqa: E501

        Compile the provided definition file (JSON or zip) to verify it is valid for Control-M.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.build_file(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains definitions to be compiled. Can be either a JSON definition file, or a zip file that contains multiple JSON definition files. (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DeploymentFileResults]
        """
        kwargs['_return_http_data_only'] = True
        return self.build_file_with_http_info(definitions_file, **kwargs)  # noqa: E501

    def build_file_with_http_info(self, definitions_file, **kwargs):  # noqa: E501
        """Compile definitions file to check its validity  # noqa: E501

        Compile the provided definition file (JSON or zip) to verify it is valid for Control-M.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.build_file_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains definitions to be compiled. Can be either a JSON definition file, or a zip file that contains multiple JSON definition files. (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DeploymentFileResults], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'definitions_file',
            'deploy_descriptor_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method build_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and ('definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `definitions_file` when calling `build_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'definitions_file' in local_var_params:
            local_var_files['definitionsFile'] = local_var_params['definitions_file']  # noqa: E501
        if 'deploy_descriptor_file' in local_var_params:
            local_var_files['deployDescriptorFile'] = local_var_params['deploy_descriptor_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[DeploymentFileResults]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/build', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
