# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class CtmServerDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'code': 'str',
        'name': 'str',
        'host': 'str',
        'type': 'str',
        'desired_state': 'str',
        'version': 'str',
        'configuration_agent_port': 'int',
        'description': 'str',
        'contact': 'str',
        'is_enabled': 'bool',
        'is_managed': 'bool',
        'gateway_listen_host': 'str',
        'gateway_listen_port': 'int',
        'protocol': 'str',
        'ctm_to_em_port': 'int',
        'time_zone': 'str',
        'new_day_time': 'str',
        'week_start_day': 'str',
        'day_light_saving_start_date': 'str',
        'day_light_saving_end_date': 'str',
        'is_uppercase_only': 'bool',
        'is_control_m_restart_installed': 'bool',
        'is_control_m_analyzer_installed': 'bool',
        'is_control_m_tape_installed': 'bool',
        'saving_mode': 'str',
        'message': 'str',
        'services_message': 'str',
        'state': 'str',
        'status': 'str',
        'os_type': 'str',
        'is_paused': 'bool',
        'last_update': 'str',
        'is_high_availability_enabled': 'bool',
        'admin_agent_status': 'str',
        'non_active_ca_status': 'str',
        'primary_host': 'str',
        'secondary_host': 'str',
        'fail_over_mode': 'str',
        'high_availability_process_name': 'str',
        'high_availability_status': 'str',
        'is_db_manager': 'str',
        'last_high_availability_process_date': 'str',
        'additional_attributes': 'list[AdditionalAttribute]',
        'services': 'list[CtmService]',
        'database_def': 'DatabaseDef'
    }

    attribute_map = {
        'code': 'code',
        'name': 'name',
        'host': 'host',
        'type': 'type',
        'desired_state': 'desiredState',
        'version': 'version',
        'configuration_agent_port': 'configurationAgentPort',
        'description': 'description',
        'contact': 'contact',
        'is_enabled': 'isEnabled',
        'is_managed': 'isManaged',
        'gateway_listen_host': 'gatewayListenHost',
        'gateway_listen_port': 'gatewayListenPort',
        'protocol': 'protocol',
        'ctm_to_em_port': 'ctmToEMPort',
        'time_zone': 'timeZone',
        'new_day_time': 'newDayTime',
        'week_start_day': 'weekStartDay',
        'day_light_saving_start_date': 'dayLightSavingStartDate',
        'day_light_saving_end_date': 'dayLightSavingEndDate',
        'is_uppercase_only': 'isUppercaseOnly',
        'is_control_m_restart_installed': 'isControlMRestartInstalled',
        'is_control_m_analyzer_installed': 'isControlMAnalyzerInstalled',
        'is_control_m_tape_installed': 'isControlMTapeInstalled',
        'saving_mode': 'savingMode',
        'message': 'message',
        'services_message': 'servicesMessage',
        'state': 'state',
        'status': 'status',
        'os_type': 'osType',
        'is_paused': 'isPaused',
        'last_update': 'lastUpdate',
        'is_high_availability_enabled': 'isHighAvailabilityEnabled',
        'admin_agent_status': 'adminAgentStatus',
        'non_active_ca_status': 'nonActiveCAStatus',
        'primary_host': 'primaryHost',
        'secondary_host': 'secondaryHost',
        'fail_over_mode': 'failOverMode',
        'high_availability_process_name': 'highAvailabilityProcessName',
        'high_availability_status': 'highAvailabilityStatus',
        'is_db_manager': 'isDBManager',
        'last_high_availability_process_date': 'lastHighAvailabilityProcessDate',
        'additional_attributes': 'additionalAttributes',
        'services': 'services',
        'database_def': 'databaseDef'
    }

    def __init__(self, code=None, name=None, host=None, type=None, desired_state=None, version=None, configuration_agent_port=None, description=None, contact=None, is_enabled=None, is_managed=None, gateway_listen_host=None, gateway_listen_port=None, protocol=None, ctm_to_em_port=None, time_zone=None, new_day_time=None, week_start_day=None, day_light_saving_start_date=None, day_light_saving_end_date=None, is_uppercase_only=None, is_control_m_restart_installed=None, is_control_m_analyzer_installed=None, is_control_m_tape_installed=None, saving_mode=None, message=None, services_message=None, state=None, status=None, os_type=None, is_paused=None, last_update=None, is_high_availability_enabled=None, admin_agent_status=None, non_active_ca_status=None, primary_host=None, secondary_host=None, fail_over_mode=None, high_availability_process_name=None, high_availability_status=None, is_db_manager=None, last_high_availability_process_date=None, additional_attributes=None, services=None, database_def=None, local_vars_configuration=None):  # noqa: E501
        """CtmServerDetails - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._code = None
        self._name = None
        self._host = None
        self._type = None
        self._desired_state = None
        self._version = None
        self._configuration_agent_port = None
        self._description = None
        self._contact = None
        self._is_enabled = None
        self._is_managed = None
        self._gateway_listen_host = None
        self._gateway_listen_port = None
        self._protocol = None
        self._ctm_to_em_port = None
        self._time_zone = None
        self._new_day_time = None
        self._week_start_day = None
        self._day_light_saving_start_date = None
        self._day_light_saving_end_date = None
        self._is_uppercase_only = None
        self._is_control_m_restart_installed = None
        self._is_control_m_analyzer_installed = None
        self._is_control_m_tape_installed = None
        self._saving_mode = None
        self._message = None
        self._services_message = None
        self._state = None
        self._status = None
        self._os_type = None
        self._is_paused = None
        self._last_update = None
        self._is_high_availability_enabled = None
        self._admin_agent_status = None
        self._non_active_ca_status = None
        self._primary_host = None
        self._secondary_host = None
        self._fail_over_mode = None
        self._high_availability_process_name = None
        self._high_availability_status = None
        self._is_db_manager = None
        self._last_high_availability_process_date = None
        self._additional_attributes = None
        self._services = None
        self._database_def = None
        self.discriminator = None

        if code is not None:
            self.code = code
        if name is not None:
            self.name = name
        if host is not None:
            self.host = host
        if type is not None:
            self.type = type
        if desired_state is not None:
            self.desired_state = desired_state
        if version is not None:
            self.version = version
        if configuration_agent_port is not None:
            self.configuration_agent_port = configuration_agent_port
        if description is not None:
            self.description = description
        if contact is not None:
            self.contact = contact
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_managed is not None:
            self.is_managed = is_managed
        if gateway_listen_host is not None:
            self.gateway_listen_host = gateway_listen_host
        if gateway_listen_port is not None:
            self.gateway_listen_port = gateway_listen_port
        if protocol is not None:
            self.protocol = protocol
        if ctm_to_em_port is not None:
            self.ctm_to_em_port = ctm_to_em_port
        if time_zone is not None:
            self.time_zone = time_zone
        if new_day_time is not None:
            self.new_day_time = new_day_time
        if week_start_day is not None:
            self.week_start_day = week_start_day
        if day_light_saving_start_date is not None:
            self.day_light_saving_start_date = day_light_saving_start_date
        if day_light_saving_end_date is not None:
            self.day_light_saving_end_date = day_light_saving_end_date
        if is_uppercase_only is not None:
            self.is_uppercase_only = is_uppercase_only
        if is_control_m_restart_installed is not None:
            self.is_control_m_restart_installed = is_control_m_restart_installed
        if is_control_m_analyzer_installed is not None:
            self.is_control_m_analyzer_installed = is_control_m_analyzer_installed
        if is_control_m_tape_installed is not None:
            self.is_control_m_tape_installed = is_control_m_tape_installed
        if saving_mode is not None:
            self.saving_mode = saving_mode
        if message is not None:
            self.message = message
        if services_message is not None:
            self.services_message = services_message
        if state is not None:
            self.state = state
        if status is not None:
            self.status = status
        if os_type is not None:
            self.os_type = os_type
        if is_paused is not None:
            self.is_paused = is_paused
        if last_update is not None:
            self.last_update = last_update
        if is_high_availability_enabled is not None:
            self.is_high_availability_enabled = is_high_availability_enabled
        if admin_agent_status is not None:
            self.admin_agent_status = admin_agent_status
        if non_active_ca_status is not None:
            self.non_active_ca_status = non_active_ca_status
        if primary_host is not None:
            self.primary_host = primary_host
        if secondary_host is not None:
            self.secondary_host = secondary_host
        if fail_over_mode is not None:
            self.fail_over_mode = fail_over_mode
        if high_availability_process_name is not None:
            self.high_availability_process_name = high_availability_process_name
        if high_availability_status is not None:
            self.high_availability_status = high_availability_status
        if is_db_manager is not None:
            self.is_db_manager = is_db_manager
        if last_high_availability_process_date is not None:
            self.last_high_availability_process_date = last_high_availability_process_date
        if additional_attributes is not None:
            self.additional_attributes = additional_attributes
        if services is not None:
            self.services = services
        if database_def is not None:
            self.database_def = database_def

    @property
    def code(self):
        """Gets the code of this CtmServerDetails.  # noqa: E501

        Control-M/Server code  # noqa: E501

        :return: The code of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this CtmServerDetails.

        Control-M/Server code  # noqa: E501

        :param code: The code of this CtmServerDetails.  # noqa: E501
        :type code: str
        """

        self._code = code

    @property
    def name(self):
        """Gets the name of this CtmServerDetails.  # noqa: E501

        Control-M/Server unique name  # noqa: E501

        :return: The name of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CtmServerDetails.

        Control-M/Server unique name  # noqa: E501

        :param name: The name of this CtmServerDetails.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def host(self):
        """Gets the host of this CtmServerDetails.  # noqa: E501

        Hostname the Control-M/Server is running on  # noqa: E501

        :return: The host of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this CtmServerDetails.

        Hostname the Control-M/Server is running on  # noqa: E501

        :param host: The host of this CtmServerDetails.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def type(self):
        """Gets the type of this CtmServerDetails.  # noqa: E501

        Control-M/Server Type [Distributed|zOS]  # noqa: E501

        :return: The type of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CtmServerDetails.

        Control-M/Server Type [Distributed|zOS]  # noqa: E501

        :param type: The type of this CtmServerDetails.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def desired_state(self):
        """Gets the desired_state of this CtmServerDetails.  # noqa: E501

        Control-M/Server desired state  # noqa: E501

        :return: The desired_state of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this CtmServerDetails.

        Control-M/Server desired state  # noqa: E501

        :param desired_state: The desired_state of this CtmServerDetails.  # noqa: E501
        :type desired_state: str
        """

        self._desired_state = desired_state

    @property
    def version(self):
        """Gets the version of this CtmServerDetails.  # noqa: E501

        Control-M/Server version  # noqa: E501

        :return: The version of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CtmServerDetails.

        Control-M/Server version  # noqa: E501

        :param version: The version of this CtmServerDetails.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def configuration_agent_port(self):
        """Gets the configuration_agent_port of this CtmServerDetails.  # noqa: E501

        The Configuration Agent Port  # noqa: E501

        :return: The configuration_agent_port of this CtmServerDetails.  # noqa: E501
        :rtype: int
        """
        return self._configuration_agent_port

    @configuration_agent_port.setter
    def configuration_agent_port(self, configuration_agent_port):
        """Sets the configuration_agent_port of this CtmServerDetails.

        The Configuration Agent Port  # noqa: E501

        :param configuration_agent_port: The configuration_agent_port of this CtmServerDetails.  # noqa: E501
        :type configuration_agent_port: int
        """

        self._configuration_agent_port = configuration_agent_port

    @property
    def description(self):
        """Gets the description of this CtmServerDetails.  # noqa: E501

        Control-M/Server description  # noqa: E501

        :return: The description of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CtmServerDetails.

        Control-M/Server description  # noqa: E501

        :param description: The description of this CtmServerDetails.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def contact(self):
        """Gets the contact of this CtmServerDetails.  # noqa: E501

        Control-M/Server contact information  # noqa: E501

        :return: The contact of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this CtmServerDetails.

        Control-M/Server contact information  # noqa: E501

        :param contact: The contact of this CtmServerDetails.  # noqa: E501
        :type contact: str
        """

        self._contact = contact

    @property
    def is_enabled(self):
        """Gets the is_enabled of this CtmServerDetails.  # noqa: E501

        Indicates if Control-M/Server is enabled  # noqa: E501

        :return: The is_enabled of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """Sets the is_enabled of this CtmServerDetails.

        Indicates if Control-M/Server is enabled  # noqa: E501

        :param is_enabled: The is_enabled of this CtmServerDetails.  # noqa: E501
        :type is_enabled: bool
        """

        self._is_enabled = is_enabled

    @property
    def is_managed(self):
        """Gets the is_managed of this CtmServerDetails.  # noqa: E501

        Indicates if Control-M/Server is managed  # noqa: E501

        :return: The is_managed of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_managed

    @is_managed.setter
    def is_managed(self, is_managed):
        """Sets the is_managed of this CtmServerDetails.

        Indicates if Control-M/Server is managed  # noqa: E501

        :param is_managed: The is_managed of this CtmServerDetails.  # noqa: E501
        :type is_managed: bool
        """

        self._is_managed = is_managed

    @property
    def gateway_listen_host(self):
        """Gets the gateway_listen_host of this CtmServerDetails.  # noqa: E501

        Control-M/Server gateway host  # noqa: E501

        :return: The gateway_listen_host of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._gateway_listen_host

    @gateway_listen_host.setter
    def gateway_listen_host(self, gateway_listen_host):
        """Sets the gateway_listen_host of this CtmServerDetails.

        Control-M/Server gateway host  # noqa: E501

        :param gateway_listen_host: The gateway_listen_host of this CtmServerDetails.  # noqa: E501
        :type gateway_listen_host: str
        """

        self._gateway_listen_host = gateway_listen_host

    @property
    def gateway_listen_port(self):
        """Gets the gateway_listen_port of this CtmServerDetails.  # noqa: E501

        Control-M/Server gateway port  # noqa: E501

        :return: The gateway_listen_port of this CtmServerDetails.  # noqa: E501
        :rtype: int
        """
        return self._gateway_listen_port

    @gateway_listen_port.setter
    def gateway_listen_port(self, gateway_listen_port):
        """Sets the gateway_listen_port of this CtmServerDetails.

        Control-M/Server gateway port  # noqa: E501

        :param gateway_listen_port: The gateway_listen_port of this CtmServerDetails.  # noqa: E501
        :type gateway_listen_port: int
        """

        self._gateway_listen_port = gateway_listen_port

    @property
    def protocol(self):
        """Gets the protocol of this CtmServerDetails.  # noqa: E501

        Protocol the Control-M/Server is using  # noqa: E501

        :return: The protocol of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this CtmServerDetails.

        Protocol the Control-M/Server is using  # noqa: E501

        :param protocol: The protocol of this CtmServerDetails.  # noqa: E501
        :type protocol: str
        """

        self._protocol = protocol

    @property
    def ctm_to_em_port(self):
        """Gets the ctm_to_em_port of this CtmServerDetails.  # noqa: E501

        Control-M/Server and Control-M/EM communication port goes through  # noqa: E501

        :return: The ctm_to_em_port of this CtmServerDetails.  # noqa: E501
        :rtype: int
        """
        return self._ctm_to_em_port

    @ctm_to_em_port.setter
    def ctm_to_em_port(self, ctm_to_em_port):
        """Sets the ctm_to_em_port of this CtmServerDetails.

        Control-M/Server and Control-M/EM communication port goes through  # noqa: E501

        :param ctm_to_em_port: The ctm_to_em_port of this CtmServerDetails.  # noqa: E501
        :type ctm_to_em_port: int
        """

        self._ctm_to_em_port = ctm_to_em_port

    @property
    def time_zone(self):
        """Gets the time_zone of this CtmServerDetails.  # noqa: E501

        Control-M/Server timezone  # noqa: E501

        :return: The time_zone of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """Sets the time_zone of this CtmServerDetails.

        Control-M/Server timezone  # noqa: E501

        :param time_zone: The time_zone of this CtmServerDetails.  # noqa: E501
        :type time_zone: str
        """

        self._time_zone = time_zone

    @property
    def new_day_time(self):
        """Gets the new_day_time of this CtmServerDetails.  # noqa: E501

        Control-M/Server \"New Day\" time  # noqa: E501

        :return: The new_day_time of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._new_day_time

    @new_day_time.setter
    def new_day_time(self, new_day_time):
        """Sets the new_day_time of this CtmServerDetails.

        Control-M/Server \"New Day\" time  # noqa: E501

        :param new_day_time: The new_day_time of this CtmServerDetails.  # noqa: E501
        :type new_day_time: str
        """

        self._new_day_time = new_day_time

    @property
    def week_start_day(self):
        """Gets the week_start_day of this CtmServerDetails.  # noqa: E501

        Control-M/Server first day of the week  # noqa: E501

        :return: The week_start_day of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._week_start_day

    @week_start_day.setter
    def week_start_day(self, week_start_day):
        """Sets the week_start_day of this CtmServerDetails.

        Control-M/Server first day of the week  # noqa: E501

        :param week_start_day: The week_start_day of this CtmServerDetails.  # noqa: E501
        :type week_start_day: str
        """

        self._week_start_day = week_start_day

    @property
    def day_light_saving_start_date(self):
        """Gets the day_light_saving_start_date of this CtmServerDetails.  # noqa: E501

        Daylight saving time start date  # noqa: E501

        :return: The day_light_saving_start_date of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._day_light_saving_start_date

    @day_light_saving_start_date.setter
    def day_light_saving_start_date(self, day_light_saving_start_date):
        """Sets the day_light_saving_start_date of this CtmServerDetails.

        Daylight saving time start date  # noqa: E501

        :param day_light_saving_start_date: The day_light_saving_start_date of this CtmServerDetails.  # noqa: E501
        :type day_light_saving_start_date: str
        """

        self._day_light_saving_start_date = day_light_saving_start_date

    @property
    def day_light_saving_end_date(self):
        """Gets the day_light_saving_end_date of this CtmServerDetails.  # noqa: E501

        Daylight saving time end date  # noqa: E501

        :return: The day_light_saving_end_date of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._day_light_saving_end_date

    @day_light_saving_end_date.setter
    def day_light_saving_end_date(self, day_light_saving_end_date):
        """Sets the day_light_saving_end_date of this CtmServerDetails.

        Daylight saving time end date  # noqa: E501

        :param day_light_saving_end_date: The day_light_saving_end_date of this CtmServerDetails.  # noqa: E501
        :type day_light_saving_end_date: str
        """

        self._day_light_saving_end_date = day_light_saving_end_date

    @property
    def is_uppercase_only(self):
        """Gets the is_uppercase_only of this CtmServerDetails.  # noqa: E501

        Restrict job attributes inputs to upper case letters only  # noqa: E501

        :return: The is_uppercase_only of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_uppercase_only

    @is_uppercase_only.setter
    def is_uppercase_only(self, is_uppercase_only):
        """Sets the is_uppercase_only of this CtmServerDetails.

        Restrict job attributes inputs to upper case letters only  # noqa: E501

        :param is_uppercase_only: The is_uppercase_only of this CtmServerDetails.  # noqa: E501
        :type is_uppercase_only: bool
        """

        self._is_uppercase_only = is_uppercase_only

    @property
    def is_control_m_restart_installed(self):
        """Gets the is_control_m_restart_installed of this CtmServerDetails.  # noqa: E501

        Control-M/Restart  # noqa: E501

        :return: The is_control_m_restart_installed of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_control_m_restart_installed

    @is_control_m_restart_installed.setter
    def is_control_m_restart_installed(self, is_control_m_restart_installed):
        """Sets the is_control_m_restart_installed of this CtmServerDetails.

        Control-M/Restart  # noqa: E501

        :param is_control_m_restart_installed: The is_control_m_restart_installed of this CtmServerDetails.  # noqa: E501
        :type is_control_m_restart_installed: bool
        """

        self._is_control_m_restart_installed = is_control_m_restart_installed

    @property
    def is_control_m_analyzer_installed(self):
        """Gets the is_control_m_analyzer_installed of this CtmServerDetails.  # noqa: E501

        Control-M/Analyzer Installed  # noqa: E501

        :return: The is_control_m_analyzer_installed of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_control_m_analyzer_installed

    @is_control_m_analyzer_installed.setter
    def is_control_m_analyzer_installed(self, is_control_m_analyzer_installed):
        """Sets the is_control_m_analyzer_installed of this CtmServerDetails.

        Control-M/Analyzer Installed  # noqa: E501

        :param is_control_m_analyzer_installed: The is_control_m_analyzer_installed of this CtmServerDetails.  # noqa: E501
        :type is_control_m_analyzer_installed: bool
        """

        self._is_control_m_analyzer_installed = is_control_m_analyzer_installed

    @property
    def is_control_m_tape_installed(self):
        """Gets the is_control_m_tape_installed of this CtmServerDetails.  # noqa: E501

        Control-M/Tape Installed  # noqa: E501

        :return: The is_control_m_tape_installed of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_control_m_tape_installed

    @is_control_m_tape_installed.setter
    def is_control_m_tape_installed(self, is_control_m_tape_installed):
        """Sets the is_control_m_tape_installed of this CtmServerDetails.

        Control-M/Tape Installed  # noqa: E501

        :param is_control_m_tape_installed: The is_control_m_tape_installed of this CtmServerDetails.  # noqa: E501
        :type is_control_m_tape_installed: bool
        """

        self._is_control_m_tape_installed = is_control_m_tape_installed

    @property
    def saving_mode(self):
        """Gets the saving_mode of this CtmServerDetails.  # noqa: E501

        Saving Mode property determines what is the current status for the connection with Configuration Agent  # noqa: E501

        :return: The saving_mode of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._saving_mode

    @saving_mode.setter
    def saving_mode(self, saving_mode):
        """Sets the saving_mode of this CtmServerDetails.

        Saving Mode property determines what is the current status for the connection with Configuration Agent  # noqa: E501

        :param saving_mode: The saving_mode of this CtmServerDetails.  # noqa: E501
        :type saving_mode: str
        """

        self._saving_mode = saving_mode

    @property
    def message(self):
        """Gets the message of this CtmServerDetails.  # noqa: E501

        Control-M/Server message describing the communication status  # noqa: E501

        :return: The message of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this CtmServerDetails.

        Control-M/Server message describing the communication status  # noqa: E501

        :param message: The message of this CtmServerDetails.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def services_message(self):
        """Gets the services_message of this CtmServerDetails.  # noqa: E501

        Control-M/Server services message  # noqa: E501

        :return: The services_message of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._services_message

    @services_message.setter
    def services_message(self, services_message):
        """Sets the services_message of this CtmServerDetails.

        Control-M/Server services message  # noqa: E501

        :param services_message: The services_message of this CtmServerDetails.  # noqa: E501
        :type services_message: str
        """

        self._services_message = services_message

    @property
    def state(self):
        """Gets the state of this CtmServerDetails.  # noqa: E501

        Control-M/Server state [up|down]. (Actual State)  # noqa: E501

        :return: The state of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CtmServerDetails.

        Control-M/Server state [up|down]. (Actual State)  # noqa: E501

        :param state: The state of this CtmServerDetails.  # noqa: E501
        :type state: str
        """

        self._state = state

    @property
    def status(self):
        """Gets the status of this CtmServerDetails.  # noqa: E501

        Calculated Control-M/Server status  # noqa: E501

        :return: The status of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this CtmServerDetails.

        Calculated Control-M/Server status  # noqa: E501

        :param status: The status of this CtmServerDetails.  # noqa: E501
        :type status: str
        """

        self._status = status

    @property
    def os_type(self):
        """Gets the os_type of this CtmServerDetails.  # noqa: E501

        Control-M/Server operating system  # noqa: E501

        :return: The os_type of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """Sets the os_type of this CtmServerDetails.

        Control-M/Server operating system  # noqa: E501

        :param os_type: The os_type of this CtmServerDetails.  # noqa: E501
        :type os_type: str
        """

        self._os_type = os_type

    @property
    def is_paused(self):
        """Gets the is_paused of this CtmServerDetails.  # noqa: E501

        Indicates if Control-M/Server is paused  # noqa: E501

        :return: The is_paused of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_paused

    @is_paused.setter
    def is_paused(self, is_paused):
        """Sets the is_paused of this CtmServerDetails.

        Indicates if Control-M/Server is paused  # noqa: E501

        :param is_paused: The is_paused of this CtmServerDetails.  # noqa: E501
        :type is_paused: bool
        """

        self._is_paused = is_paused

    @property
    def last_update(self):
        """Gets the last_update of this CtmServerDetails.  # noqa: E501

        The Control-M/Server last updated date  # noqa: E501

        :return: The last_update of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this CtmServerDetails.

        The Control-M/Server last updated date  # noqa: E501

        :param last_update: The last_update of this CtmServerDetails.  # noqa: E501
        :type last_update: str
        """

        self._last_update = last_update

    @property
    def is_high_availability_enabled(self):
        """Gets the is_high_availability_enabled of this CtmServerDetails.  # noqa: E501

        Indicates if High Availability is installed  # noqa: E501

        :return: The is_high_availability_enabled of this CtmServerDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_high_availability_enabled

    @is_high_availability_enabled.setter
    def is_high_availability_enabled(self, is_high_availability_enabled):
        """Sets the is_high_availability_enabled of this CtmServerDetails.

        Indicates if High Availability is installed  # noqa: E501

        :param is_high_availability_enabled: The is_high_availability_enabled of this CtmServerDetails.  # noqa: E501
        :type is_high_availability_enabled: bool
        """

        self._is_high_availability_enabled = is_high_availability_enabled

    @property
    def admin_agent_status(self):
        """Gets the admin_agent_status of this CtmServerDetails.  # noqa: E501

        Status of configuration agent on active host  # noqa: E501

        :return: The admin_agent_status of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._admin_agent_status

    @admin_agent_status.setter
    def admin_agent_status(self, admin_agent_status):
        """Sets the admin_agent_status of this CtmServerDetails.

        Status of configuration agent on active host  # noqa: E501

        :param admin_agent_status: The admin_agent_status of this CtmServerDetails.  # noqa: E501
        :type admin_agent_status: str
        """

        self._admin_agent_status = admin_agent_status

    @property
    def non_active_ca_status(self):
        """Gets the non_active_ca_status of this CtmServerDetails.  # noqa: E501

        Status of configuration agent on non-active host  # noqa: E501

        :return: The non_active_ca_status of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._non_active_ca_status

    @non_active_ca_status.setter
    def non_active_ca_status(self, non_active_ca_status):
        """Sets the non_active_ca_status of this CtmServerDetails.

        Status of configuration agent on non-active host  # noqa: E501

        :param non_active_ca_status: The non_active_ca_status of this CtmServerDetails.  # noqa: E501
        :type non_active_ca_status: str
        """

        self._non_active_ca_status = non_active_ca_status

    @property
    def primary_host(self):
        """Gets the primary_host of this CtmServerDetails.  # noqa: E501

        Primary host  # noqa: E501

        :return: The primary_host of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._primary_host

    @primary_host.setter
    def primary_host(self, primary_host):
        """Sets the primary_host of this CtmServerDetails.

        Primary host  # noqa: E501

        :param primary_host: The primary_host of this CtmServerDetails.  # noqa: E501
        :type primary_host: str
        """

        self._primary_host = primary_host

    @property
    def secondary_host(self):
        """Gets the secondary_host of this CtmServerDetails.  # noqa: E501

        Secondary Host  # noqa: E501

        :return: The secondary_host of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._secondary_host

    @secondary_host.setter
    def secondary_host(self, secondary_host):
        """Sets the secondary_host of this CtmServerDetails.

        Secondary Host  # noqa: E501

        :param secondary_host: The secondary_host of this CtmServerDetails.  # noqa: E501
        :type secondary_host: str
        """

        self._secondary_host = secondary_host

    @property
    def fail_over_mode(self):
        """Gets the fail_over_mode of this CtmServerDetails.  # noqa: E501

        High Availability fail over mode [Manual, Automatic]  # noqa: E501

        :return: The fail_over_mode of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._fail_over_mode

    @fail_over_mode.setter
    def fail_over_mode(self, fail_over_mode):
        """Sets the fail_over_mode of this CtmServerDetails.

        High Availability fail over mode [Manual, Automatic]  # noqa: E501

        :param fail_over_mode: The fail_over_mode of this CtmServerDetails.  # noqa: E501
        :type fail_over_mode: str
        """

        self._fail_over_mode = fail_over_mode

    @property
    def high_availability_process_name(self):
        """Gets the high_availability_process_name of this CtmServerDetails.  # noqa: E501

        High Availability process name  # noqa: E501

        :return: The high_availability_process_name of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._high_availability_process_name

    @high_availability_process_name.setter
    def high_availability_process_name(self, high_availability_process_name):
        """Sets the high_availability_process_name of this CtmServerDetails.

        High Availability process name  # noqa: E501

        :param high_availability_process_name: The high_availability_process_name of this CtmServerDetails.  # noqa: E501
        :type high_availability_process_name: str
        """

        self._high_availability_process_name = high_availability_process_name

    @property
    def high_availability_status(self):
        """Gets the high_availability_status of this CtmServerDetails.  # noqa: E501

        The server high availability status  # noqa: E501

        :return: The high_availability_status of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._high_availability_status

    @high_availability_status.setter
    def high_availability_status(self, high_availability_status):
        """Sets the high_availability_status of this CtmServerDetails.

        The server high availability status  # noqa: E501

        :param high_availability_status: The high_availability_status of this CtmServerDetails.  # noqa: E501
        :type high_availability_status: str
        """

        self._high_availability_status = high_availability_status

    @property
    def is_db_manager(self):
        """Gets the is_db_manager of this CtmServerDetails.  # noqa: E501

        The server high availability status  # noqa: E501

        :return: The is_db_manager of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._is_db_manager

    @is_db_manager.setter
    def is_db_manager(self, is_db_manager):
        """Sets the is_db_manager of this CtmServerDetails.

        The server high availability status  # noqa: E501

        :param is_db_manager: The is_db_manager of this CtmServerDetails.  # noqa: E501
        :type is_db_manager: str
        """

        self._is_db_manager = is_db_manager

    @property
    def last_high_availability_process_date(self):
        """Gets the last_high_availability_process_date of this CtmServerDetails.  # noqa: E501

        Last high availability Manual/Automatic Failover/Fallback date  # noqa: E501

        :return: The last_high_availability_process_date of this CtmServerDetails.  # noqa: E501
        :rtype: str
        """
        return self._last_high_availability_process_date

    @last_high_availability_process_date.setter
    def last_high_availability_process_date(self, last_high_availability_process_date):
        """Sets the last_high_availability_process_date of this CtmServerDetails.

        Last high availability Manual/Automatic Failover/Fallback date  # noqa: E501

        :param last_high_availability_process_date: The last_high_availability_process_date of this CtmServerDetails.  # noqa: E501
        :type last_high_availability_process_date: str
        """

        self._last_high_availability_process_date = last_high_availability_process_date

    @property
    def additional_attributes(self):
        """Gets the additional_attributes of this CtmServerDetails.  # noqa: E501

        Additional Attributes  # noqa: E501

        :return: The additional_attributes of this CtmServerDetails.  # noqa: E501
        :rtype: list[AdditionalAttribute]
        """
        return self._additional_attributes

    @additional_attributes.setter
    def additional_attributes(self, additional_attributes):
        """Sets the additional_attributes of this CtmServerDetails.

        Additional Attributes  # noqa: E501

        :param additional_attributes: The additional_attributes of this CtmServerDetails.  # noqa: E501
        :type additional_attributes: list[AdditionalAttribute]
        """

        self._additional_attributes = additional_attributes

    @property
    def services(self):
        """Gets the services of this CtmServerDetails.  # noqa: E501


        :return: The services of this CtmServerDetails.  # noqa: E501
        :rtype: list[CtmService]
        """
        return self._services

    @services.setter
    def services(self, services):
        """Sets the services of this CtmServerDetails.


        :param services: The services of this CtmServerDetails.  # noqa: E501
        :type services: list[CtmService]
        """

        self._services = services

    @property
    def database_def(self):
        """Gets the database_def of this CtmServerDetails.  # noqa: E501


        :return: The database_def of this CtmServerDetails.  # noqa: E501
        :rtype: DatabaseDef
        """
        return self._database_def

    @database_def.setter
    def database_def(self, database_def):
        """Sets the database_def of this CtmServerDetails.


        :param database_def: The database_def of this CtmServerDetails.  # noqa: E501
        :type database_def: DatabaseDef
        """

        self._database_def = database_def

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CtmServerDetails):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CtmServerDetails):
            return True

        return self.to_dict() != other.to_dict()
