# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class DatabaseDef(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'type': 'str',
        'version': 'str',
        'host': 'str',
        'port': 'str',
        'message': 'str',
        'status': 'str',
        'service_name': 'str',
        'schema_name': 'str',
        'additional_attributes': 'list[AdditionalAttribute]',
        'pgattributes': 'PgAttributes',
        'shared_access': 'list[SharedAccess]'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'version': 'version',
        'host': 'host',
        'port': 'port',
        'message': 'message',
        'status': 'status',
        'service_name': 'serviceName',
        'schema_name': 'schemaName',
        'additional_attributes': 'additionalAttributes',
        'pgattributes': 'pgattributes',
        'shared_access': 'sharedAccess'
    }

    def __init__(self, name=None, type=None, version=None, host=None, port=None, message=None, status=None, service_name=None, schema_name=None, additional_attributes=None, pgattributes=None, shared_access=None, local_vars_configuration=None):  # noqa: E501
        """DatabaseDef - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._type = None
        self._version = None
        self._host = None
        self._port = None
        self._message = None
        self._status = None
        self._service_name = None
        self._schema_name = None
        self._additional_attributes = None
        self._pgattributes = None
        self._shared_access = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if version is not None:
            self.version = version
        if host is not None:
            self.host = host
        if port is not None:
            self.port = port
        if message is not None:
            self.message = message
        if status is not None:
            self.status = status
        if service_name is not None:
            self.service_name = service_name
        if schema_name is not None:
            self.schema_name = schema_name
        if additional_attributes is not None:
            self.additional_attributes = additional_attributes
        if pgattributes is not None:
            self.pgattributes = pgattributes
        if shared_access is not None:
            self.shared_access = shared_access

    @property
    def name(self):
        """Gets the name of this DatabaseDef.  # noqa: E501

        Database Name  # noqa: E501

        :return: The name of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatabaseDef.

        Database Name  # noqa: E501

        :param name: The name of this DatabaseDef.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def type(self):
        """Gets the type of this DatabaseDef.  # noqa: E501

        Database Type (MSSQL, PostgreSQL)  # noqa: E501

        :return: The type of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this DatabaseDef.

        Database Type (MSSQL, PostgreSQL)  # noqa: E501

        :param type: The type of this DatabaseDef.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def version(self):
        """Gets the version of this DatabaseDef.  # noqa: E501

        Database Version  # noqa: E501

        :return: The version of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DatabaseDef.

        Database Version  # noqa: E501

        :param version: The version of this DatabaseDef.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def host(self):
        """Gets the host of this DatabaseDef.  # noqa: E501

        Database Host  # noqa: E501

        :return: The host of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this DatabaseDef.

        Database Host  # noqa: E501

        :param host: The host of this DatabaseDef.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def port(self):
        """Gets the port of this DatabaseDef.  # noqa: E501

        Database Port  # noqa: E501

        :return: The port of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this DatabaseDef.

        Database Port  # noqa: E501

        :param port: The port of this DatabaseDef.  # noqa: E501
        :type port: str
        """

        self._port = port

    @property
    def message(self):
        """Gets the message of this DatabaseDef.  # noqa: E501

        Database Message  # noqa: E501

        :return: The message of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this DatabaseDef.

        Database Message  # noqa: E501

        :param message: The message of this DatabaseDef.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def status(self):
        """Gets the status of this DatabaseDef.  # noqa: E501

        Database Status  # noqa: E501

        :return: The status of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DatabaseDef.

        Database Status  # noqa: E501

        :param status: The status of this DatabaseDef.  # noqa: E501
        :type status: str
        """

        self._status = status

    @property
    def service_name(self):
        """Gets the service_name of this DatabaseDef.  # noqa: E501

        Database Service Name  # noqa: E501

        :return: The service_name of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """Sets the service_name of this DatabaseDef.

        Database Service Name  # noqa: E501

        :param service_name: The service_name of this DatabaseDef.  # noqa: E501
        :type service_name: str
        """

        self._service_name = service_name

    @property
    def schema_name(self):
        """Gets the schema_name of this DatabaseDef.  # noqa: E501

        Database schema name  # noqa: E501

        :return: The schema_name of this DatabaseDef.  # noqa: E501
        :rtype: str
        """
        return self._schema_name

    @schema_name.setter
    def schema_name(self, schema_name):
        """Sets the schema_name of this DatabaseDef.

        Database schema name  # noqa: E501

        :param schema_name: The schema_name of this DatabaseDef.  # noqa: E501
        :type schema_name: str
        """

        self._schema_name = schema_name

    @property
    def additional_attributes(self):
        """Gets the additional_attributes of this DatabaseDef.  # noqa: E501

        Additional Attributes  # noqa: E501

        :return: The additional_attributes of this DatabaseDef.  # noqa: E501
        :rtype: list[AdditionalAttribute]
        """
        return self._additional_attributes

    @additional_attributes.setter
    def additional_attributes(self, additional_attributes):
        """Sets the additional_attributes of this DatabaseDef.

        Additional Attributes  # noqa: E501

        :param additional_attributes: The additional_attributes of this DatabaseDef.  # noqa: E501
        :type additional_attributes: list[AdditionalAttribute]
        """

        self._additional_attributes = additional_attributes

    @property
    def pgattributes(self):
        """Gets the pgattributes of this DatabaseDef.  # noqa: E501


        :return: The pgattributes of this DatabaseDef.  # noqa: E501
        :rtype: PgAttributes
        """
        return self._pgattributes

    @pgattributes.setter
    def pgattributes(self, pgattributes):
        """Sets the pgattributes of this DatabaseDef.


        :param pgattributes: The pgattributes of this DatabaseDef.  # noqa: E501
        :type pgattributes: PgAttributes
        """

        self._pgattributes = pgattributes

    @property
    def shared_access(self):
        """Gets the shared_access of this DatabaseDef.  # noqa: E501

        List of components that can access this database  # noqa: E501

        :return: The shared_access of this DatabaseDef.  # noqa: E501
        :rtype: list[SharedAccess]
        """
        return self._shared_access

    @shared_access.setter
    def shared_access(self, shared_access):
        """Sets the shared_access of this DatabaseDef.

        List of components that can access this database  # noqa: E501

        :param shared_access: The shared_access of this DatabaseDef.  # noqa: E501
        :type shared_access: list[SharedAccess]
        """

        self._shared_access = shared_access

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatabaseDef):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DatabaseDef):
            return True

        return self.to_dict() != other.to_dict()
