# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ExceptionAlertData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'alert_id': 'int',
        'severity': 'str',
        'status': 'str',
        'component_type': 'str',
        'component_name': 'str',
        'date_time': 'str',
        'message_code': 'str',
        'message': 'str',
        'comment': 'str',
        'repeat_counter': 'int'
    }

    attribute_map = {
        'alert_id': 'alertID',
        'severity': 'severity',
        'status': 'status',
        'component_type': 'componentType',
        'component_name': 'componentName',
        'date_time': 'dateTime',
        'message_code': 'messageCode',
        'message': 'message',
        'comment': 'comment',
        'repeat_counter': 'repeatCounter'
    }

    def __init__(self, alert_id=None, severity=None, status=None, component_type=None, component_name=None, date_time=None, message_code=None, message=None, comment=None, repeat_counter=None, local_vars_configuration=None):  # noqa: E501
        """ExceptionAlertData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._alert_id = None
        self._severity = None
        self._status = None
        self._component_type = None
        self._component_name = None
        self._date_time = None
        self._message_code = None
        self._message = None
        self._comment = None
        self._repeat_counter = None
        self.discriminator = None

        if alert_id is not None:
            self.alert_id = alert_id
        if severity is not None:
            self.severity = severity
        if status is not None:
            self.status = status
        if component_type is not None:
            self.component_type = component_type
        if component_name is not None:
            self.component_name = component_name
        if date_time is not None:
            self.date_time = date_time
        if message_code is not None:
            self.message_code = message_code
        if message is not None:
            self.message = message
        if comment is not None:
            self.comment = comment
        if repeat_counter is not None:
            self.repeat_counter = repeat_counter

    @property
    def alert_id(self):
        """Gets the alert_id of this ExceptionAlertData.  # noqa: E501

        Exception alert ID.  # noqa: E501

        :return: The alert_id of this ExceptionAlertData.  # noqa: E501
        :rtype: int
        """
        return self._alert_id

    @alert_id.setter
    def alert_id(self, alert_id):
        """Sets the alert_id of this ExceptionAlertData.

        Exception alert ID.  # noqa: E501

        :param alert_id: The alert_id of this ExceptionAlertData.  # noqa: E501
        :type alert_id: int
        """

        self._alert_id = alert_id

    @property
    def severity(self):
        """Gets the severity of this ExceptionAlertData.  # noqa: E501

        Exception alert severity (Warning/Error/Severe).  # noqa: E501

        :return: The severity of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this ExceptionAlertData.

        Exception alert severity (Warning/Error/Severe).  # noqa: E501

        :param severity: The severity of this ExceptionAlertData.  # noqa: E501
        :type severity: str
        """

        self._severity = severity

    @property
    def status(self):
        """Gets the status of this ExceptionAlertData.  # noqa: E501

        Exception alert status (Handled/Not Handled). EDITABLE.  # noqa: E501

        :return: The status of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ExceptionAlertData.

        Exception alert status (Handled/Not Handled). EDITABLE.  # noqa: E501

        :param status: The status of this ExceptionAlertData.  # noqa: E501
        :type status: str
        """

        self._status = status

    @property
    def component_type(self):
        """Gets the component_type of this ExceptionAlertData.  # noqa: E501

        Component type of the exception alert (CMS,Agent,Load Balancer,Control-M/Server,Control-M/EM etc.).  # noqa: E501

        :return: The component_type of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._component_type

    @component_type.setter
    def component_type(self, component_type):
        """Sets the component_type of this ExceptionAlertData.

        Component type of the exception alert (CMS,Agent,Load Balancer,Control-M/Server,Control-M/EM etc.).  # noqa: E501

        :param component_type: The component_type of this ExceptionAlertData.  # noqa: E501
        :type component_type: str
        """

        self._component_type = component_type

    @property
    def component_name(self):
        """Gets the component_name of this ExceptionAlertData.  # noqa: E501

        Component name of the exception alert.  # noqa: E501

        :return: The component_name of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name):
        """Sets the component_name of this ExceptionAlertData.

        Component name of the exception alert.  # noqa: E501

        :param component_name: The component_name of this ExceptionAlertData.  # noqa: E501
        :type component_name: str
        """

        self._component_name = component_name

    @property
    def date_time(self):
        """Gets the date_time of this ExceptionAlertData.  # noqa: E501

        The date and time when the exception alert occur. Date-Time format ( MM/DD/YYYY HH:MM AM/PM ).  # noqa: E501

        :return: The date_time of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._date_time

    @date_time.setter
    def date_time(self, date_time):
        """Sets the date_time of this ExceptionAlertData.

        The date and time when the exception alert occur. Date-Time format ( MM/DD/YYYY HH:MM AM/PM ).  # noqa: E501

        :param date_time: The date_time of this ExceptionAlertData.  # noqa: E501
        :type date_time: str
        """

        self._date_time = date_time

    @property
    def message_code(self):
        """Gets the message_code of this ExceptionAlertData.  # noqa: E501

        Message code of the reported exception alert.  # noqa: E501

        :return: The message_code of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._message_code

    @message_code.setter
    def message_code(self, message_code):
        """Sets the message_code of this ExceptionAlertData.

        Message code of the reported exception alert.  # noqa: E501

        :param message_code: The message_code of this ExceptionAlertData.  # noqa: E501
        :type message_code: str
        """

        self._message_code = message_code

    @property
    def message(self):
        """Gets the message of this ExceptionAlertData.  # noqa: E501

        Information about the reported exception alert.  # noqa: E501

        :return: The message of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ExceptionAlertData.

        Information about the reported exception alert.  # noqa: E501

        :param message: The message of this ExceptionAlertData.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def comment(self):
        """Gets the comment of this ExceptionAlertData.  # noqa: E501

        Customer note about the exception alert. EDITABLE.  # noqa: E501

        :return: The comment of this ExceptionAlertData.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this ExceptionAlertData.

        Customer note about the exception alert. EDITABLE.  # noqa: E501

        :param comment: The comment of this ExceptionAlertData.  # noqa: E501
        :type comment: str
        """

        self._comment = comment

    @property
    def repeat_counter(self):
        """Gets the repeat_counter of this ExceptionAlertData.  # noqa: E501

        Number of times this exception alert reported.  # noqa: E501

        :return: The repeat_counter of this ExceptionAlertData.  # noqa: E501
        :rtype: int
        """
        return self._repeat_counter

    @repeat_counter.setter
    def repeat_counter(self, repeat_counter):
        """Sets the repeat_counter of this ExceptionAlertData.

        Number of times this exception alert reported.  # noqa: E501

        :param repeat_counter: The repeat_counter of this ExceptionAlertData.  # noqa: E501
        :type repeat_counter: int
        """

        self._repeat_counter = repeat_counter

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExceptionAlertData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExceptionAlertData):
            return True

        return self.to_dict() != other.to_dict()
