# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class JobSchedulingPlan(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'calculation_status': 'str',
        'job_name': 'str',
        'job_order': 'str',
        'job_order_info': 'JobOrderInfo',
        'job_view': 'JobView',
        'messages': 'list[str]',
        'parent_table': 'str'
    }

    attribute_map = {
        'calculation_status': 'calculation_status',
        'job_name': 'job_name',
        'job_order': 'job_order',
        'job_order_info': 'job_order_info',
        'job_view': 'job_view',
        'messages': 'messages',
        'parent_table': 'parent_table'
    }

    def __init__(self, calculation_status=None, job_name=None, job_order=None, job_order_info=None, job_view=None, messages=None, parent_table=None, local_vars_configuration=None):  # noqa: E501
        """JobSchedulingPlan - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._calculation_status = None
        self._job_name = None
        self._job_order = None
        self._job_order_info = None
        self._job_view = None
        self._messages = None
        self._parent_table = None
        self.discriminator = None

        if calculation_status is not None:
            self.calculation_status = calculation_status
        if job_name is not None:
            self.job_name = job_name
        if job_order is not None:
            self.job_order = job_order
        if job_order_info is not None:
            self.job_order_info = job_order_info
        if job_view is not None:
            self.job_view = job_view
        if messages is not None:
            self.messages = messages
        if parent_table is not None:
            self.parent_table = parent_table

    @property
    def calculation_status(self):
        """Gets the calculation_status of this JobSchedulingPlan.  # noqa: E501


        :return: The calculation_status of this JobSchedulingPlan.  # noqa: E501
        :rtype: str
        """
        return self._calculation_status

    @calculation_status.setter
    def calculation_status(self, calculation_status):
        """Sets the calculation_status of this JobSchedulingPlan.


        :param calculation_status: The calculation_status of this JobSchedulingPlan.  # noqa: E501
        :type calculation_status: str
        """
        allowed_values = ["SUCCESS", "ERROR", "UNRECOGNIZED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and calculation_status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `calculation_status` ({0}), must be one of {1}"  # noqa: E501
                .format(calculation_status, allowed_values)
            )

        self._calculation_status = calculation_status

    @property
    def job_name(self):
        """Gets the job_name of this JobSchedulingPlan.  # noqa: E501


        :return: The job_name of this JobSchedulingPlan.  # noqa: E501
        :rtype: str
        """
        return self._job_name

    @job_name.setter
    def job_name(self, job_name):
        """Sets the job_name of this JobSchedulingPlan.


        :param job_name: The job_name of this JobSchedulingPlan.  # noqa: E501
        :type job_name: str
        """

        self._job_name = job_name

    @property
    def job_order(self):
        """Gets the job_order of this JobSchedulingPlan.  # noqa: E501


        :return: The job_order of this JobSchedulingPlan.  # noqa: E501
        :rtype: str
        """
        return self._job_order

    @job_order.setter
    def job_order(self, job_order):
        """Sets the job_order of this JobSchedulingPlan.


        :param job_order: The job_order of this JobSchedulingPlan.  # noqa: E501
        :type job_order: str
        """

        self._job_order = job_order

    @property
    def job_order_info(self):
        """Gets the job_order_info of this JobSchedulingPlan.  # noqa: E501


        :return: The job_order_info of this JobSchedulingPlan.  # noqa: E501
        :rtype: JobOrderInfo
        """
        return self._job_order_info

    @job_order_info.setter
    def job_order_info(self, job_order_info):
        """Sets the job_order_info of this JobSchedulingPlan.


        :param job_order_info: The job_order_info of this JobSchedulingPlan.  # noqa: E501
        :type job_order_info: JobOrderInfo
        """

        self._job_order_info = job_order_info

    @property
    def job_view(self):
        """Gets the job_view of this JobSchedulingPlan.  # noqa: E501


        :return: The job_view of this JobSchedulingPlan.  # noqa: E501
        :rtype: JobView
        """
        return self._job_view

    @job_view.setter
    def job_view(self, job_view):
        """Sets the job_view of this JobSchedulingPlan.


        :param job_view: The job_view of this JobSchedulingPlan.  # noqa: E501
        :type job_view: JobView
        """

        self._job_view = job_view

    @property
    def messages(self):
        """Gets the messages of this JobSchedulingPlan.  # noqa: E501


        :return: The messages of this JobSchedulingPlan.  # noqa: E501
        :rtype: list[str]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this JobSchedulingPlan.


        :param messages: The messages of this JobSchedulingPlan.  # noqa: E501
        :type messages: list[str]
        """

        self._messages = messages

    @property
    def parent_table(self):
        """Gets the parent_table of this JobSchedulingPlan.  # noqa: E501


        :return: The parent_table of this JobSchedulingPlan.  # noqa: E501
        :rtype: str
        """
        return self._parent_table

    @parent_table.setter
    def parent_table(self, parent_table):
        """Sets the parent_table of this JobSchedulingPlan.


        :param parent_table: The parent_table of this JobSchedulingPlan.  # noqa: E501
        :type parent_table: str
        """

        self._parent_table = parent_table

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobSchedulingPlan):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobSchedulingPlan):
            return True

        return self.to_dict() != other.to_dict()
