# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ActionsAuthRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'destination': 'str',
        'action': 'str',
        'category': 'str',
        'auth_level': 'str',
        'action_type': 'str',
        'additional_info': 'str',
        'category2': 'str',
        'policy': 'str',
        'auth_attr': 'str'
    }

    attribute_map = {
        'destination': 'destination',
        'action': 'action',
        'category': 'category',
        'auth_level': 'authLevel',
        'action_type': 'actionType',
        'additional_info': 'additionalInfo',
        'category2': 'category2',
        'policy': 'policy',
        'auth_attr': 'authAttr'
    }

    def __init__(self, destination=None, action=None, category=None, auth_level=None, action_type=None, additional_info=None, category2=None, policy=None, auth_attr=None, local_vars_configuration=None):  # noqa: E501
        """ActionsAuthRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._destination = None
        self._action = None
        self._category = None
        self._auth_level = None
        self._action_type = None
        self._additional_info = None
        self._category2 = None
        self._policy = None
        self._auth_attr = None
        self.discriminator = None

        if destination is not None:
            self.destination = destination
        if action is not None:
            self.action = action
        if category is not None:
            self.category = category
        if auth_level is not None:
            self.auth_level = auth_level
        if action_type is not None:
            self.action_type = action_type
        if additional_info is not None:
            self.additional_info = additional_info
        if category2 is not None:
            self.category2 = category2
        if policy is not None:
            self.policy = policy
        if auth_attr is not None:
            self.auth_attr = auth_attr

    @property
    def destination(self):
        """Gets the destination of this ActionsAuthRecord.  # noqa: E501

        component in which the action sent - Possible Values - EM, CTM_Server, CTM_Agent, CTM_CM  # noqa: E501

        :return: The destination of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """Sets the destination of this ActionsAuthRecord.

        component in which the action sent - Possible Values - EM, CTM_Server, CTM_Agent, CTM_CM  # noqa: E501

        :param destination: The destination of this ActionsAuthRecord.  # noqa: E501
        :type destination: str
        """
        allowed_values = ["EM", "CTM_Server", "CTM_Agent", "CTM_CM"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and destination not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `destination` ({0}), must be one of {1}"  # noqa: E501
                .format(destination, allowed_values)
            )

        self._destination = destination

    @property
    def action(self):
        """Gets the action of this ActionsAuthRecord.  # noqa: E501

        action name unique list of actions' names as appear in the actions_auth em db table, along with the destination makes a unique action auth entry  # noqa: E501

        :return: The action of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this ActionsAuthRecord.

        action name unique list of actions' names as appear in the actions_auth em db table, along with the destination makes a unique action auth entry  # noqa: E501

        :param action: The action of this ActionsAuthRecord.  # noqa: E501
        :type action: str
        """
        allowed_values = ["Collect_measurements_and_reports_request", "Set_agent_debug_info_request", "Get_agent_debug_info_request", "Set_agent_config_params_request", "Get_agent_config_params_request", "Ctmag_set_cert_request", "Ctmag_get_csr_request", "Ctmag_get_cert_expire_date_request", "Ctmag_get_config_request", "Ctmagent_recycle_request", "Ctmag_get_locale_list_request", "Ctmag_update_config_request", "Authorize_remote_host_request", "Ctmsap_update_ew_config_request", "Ctmsap_get_ew_config_request", "Ctmcm_update_extract_rule_table_request", "Ctmcm_get_extract_rule_table_request", "Ctmcm_get_templates_request", "Ctmcm_get_accounts_request", "Ctmcm_add_account_request", "Ctmcm_update_account_request", "Ctmcm_delete_account_request", "Ctmcm_validate_account_request", "Ctmcm_get_info_request", "Ctmcm_mass_update_request", "Ctmcm_get_config_request", "Ctmcm_update_config_request", "Ctmsap_get_accounts_names_request", "Ctmsap_get_sap_interception_criteria_request", "Ctmsap_update_sap_interception_criteria_request", "Ctmsap_get_ctm_interception_rules_request", "Ctmsap_update_ctm_interception_rules_request", "Ctmsap_get_extract_rules_request", "Ctmsap_update_extract_rules_request", "Ctmsap_get_user_exit_files_request", "Ctmsap_get_xtractor_config_request", "Ctmsap_update_xtractor_config_request", "Ctmsap_check_XBP2_enable_request", "Ctmsap_get_sap_calendars_request", "Ctmsap_import_sap_calendar_request", "Ctmsap_get_ew_events_names_request", "Ctmsap_create_profile_request", "Ctmsap_set_profile_request", "Ctmsap_delete_profile_request", "Ctmsap_get_profiles_request", "Ctmsap_get_profile_criteria_request", "Ctmsap_activate_profile_request", "Ctmag_set_extract_service_status_request", "Ctmag_update_extract_service_prop_request", "Ctmag_get_extract_service_prop_request", "Ctmcm_jndi_browse_request", "Ctmcm_load_ejb_request", "Ctmcm_get_encryption_type_request", "Ctmcm_get_known_hosts_request", "Ctmcm_update_aft_server_configuration_request", "Ctmcm_get_aft_server_configuration_request", "Ctmcm_verify_local_path_request", "Ctmcm_mft_b2b_rest_patch_request", "Ctmcm_get_as2_encryption_algorithms_request", "Ctmcm_get_as2_signature_algorithms_request", "Ctmcm_get_s3_regions_request", "Ctmcm_get_oracle_regions_request", "Ctmcm_get_oracle_compartments_request", "Ctmcm_get_ssh_keys_content_request", "Ctmdb_remove_dbvendor_request", "Ctmdb_update_dbvendor_request", "Ctmdb_add_dbvendor_request", "Ctmcm_mft_get_b2b_mode_request", "Ctmcm_mft_b2b_rest_delete_request", "Ctmcm_mft_b2b_rest_read_request", "Ctmcm_mft_b2b_rest_update_request", "Ctmcm_mft_b2b_rest_create_request", "Ctmcm_mft_b2b_general_command_request", "Ctmpsft_recycle_request", "Ctmcm_get_Mvs_templates_request", "Ctmcm_delete_Mvs_template_request", "Ctmcm_add_Mvs_template_request", "Ctmcm_update_Mvs_template_request", "Ctmsap_update_sap_interception_profile_request", "Ctmsap_get_sap_interception_profiles_request", "Ctmcm_get_pgp_templates_request", "Ctmcm_delete_pgp_template_request", "Ctmcm_add_pgp_template_request", "Ctmcm_update_pgp_template_request", "Ctmcm_mass_update_details_request", "Ctmcm_create_ssh_key_request", "Ctmcm_authorize_remote_host_request", "Ctmcm_get_home_directory_request", "Ctmoebs_activate_ew_request", "Ctmoebs_get_alerts_list_request", "Ctmoebs_get_applications_list_request", "Ctmoebs_update_ew_rules_request", "Ctmoebs_get_ew_rules_request", "Ctmoebs_update_ew_config_request", "Ctmoebs_get_ew_config_request", "Ctmoebs_get_service_names_request", "Ctmcm_browse_file_request", "Ctmsap_clear_events_request", "Ctmsap_update_ew_rules_request", "Ctmsap_get_ew_rules_request", "Zos_get_sys_parms_request", "Update_deployment_target_request", "Update_deployment_parameters_request", "Get_deployment_output_request", "Retry_deployment_request", "Cancel_deployment_request", "Delete_deployment_request", "Add_uninstall_deployment_request", "Ctmsec_get_users_groups_request", "Ctmsec_delete_user_request", "Ctmsec_delete_group_request", "Ctmsec_update_user_request", "Ctmsec_update_group_request", "Ctmsec_new_user_request", "Ctmsec_new_group_request", "Ctmsec_get_security_attributes_request", "Ctmsec_update_security_attributes_request", "Ctmagent_add_request", "Ctmagent_delete_request", "Ctmagent_ping_request", "Ctmagent_get_parameters_request", "Ctmagent_set_parameters_request", "Ctmagent_enable_request", "Ctmagent_disable_request", "Get_ctms_debug_info_request", "Set_ctms_debug_info_request", "Ctmrjx_get_host_details_request", "Ctmrjx_add_host_request", "Ctmrjx_update_host_request", "Ctmrjx_delete_host_request", "Ctmrjx_test_host_request", "Ctmrjx_enable_host_request", "Ctmrjx_disable_host_request", "Ctmrjx_ping_host_request", "Ctmrjx_get_owners_request", "Ctmrjx_get_owner_details_request", "Ctmrjx_add_owner_request", "Ctmrjx_update_owner_request", "Ctmrjx_delete_owner_request", "Ctmrjx_get_keynames_list_request", "Ctmrjx_test_user_request", "Ctm_get_node_groups_request", "Ctm_update_node_group_request", "Ctm_add_node_group_request", "Ctm_delete_node_group_request", "Zos_ctl_request", "Zos_new_sys_parm_request", "Zos_update_sys_parm_request", "Zos_delete_sys_parm_request", "Zos_refresh_sys_parms_request", "Ctmnodeid_test_user_request", "Ctm_server_get_sys_parms_request", "Ctm_server_update_sys_parm_request", "Ctm_server_refresh_sys_parms_request", "Set_pause_request", "Zos_get_sys_parms_enhanced_request", "Ctmserver_get_ssh_keys_list_request", "Ctmserver_create_ssh_key_request", "Ctmserver_update_ssh_key_request", "Ctmserver_delete_ssh_key_request", "Ctmserver_get_public_key_request", "Get_supported_shout_destination_addresses_request", "Get_shout_destination_tables_request", "Delete_shout_destination_table_request", "Set_active_shout_destination_table_request", "Update_shout_destination_request", "Create_shout_destination_request", "Delete_shout_destination_request", "Ctm_get_all_node_restrictions_request", "Ctm_add_node_restriction_request", "Ctm_update_node_restriction_request", "Ctm_delete_node_restrictions_request", "Ctmsrv_get_cm_accounts_status_request", "Ctmsrv_update_cm_account_status_request", "Set_ctm_primary_request", "Set_ctm_failover_mode_request", "Replication_mode_request", "Ctmagent_troubleshooting_request", "Set_db_host_port_request", "Get_db_host_port_request", "Xalert_unhandle_request", "Create_em_component_request", "Get_component_request", "Refresh_ctms_ag_deploy_request", "Refresh_ctms_request", "Get_agents_request", "Xalert_handle_request", "Get_all_node_groups_request", "Get_components_request", "View_agents_log_request", "Get_xalerts_request", "Delete_sys_parms_request", "Update_sys_parms_request", "New_sys_parms_request", "Get_sys_parms_request", "Get_cms_details_request", "Get_ctms_codes_request", "Delete_ctms_request", "Ccp_add_or_update_request", "Ccp_get_summary_request", "Ccp_get_full_request", "Ccp_delete_request", "Ccp_get_sync_status_request", "Get_webserver_debuglevelinfo_request", "New_ctms_request", "Discover_request", "Get_ctms_details_request", "Un_manage_ctms_request", "Manage_ctms_request", "Disable_ctms_request", "Get_WebServer_urls_request", "Enable_ctms_request", "Rename_CTMServer_dry_run_request", "Get_db_details_request", "Get_em_details_request", "Move_em_control_request", "Set_webserver_debuglevelinfo_request", "Set_em_primary_request", "Start_replication_request", "Create_xalert_request", "Set_em_failover_mode_request", "Purge_xalerts_request", "Remove_old_versions_request", "Move_em_ctm_control_request", "Set_em_ctm_primary_request", "Get_capacity_exceed_alert_params_request", "Set_capacity_exceed_alert_params_request", "Test_envs_connectivity_request", "Set_enable_capacity_exceed_alert_request", "Get_enable_capacity_exceed_alert_request", "Get_license_site_info_request", "Get_license_info_request", "Update_license_request", "Get_web_server_details_request", "Get_available_client_updates_request", "Set_required_fp_or_patch_request", "Import_client_certificates_request", "Get_archive_server_conf_request", "Set_archive_server_conf_request", "Archive_Browse_CCM", "Archive_Update_CCM", "Set_B2B_mode_for_mft_request", "Promote_and_rename_CTMServer_request", "Get_compatibility_details_request", "Set_compatibility_version_request", "Update_local_CTMServer_attribute_request", "Update_ctms_request", "Ignore_request", "Recycle_request", "Stop_request", "Start_request", "Get_em_component_request", "Delete_em_component_request", "Remove_old_alerts_request", "Update_em_component_request", "List_em_user_names_request", "Get_diag_output_request", "Add_deployment_request", "Get_deployment_list_request", "Get_machine_details_request", "Get_packages_request", "Update_Add_Ons_request", "Get_Add_Ons_request", "LDAP_get_types_request", "Web_launch_prepare_package", "ManageSSL_generate_certificate_request", "ManageSSL_get_components_request", "ManageSSL_create_new_CA_request", "ManageSSL_get_CA_details_request", "Is_annotation_required_request", "Actions_auth_request", "Login_admin_db_request", "Db_extend_request", "Get_db_file_list_request", "Db_check_space_request", "Polling_request", "Ctl_request", "Xalert_update_note_request", "Ctmcm_mft_set_b2b_mode_request", "Get_ctm_node_groups_request", "Get_ctm_node_group_request", "Activate_server_request", "Deactivate_server_request", "Delete_sys_parms_ext_request", "Get_sys_parms_ext_request", "New_sys_parms_ext_request", "Update_Add_Ons_request_with_audit", "Update_sys_parms_ext_request", "internal_New_ctms_request"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and action not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def category(self):
        """Gets the category of this ActionsAuthRecord.  # noqa: E501

        Privilege (Can be empty) Possible Values for categories fields  - OPER, DATABASE, CONFIG, CTMSEC, CPMAN, RAMAN, AGMAN, CMMAN, CCP, UNKNOWN  # noqa: E501

        :return: The category of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this ActionsAuthRecord.

        Privilege (Can be empty) Possible Values for categories fields  - OPER, DATABASE, CONFIG, CTMSEC, CPMAN, RAMAN, AGMAN, CMMAN, CCP, UNKNOWN  # noqa: E501

        :param category: The category of this ActionsAuthRecord.  # noqa: E501
        :type category: str
        """

        self._category = category

    @property
    def auth_level(self):
        """Gets the auth_level of this ActionsAuthRecord.  # noqa: E501

        required minimum authorization level - BROWSE, UPDATE, FULL  # noqa: E501

        :return: The auth_level of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._auth_level

    @auth_level.setter
    def auth_level(self, auth_level):
        """Sets the auth_level of this ActionsAuthRecord.

        required minimum authorization level - BROWSE, UPDATE, FULL  # noqa: E501

        :param auth_level: The auth_level of this ActionsAuthRecord.  # noqa: E501
        :type auth_level: str
        """

        self._auth_level = auth_level

    @property
    def action_type(self):
        """Gets the action_type of this ActionsAuthRecord.  # noqa: E501

        R - request always pass, authorization is done on the response; C - Connection Profile name will remain empty and will be ignored; E - Not related to authorization  # noqa: E501

        :return: The action_type of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """Sets the action_type of this ActionsAuthRecord.

        R - request always pass, authorization is done on the response; C - Connection Profile name will remain empty and will be ignored; E - Not related to authorization  # noqa: E501

        :param action_type: The action_type of this ActionsAuthRecord.  # noqa: E501
        :type action_type: str
        """

        self._action_type = action_type

    @property
    def additional_info(self):
        """Gets the additional_info of this ActionsAuthRecord.  # noqa: E501

        currently not in use regarding authorization  # noqa: E501

        :return: The additional_info of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """Sets the additional_info of this ActionsAuthRecord.

        currently not in use regarding authorization  # noqa: E501

        :param additional_info: The additional_info of this ActionsAuthRecord.  # noqa: E501
        :type additional_info: str
        """

        self._additional_info = additional_info

    @property
    def category2(self):
        """Gets the category2 of this ActionsAuthRecord.  # noqa: E501


        :return: The category2 of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._category2

    @category2.setter
    def category2(self, category2):
        """Sets the category2 of this ActionsAuthRecord.


        :param category2: The category2 of this ActionsAuthRecord.  # noqa: E501
        :type category2: str
        """

        self._category2 = category2

    @property
    def policy(self):
        """Gets the policy of this ActionsAuthRecord.  # noqa: E501

        relation between Category and category2 - 1. Only category, 2. Only Category2, 3. Category AND Category2, 4. Category OR Category2  # noqa: E501

        :return: The policy of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._policy

    @policy.setter
    def policy(self, policy):
        """Sets the policy of this ActionsAuthRecord.

        relation between Category and category2 - 1. Only category, 2. Only Category2, 3. Category AND Category2, 4. Category OR Category2  # noqa: E501

        :param policy: The policy of this ActionsAuthRecord.  # noqa: E501
        :type policy: str
        """
        allowed_values = ["CTG", "CTG2", "CTG_AND_CTG2", "CTG_OR_CTG2"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and policy not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `policy` ({0}), must be one of {1}"  # noqa: E501
                .format(policy, allowed_values)
            )

        self._policy = policy

    @property
    def auth_attr(self):
        """Gets the auth_attr of this ActionsAuthRecord.  # noqa: E501

        In case that not all information for authorization exist in the header request, it contain path in the body for the missing field\\fields.  # noqa: E501

        :return: The auth_attr of this ActionsAuthRecord.  # noqa: E501
        :rtype: str
        """
        return self._auth_attr

    @auth_attr.setter
    def auth_attr(self, auth_attr):
        """Sets the auth_attr of this ActionsAuthRecord.

        In case that not all information for authorization exist in the header request, it contain path in the body for the missing field\\fields.  # noqa: E501

        :param auth_attr: The auth_attr of this ActionsAuthRecord.  # noqa: E501
        :type auth_attr: str
        """

        self._auth_attr = auth_attr

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActionsAuthRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ActionsAuthRecord):
            return True

        return self.to_dict() != other.to_dict()
