# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class AgentThingProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'physical_name': 'str',
        'tag': 'str',
        'server': 'str',
        'recreate_sqs': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'physical_name': 'physicalName',
        'tag': 'tag',
        'server': 'server',
        'recreate_sqs': 'recreateSqs'
    }

    def __init__(self, name=None, physical_name=None, tag=None, server=None, recreate_sqs=None, local_vars_configuration=None):  # noqa: E501
        """AgentThingProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._physical_name = None
        self._tag = None
        self._server = None
        self._recreate_sqs = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if physical_name is not None:
            self.physical_name = physical_name
        if tag is not None:
            self.tag = tag
        if server is not None:
            self.server = server
        if recreate_sqs is not None:
            self.recreate_sqs = recreate_sqs

    @property
    def name(self):
        """Gets the name of this AgentThingProperties.  # noqa: E501

        the logical name to be used for new agent (equivilant to NodeId)  # noqa: E501

        :return: The name of this AgentThingProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AgentThingProperties.

        the logical name to be used for new agent (equivilant to NodeId)  # noqa: E501

        :param name: The name of this AgentThingProperties.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def physical_name(self):
        """Gets the physical_name of this AgentThingProperties.  # noqa: E501

        the physical name of the thing the agent is installed on  # noqa: E501

        :return: The physical_name of this AgentThingProperties.  # noqa: E501
        :rtype: str
        """
        return self._physical_name

    @physical_name.setter
    def physical_name(self, physical_name):
        """Sets the physical_name of this AgentThingProperties.

        the physical name of the thing the agent is installed on  # noqa: E501

        :param physical_name: The physical_name of this AgentThingProperties.  # noqa: E501
        :type physical_name: str
        """

        self._physical_name = physical_name

    @property
    def tag(self):
        """Gets the tag of this AgentThingProperties.  # noqa: E501

        the agent tag to be associated with the new agent (CMS RBA permissions tag that is)  # noqa: E501

        :return: The tag of this AgentThingProperties.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this AgentThingProperties.

        the agent tag to be associated with the new agent (CMS RBA permissions tag that is)  # noqa: E501

        :param tag: The tag of this AgentThingProperties.  # noqa: E501
        :type tag: str
        """

        self._tag = tag

    @property
    def server(self):
        """Gets the server of this AgentThingProperties.  # noqa: E501

        the server name to be used for new agent  # noqa: E501

        :return: The server of this AgentThingProperties.  # noqa: E501
        :rtype: str
        """
        return self._server

    @server.setter
    def server(self, server):
        """Sets the server of this AgentThingProperties.

        the server name to be used for new agent  # noqa: E501

        :param server: The server of this AgentThingProperties.  # noqa: E501
        :type server: str
        """

        self._server = server

    @property
    def recreate_sqs(self):
        """Gets the recreate_sqs of this AgentThingProperties.  # noqa: E501

        This parameter would signal CTMS to recreate the SQS as needed.  # noqa: E501

        :return: The recreate_sqs of this AgentThingProperties.  # noqa: E501
        :rtype: bool
        """
        return self._recreate_sqs

    @recreate_sqs.setter
    def recreate_sqs(self, recreate_sqs):
        """Sets the recreate_sqs of this AgentThingProperties.

        This parameter would signal CTMS to recreate the SQS as needed.  # noqa: E501

        :param recreate_sqs: The recreate_sqs of this AgentThingProperties.  # noqa: E501
        :type recreate_sqs: bool
        """

        self._recreate_sqs = recreate_sqs

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AgentThingProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AgentThingProperties):
            return True

        return self.to_dict() != other.to_dict()
