# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class RunReport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'format': 'str',
        'filters': 'list[ReportFilter]',
        'date_time_settings': 'ReportDateTimeSettings'
    }

    attribute_map = {
        'name': 'name',
        'format': 'format',
        'filters': 'filters',
        'date_time_settings': 'dateTimeSettings'
    }

    def __init__(self, name=None, format=None, filters=None, date_time_settings=None, local_vars_configuration=None):  # noqa: E501
        """RunReport - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._format = None
        self._filters = None
        self._date_time_settings = None
        self.discriminator = None

        self.name = name
        if format is not None:
            self.format = format
        if filters is not None:
            self.filters = filters
        if date_time_settings is not None:
            self.date_time_settings = date_time_settings

    @property
    def name(self):
        """Gets the name of this RunReport.  # noqa: E501


        :return: The name of this RunReport.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RunReport.


        :param name: The name of this RunReport.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def format(self):
        """Gets the format of this RunReport.  # noqa: E501


        :return: The format of this RunReport.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this RunReport.


        :param format: The format of this RunReport.  # noqa: E501
        :type format: str
        """

        self._format = format

    @property
    def filters(self):
        """Gets the filters of this RunReport.  # noqa: E501


        :return: The filters of this RunReport.  # noqa: E501
        :rtype: list[ReportFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this RunReport.


        :param filters: The filters of this RunReport.  # noqa: E501
        :type filters: list[ReportFilter]
        """

        self._filters = filters

    @property
    def date_time_settings(self):
        """Gets the date_time_settings of this RunReport.  # noqa: E501


        :return: The date_time_settings of this RunReport.  # noqa: E501
        :rtype: ReportDateTimeSettings
        """
        return self._date_time_settings

    @date_time_settings.setter
    def date_time_settings(self, date_time_settings):
        """Sets the date_time_settings of this RunReport.


        :param date_time_settings: The date_time_settings of this RunReport.  # noqa: E501
        :type date_time_settings: ReportDateTimeSettings
        """

        self._date_time_settings = date_time_settings

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RunReport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RunReport):
            return True

        return self.to_dict() != other.to_dict()
