# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class KeyValue(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'value': 'str',
        'default_value': 'str',
        'validation': 'str',
        'category': 'str',
        'description': 'str',
        'err_msg': 'str',
        'verification': 'str',
        'table': 'str',
        'type': 'str',
        'limits': 'str',
        'refresh': 'str',
        'refresh_type_description': 'str',
        'last_updated': 'str',
        'component': 'str',
        'component_type': 'str',
        'component_host': 'str'
    }

    attribute_map = {
        'name': 'name',
        'value': 'value',
        'default_value': 'defaultValue',
        'validation': 'validation',
        'category': 'category',
        'description': 'description',
        'err_msg': 'errMsg',
        'verification': 'verification',
        'table': 'table',
        'type': 'type',
        'limits': 'limits',
        'refresh': 'refresh',
        'refresh_type_description': 'refreshTypeDescription',
        'last_updated': 'LastUpdated',
        'component': 'component',
        'component_type': 'componentType',
        'component_host': 'componentHost'
    }

    def __init__(self, name=None, value=None, default_value=None, validation=None, category=None, description=None, err_msg=None, verification=None, table=None, type=None, limits=None, refresh=None, refresh_type_description=None, last_updated=None, component=None, component_type=None, component_host=None, local_vars_configuration=None):  # noqa: E501
        """KeyValue - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._value = None
        self._default_value = None
        self._validation = None
        self._category = None
        self._description = None
        self._err_msg = None
        self._verification = None
        self._table = None
        self._type = None
        self._limits = None
        self._refresh = None
        self._refresh_type_description = None
        self._last_updated = None
        self._component = None
        self._component_type = None
        self._component_host = None
        self.discriminator = None

        self.name = name
        self.value = value
        if default_value is not None:
            self.default_value = default_value
        if validation is not None:
            self.validation = validation
        if category is not None:
            self.category = category
        if description is not None:
            self.description = description
        if err_msg is not None:
            self.err_msg = err_msg
        if verification is not None:
            self.verification = verification
        if table is not None:
            self.table = table
        if type is not None:
            self.type = type
        if limits is not None:
            self.limits = limits
        if refresh is not None:
            self.refresh = refresh
        if refresh_type_description is not None:
            self.refresh_type_description = refresh_type_description
        if last_updated is not None:
            self.last_updated = last_updated
        if component is not None:
            self.component = component
        if component_type is not None:
            self.component_type = component_type
        if component_host is not None:
            self.component_host = component_host

    @property
    def name(self):
        """Gets the name of this KeyValue.  # noqa: E501

        Unique key  # noqa: E501

        :return: The name of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this KeyValue.

        Unique key  # noqa: E501

        :param name: The name of this KeyValue.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def value(self):
        """Gets the value of this KeyValue.  # noqa: E501

        Any value in string form.  # noqa: E501

        :return: The value of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this KeyValue.

        Any value in string form.  # noqa: E501

        :param value: The value of this KeyValue.  # noqa: E501
        :type value: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    @property
    def default_value(self):
        """Gets the default_value of this KeyValue.  # noqa: E501

        The default value if exist.  # noqa: E501

        :return: The default_value of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """Sets the default_value of this KeyValue.

        The default value if exist.  # noqa: E501

        :param default_value: The default_value of this KeyValue.  # noqa: E501
        :type default_value: str
        """

        self._default_value = default_value

    @property
    def validation(self):
        """Gets the validation of this KeyValue.  # noqa: E501

        The validation type number.  # noqa: E501

        :return: The validation of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._validation

    @validation.setter
    def validation(self, validation):
        """Sets the validation of this KeyValue.

        The validation type number.  # noqa: E501

        :param validation: The validation of this KeyValue.  # noqa: E501
        :type validation: str
        """

        self._validation = validation

    @property
    def category(self):
        """Gets the category of this KeyValue.  # noqa: E501

        The category of the parameter.  # noqa: E501

        :return: The category of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this KeyValue.

        The category of the parameter.  # noqa: E501

        :param category: The category of this KeyValue.  # noqa: E501
        :type category: str
        """

        self._category = category

    @property
    def description(self):
        """Gets the description of this KeyValue.  # noqa: E501

        The description of the parameter.  # noqa: E501

        :return: The description of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this KeyValue.

        The description of the parameter.  # noqa: E501

        :param description: The description of this KeyValue.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def err_msg(self):
        """Gets the err_msg of this KeyValue.  # noqa: E501

        The error message of the parameter.  # noqa: E501

        :return: The err_msg of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._err_msg

    @err_msg.setter
    def err_msg(self, err_msg):
        """Sets the err_msg of this KeyValue.

        The error message of the parameter.  # noqa: E501

        :param err_msg: The err_msg of this KeyValue.  # noqa: E501
        :type err_msg: str
        """

        self._err_msg = err_msg

    @property
    def verification(self):
        """Gets the verification of this KeyValue.  # noqa: E501

        The verification type of the parameter.  # noqa: E501

        :return: The verification of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._verification

    @verification.setter
    def verification(self, verification):
        """Sets the verification of this KeyValue.

        The verification type of the parameter.  # noqa: E501

        :param verification: The verification of this KeyValue.  # noqa: E501
        :type verification: str
        """

        self._verification = verification

    @property
    def table(self):
        """Gets the table of this KeyValue.  # noqa: E501

        The table the parameter belongs to.  # noqa: E501

        :return: The table of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._table

    @table.setter
    def table(self, table):
        """Sets the table of this KeyValue.

        The table the parameter belongs to.  # noqa: E501

        :param table: The table of this KeyValue.  # noqa: E501
        :type table: str
        """

        self._table = table

    @property
    def type(self):
        """Gets the type of this KeyValue.  # noqa: E501

        The parameter type.  # noqa: E501

        :return: The type of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this KeyValue.

        The parameter type.  # noqa: E501

        :param type: The type of this KeyValue.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def limits(self):
        """Gets the limits of this KeyValue.  # noqa: E501

        The validation limits of the parameter.  # noqa: E501

        :return: The limits of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._limits

    @limits.setter
    def limits(self, limits):
        """Sets the limits of this KeyValue.

        The validation limits of the parameter.  # noqa: E501

        :param limits: The limits of this KeyValue.  # noqa: E501
        :type limits: str
        """

        self._limits = limits

    @property
    def refresh(self):
        """Gets the refresh of this KeyValue.  # noqa: E501

        The server needs to undergo a 'refresh' process in order for the new value of the system parameter to become effective.  # noqa: E501

        :return: The refresh of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._refresh

    @refresh.setter
    def refresh(self, refresh):
        """Sets the refresh of this KeyValue.

        The server needs to undergo a 'refresh' process in order for the new value of the system parameter to become effective.  # noqa: E501

        :param refresh: The refresh of this KeyValue.  # noqa: E501
        :type refresh: str
        """

        self._refresh = refresh

    @property
    def refresh_type_description(self):
        """Gets the refresh_type_description of this KeyValue.  # noqa: E501

        Explanation about the refresh type's process that should be done.  # noqa: E501

        :return: The refresh_type_description of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._refresh_type_description

    @refresh_type_description.setter
    def refresh_type_description(self, refresh_type_description):
        """Sets the refresh_type_description of this KeyValue.

        Explanation about the refresh type's process that should be done.  # noqa: E501

        :param refresh_type_description: The refresh_type_description of this KeyValue.  # noqa: E501
        :type refresh_type_description: str
        """

        self._refresh_type_description = refresh_type_description

    @property
    def last_updated(self):
        """Gets the last_updated of this KeyValue.  # noqa: E501

        The component type.  # noqa: E501

        :return: The last_updated of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this KeyValue.

        The component type.  # noqa: E501

        :param last_updated: The last_updated of this KeyValue.  # noqa: E501
        :type last_updated: str
        """

        self._last_updated = last_updated

    @property
    def component(self):
        """Gets the component of this KeyValue.  # noqa: E501

        The component in the mainframe.  # noqa: E501

        :return: The component of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._component

    @component.setter
    def component(self, component):
        """Sets the component of this KeyValue.

        The component in the mainframe.  # noqa: E501

        :param component: The component of this KeyValue.  # noqa: E501
        :type component: str
        """

        self._component = component

    @property
    def component_type(self):
        """Gets the component_type of this KeyValue.  # noqa: E501

        The component type.  # noqa: E501

        :return: The component_type of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._component_type

    @component_type.setter
    def component_type(self, component_type):
        """Sets the component_type of this KeyValue.

        The component type.  # noqa: E501

        :param component_type: The component_type of this KeyValue.  # noqa: E501
        :type component_type: str
        """

        self._component_type = component_type

    @property
    def component_host(self):
        """Gets the component_host of this KeyValue.  # noqa: E501

        The component host.  # noqa: E501

        :return: The component_host of this KeyValue.  # noqa: E501
        :rtype: str
        """
        return self._component_host

    @component_host.setter
    def component_host(self, component_host):
        """Sets the component_host of this KeyValue.

        The component host.  # noqa: E501

        :param component_host: The component_host of this KeyValue.  # noqa: E501
        :type component_host: str
        """

        self._component_host = component_host

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KeyValue):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, KeyValue):
            return True

        return self.to_dict() != other.to_dict()
