# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ParticipationRule(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rule_type': 'str',
        'date_time': 'ParticipationDateTime',
        'event': 'ParticipationEvent'
    }

    attribute_map = {
        'rule_type': 'ruleType',
        'date_time': 'dateTime',
        'event': 'event'
    }

    def __init__(self, rule_type=None, date_time=None, event=None, local_vars_configuration=None):  # noqa: E501
        """ParticipationRule - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._rule_type = None
        self._date_time = None
        self._event = None
        self.discriminator = None

        self.rule_type = rule_type
        if date_time is not None:
            self.date_time = date_time
        if event is not None:
            self.event = event

    @property
    def rule_type(self):
        """Gets the rule_type of this ParticipationRule.  # noqa: E501

        The rule type.  # noqa: E501

        :return: The rule_type of this ParticipationRule.  # noqa: E501
        :rtype: str
        """
        return self._rule_type

    @rule_type.setter
    def rule_type(self, rule_type):
        """Sets the rule_type of this ParticipationRule.

        The rule type.  # noqa: E501

        :param rule_type: The rule_type of this ParticipationRule.  # noqa: E501
        :type rule_type: str
        """
        if self.local_vars_configuration.client_side_validation and rule_type is None:  # noqa: E501
            raise ValueError("Invalid value for `rule_type`, must not be `None`")  # noqa: E501
        allowed_values = ["DATE_TIME", "EVENT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and rule_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `rule_type` ({0}), must be one of {1}"  # noqa: E501
                .format(rule_type, allowed_values)
            )

        self._rule_type = rule_type

    @property
    def date_time(self):
        """Gets the date_time of this ParticipationRule.  # noqa: E501


        :return: The date_time of this ParticipationRule.  # noqa: E501
        :rtype: ParticipationDateTime
        """
        return self._date_time

    @date_time.setter
    def date_time(self, date_time):
        """Sets the date_time of this ParticipationRule.


        :param date_time: The date_time of this ParticipationRule.  # noqa: E501
        :type date_time: ParticipationDateTime
        """

        self._date_time = date_time

    @property
    def event(self):
        """Gets the event of this ParticipationRule.  # noqa: E501


        :return: The event of this ParticipationRule.  # noqa: E501
        :rtype: ParticipationEvent
        """
        return self._event

    @event.setter
    def event(self, event):
        """Sets the event of this ParticipationRule.


        :param event: The event of this ParticipationRule.  # noqa: E501
        :type event: ParticipationEvent
        """

        self._event = event

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ParticipationRule):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ParticipationRule):
            return True

        return self.to_dict() != other.to_dict()
