# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class PingAgentParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'discover': 'bool',
        'timeout': 'int',
        'agent_type': 'str'
    }

    attribute_map = {
        'discover': 'discover',
        'timeout': 'timeout',
        'agent_type': 'agentType'
    }

    def __init__(self, discover=False, timeout=60, agent_type=None, local_vars_configuration=None):  # noqa: E501
        """PingAgentParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._discover = None
        self._timeout = None
        self._agent_type = None
        self.discriminator = None

        if discover is not None:
            self.discover = discover
        if timeout is not None:
            self.timeout = timeout
        if agent_type is not None:
            self.agent_type = agent_type

    @property
    def discover(self):
        """Gets the discover of this PingAgentParams.  # noqa: E501

        Discover parameter when true the agent will be added to the Control-M. HIDDEN  # noqa: E501

        :return: The discover of this PingAgentParams.  # noqa: E501
        :rtype: bool
        """
        return self._discover

    @discover.setter
    def discover(self, discover):
        """Sets the discover of this PingAgentParams.

        Discover parameter when true the agent will be added to the Control-M. HIDDEN  # noqa: E501

        :param discover: The discover of this PingAgentParams.  # noqa: E501
        :type discover: bool
        """

        self._discover = discover

    @property
    def timeout(self):
        """Gets the timeout of this PingAgentParams.  # noqa: E501

        maximum time in seconds to wait (default 60). HIDDEN  # noqa: E501

        :return: The timeout of this PingAgentParams.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this PingAgentParams.

        maximum time in seconds to wait (default 60). HIDDEN  # noqa: E501

        :param timeout: The timeout of this PingAgentParams.  # noqa: E501
        :type timeout: int
        """

        self._timeout = timeout

    @property
    def agent_type(self):
        """Gets the agent_type of this PingAgentParams.  # noqa: E501

        The agent's type.  # noqa: E501

        :return: The agent_type of this PingAgentParams.  # noqa: E501
        :rtype: str
        """
        return self._agent_type

    @agent_type.setter
    def agent_type(self, agent_type):
        """Sets the agent_type of this PingAgentParams.

        The agent's type.  # noqa: E501

        :param agent_type: The agent_type of this PingAgentParams.  # noqa: E501
        :type agent_type: str
        """

        self._agent_type = agent_type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PingAgentParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PingAgentParams):
            return True

        return self.to_dict() != other.to_dict()
