# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class RuleStatistics(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rule_name': 'str',
        'retention': 'int',
        'retention_type': 'str',
        'oldest_item': 'str',
        'newest_item': 'str',
        'total_jobs': 'int',
        'data_size': 'str'
    }

    attribute_map = {
        'rule_name': 'ruleName',
        'retention': 'retention',
        'retention_type': 'retentionType',
        'oldest_item': 'oldestItem',
        'newest_item': 'newestItem',
        'total_jobs': 'totalJobs',
        'data_size': 'dataSize'
    }

    def __init__(self, rule_name=None, retention=None, retention_type=None, oldest_item=None, newest_item=None, total_jobs=None, data_size=None, local_vars_configuration=None):  # noqa: E501
        """RuleStatistics - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._rule_name = None
        self._retention = None
        self._retention_type = None
        self._oldest_item = None
        self._newest_item = None
        self._total_jobs = None
        self._data_size = None
        self.discriminator = None

        if rule_name is not None:
            self.rule_name = rule_name
        if retention is not None:
            self.retention = retention
        if retention_type is not None:
            self.retention_type = retention_type
        if oldest_item is not None:
            self.oldest_item = oldest_item
        if newest_item is not None:
            self.newest_item = newest_item
        if total_jobs is not None:
            self.total_jobs = total_jobs
        if data_size is not None:
            self.data_size = data_size

    @property
    def rule_name(self):
        """Gets the rule_name of this RuleStatistics.  # noqa: E501


        :return: The rule_name of this RuleStatistics.  # noqa: E501
        :rtype: str
        """
        return self._rule_name

    @rule_name.setter
    def rule_name(self, rule_name):
        """Sets the rule_name of this RuleStatistics.


        :param rule_name: The rule_name of this RuleStatistics.  # noqa: E501
        :type rule_name: str
        """

        self._rule_name = rule_name

    @property
    def retention(self):
        """Gets the retention of this RuleStatistics.  # noqa: E501


        :return: The retention of this RuleStatistics.  # noqa: E501
        :rtype: int
        """
        return self._retention

    @retention.setter
    def retention(self, retention):
        """Sets the retention of this RuleStatistics.


        :param retention: The retention of this RuleStatistics.  # noqa: E501
        :type retention: int
        """

        self._retention = retention

    @property
    def retention_type(self):
        """Gets the retention_type of this RuleStatistics.  # noqa: E501


        :return: The retention_type of this RuleStatistics.  # noqa: E501
        :rtype: str
        """
        return self._retention_type

    @retention_type.setter
    def retention_type(self, retention_type):
        """Sets the retention_type of this RuleStatistics.


        :param retention_type: The retention_type of this RuleStatistics.  # noqa: E501
        :type retention_type: str
        """
        allowed_values = ["Years", "Months", "Days"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and retention_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `retention_type` ({0}), must be one of {1}"  # noqa: E501
                .format(retention_type, allowed_values)
            )

        self._retention_type = retention_type

    @property
    def oldest_item(self):
        """Gets the oldest_item of this RuleStatistics.  # noqa: E501


        :return: The oldest_item of this RuleStatistics.  # noqa: E501
        :rtype: str
        """
        return self._oldest_item

    @oldest_item.setter
    def oldest_item(self, oldest_item):
        """Sets the oldest_item of this RuleStatistics.


        :param oldest_item: The oldest_item of this RuleStatistics.  # noqa: E501
        :type oldest_item: str
        """

        self._oldest_item = oldest_item

    @property
    def newest_item(self):
        """Gets the newest_item of this RuleStatistics.  # noqa: E501


        :return: The newest_item of this RuleStatistics.  # noqa: E501
        :rtype: str
        """
        return self._newest_item

    @newest_item.setter
    def newest_item(self, newest_item):
        """Sets the newest_item of this RuleStatistics.


        :param newest_item: The newest_item of this RuleStatistics.  # noqa: E501
        :type newest_item: str
        """

        self._newest_item = newest_item

    @property
    def total_jobs(self):
        """Gets the total_jobs of this RuleStatistics.  # noqa: E501


        :return: The total_jobs of this RuleStatistics.  # noqa: E501
        :rtype: int
        """
        return self._total_jobs

    @total_jobs.setter
    def total_jobs(self, total_jobs):
        """Sets the total_jobs of this RuleStatistics.


        :param total_jobs: The total_jobs of this RuleStatistics.  # noqa: E501
        :type total_jobs: int
        """

        self._total_jobs = total_jobs

    @property
    def data_size(self):
        """Gets the data_size of this RuleStatistics.  # noqa: E501


        :return: The data_size of this RuleStatistics.  # noqa: E501
        :rtype: str
        """
        return self._data_size

    @data_size.setter
    def data_size(self, data_size):
        """Sets the data_size of this RuleStatistics.


        :param data_size: The data_size of this RuleStatistics.  # noqa: E501
        :type data_size: str
        """

        self._data_size = data_size

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RuleStatistics):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RuleStatistics):
            return True

        return self.to_dict() != other.to_dict()
