# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class VaultParam(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'label': 'str',
        'label_api': 'str',
        'name': 'str',
        'is_mandatory': 'bool',
        'min_length': 'int',
        'max_length': 'int',
        'excluded_chars': 'str',
        'is_in_excluded_chars': 'bool',
        'valid_values': 'str',
        'default_visibility': 'str',
        'default_value': 'str'
    }

    attribute_map = {
        'type': 'type',
        'label': 'label',
        'label_api': 'labelApi',
        'name': 'name',
        'is_mandatory': 'isMandatory',
        'min_length': 'minLength',
        'max_length': 'maxLength',
        'excluded_chars': 'excludedChars',
        'is_in_excluded_chars': 'isInExcludedChars',
        'valid_values': 'validValues',
        'default_visibility': 'defaultVisibility',
        'default_value': 'defaultValue'
    }

    def __init__(self, type=None, label=None, label_api=None, name=None, is_mandatory=None, min_length=None, max_length=None, excluded_chars=None, is_in_excluded_chars=None, valid_values=None, default_visibility=None, default_value=None, local_vars_configuration=None):  # noqa: E501
        """VaultParam - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._label = None
        self._label_api = None
        self._name = None
        self._is_mandatory = None
        self._min_length = None
        self._max_length = None
        self._excluded_chars = None
        self._is_in_excluded_chars = None
        self._valid_values = None
        self._default_visibility = None
        self._default_value = None
        self.discriminator = None

        self.type = type
        self.label = label
        self.label_api = label_api
        if name is not None:
            self.name = name
        if is_mandatory is not None:
            self.is_mandatory = is_mandatory
        if min_length is not None:
            self.min_length = min_length
        if max_length is not None:
            self.max_length = max_length
        if excluded_chars is not None:
            self.excluded_chars = excluded_chars
        if is_in_excluded_chars is not None:
            self.is_in_excluded_chars = is_in_excluded_chars
        if valid_values is not None:
            self.valid_values = valid_values
        if default_visibility is not None:
            self.default_visibility = default_visibility
        if default_value is not None:
            self.default_value = default_value

    @property
    def type(self):
        """Gets the type of this VaultParam.  # noqa: E501

        The UI Control type, could be 'textbox' or 'textarea'  # noqa: E501

        :return: The type of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VaultParam.

        The UI Control type, could be 'textbox' or 'textarea'  # noqa: E501

        :param type: The type of this VaultParam.  # noqa: E501
        :type type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def label(self):
        """Gets the label of this VaultParam.  # noqa: E501

        The displayed name of the field parameter  # noqa: E501

        :return: The label of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this VaultParam.

        The displayed name of the field parameter  # noqa: E501

        :param label: The label of this VaultParam.  # noqa: E501
        :type label: str
        """
        if self.local_vars_configuration.client_side_validation and label is None:  # noqa: E501
            raise ValueError("Invalid value for `label`, must not be `None`")  # noqa: E501

        self._label = label

    @property
    def label_api(self):
        """Gets the label_api of this VaultParam.  # noqa: E501

        The display name of the parameter in Automation API  # noqa: E501

        :return: The label_api of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._label_api

    @label_api.setter
    def label_api(self, label_api):
        """Sets the label_api of this VaultParam.

        The display name of the parameter in Automation API  # noqa: E501

        :param label_api: The label_api of this VaultParam.  # noqa: E501
        :type label_api: str
        """
        if self.local_vars_configuration.client_side_validation and label_api is None:  # noqa: E501
            raise ValueError("Invalid value for `label_api`, must not be `None`")  # noqa: E501

        self._label_api = label_api

    @property
    def name(self):
        """Gets the name of this VaultParam.  # noqa: E501

        The name of the field parameter  # noqa: E501

        :return: The name of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VaultParam.

        The name of the field parameter  # noqa: E501

        :param name: The name of this VaultParam.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def is_mandatory(self):
        """Gets the is_mandatory of this VaultParam.  # noqa: E501

        UI validation (optional) - indicates whether user must fill this parameter  # noqa: E501

        :return: The is_mandatory of this VaultParam.  # noqa: E501
        :rtype: bool
        """
        return self._is_mandatory

    @is_mandatory.setter
    def is_mandatory(self, is_mandatory):
        """Sets the is_mandatory of this VaultParam.

        UI validation (optional) - indicates whether user must fill this parameter  # noqa: E501

        :param is_mandatory: The is_mandatory of this VaultParam.  # noqa: E501
        :type is_mandatory: bool
        """

        self._is_mandatory = is_mandatory

    @property
    def min_length(self):
        """Gets the min_length of this VaultParam.  # noqa: E501

        UI validation (optional) - the minimum allowed value field length  # noqa: E501

        :return: The min_length of this VaultParam.  # noqa: E501
        :rtype: int
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length):
        """Sets the min_length of this VaultParam.

        UI validation (optional) - the minimum allowed value field length  # noqa: E501

        :param min_length: The min_length of this VaultParam.  # noqa: E501
        :type min_length: int
        """

        self._min_length = min_length

    @property
    def max_length(self):
        """Gets the max_length of this VaultParam.  # noqa: E501

        UI validation (optional) - the maximum allowed value field length  # noqa: E501

        :return: The max_length of this VaultParam.  # noqa: E501
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """Sets the max_length of this VaultParam.

        UI validation (optional) - the maximum allowed value field length  # noqa: E501

        :param max_length: The max_length of this VaultParam.  # noqa: E501
        :type max_length: int
        """

        self._max_length = max_length

    @property
    def excluded_chars(self):
        """Gets the excluded_chars of this VaultParam.  # noqa: E501

        UI validation (optional) - indicates to excludes specific chars seperated by ;  # noqa: E501

        :return: The excluded_chars of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._excluded_chars

    @excluded_chars.setter
    def excluded_chars(self, excluded_chars):
        """Sets the excluded_chars of this VaultParam.

        UI validation (optional) - indicates to excludes specific chars seperated by ;  # noqa: E501

        :param excluded_chars: The excluded_chars of this VaultParam.  # noqa: E501
        :type excluded_chars: str
        """

        self._excluded_chars = excluded_chars

    @property
    def is_in_excluded_chars(self):
        """Gets the is_in_excluded_chars of this VaultParam.  # noqa: E501

        UI validation (optional) - indicates whether excludedChars is enabled  # noqa: E501

        :return: The is_in_excluded_chars of this VaultParam.  # noqa: E501
        :rtype: bool
        """
        return self._is_in_excluded_chars

    @is_in_excluded_chars.setter
    def is_in_excluded_chars(self, is_in_excluded_chars):
        """Sets the is_in_excluded_chars of this VaultParam.

        UI validation (optional) - indicates whether excludedChars is enabled  # noqa: E501

        :param is_in_excluded_chars: The is_in_excluded_chars of this VaultParam.  # noqa: E501
        :type is_in_excluded_chars: bool
        """

        self._is_in_excluded_chars = is_in_excluded_chars

    @property
    def valid_values(self):
        """Gets the valid_values of this VaultParam.  # noqa: E501

        UI validation (optional) - indicates the allowed input types, 'alphanumeric', 'numbers', 'chars' or 'all'  # noqa: E501

        :return: The valid_values of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._valid_values

    @valid_values.setter
    def valid_values(self, valid_values):
        """Sets the valid_values of this VaultParam.

        UI validation (optional) - indicates the allowed input types, 'alphanumeric', 'numbers', 'chars' or 'all'  # noqa: E501

        :param valid_values: The valid_values of this VaultParam.  # noqa: E501
        :type valid_values: str
        """

        self._valid_values = valid_values

    @property
    def default_visibility(self):
        """Gets the default_visibility of this VaultParam.  # noqa: E501

        UI appearance (optional) - indicates the UI Control visibility,  'visible', 'hidden' or 'readonly'  # noqa: E501

        :return: The default_visibility of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._default_visibility

    @default_visibility.setter
    def default_visibility(self, default_visibility):
        """Sets the default_visibility of this VaultParam.

        UI appearance (optional) - indicates the UI Control visibility,  'visible', 'hidden' or 'readonly'  # noqa: E501

        :param default_visibility: The default_visibility of this VaultParam.  # noqa: E501
        :type default_visibility: str
        """

        self._default_visibility = default_visibility

    @property
    def default_value(self):
        """Gets the default_value of this VaultParam.  # noqa: E501

        UI appearance (optional)- this value automatically sets on the UI Control in-case no other value specified  # noqa: E501

        :return: The default_value of this VaultParam.  # noqa: E501
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """Sets the default_value of this VaultParam.

        UI appearance (optional)- this value automatically sets on the UI Control in-case no other value specified  # noqa: E501

        :param default_value: The default_value of this VaultParam.  # noqa: E501
        :type default_value: str
        """

        self._default_value = default_value

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VaultParam):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VaultParam):
            return True

        return self.to_dict() != other.to_dict()
