# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient
from clients.ctm_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ConfigApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_agent(self, server, body, **kwargs):  # noqa: E501
        """add agent to Server  # noqa: E501

        Add an agent to Server. This command does not install or configure the agent. It only defines the agent in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_agent(server, body, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is going to be added to. (required)
        :type server: str
        :param body: (required)
        :type body: AddAgentParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_agent_with_http_info(server, body, **kwargs)  # noqa: E501

    def add_agent_with_http_info(self, server, body, **kwargs):  # noqa: E501
        """add agent to Server  # noqa: E501

        Add an agent to Server. This command does not install or configure the agent. It only defines the agent in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_agent_with_http_info(server, body, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is going to be added to. (required)
        :type server: str
        :param body: (required)
        :type body: AddAgentParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_agent" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_agent`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `add_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_agentless_host(self, server, **kwargs):  # noqa: E501
        """add agentless host to Server  # noqa: E501

        Add an agentless host to Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_agentless_host(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is going to be added to. (required)
        :type server: str
        :param data: The non default, advanced configuration data
        :type data: AddRemoteHostParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_agentless_host_with_http_info(server, **kwargs)  # noqa: E501

    def add_agentless_host_with_http_info(self, server, **kwargs):  # noqa: E501
        """add agentless host to Server  # noqa: E501

        Add an agentless host to Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_agentless_host_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is going to be added to. (required)
        :type server: str
        :param data: The non default, advanced configuration data
        :type data: AddRemoteHostParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_agentless_host" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_agentless_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            422: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agentlesshost', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_archive_rule(self, archive_rule, **kwargs):  # noqa: E501
        """Add Workload Archiving rule  # noqa: E501

        Add a new Workload Archiving rule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_archive_rule(archive_rule, async_req=True)
        >>> result = thread.get()

        :param archive_rule: archive rule details to add (required)
        :type archive_rule: ArchiveRule
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_archive_rule_with_http_info(archive_rule, **kwargs)  # noqa: E501

    def add_archive_rule_with_http_info(self, archive_rule, **kwargs):  # noqa: E501
        """Add Workload Archiving rule  # noqa: E501

        Add a new Workload Archiving rule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_archive_rule_with_http_info(archive_rule, async_req=True)
        >>> result = thread.get()

        :param archive_rule: archive rule details to add (required)
        :type archive_rule: ArchiveRule
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'archive_rule'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_archive_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'archive_rule' is set
        if self.api_client.client_side_validation and ('archive_rule' not in local_var_params or  # noqa: E501
                                                        local_var_params['archive_rule'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `archive_rule` when calling `add_archive_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'archive_rule' in local_var_params:
            body_params = local_var_params['archive_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/archive/rule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_ctm_security_group(self, ctm_name, ctm_sec_group_data, **kwargs):  # noqa: E501
        """Add CTM Security new group  # noqa: E501

        Add CTM Security new group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ctm_security_group(ctm_name, ctm_sec_group_data, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_sec_group_data: (required)
        :type ctm_sec_group_data: CtmSecGroupData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_ctm_security_group_with_http_info(ctm_name, ctm_sec_group_data, **kwargs)  # noqa: E501

    def add_ctm_security_group_with_http_info(self, ctm_name, ctm_sec_group_data, **kwargs):  # noqa: E501
        """Add CTM Security new group  # noqa: E501

        Add CTM Security new group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ctm_security_group_with_http_info(ctm_name, ctm_sec_group_data, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_sec_group_data: (required)
        :type ctm_sec_group_data: CtmSecGroupData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name',
            'ctm_sec_group_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ctm_security_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `add_ctm_security_group`")  # noqa: E501
        # verify the required parameter 'ctm_sec_group_data' is set
        if self.api_client.client_side_validation and ('ctm_sec_group_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_sec_group_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_sec_group_data` when calling `add_ctm_security_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ctm_sec_group_data' in local_var_params:
            body_params = local_var_params['ctm_sec_group_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/security/group', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_ctm_security_user(self, ctm_name, ctm_sec_user_data, **kwargs):  # noqa: E501
        """Add CTM Security user  # noqa: E501

        Add CTM Security user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ctm_security_user(ctm_name, ctm_sec_user_data, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_sec_user_data: (required)
        :type ctm_sec_user_data: CtmSecUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_ctm_security_user_with_http_info(ctm_name, ctm_sec_user_data, **kwargs)  # noqa: E501

    def add_ctm_security_user_with_http_info(self, ctm_name, ctm_sec_user_data, **kwargs):  # noqa: E501
        """Add CTM Security user  # noqa: E501

        Add CTM Security user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ctm_security_user_with_http_info(ctm_name, ctm_sec_user_data, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_sec_user_data: (required)
        :type ctm_sec_user_data: CtmSecUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name',
            'ctm_sec_user_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ctm_security_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `add_ctm_security_user`")  # noqa: E501
        # verify the required parameter 'ctm_sec_user_data' is set
        if self.api_client.client_side_validation and ('ctm_sec_user_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_sec_user_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_sec_user_data` when calling `add_ctm_security_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ctm_sec_user_data' in local_var_params:
            body_params = local_var_params['ctm_sec_user_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/security/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_em_component(self, body, **kwargs):  # noqa: E501
        """Add a new EM component  # noqa: E501

        Add a new Control-M/Enterprise Manager component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_em_component(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: EmComponentDef
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_em_component_with_http_info(body, **kwargs)  # noqa: E501

    def add_em_component_with_http_info(self, body, **kwargs):  # noqa: E501
        """Add a new EM component  # noqa: E501

        Add a new Control-M/Enterprise Manager component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_em_component_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: EmComponentDef
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_em_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `add_em_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/em/component', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_external_user(self, external_user_data, **kwargs):  # noqa: E501
        """Add and external user  # noqa: E501

        Add and external user for b2b  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user(external_user_data, async_req=True)
        >>> result = thread.get()

        :param external_user_data: External user data (required)
        :type external_user_data: ExternalUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_external_user_with_http_info(external_user_data, **kwargs)  # noqa: E501

    def add_external_user_with_http_info(self, external_user_data, **kwargs):  # noqa: E501
        """Add and external user  # noqa: E501

        Add and external user for b2b  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_with_http_info(external_user_data, async_req=True)
        >>> result = thread.get()

        :param external_user_data: External user data (required)
        :type external_user_data: ExternalUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'external_user_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_external_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_user_data' is set
        if self.api_client.client_side_validation and ('external_user_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_user_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_user_data` when calling `add_external_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_user_data' in local_var_params:
            body_params = local_var_params['external_user_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/externaluser', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_external_user_for_site(self, site_name, external_user_data, **kwargs):  # noqa: E501
        """Add and external user for site  # noqa: E501

        Add and external user for site for b2b  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_for_site(site_name, external_user_data, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param external_user_data: External user data (required)
        :type external_user_data: ExternalUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_external_user_for_site_with_http_info(site_name, external_user_data, **kwargs)  # noqa: E501

    def add_external_user_for_site_with_http_info(self, site_name, external_user_data, **kwargs):  # noqa: E501
        """Add and external user for site  # noqa: E501

        Add and external user for site for b2b  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_for_site_with_http_info(site_name, external_user_data, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param external_user_data: External user data (required)
        :type external_user_data: ExternalUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'external_user_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_external_user_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_external_user_for_site`")  # noqa: E501
        # verify the required parameter 'external_user_data' is set
        if self.api_client.client_side_validation and ('external_user_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['external_user_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_user_data` when calling `add_external_user_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_user_data' in local_var_params:
            body_params = local_var_params['external_user_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/externaluser', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_external_user_or_user_group_to_mft_folder(self, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Add external user or user groups to virtual folder external users list.  # noqa: E501

        Add external user user groups to virtual folder external users list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_or_user_group_to_mft_folder(folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name or group name (required)
        :type user_or_group: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_external_user_or_user_group_to_mft_folder_with_http_info(folder_name, user_or_group, **kwargs)  # noqa: E501

    def add_external_user_or_user_group_to_mft_folder_with_http_info(self, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Add external user or user groups to virtual folder external users list.  # noqa: E501

        Add external user user groups to virtual folder external users list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_or_user_group_to_mft_folder_with_http_info(folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name or group name (required)
        :type user_or_group: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'folder_name',
            'user_or_group'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_external_user_or_user_group_to_mft_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and ('folder_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_name` when calling `add_external_user_or_user_group_to_mft_folder`")  # noqa: E501
        # verify the required parameter 'user_or_group' is set
        if self.api_client.client_side_validation and ('user_or_group' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_or_group'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_or_group` when calling `add_external_user_or_user_group_to_mft_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'folder_name' in local_var_params:
            path_params['folderName'] = local_var_params['folder_name']  # noqa: E501
        if 'user_or_group' in local_var_params:
            path_params['userOrGroup'] = local_var_params['user_or_group']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/virtualfolder/{folderName}/user/{userOrGroup}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_external_user_or_user_group_to_mft_folder_for_site(self, site_name, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Add external user or user groups to virtual folder external users list for site.  # noqa: E501

        Add external user user groups to virtual folder external users list for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_or_user_group_to_mft_folder_for_site(site_name, folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name or group name (required)
        :type user_or_group: str
        :param access_level: Access level of user or group for specific folder
        :type access_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_external_user_or_user_group_to_mft_folder_for_site_with_http_info(site_name, folder_name, user_or_group, **kwargs)  # noqa: E501

    def add_external_user_or_user_group_to_mft_folder_for_site_with_http_info(self, site_name, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Add external user or user groups to virtual folder external users list for site.  # noqa: E501

        Add external user user groups to virtual folder external users list for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_or_user_group_to_mft_folder_for_site_with_http_info(site_name, folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name or group name (required)
        :type user_or_group: str
        :param access_level: Access level of user or group for specific folder
        :type access_level: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'folder_name',
            'user_or_group',
            'access_level'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_external_user_or_user_group_to_mft_folder_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_external_user_or_user_group_to_mft_folder_for_site`")  # noqa: E501
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and ('folder_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_name` when calling `add_external_user_or_user_group_to_mft_folder_for_site`")  # noqa: E501
        # verify the required parameter 'user_or_group' is set
        if self.api_client.client_side_validation and ('user_or_group' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_or_group'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_or_group` when calling `add_external_user_or_user_group_to_mft_folder_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'folder_name' in local_var_params:
            path_params['folderName'] = local_var_params['folder_name']  # noqa: E501
        if 'user_or_group' in local_var_params:
            path_params['userOrGroup'] = local_var_params['user_or_group']  # noqa: E501

        query_params = []
        if 'access_level' in local_var_params and local_var_params['access_level'] is not None:  # noqa: E501
            query_params.append(('accessLevel', local_var_params['access_level']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/virtualfolder/{folderName}/user/{userOrGroup}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_external_user_to_mft_user_group_for_site(self, site_name, group_name, user_name, **kwargs):  # noqa: E501
        """Add external user to user groups for site.  # noqa: E501

        Add external user to user groups for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_to_mft_user_group_for_site(site_name, group_name, user_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group (required)
        :type group_name: str
        :param user_name: The user name (required)
        :type user_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupPropertiesData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_external_user_to_mft_user_group_for_site_with_http_info(site_name, group_name, user_name, **kwargs)  # noqa: E501

    def add_external_user_to_mft_user_group_for_site_with_http_info(self, site_name, group_name, user_name, **kwargs):  # noqa: E501
        """Add external user to user groups for site.  # noqa: E501

        Add external user to user groups for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_external_user_to_mft_user_group_for_site_with_http_info(site_name, group_name, user_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group (required)
        :type group_name: str
        :param user_name: The user name (required)
        :type user_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserGroupPropertiesData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'group_name',
            'user_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_external_user_to_mft_user_group_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_external_user_to_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if self.api_client.client_side_validation and ('group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_name` when calling `add_external_user_to_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'user_name' is set
        if self.api_client.client_side_validation and ('user_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_name` when calling `add_external_user_to_mft_user_group_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'group_name' in local_var_params:
            path_params['groupName'] = local_var_params['group_name']  # noqa: E501
        if 'user_name' in local_var_params:
            path_params['userName'] = local_var_params['user_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "UserGroupPropertiesData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/usergroup/{groupName}/user/{userName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_gateway(self, gateway_data, **kwargs):  # noqa: E501
        """add gateway.  # noqa: E501

        add gateway.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_gateway(gateway_data, async_req=True)
        >>> result = thread.get()

        :param gateway_data: gateway data (required)
        :type gateway_data: GatewayData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_gateway_with_http_info(gateway_data, **kwargs)  # noqa: E501

    def add_gateway_with_http_info(self, gateway_data, **kwargs):  # noqa: E501
        """add gateway.  # noqa: E501

        add gateway.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_gateway_with_http_info(gateway_data, async_req=True)
        >>> result = thread.get()

        :param gateway_data: gateway data (required)
        :type gateway_data: GatewayData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'gateway_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_gateway" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gateway_data' is set
        if self.api_client.client_side_validation and ('gateway_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['gateway_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `gateway_data` when calling `add_gateway`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'gateway_data' in local_var_params:
            body_params = local_var_params['gateway_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/gateway', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_gateway_for_site(self, site_name, gateway_data, **kwargs):  # noqa: E501
        """add gateway for site.  # noqa: E501

        add gateway for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_gateway_for_site(site_name, gateway_data, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param gateway_data: gateway data (required)
        :type gateway_data: GatewayData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_gateway_for_site_with_http_info(site_name, gateway_data, **kwargs)  # noqa: E501

    def add_gateway_for_site_with_http_info(self, site_name, gateway_data, **kwargs):  # noqa: E501
        """add gateway for site.  # noqa: E501

        add gateway for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_gateway_for_site_with_http_info(site_name, gateway_data, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param gateway_data: gateway data (required)
        :type gateway_data: GatewayData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'gateway_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_gateway_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_gateway_for_site`")  # noqa: E501
        # verify the required parameter 'gateway_data' is set
        if self.api_client.client_side_validation and ('gateway_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['gateway_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `gateway_data` when calling `add_gateway_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'gateway_data' in local_var_params:
            body_params = local_var_params['gateway_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/gateway', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_host_restriction(self, ctm, **kwargs):  # noqa: E501
        """Add new Host Restriction.  # noqa: E501

        Add new Host Restriction to the agent/s of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_host_restriction(ctm, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param host_restriction: The Host Restrictions to add on the Agent/s
        :type host_restriction: HostRestriction
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_host_restriction_with_http_info(ctm, **kwargs)  # noqa: E501

    def add_host_restriction_with_http_info(self, ctm, **kwargs):  # noqa: E501
        """Add new Host Restriction.  # noqa: E501

        Add new Host Restriction to the agent/s of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_host_restriction_with_http_info(ctm, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param host_restriction: The Host Restrictions to add on the Agent/s
        :type host_restriction: HostRestriction
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'host_restriction'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_host_restriction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm' is set
        if self.api_client.client_side_validation and ('ctm' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm` when calling `add_host_restriction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm' in local_var_params:
            path_params['ctm'] = local_var_params['ctm']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_restriction' in local_var_params:
            body_params = local_var_params['host_restriction']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctm}/hostRestriction', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_host_to_hostgroup(self, server, hostgroup, agent, **kwargs):  # noqa: E501
        """add agent to hostgroup  # noqa: E501

        Add an agent to hostgroup. Create the the hostgroup if it does not exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_host_to_hostgroup(server, hostgroup, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroup belongs to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param agent: The hostname of the new agent (required)
        :type agent: AgentInHostgroup
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentsInGroupSuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_host_to_hostgroup_with_http_info(server, hostgroup, agent, **kwargs)  # noqa: E501

    def add_host_to_hostgroup_with_http_info(self, server, hostgroup, agent, **kwargs):  # noqa: E501
        """add agent to hostgroup  # noqa: E501

        Add an agent to hostgroup. Create the the hostgroup if it does not exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_host_to_hostgroup_with_http_info(server, hostgroup, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroup belongs to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param agent: The hostname of the new agent (required)
        :type agent: AgentInHostgroup
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AgentsInGroupSuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'hostgroup',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_host_to_hostgroup" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_host_to_hostgroup`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in local_var_params or  # noqa: E501
                                                        local_var_params['hostgroup'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hostgroup` when calling `add_host_to_hostgroup`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `add_host_to_hostgroup`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'hostgroup' in local_var_params:
            path_params['hostgroup'] = local_var_params['hostgroup']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'agent' in local_var_params:
            body_params = local_var_params['agent']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AgentsInGroupSuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}/agent', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_hub_to_cluster(self, agentname, **kwargs):  # noqa: E501
        """add hub to cluster.  # noqa: E501

        add hub to cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_hub_to_cluster(agentname, async_req=True)
        >>> result = thread.get()

        :param agentname: Agent name (required)
        :type agentname: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_hub_to_cluster_with_http_info(agentname, **kwargs)  # noqa: E501

    def add_hub_to_cluster_with_http_info(self, agentname, **kwargs):  # noqa: E501
        """add hub to cluster.  # noqa: E501

        add hub to cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_hub_to_cluster_with_http_info(agentname, async_req=True)
        >>> result = thread.get()

        :param agentname: Agent name (required)
        :type agentname: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'agentname'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_hub_to_cluster" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agentname' is set
        if self.api_client.client_side_validation and ('agentname' not in local_var_params or  # noqa: E501
                                                        local_var_params['agentname'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agentname` when calling `add_hub_to_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agentname' in local_var_params:
            path_params['agentname'] = local_var_params['agentname']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/cluster/hub/{agentname}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_hub_to_cluster_for_site(self, site_name, agentname, **kwargs):  # noqa: E501
        """add hub to cluster for site.  # noqa: E501

        add hub to cluster for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_hub_to_cluster_for_site(site_name, agentname, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param agentname: Agent name (required)
        :type agentname: str
        :param mfte_db_config: File with content of centralized database details.
        :type mfte_db_config: MfteDbConfig
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_hub_to_cluster_for_site_with_http_info(site_name, agentname, **kwargs)  # noqa: E501

    def add_hub_to_cluster_for_site_with_http_info(self, site_name, agentname, **kwargs):  # noqa: E501
        """add hub to cluster for site.  # noqa: E501

        add hub to cluster for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_hub_to_cluster_for_site_with_http_info(site_name, agentname, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param agentname: Agent name (required)
        :type agentname: str
        :param mfte_db_config: File with content of centralized database details.
        :type mfte_db_config: MfteDbConfig
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'agentname',
            'mfte_db_config'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_hub_to_cluster_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_hub_to_cluster_for_site`")  # noqa: E501
        # verify the required parameter 'agentname' is set
        if self.api_client.client_side_validation and ('agentname' not in local_var_params or  # noqa: E501
                                                        local_var_params['agentname'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agentname` when calling `add_hub_to_cluster_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'agentname' in local_var_params:
            path_params['agentname'] = local_var_params['agentname']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mfte_db_config' in local_var_params:
            body_params = local_var_params['mfte_db_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/cluster/hub/{agentname}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_ldap_group_to_mft_user_group_for_site(self, site_name, group_name, ldap_group_name, **kwargs):  # noqa: E501
        """Add LDAP group to group for site.  # noqa: E501

        Add LDAP group to group for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ldap_group_to_mft_user_group_for_site(site_name, group_name, ldap_group_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group. (required)
        :type group_name: str
        :param ldap_group_name: The LDAP group name. (required)
        :type ldap_group_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupPropertiesData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_ldap_group_to_mft_user_group_for_site_with_http_info(site_name, group_name, ldap_group_name, **kwargs)  # noqa: E501

    def add_ldap_group_to_mft_user_group_for_site_with_http_info(self, site_name, group_name, ldap_group_name, **kwargs):  # noqa: E501
        """Add LDAP group to group for site.  # noqa: E501

        Add LDAP group to group for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ldap_group_to_mft_user_group_for_site_with_http_info(site_name, group_name, ldap_group_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group. (required)
        :type group_name: str
        :param ldap_group_name: The LDAP group name. (required)
        :type ldap_group_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserGroupPropertiesData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'group_name',
            'ldap_group_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ldap_group_to_mft_user_group_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_ldap_group_to_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if self.api_client.client_side_validation and ('group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_name` when calling `add_ldap_group_to_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'ldap_group_name' is set
        if self.api_client.client_side_validation and ('ldap_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ldap_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ldap_group_name` when calling `add_ldap_group_to_mft_user_group_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'group_name' in local_var_params:
            path_params['groupName'] = local_var_params['group_name']  # noqa: E501
        if 'ldap_group_name' in local_var_params:
            path_params['ldapGroupName'] = local_var_params['ldap_group_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "UserGroupPropertiesData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/usergroup/{groupName}/ldapGroup/{ldapGroupName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_mft_folder(self, folder_properties_data, **kwargs):  # noqa: E501
        """Add virtual folder  # noqa: E501

        Add virtual folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_folder(folder_properties_data, async_req=True)
        >>> result = thread.get()

        :param folder_properties_data: virtual folder data (required)
        :type folder_properties_data: FolderPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_mft_folder_with_http_info(folder_properties_data, **kwargs)  # noqa: E501

    def add_mft_folder_with_http_info(self, folder_properties_data, **kwargs):  # noqa: E501
        """Add virtual folder  # noqa: E501

        Add virtual folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_folder_with_http_info(folder_properties_data, async_req=True)
        >>> result = thread.get()

        :param folder_properties_data: virtual folder data (required)
        :type folder_properties_data: FolderPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'folder_properties_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_mft_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'folder_properties_data' is set
        if self.api_client.client_side_validation and ('folder_properties_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_properties_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_properties_data` when calling `add_mft_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'folder_properties_data' in local_var_params:
            body_params = local_var_params['folder_properties_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/virtualfolder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_mft_folder_for_site(self, site_name, folder_properties_data, **kwargs):  # noqa: E501
        """Add virtual folder for site  # noqa: E501

        Add virtual folder for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_folder_for_site(site_name, folder_properties_data, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_properties_data: virtual folder data (required)
        :type folder_properties_data: FolderPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_mft_folder_for_site_with_http_info(site_name, folder_properties_data, **kwargs)  # noqa: E501

    def add_mft_folder_for_site_with_http_info(self, site_name, folder_properties_data, **kwargs):  # noqa: E501
        """Add virtual folder for site  # noqa: E501

        Add virtual folder for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_folder_for_site_with_http_info(site_name, folder_properties_data, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_properties_data: virtual folder data (required)
        :type folder_properties_data: FolderPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'folder_properties_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_mft_folder_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_mft_folder_for_site`")  # noqa: E501
        # verify the required parameter 'folder_properties_data' is set
        if self.api_client.client_side_validation and ('folder_properties_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_properties_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_properties_data` when calling `add_mft_folder_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'folder_properties_data' in local_var_params:
            body_params = local_var_params['folder_properties_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/virtualfolder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_mft_processing_rule_for_site(self, site_name, rule_properties_file, **kwargs):  # noqa: E501
        """Add MFTE processing rule for site  # noqa: E501

        Add MFTE processing rule for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_processing_rule_for_site(site_name, rule_properties_file, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_properties_file: File with contenet of rule properties data. (required)
        :type rule_properties_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_mft_processing_rule_for_site_with_http_info(site_name, rule_properties_file, **kwargs)  # noqa: E501

    def add_mft_processing_rule_for_site_with_http_info(self, site_name, rule_properties_file, **kwargs):  # noqa: E501
        """Add MFTE processing rule for site  # noqa: E501

        Add MFTE processing rule for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_processing_rule_for_site_with_http_info(site_name, rule_properties_file, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_properties_file: File with contenet of rule properties data. (required)
        :type rule_properties_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'rule_properties_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_mft_processing_rule_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_mft_processing_rule_for_site`")  # noqa: E501
        # verify the required parameter 'rule_properties_file' is set
        if self.api_client.client_side_validation and ('rule_properties_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_properties_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_properties_file` when calling `add_mft_processing_rule_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'rule_properties_file' in local_var_params:
            local_var_files['rulePropertiesFile'] = local_var_params['rule_properties_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/processingRule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_mft_user_group(self, user_group_properties_data, **kwargs):  # noqa: E501
        """Add user group.  # noqa: E501

        Add user group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_user_group(user_group_properties_data, async_req=True)
        >>> result = thread.get()

        :param user_group_properties_data: User group object properites (required)
        :type user_group_properties_data: UserGroupPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_mft_user_group_with_http_info(user_group_properties_data, **kwargs)  # noqa: E501

    def add_mft_user_group_with_http_info(self, user_group_properties_data, **kwargs):  # noqa: E501
        """Add user group.  # noqa: E501

        Add user group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_user_group_with_http_info(user_group_properties_data, async_req=True)
        >>> result = thread.get()

        :param user_group_properties_data: User group object properites (required)
        :type user_group_properties_data: UserGroupPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user_group_properties_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_mft_user_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_group_properties_data' is set
        if self.api_client.client_side_validation and ('user_group_properties_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_group_properties_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_group_properties_data` when calling `add_mft_user_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_group_properties_data' in local_var_params:
            body_params = local_var_params['user_group_properties_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/usergroup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_mft_user_group_for_site(self, site_name, user_group_properties_data, **kwargs):  # noqa: E501
        """Add user group for site.  # noqa: E501

        Add user group for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_user_group_for_site(site_name, user_group_properties_data, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param user_group_properties_data: User group object properites (required)
        :type user_group_properties_data: UserGroupPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_mft_user_group_for_site_with_http_info(site_name, user_group_properties_data, **kwargs)  # noqa: E501

    def add_mft_user_group_for_site_with_http_info(self, site_name, user_group_properties_data, **kwargs):  # noqa: E501
        """Add user group for site.  # noqa: E501

        Add user group for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_mft_user_group_for_site_with_http_info(site_name, user_group_properties_data, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param user_group_properties_data: User group object properites (required)
        :type user_group_properties_data: UserGroupPropertiesData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'user_group_properties_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_mft_user_group_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `add_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'user_group_properties_data' is set
        if self.api_client.client_side_validation and ('user_group_properties_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_group_properties_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_group_properties_data` when calling `add_mft_user_group_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_group_properties_data' in local_var_params:
            body_params = local_var_params['user_group_properties_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/usergroup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_pgp_template(self, server, agent, template_name, pgp_template_data, **kwargs):  # noqa: E501
        """Add PGP Template  # noqa: E501

        Add PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_pgp_template(server, agent, template_name, pgp_template_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The PGP Template Name (required)
        :type template_name: str
        :param pgp_template_data: PGP Template Data (required)
        :type pgp_template_data: PgpTemplateData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, **kwargs)  # noqa: E501

    def add_pgp_template_with_http_info(self, server, agent, template_name, pgp_template_data, **kwargs):  # noqa: E501
        """Add PGP Template  # noqa: E501

        Add PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The PGP Template Name (required)
        :type template_name: str
        :param pgp_template_data: PGP Template Data (required)
        :type pgp_template_data: PgpTemplateData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'template_name',
            'pgp_template_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_pgp_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_pgp_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `add_pgp_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['template_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `template_name` when calling `add_pgp_template`")  # noqa: E501
        # verify the required parameter 'pgp_template_data' is set
        if self.api_client.client_side_validation and ('pgp_template_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['pgp_template_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pgp_template_data` when calling `add_pgp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'template_name' in local_var_params:
            path_params['templateName'] = local_var_params['template_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pgp_template_data' in local_var_params:
            body_params = local_var_params['pgp_template_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/pgptemplate/{templateName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_remote_host(self, server, **kwargs):  # noqa: E501
        """add remote host to Server  # noqa: E501

        Add a remote host to Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_remote_host(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host is going to be added to. (required)
        :type server: str
        :param data: The non default, advanced configuration data
        :type data: AddRemoteHostParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_remote_host_with_http_info(server, **kwargs)  # noqa: E501

    def add_remote_host_with_http_info(self, server, **kwargs):  # noqa: E501
        """add remote host to Server  # noqa: E501

        Add a remote host to Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_remote_host_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host is going to be added to. (required)
        :type server: str
        :param data: The non default, advanced configuration data
        :type data: AddRemoteHostParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_remote_host" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_remote_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/remotehost', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_role(self, role_file, **kwargs):  # noqa: E501
        """Add Authorization Role  # noqa: E501

        Add Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_role(role_file, async_req=True)
        >>> result = thread.get()

        :param role_file: File with contenet of Role Data. (required)
        :type role_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_role_with_http_info(role_file, **kwargs)  # noqa: E501

    def add_role_with_http_info(self, role_file, **kwargs):  # noqa: E501
        """Add Authorization Role  # noqa: E501

        Add Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_role_with_http_info(role_file, async_req=True)
        >>> result = thread.get()

        :param role_file: File with contenet of Role Data. (required)
        :type role_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'role_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'role_file' is set
        if self.api_client.client_side_validation and ('role_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_file` when calling `add_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'role_file' in local_var_params:
            local_var_files['roleFile'] = local_var_params['role_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_role_to_ldap_group(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Add a role to LDAP group  # noqa: E501

        Add a role to LDAP group so any user belong to the LDAP group will get all permissions defined in the role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_role_to_ldap_group(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param ldapgroup: Name of LDAP group (required)
        :type ldapgroup: str
        :param role: Name of role (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_role_to_ldap_group_with_http_info(ldapgroup, role, **kwargs)  # noqa: E501

    def add_role_to_ldap_group_with_http_info(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Add a role to LDAP group  # noqa: E501

        Add a role to LDAP group so any user belong to the LDAP group will get all permissions defined in the role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_role_to_ldap_group_with_http_info(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param ldapgroup: Name of LDAP group (required)
        :type ldapgroup: str
        :param role: Name of role (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ldapgroup',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role_to_ldap_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ldapgroup' is set
        if self.api_client.client_side_validation and ('ldapgroup' not in local_var_params or  # noqa: E501
                                                        local_var_params['ldapgroup'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ldapgroup` when calling `add_role_to_ldap_group`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `add_role_to_ldap_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ldapgroup' in local_var_params:
            path_params['ldapgroup'] = local_var_params['ldapgroup']  # noqa: E501
        if 'role' in local_var_params:
            path_params['role'] = local_var_params['role']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/ldap/{ldapgroup}/role/{role}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_role_to_user(self, user, role, **kwargs):  # noqa: E501
        """Add a role to user  # noqa: E501

        Add a role to user so that user will inherit role authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_role_to_user(user, role, async_req=True)
        >>> result = thread.get()

        :param user: Name of user (required)
        :type user: str
        :param role: Name of role (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_role_to_user_with_http_info(user, role, **kwargs)  # noqa: E501

    def add_role_to_user_with_http_info(self, user, role, **kwargs):  # noqa: E501
        """Add a role to user  # noqa: E501

        Add a role to user so that user will inherit role authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_role_to_user_with_http_info(user, role, async_req=True)
        >>> result = thread.get()

        :param user: Name of user (required)
        :type user: str
        :param role: Name of role (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role_to_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in local_var_params or  # noqa: E501
                                                        local_var_params['user'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user` when calling `add_role_to_user`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `add_role_to_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501
        if 'role' in local_var_params:
            path_params['role'] = local_var_params['role']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/user/{user}/role/{role}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_secret(self, name_value, **kwargs):  # noqa: E501
        """Add a new secret  # noqa: E501

        Add a new secret to the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_secret(name_value, async_req=True)
        >>> result = thread.get()

        :param name_value: The new secret value (required)
        :type name_value: SecretKeyValue
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_secret_with_http_info(name_value, **kwargs)  # noqa: E501

    def add_secret_with_http_info(self, name_value, **kwargs):  # noqa: E501
        """Add a new secret  # noqa: E501

        Add a new secret to the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_secret_with_http_info(name_value, async_req=True)
        >>> result = thread.get()

        :param name_value: The new secret value (required)
        :type name_value: SecretKeyValue
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name_value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_secret" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name_value' is set
        if self.api_client.client_side_validation and ('name_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['name_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name_value` when calling `add_secret`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'name_value' in local_var_params:
            body_params = local_var_params['name_value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/secret', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_server(self, body, **kwargs):  # noqa: E501
        """Discover and add server to the system  # noqa: E501

        Discover and add a Server. This command setting up new server in the system by automatic discover parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_server(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: AddServerParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_server_with_http_info(body, **kwargs)  # noqa: E501

    def add_server_with_http_info(self, body, **kwargs):  # noqa: E501
        """Discover and add server to the system  # noqa: E501

        Discover and add a Server. This command setting up new server in the system by automatic discover parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_server_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: AddServerParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_server" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `add_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_ssh_key(self, ctm, ssh_key_data, **kwargs):  # noqa: E501
        """Add an SSH key to the control-m server.  # noqa: E501

        Add an SSH key to the control-m server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ssh_key(ctm, ssh_key_data, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param ssh_key_data: The parameters of the ssh key name password type format bits. (required)
        :type ssh_key_data: SSHKeyData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_ssh_key_with_http_info(ctm, ssh_key_data, **kwargs)  # noqa: E501

    def add_ssh_key_with_http_info(self, ctm, ssh_key_data, **kwargs):  # noqa: E501
        """Add an SSH key to the control-m server.  # noqa: E501

        Add an SSH key to the control-m server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ssh_key_with_http_info(ctm, ssh_key_data, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param ssh_key_data: The parameters of the ssh key name password type format bits. (required)
        :type ssh_key_data: SSHKeyData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'ssh_key_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ssh_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm' is set
        if self.api_client.client_side_validation and ('ctm' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm` when calling `add_ssh_key`")  # noqa: E501
        # verify the required parameter 'ssh_key_data' is set
        if self.api_client.client_side_validation and ('ssh_key_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['ssh_key_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ssh_key_data` when calling `add_ssh_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm' in local_var_params:
            path_params['ctm'] = local_var_params['ctm']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ssh_key_data' in local_var_params:
            body_params = local_var_params['ssh_key_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            422: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctm}/sshkey/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_user(self, user_file, **kwargs):  # noqa: E501
        """Add user  # noqa: E501

        Add user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_user(user_file, async_req=True)
        >>> result = thread.get()

        :param user_file: File with contenet of user data. (required)
        :type user_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_user_with_http_info(user_file, **kwargs)  # noqa: E501

    def add_user_with_http_info(self, user_file, **kwargs):  # noqa: E501
        """Add user  # noqa: E501

        Add user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_user_with_http_info(user_file, async_req=True)
        >>> result = thread.get()

        :param user_file: File with contenet of user data. (required)
        :type user_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_file' is set
        if self.api_client.client_side_validation and ('user_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_file` when calling `add_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'user_file' in local_var_params:
            local_var_files['userFile'] = local_var_params['user_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_wda_gateway(self, server, agent, data_assurance_gateway_data, **kwargs):  # noqa: E501
        """add DataAssurance gateway.  # noqa: E501

        add DataAssurance gateway.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_wda_gateway(server, agent, data_assurance_gateway_data, async_req=True)
        >>> result = thread.get()

        :param server: server name (required)
        :type server: str
        :param agent: agent name (required)
        :type agent: str
        :param data_assurance_gateway_data: DataAssurance Gateway Data (required)
        :type data_assurance_gateway_data: DataAssuranceGatewayData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_wda_gateway_with_http_info(server, agent, data_assurance_gateway_data, **kwargs)  # noqa: E501

    def add_wda_gateway_with_http_info(self, server, agent, data_assurance_gateway_data, **kwargs):  # noqa: E501
        """add DataAssurance gateway.  # noqa: E501

        add DataAssurance gateway.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_wda_gateway_with_http_info(server, agent, data_assurance_gateway_data, async_req=True)
        >>> result = thread.get()

        :param server: server name (required)
        :type server: str
        :param agent: agent name (required)
        :type agent: str
        :param data_assurance_gateway_data: DataAssurance Gateway Data (required)
        :type data_assurance_gateway_data: DataAssuranceGatewayData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'data_assurance_gateway_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_wda_gateway" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_wda_gateway`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `add_wda_gateway`")  # noqa: E501
        # verify the required parameter 'data_assurance_gateway_data' is set
        if self.api_client.client_side_validation and ('data_assurance_gateway_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_assurance_gateway_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_assurance_gateway_data` when calling `add_wda_gateway`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data_assurance_gateway_data' in local_var_params:
            body_params = local_var_params['data_assurance_gateway_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/dataAssurance/{server}/{agent}/gateway', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_zos_template(self, server, agent, template_name, zos_template_data, **kwargs):  # noqa: E501
        """Add z/OS Template  # noqa: E501

        Add z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_zos_template(server, agent, template_name, zos_template_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The z/OS Template Name (required)
        :type template_name: str
        :param zos_template_data: z/OS Template Data (required)
        :type zos_template_data: ZosTemplateData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_zos_template_with_http_info(server, agent, template_name, zos_template_data, **kwargs)  # noqa: E501

    def add_zos_template_with_http_info(self, server, agent, template_name, zos_template_data, **kwargs):  # noqa: E501
        """Add z/OS Template  # noqa: E501

        Add z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_zos_template_with_http_info(server, agent, template_name, zos_template_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The z/OS Template Name (required)
        :type template_name: str
        :param zos_template_data: z/OS Template Data (required)
        :type zos_template_data: ZosTemplateData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'template_name',
            'zos_template_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_zos_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_zos_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `add_zos_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['template_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `template_name` when calling `add_zos_template`")  # noqa: E501
        # verify the required parameter 'zos_template_data' is set
        if self.api_client.client_side_validation and ('zos_template_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['zos_template_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `zos_template_data` when calling `add_zos_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'template_name' in local_var_params:
            path_params['templateName'] = local_var_params['template_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zos_template_data' in local_var_params:
            body_params = local_var_params['zos_template_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/zostemplate/{templateName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def authorize_mft_ssh_cluster(self, server, agent, cluster_name, hostname_port_list, **kwargs):  # noqa: E501
        """Authorize SSH Cluster  # noqa: E501

        Authorize SSH Cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_mft_ssh_cluster(server, agent, cluster_name, hostname_port_list, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param cluster_name: Ssh Cluster Name (required)
        :type cluster_name: str
        :param hostname_port_list: File with content of hostnames and ports (required)
        :type hostname_port_list: ClusterAuthorizationData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.authorize_mft_ssh_cluster_with_http_info(server, agent, cluster_name, hostname_port_list, **kwargs)  # noqa: E501

    def authorize_mft_ssh_cluster_with_http_info(self, server, agent, cluster_name, hostname_port_list, **kwargs):  # noqa: E501
        """Authorize SSH Cluster  # noqa: E501

        Authorize SSH Cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_mft_ssh_cluster_with_http_info(server, agent, cluster_name, hostname_port_list, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param cluster_name: Ssh Cluster Name (required)
        :type cluster_name: str
        :param hostname_port_list: File with content of hostnames and ports (required)
        :type hostname_port_list: ClusterAuthorizationData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'cluster_name',
            'hostname_port_list'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authorize_mft_ssh_cluster" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `authorize_mft_ssh_cluster`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `authorize_mft_ssh_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['cluster_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `cluster_name` when calling `authorize_mft_ssh_cluster`")  # noqa: E501
        # verify the required parameter 'hostname_port_list' is set
        if self.api_client.client_side_validation and ('hostname_port_list' not in local_var_params or  # noqa: E501
                                                        local_var_params['hostname_port_list'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hostname_port_list` when calling `authorize_mft_ssh_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'cluster_name' in local_var_params:
            path_params['clusterName'] = local_var_params['cluster_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hostname_port_list' in local_var_params:
            body_params = local_var_params['hostname_port_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/ssh/cluster/{clusterName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def authorize_mft_ssh_host(self, server, agent, hostname, **kwargs):  # noqa: E501
        """Authorize SSH Host  # noqa: E501

        Authorize SSH Host for SFTP account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_mft_ssh_host(server, agent, hostname, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param hostname: Ssh Hostname (required)
        :type hostname: str
        :param port: Ssh port for the relevant host
        :type port: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.authorize_mft_ssh_host_with_http_info(server, agent, hostname, **kwargs)  # noqa: E501

    def authorize_mft_ssh_host_with_http_info(self, server, agent, hostname, **kwargs):  # noqa: E501
        """Authorize SSH Host  # noqa: E501

        Authorize SSH Host for SFTP account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_mft_ssh_host_with_http_info(server, agent, hostname, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param hostname: Ssh Hostname (required)
        :type hostname: str
        :param port: Ssh port for the relevant host
        :type port: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'hostname',
            'port'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authorize_mft_ssh_host" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `authorize_mft_ssh_host`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `authorize_mft_ssh_host`")  # noqa: E501
        # verify the required parameter 'hostname' is set
        if self.api_client.client_side_validation and ('hostname' not in local_var_params or  # noqa: E501
                                                        local_var_params['hostname'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hostname` when calling `authorize_mft_ssh_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'hostname' in local_var_params:
            path_params['hostname'] = local_var_params['hostname']  # noqa: E501

        query_params = []
        if 'port' in local_var_params and local_var_params['port'] is not None:  # noqa: E501
            query_params.append(('port', local_var_params['port']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/ssh/host/{hostname}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def authorize_ssh_known_agentlesshost(self, server, agentlesshost, **kwargs):  # noqa: E501
        """Authorize  # noqa: E501

        Authorized known ssh agentless host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_ssh_known_agentlesshost(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected to. (required)
        :type server: str
        :param agentlesshost: The name of the agentless host. (required)
        :type agentlesshost: str
        :param authorize_ssh_data: The data of the authorize ssh request
        :type authorize_ssh_data: AuthorizeSSHData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.authorize_ssh_known_agentlesshost_with_http_info(server, agentlesshost, **kwargs)  # noqa: E501

    def authorize_ssh_known_agentlesshost_with_http_info(self, server, agentlesshost, **kwargs):  # noqa: E501
        """Authorize  # noqa: E501

        Authorized known ssh agentless host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_ssh_known_agentlesshost_with_http_info(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected to. (required)
        :type server: str
        :param agentlesshost: The name of the agentless host. (required)
        :type agentlesshost: str
        :param authorize_ssh_data: The data of the authorize ssh request
        :type authorize_ssh_data: AuthorizeSSHData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agentlesshost',
            'authorize_ssh_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authorize_ssh_known_agentlesshost" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `authorize_ssh_known_agentlesshost`")  # noqa: E501
        # verify the required parameter 'agentlesshost' is set
        if self.api_client.client_side_validation and ('agentlesshost' not in local_var_params or  # noqa: E501
                                                        local_var_params['agentlesshost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agentlesshost` when calling `authorize_ssh_known_agentlesshost`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agentlesshost' in local_var_params:
            path_params['agentlesshost'] = local_var_params['agentlesshost']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'authorize_ssh_data' in local_var_params:
            body_params = local_var_params['authorize_ssh_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agentlesshost/{agentlesshost}/authorize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def authorize_ssh_known_remotehost(self, server, remotehost, **kwargs):  # noqa: E501
        """Authorize  # noqa: E501

        Authorized known ssh remote host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_ssh_known_remotehost(server, remotehost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host is connected to. (required)
        :type server: str
        :param remotehost: The name of the remote host. (required)
        :type remotehost: str
        :param associated_agent: Optionally case insensitive agent name of host or alias of the Agent.
        :type associated_agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.authorize_ssh_known_remotehost_with_http_info(server, remotehost, **kwargs)  # noqa: E501

    def authorize_ssh_known_remotehost_with_http_info(self, server, remotehost, **kwargs):  # noqa: E501
        """Authorize  # noqa: E501

        Authorized known ssh remote host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.authorize_ssh_known_remotehost_with_http_info(server, remotehost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host is connected to. (required)
        :type server: str
        :param remotehost: The name of the remote host. (required)
        :type remotehost: str
        :param associated_agent: Optionally case insensitive agent name of host or alias of the Agent.
        :type associated_agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'remotehost',
            'associated_agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authorize_ssh_known_remotehost" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `authorize_ssh_known_remotehost`")  # noqa: E501
        # verify the required parameter 'remotehost' is set
        if self.api_client.client_side_validation and ('remotehost' not in local_var_params or  # noqa: E501
                                                        local_var_params['remotehost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `remotehost` when calling `authorize_ssh_known_remotehost`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'remotehost' in local_var_params:
            path_params['remotehost'] = local_var_params['remotehost']  # noqa: E501

        query_params = []
        if 'associated_agent' in local_var_params and local_var_params['associated_agent'] is not None:  # noqa: E501
            query_params.append(('associatedAgent', local_var_params['associated_agent']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/remotehost/{remotehost}/authorize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def change_user_password(self, user, **kwargs):  # noqa: E501
        """Change user password  # noqa: E501

        Change user password  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.change_user_password(user, async_req=True)
        >>> result = thread.get()

        :param user: user name (required)
        :type user: str
        :param password: The new password.
        :type password: UserPassword
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.change_user_password_with_http_info(user, **kwargs)  # noqa: E501

    def change_user_password_with_http_info(self, user, **kwargs):  # noqa: E501
        """Change user password  # noqa: E501

        Change user password  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.change_user_password_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param user: user name (required)
        :type user: str
        :param password: The new password.
        :type password: UserPassword
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user',
            'password'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_user_password" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in local_var_params or  # noqa: E501
                                                        local_var_params['user'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user` when calling `change_user_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'password' in local_var_params:
            body_params = local_var_params['password']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/user/{user}/password/adminUpdate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_agent_certificate_signing_request(self, server, agent, csr_data, **kwargs):  # noqa: E501
        """Create certificate signing request (CSR).  # noqa: E501

        Create certificate signing request (CSR) on SSL configured Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_agent_certificate_signing_request(server, agent, csr_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent. (required)
        :type agent: str
        :param csr_data: Certificate Signing Request (CSR) data (required)
        :type csr_data: CertificateSigningRequestData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.create_agent_certificate_signing_request_with_http_info(server, agent, csr_data, **kwargs)  # noqa: E501

    def create_agent_certificate_signing_request_with_http_info(self, server, agent, csr_data, **kwargs):  # noqa: E501
        """Create certificate signing request (CSR).  # noqa: E501

        Create certificate signing request (CSR) on SSL configured Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_agent_certificate_signing_request_with_http_info(server, agent, csr_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent. (required)
        :type agent: str
        :param csr_data: Certificate Signing Request (CSR) data (required)
        :type csr_data: CertificateSigningRequestData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'csr_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_agent_certificate_signing_request" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `create_agent_certificate_signing_request`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `create_agent_certificate_signing_request`")  # noqa: E501
        # verify the required parameter 'csr_data' is set
        if self.api_client.client_side_validation and ('csr_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['csr_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `csr_data` when calling `create_agent_certificate_signing_request`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'csr_data' in local_var_params:
            body_params = local_var_params['csr_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/csr', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_gateway(self, **kwargs):  # noqa: E501
        """Add gateway for server.  # noqa: E501

        Add gateway for server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_gateway(async_req=True)
        >>> result = thread.get()

        :param add_gateway_params: Gateway parameters
        :type add_gateway_params: AddGatewayParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.create_gateway_with_http_info(**kwargs)  # noqa: E501

    def create_gateway_with_http_info(self, **kwargs):  # noqa: E501
        """Add gateway for server.  # noqa: E501

        Add gateway for server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_gateway_with_http_info(async_req=True)
        >>> result = thread.get()

        :param add_gateway_params: Gateway parameters
        :type add_gateway_params: AddGatewayParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'add_gateway_params'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_gateway" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_gateway_params' in local_var_params:
            body_params = local_var_params['add_gateway_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/gateway', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_run_as_user(self, server, run_as_user_data, **kwargs):  # noqa: E501
        """Add a new Run-as user  # noqa: E501

        Add a new Run-as user to server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_run_as_user(server, run_as_user_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param run_as_user_data: Run as user data (required)
        :type run_as_user_data: RunAsUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.create_run_as_user_with_http_info(server, run_as_user_data, **kwargs)  # noqa: E501

    def create_run_as_user_with_http_info(self, server, run_as_user_data, **kwargs):  # noqa: E501
        """Add a new Run-as user  # noqa: E501

        Add a new Run-as user to server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_run_as_user_with_http_info(server, run_as_user_data, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param run_as_user_data: Run as user data (required)
        :type run_as_user_data: RunAsUserData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'run_as_user_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_run_as_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `create_run_as_user`")  # noqa: E501
        # verify the required parameter 'run_as_user_data' is set
        if self.api_client.client_side_validation and ('run_as_user_data' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_as_user_data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_as_user_data` when calling `create_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'run_as_user_data' in local_var_params:
            body_params = local_var_params['run_as_user_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/runasuser', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def ctm_pause(self, server, **kwargs):  # noqa: E501
        """Pause the CTM server.  # noqa: E501

        When server is paused, the server is still up and running but do not execute new jobs. Any jobs that are already executing will continue to be.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ctm_pause(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.ctm_pause_with_http_info(server, **kwargs)  # noqa: E501

    def ctm_pause_with_http_info(self, server, **kwargs):  # noqa: E501
        """Pause the CTM server.  # noqa: E501

        When server is paused, the server is still up and running but do not execute new jobs. Any jobs that are already executing will continue to be.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ctm_pause_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ctm_pause" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `ctm_pause`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: None,
            403: None,
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/pause', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def ctm_server_rename(self, ctm_name, ctm_server_rename_params, **kwargs):  # noqa: E501
        """CTM Server Rename.  # noqa: E501

        CTM Server Rename request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ctm_server_rename(ctm_name, ctm_server_rename_params, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_server_rename_params: CTM Server Rename parameters (required)
        :type ctm_server_rename_params: CtmServerRenameParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.ctm_server_rename_with_http_info(ctm_name, ctm_server_rename_params, **kwargs)  # noqa: E501

    def ctm_server_rename_with_http_info(self, ctm_name, ctm_server_rename_params, **kwargs):  # noqa: E501
        """CTM Server Rename.  # noqa: E501

        CTM Server Rename request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ctm_server_rename_with_http_info(ctm_name, ctm_server_rename_params, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_server_rename_params: CTM Server Rename parameters (required)
        :type ctm_server_rename_params: CtmServerRenameParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name',
            'ctm_server_rename_params'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ctm_server_rename" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `ctm_server_rename`")  # noqa: E501
        # verify the required parameter 'ctm_server_rename_params' is set
        if self.api_client.client_side_validation and ('ctm_server_rename_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_server_rename_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_server_rename_params` when calling `ctm_server_rename`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ctm_server_rename_params' in local_var_params:
            body_params = local_var_params['ctm_server_rename_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/rename', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def ctm_server_rename_preview(self, ctm_name, ctm_server_rename_params, **kwargs):  # noqa: E501
        """CTM Server Rename Preview.  # noqa: E501

        CTM Server Rename Preview for generate Warnings report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ctm_server_rename_preview(ctm_name, ctm_server_rename_params, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_server_rename_params: CTM Server Rename Preview parameters (required)
        :type ctm_server_rename_params: CtmServerRenameParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CtmServerRenameReport
        """
        kwargs['_return_http_data_only'] = True
        return self.ctm_server_rename_preview_with_http_info(ctm_name, ctm_server_rename_params, **kwargs)  # noqa: E501

    def ctm_server_rename_preview_with_http_info(self, ctm_name, ctm_server_rename_params, **kwargs):  # noqa: E501
        """CTM Server Rename Preview.  # noqa: E501

        CTM Server Rename Preview for generate Warnings report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ctm_server_rename_preview_with_http_info(ctm_name, ctm_server_rename_params, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param ctm_server_rename_params: CTM Server Rename Preview parameters (required)
        :type ctm_server_rename_params: CtmServerRenameParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CtmServerRenameReport, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name',
            'ctm_server_rename_params'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ctm_server_rename_preview" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `ctm_server_rename_preview`")  # noqa: E501
        # verify the required parameter 'ctm_server_rename_params' is set
        if self.api_client.client_side_validation and ('ctm_server_rename_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_server_rename_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_server_rename_params` when calling `ctm_server_rename_preview`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ctm_server_rename_params' in local_var_params:
            body_params = local_var_params['ctm_server_rename_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "CtmServerRenameReport",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/rename/preview', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def database_to_sync_mode(self, server, **kwargs):  # noqa: E501
        """Perform Control-M/Server Trigger DB sync mode  # noqa: E501

        Perform Control-M/Server Trigger DB sync mode on a specified Server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.database_to_sync_mode(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.database_to_sync_mode_with_http_info(server, **kwargs)  # noqa: E501

    def database_to_sync_mode_with_http_info(self, server, **kwargs):  # noqa: E501
        """Perform Control-M/Server Trigger DB sync mode  # noqa: E501

        Perform Control-M/Server Trigger DB sync mode on a specified Server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.database_to_sync_mode_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method database_to_sync_mode" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `database_to_sync_mode`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/database/sync', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def define_server(self, params, **kwargs):  # noqa: E501
        """add server definition to the system  # noqa: E501

        Define a Server. This command setting up new server in the system  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.define_server(params, async_req=True)
        >>> result = thread.get()

        :param params: (required)
        :type params: ServerDefinitionParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.define_server_with_http_info(params, **kwargs)  # noqa: E501

    def define_server_with_http_info(self, params, **kwargs):  # noqa: E501
        """add server definition to the system  # noqa: E501

        Define a Server. This command setting up new server in the system  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.define_server_with_http_info(params, async_req=True)
        >>> result = thread.get()

        :param params: (required)
        :type params: ServerDefinitionParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'params'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method define_server" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'params' is set
        if self.api_client.client_side_validation and ('params' not in local_var_params or  # noqa: E501
                                                        local_var_params['params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `params` when calling `define_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in local_var_params:
            body_params = local_var_params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/define', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_agent(self, server, agent, **kwargs):  # noqa: E501
        """delete an agent from Server  # noqa: E501

        Delete an agent from a Server. This will not shut the agent down. It only disconnects and removes it from the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected to. (required)
        :type server: str
        :param agent: The name of the agent to delete. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_agent_with_http_info(server, agent, **kwargs)  # noqa: E501

    def delete_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """delete an agent from Server  # noqa: E501

        Delete an agent from a Server. This will not shut the agent down. It only disconnects and removes it from the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected to. (required)
        :type server: str
        :param agent: The name of the agent to delete. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_agent" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `delete_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_agentless_host(self, server, agentlesshost, **kwargs):  # noqa: E501
        """delete an agentless host from Server  # noqa: E501

        Delete an agentless host from a Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_agentless_host(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected to. (required)
        :type server: str
        :param agentlesshost: The name of the agentless host to delete. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_agentless_host_with_http_info(server, agentlesshost, **kwargs)  # noqa: E501

    def delete_agentless_host_with_http_info(self, server, agentlesshost, **kwargs):  # noqa: E501
        """delete an agentless host from Server  # noqa: E501

        Delete an agentless host from a Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_agentless_host_with_http_info(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected to. (required)
        :type server: str
        :param agentlesshost: The name of the agentless host to delete. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agentlesshost'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_agentless_host" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_agentless_host`")  # noqa: E501
        # verify the required parameter 'agentlesshost' is set
        if self.api_client.client_side_validation and ('agentlesshost' not in local_var_params or  # noqa: E501
                                                        local_var_params['agentlesshost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agentlesshost` when calling `delete_agentless_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agentlesshost' in local_var_params:
            path_params['agentlesshost'] = local_var_params['agentlesshost']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agentlesshost/{agentlesshost}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_archive_rule(self, rule_name, delete_rule_data_flag, **kwargs):  # noqa: E501
        """Delete Workload Archiving rule  # noqa: E501

        Deletes Workload Archiving rule by name. It is required to send deleteRuleData flag to specify if rule need to be deleted with all the collected data or deleteRuleWithoutData otherwise.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_archive_rule(rule_name, delete_rule_data_flag, async_req=True)
        >>> result = thread.get()

        :param rule_name: Rule name to delete (required)
        :type rule_name: str
        :param delete_rule_data_flag: Remove rule with collected data or without. REQUIRED. (required)
        :type delete_rule_data_flag: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_archive_rule_with_http_info(rule_name, delete_rule_data_flag, **kwargs)  # noqa: E501

    def delete_archive_rule_with_http_info(self, rule_name, delete_rule_data_flag, **kwargs):  # noqa: E501
        """Delete Workload Archiving rule  # noqa: E501

        Deletes Workload Archiving rule by name. It is required to send deleteRuleData flag to specify if rule need to be deleted with all the collected data or deleteRuleWithoutData otherwise.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_archive_rule_with_http_info(rule_name, delete_rule_data_flag, async_req=True)
        >>> result = thread.get()

        :param rule_name: Rule name to delete (required)
        :type rule_name: str
        :param delete_rule_data_flag: Remove rule with collected data or without. REQUIRED. (required)
        :type delete_rule_data_flag: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'rule_name',
            'delete_rule_data_flag'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_archive_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rule_name' is set
        if self.api_client.client_side_validation and ('rule_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_name` when calling `delete_archive_rule`")  # noqa: E501
        # verify the required parameter 'delete_rule_data_flag' is set
        if self.api_client.client_side_validation and ('delete_rule_data_flag' not in local_var_params or  # noqa: E501
                                                        local_var_params['delete_rule_data_flag'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `delete_rule_data_flag` when calling `delete_archive_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_name' in local_var_params:
            path_params['ruleName'] = local_var_params['rule_name']  # noqa: E501

        query_params = []
        if 'delete_rule_data_flag' in local_var_params and local_var_params['delete_rule_data_flag'] is not None:  # noqa: E501
            query_params.append(('deleteRuleDataFlag', local_var_params['delete_rule_data_flag']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/archive/rule/{ruleName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_authorization_role(self, role, **kwargs):  # noqa: E501
        """Delete Authorization Role  # noqa: E501

        Delete Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_authorization_role(role, async_req=True)
        >>> result = thread.get()

        :param role: The Role name. (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_authorization_role_with_http_info(role, **kwargs)  # noqa: E501

    def delete_authorization_role_with_http_info(self, role, **kwargs):  # noqa: E501
        """Delete Authorization Role  # noqa: E501

        Delete Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_authorization_role_with_http_info(role, async_req=True)
        >>> result = thread.get()

        :param role: The Role name. (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_authorization_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `delete_authorization_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in local_var_params:
            path_params['role'] = local_var_params['role']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/role/{role}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_ctm_security_group(self, ctm_name, group_name, **kwargs):  # noqa: E501
        """Delete CTM Security group  # noqa: E501

        Delete CTM Security group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ctm_security_group(ctm_name, group_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param group_name: (required)
        :type group_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_ctm_security_group_with_http_info(ctm_name, group_name, **kwargs)  # noqa: E501

    def delete_ctm_security_group_with_http_info(self, ctm_name, group_name, **kwargs):  # noqa: E501
        """Delete CTM Security group  # noqa: E501

        Delete CTM Security group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ctm_security_group_with_http_info(ctm_name, group_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param group_name: (required)
        :type group_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name',
            'group_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ctm_security_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `delete_ctm_security_group`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if self.api_client.client_side_validation and ('group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_ctm_security_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501
        if 'group_name' in local_var_params:
            path_params['groupName'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/security/group/{groupName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_ctm_security_user(self, ctm_name, user_name, **kwargs):  # noqa: E501
        """Delete CTM Security user  # noqa: E501

        Delete CTM Security user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ctm_security_user(ctm_name, user_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param user_name: (required)
        :type user_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_ctm_security_user_with_http_info(ctm_name, user_name, **kwargs)  # noqa: E501

    def delete_ctm_security_user_with_http_info(self, ctm_name, user_name, **kwargs):  # noqa: E501
        """Delete CTM Security user  # noqa: E501

        Delete CTM Security user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ctm_security_user_with_http_info(ctm_name, user_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param user_name: (required)
        :type user_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name',
            'user_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ctm_security_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `delete_ctm_security_user`")  # noqa: E501
        # verify the required parameter 'user_name' is set
        if self.api_client.client_side_validation and ('user_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_name` when calling `delete_ctm_security_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501
        if 'user_name' in local_var_params:
            path_params['userName'] = local_var_params['user_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/security/user/{userName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_em_component(self, host, type, name, **kwargs):  # noqa: E501
        """Delete a specific EM component  # noqa: E501

        Delete the specified Control-M/Enterprise Manager component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_em_component(host, type, name, async_req=True)
        >>> result = thread.get()

        :param host: The hostname of the server where the EM component is running. (required)
        :type host: str
        :param type: The type of the EM component. (required)
        :type type: str
        :param name: The logical name of the EM component. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_em_component_with_http_info(host, type, name, **kwargs)  # noqa: E501

    def delete_em_component_with_http_info(self, host, type, name, **kwargs):  # noqa: E501
        """Delete a specific EM component  # noqa: E501

        Delete the specified Control-M/Enterprise Manager component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_em_component_with_http_info(host, type, name, async_req=True)
        >>> result = thread.get()

        :param host: The hostname of the server where the EM component is running. (required)
        :type host: str
        :param type: The type of the EM component. (required)
        :type type: str
        :param name: The logical name of the EM component. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'host',
            'type',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_em_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'host' is set
        if self.api_client.client_side_validation and ('host' not in local_var_params or  # noqa: E501
                                                        local_var_params['host'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `host` when calling `delete_em_component`")  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `delete_em_component`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_em_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'host' in local_var_params:
            path_params['host'] = local_var_params['host']  # noqa: E501
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/em/component/{host}/{type}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_external_user(self, username, **kwargs):  # noqa: E501
        """Delete an external user  # noqa: E501

        Delete an existing external user in MFT  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user(username, async_req=True)
        >>> result = thread.get()

        :param username: The name of the external user to delete (required)
        :type username: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_external_user_with_http_info(username, **kwargs)  # noqa: E501

    def delete_external_user_with_http_info(self, username, **kwargs):  # noqa: E501
        """Delete an external user  # noqa: E501

        Delete an existing external user in MFT  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_with_http_info(username, async_req=True)
        >>> result = thread.get()

        :param username: The name of the external user to delete (required)
        :type username: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'username'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'username' is set
        if self.api_client.client_side_validation and ('username' not in local_var_params or  # noqa: E501
                                                        local_var_params['username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `username` when calling `delete_external_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'username' in local_var_params:
            path_params['username'] = local_var_params['username']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/externaluser/{username}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_external_user_for_site(self, site_name, username, **kwargs):  # noqa: E501
        """Delete an external user from site  # noqa: E501

        Delete an existing external user from site in MFT  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_for_site(site_name, username, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param username: The name of the external user to delete (required)
        :type username: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_external_user_for_site_with_http_info(site_name, username, **kwargs)  # noqa: E501

    def delete_external_user_for_site_with_http_info(self, site_name, username, **kwargs):  # noqa: E501
        """Delete an external user from site  # noqa: E501

        Delete an existing external user from site in MFT  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_for_site_with_http_info(site_name, username, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param username: The name of the external user to delete (required)
        :type username: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'username'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_user_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `delete_external_user_for_site`")  # noqa: E501
        # verify the required parameter 'username' is set
        if self.api_client.client_side_validation and ('username' not in local_var_params or  # noqa: E501
                                                        local_var_params['username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `username` when calling `delete_external_user_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'username' in local_var_params:
            path_params['username'] = local_var_params['username']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/externaluser/{username}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_external_user_from_mft_user_group_for_site(self, site_name, group_name, user_name, **kwargs):  # noqa: E501
        """Remove an external user from group in MFT for site.  # noqa: E501

        Remove an external user from group in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_from_mft_user_group_for_site(site_name, group_name, user_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group. (required)
        :type group_name: str
        :param user_name: The user name. (required)
        :type user_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_external_user_from_mft_user_group_for_site_with_http_info(site_name, group_name, user_name, **kwargs)  # noqa: E501

    def delete_external_user_from_mft_user_group_for_site_with_http_info(self, site_name, group_name, user_name, **kwargs):  # noqa: E501
        """Remove an external user from group in MFT for site.  # noqa: E501

        Remove an external user from group in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_from_mft_user_group_for_site_with_http_info(site_name, group_name, user_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group. (required)
        :type group_name: str
        :param user_name: The user name. (required)
        :type user_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'group_name',
            'user_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_user_from_mft_user_group_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `delete_external_user_from_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if self.api_client.client_side_validation and ('group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_external_user_from_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'user_name' is set
        if self.api_client.client_side_validation and ('user_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_name` when calling `delete_external_user_from_mft_user_group_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'group_name' in local_var_params:
            path_params['groupName'] = local_var_params['group_name']  # noqa: E501
        if 'user_name' in local_var_params:
            path_params['userName'] = local_var_params['user_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/usergroup/{groupName}/user/{userName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_external_user_or_user_group_from_mft_folder(self, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Remove an external user or user group from an existing virtual folder in MFT.  # noqa: E501

        Remove an external user or user group from an existing virtual folder in MFT.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_or_user_group_from_mft_folder(folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name (required)
        :type user_or_group: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_external_user_or_user_group_from_mft_folder_with_http_info(folder_name, user_or_group, **kwargs)  # noqa: E501

    def delete_external_user_or_user_group_from_mft_folder_with_http_info(self, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Remove an external user or user group from an existing virtual folder in MFT.  # noqa: E501

        Remove an external user or user group from an existing virtual folder in MFT.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_or_user_group_from_mft_folder_with_http_info(folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name (required)
        :type user_or_group: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'folder_name',
            'user_or_group'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_user_or_user_group_from_mft_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and ('folder_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_name` when calling `delete_external_user_or_user_group_from_mft_folder`")  # noqa: E501
        # verify the required parameter 'user_or_group' is set
        if self.api_client.client_side_validation and ('user_or_group' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_or_group'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_or_group` when calling `delete_external_user_or_user_group_from_mft_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'folder_name' in local_var_params:
            path_params['folderName'] = local_var_params['folder_name']  # noqa: E501
        if 'user_or_group' in local_var_params:
            path_params['userOrGroup'] = local_var_params['user_or_group']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/virtualfolder/{folderName}/user/{userOrGroup}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_external_user_or_user_group_from_mft_folder_for_site(self, site_name, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Remove an external user or user group from an existing virtual folder in MFT for site.  # noqa: E501

        Remove an external user or user group from an existing virtual folder in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_or_user_group_from_mft_folder_for_site(site_name, folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name (required)
        :type user_or_group: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_external_user_or_user_group_from_mft_folder_for_site_with_http_info(site_name, folder_name, user_or_group, **kwargs)  # noqa: E501

    def delete_external_user_or_user_group_from_mft_folder_for_site_with_http_info(self, site_name, folder_name, user_or_group, **kwargs):  # noqa: E501
        """Remove an external user or user group from an existing virtual folder in MFT for site.  # noqa: E501

        Remove an external user or user group from an existing virtual folder in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_user_or_user_group_from_mft_folder_for_site_with_http_info(site_name, folder_name, user_or_group, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param user_or_group: The user name (required)
        :type user_or_group: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'folder_name',
            'user_or_group'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_user_or_user_group_from_mft_folder_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `delete_external_user_or_user_group_from_mft_folder_for_site`")  # noqa: E501
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and ('folder_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_name` when calling `delete_external_user_or_user_group_from_mft_folder_for_site`")  # noqa: E501
        # verify the required parameter 'user_or_group' is set
        if self.api_client.client_side_validation and ('user_or_group' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_or_group'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_or_group` when calling `delete_external_user_or_user_group_from_mft_folder_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'folder_name' in local_var_params:
            path_params['folderName'] = local_var_params['folder_name']  # noqa: E501
        if 'user_or_group' in local_var_params:
            path_params['userOrGroup'] = local_var_params['user_or_group']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/virtualfolder/{folderName}/user/{userOrGroup}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_host_from_group(self, server, hostgroup, host, **kwargs):  # noqa: E501
        """delete an agent from a hostgroup  # noqa: E501

        Delete an agent from the specified hostgroup. If the group is empty it will also be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_host_from_group(server, hostgroup, host, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroup belongs to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param host: The agent to be deleted (required)
        :type host: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentsInGroupSuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_host_from_group_with_http_info(server, hostgroup, host, **kwargs)  # noqa: E501

    def delete_host_from_group_with_http_info(self, server, hostgroup, host, **kwargs):  # noqa: E501
        """delete an agent from a hostgroup  # noqa: E501

        Delete an agent from the specified hostgroup. If the group is empty it will also be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_host_from_group_with_http_info(server, hostgroup, host, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroup belongs to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param host: The agent to be deleted (required)
        :type host: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AgentsInGroupSuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'hostgroup',
            'host'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_host_from_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_host_from_group`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in local_var_params or  # noqa: E501
                                                        local_var_params['hostgroup'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hostgroup` when calling `delete_host_from_group`")  # noqa: E501
        # verify the required parameter 'host' is set
        if self.api_client.client_side_validation and ('host' not in local_var_params or  # noqa: E501
                                                        local_var_params['host'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `host` when calling `delete_host_from_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'hostgroup' in local_var_params:
            path_params['hostgroup'] = local_var_params['hostgroup']  # noqa: E501
        if 'host' in local_var_params:
            path_params['host'] = local_var_params['host']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AgentsInGroupSuccessData",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}/agent/{host}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_host_group(self, server, hostgroup, **kwargs):  # noqa: E501
        """delete host group  # noqa: E501

        delete host group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_host_group(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_host_group_with_http_info(server, hostgroup, **kwargs)  # noqa: E501

    def delete_host_group_with_http_info(self, server, hostgroup, **kwargs):  # noqa: E501
        """delete host group  # noqa: E501

        delete host group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_host_group_with_http_info(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'hostgroup'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_host_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_host_group`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in local_var_params or  # noqa: E501
                                                        local_var_params['hostgroup'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hostgroup` when calling `delete_host_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'hostgroup' in local_var_params:
            path_params['hostgroup'] = local_var_params['hostgroup']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_host_restrictions(self, ctm, node_prefix, **kwargs):  # noqa: E501
        """Delete Host Restrictions.  # noqa: E501

        Delete Host Restrictions to the agent/s of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_host_restrictions(ctm, node_prefix, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param node_prefix: The nodePrefix query parameter accepts comma-separated values of node prefixes. It removes all host restrictions matching the submitted nodePrefixes in the API request. (required)
        :type node_prefix: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_host_restrictions_with_http_info(ctm, node_prefix, **kwargs)  # noqa: E501

    def delete_host_restrictions_with_http_info(self, ctm, node_prefix, **kwargs):  # noqa: E501
        """Delete Host Restrictions.  # noqa: E501

        Delete Host Restrictions to the agent/s of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_host_restrictions_with_http_info(ctm, node_prefix, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param node_prefix: The nodePrefix query parameter accepts comma-separated values of node prefixes. It removes all host restrictions matching the submitted nodePrefixes in the API request. (required)
        :type node_prefix: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'node_prefix'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_host_restrictions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm' is set
        if self.api_client.client_side_validation and ('ctm' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm` when calling `delete_host_restrictions`")  # noqa: E501
        # verify the required parameter 'node_prefix' is set
        if self.api_client.client_side_validation and ('node_prefix' not in local_var_params or  # noqa: E501
                                                        local_var_params['node_prefix'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `node_prefix` when calling `delete_host_restrictions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm' in local_var_params:
            path_params['ctm'] = local_var_params['ctm']  # noqa: E501

        query_params = []
        if 'node_prefix' in local_var_params and local_var_params['node_prefix'] is not None:  # noqa: E501
            query_params.append(('nodePrefix', local_var_params['node_prefix']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctm}/hostRestriction', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_ldap_group_from_mft_user_group_for_site(self, site_name, group_name, ldap_group_name, **kwargs):  # noqa: E501
        """Remove an LDAP group from group in MFT for site.  # noqa: E501

        Remove an LDAP group from group in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ldap_group_from_mft_user_group_for_site(site_name, group_name, ldap_group_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group. (required)
        :type group_name: str
        :param ldap_group_name: The LDAP group name. (required)
        :type ldap_group_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_ldap_group_from_mft_user_group_for_site_with_http_info(site_name, group_name, ldap_group_name, **kwargs)  # noqa: E501

    def delete_ldap_group_from_mft_user_group_for_site_with_http_info(self, site_name, group_name, ldap_group_name, **kwargs):  # noqa: E501
        """Remove an LDAP group from group in MFT for site.  # noqa: E501

        Remove an LDAP group from group in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ldap_group_from_mft_user_group_for_site_with_http_info(site_name, group_name, ldap_group_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param group_name: Name of Group. (required)
        :type group_name: str
        :param ldap_group_name: The LDAP group name. (required)
        :type ldap_group_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'group_name',
            'ldap_group_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ldap_group_from_mft_user_group_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `delete_ldap_group_from_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if self.api_client.client_side_validation and ('group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_ldap_group_from_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'ldap_group_name' is set
        if self.api_client.client_side_validation and ('ldap_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ldap_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ldap_group_name` when calling `delete_ldap_group_from_mft_user_group_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'group_name' in local_var_params:
            path_params['groupName'] = local_var_params['group_name']  # noqa: E501
        if 'ldap_group_name' in local_var_params:
            path_params['ldapGroupName'] = local_var_params['ldap_group_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/usergroup/{groupName}/ldapGroup/{ldapGroupName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_mft_folder(self, folder_name, **kwargs):  # noqa: E501
        """Delete a virtual folder.  # noqa: E501

        Delete an existing virtual folder in MFT.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_folder(folder_name, async_req=True)
        >>> result = thread.get()

        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_mft_folder_with_http_info(folder_name, **kwargs)  # noqa: E501

    def delete_mft_folder_with_http_info(self, folder_name, **kwargs):  # noqa: E501
        """Delete a virtual folder.  # noqa: E501

        Delete an existing virtual folder in MFT.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_folder_with_http_info(folder_name, async_req=True)
        >>> result = thread.get()

        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'folder_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mft_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and ('folder_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_name` when calling `delete_mft_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'folder_name' in local_var_params:
            path_params['folderName'] = local_var_params['folder_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/virtualfolder/{folderName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_mft_folder_for_site(self, site_name, folder_name, **kwargs):  # noqa: E501
        """Delete a virtual folder for site.  # noqa: E501

        Delete an existing virtual folder in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_folder_for_site(site_name, folder_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_mft_folder_for_site_with_http_info(site_name, folder_name, **kwargs)  # noqa: E501

    def delete_mft_folder_for_site_with_http_info(self, site_name, folder_name, **kwargs):  # noqa: E501
        """Delete a virtual folder for site.  # noqa: E501

        Delete an existing virtual folder in MFT for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_folder_for_site_with_http_info(site_name, folder_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param folder_name: Name of folder (required)
        :type folder_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'folder_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mft_folder_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `delete_mft_folder_for_site`")  # noqa: E501
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and ('folder_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_name` when calling `delete_mft_folder_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'folder_name' in local_var_params:
            path_params['folderName'] = local_var_params['folder_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/virtualfolder/{folderName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_mft_processing_rule_for_site(self, site_name, rule_name, **kwargs):  # noqa: E501
        """Delete MFTE processing rule for site.  # noqa: E501

        Delete MFTE processing rule for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_processing_rule_for_site(site_name, rule_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_name: Name of rule (required)
        :type rule_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_mft_processing_rule_for_site_with_http_info(site_name, rule_name, **kwargs)  # noqa: E501

    def delete_mft_processing_rule_for_site_with_http_info(self, site_name, rule_name, **kwargs):  # noqa: E501
        """Delete MFTE processing rule for site.  # noqa: E501

        Delete MFTE processing rule for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_processing_rule_for_site_with_http_info(site_name, rule_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_name: Name of rule (required)
        :type rule_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'rule_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mft_processing_rule_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `delete_mft_processing_rule_for_site`")  # noqa: E501
        # verify the required parameter 'rule_name' is set
        if self.api_client.client_side_validation and ('rule_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_name` when calling `delete_mft_processing_rule_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'rule_name' in local_var_params:
            path_params['ruleName'] = local_var_params['rule_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/processingRule/{ruleName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_mft_user_group(self, name, **kwargs):  # noqa: E501
        """Delete user group.  # noqa: E501

        Delete user group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_user_group(name, async_req=True)
        >>> result = thread.get()

        :param name: User group name (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_mft_user_group_with_http_info(name, **kwargs)  # noqa: E501

    def delete_mft_user_group_with_http_info(self, name, **kwargs):  # noqa: E501
        """Delete user group.  # noqa: E501

        Delete user group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_user_group_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param name: User group name (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mft_user_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_mft_user_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/usergroup/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_mft_user_group_for_site(self, site_name, name, **kwargs):  # noqa: E501
        """Delete user group for site.  # noqa: E501

        Delete user group for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_user_group_for_site(site_name, name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: User group name (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_mft_user_group_for_site_with_http_info(site_name, name, **kwargs)  # noqa: E501

    def delete_mft_user_group_for_site_with_http_info(self, site_name, name, **kwargs):  # noqa: E501
        """Delete user group for site.  # noqa: E501

        Delete user group for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mft_user_group_for_site_with_http_info(site_name, name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: User group name (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mft_user_group_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `delete_mft_user_group_for_site`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_mft_user_group_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/usergroup/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_pgp_template(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete PGP Template  # noqa: E501

        Delete PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_pgp_template(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The PGP Template Name (required)
        :type template_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_pgp_template_with_http_info(server, agent, template_name, **kwargs)  # noqa: E501

    def delete_pgp_template_with_http_info(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete PGP Template  # noqa: E501

        Delete PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_pgp_template_with_http_info(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The PGP Template Name (required)
        :type template_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'template_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pgp_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_pgp_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `delete_pgp_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['template_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `template_name` when calling `delete_pgp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'template_name' in local_var_params:
            path_params['templateName'] = local_var_params['template_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/pgptemplate/{templateName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_remote_host(self, server, remotehost, **kwargs):  # noqa: E501
        """delete a remote host from Server  # noqa: E501

        Delete a remote host from a Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_remote_host(server, remotehost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host is connected to. (required)
        :type server: str
        :param remotehost: The name of the remote host to delete. (required)
        :type remotehost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_remote_host_with_http_info(server, remotehost, **kwargs)  # noqa: E501

    def delete_remote_host_with_http_info(self, server, remotehost, **kwargs):  # noqa: E501
        """delete a remote host from Server  # noqa: E501

        Delete a remote host from a Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_remote_host_with_http_info(server, remotehost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host is connected to. (required)
        :type server: str
        :param remotehost: The name of the remote host to delete. (required)
        :type remotehost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'remotehost'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_remote_host" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_remote_host`")  # noqa: E501
        # verify the required parameter 'remotehost' is set
        if self.api_client.client_side_validation and ('remotehost' not in local_var_params or  # noqa: E501
                                                        local_var_params['remotehost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `remotehost` when calling `delete_remote_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'remotehost' in local_var_params:
            path_params['remotehost'] = local_var_params['remotehost']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/remotehost/{remotehost}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_role_from_ldap_group(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Delete a role from LDAP group  # noqa: E501

        Delete a role from LDAP group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_role_from_ldap_group(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param ldapgroup: Name of LDAP group (required)
        :type ldapgroup: str
        :param role: Name of role (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_role_from_ldap_group_with_http_info(ldapgroup, role, **kwargs)  # noqa: E501

    def delete_role_from_ldap_group_with_http_info(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Delete a role from LDAP group  # noqa: E501

        Delete a role from LDAP group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_role_from_ldap_group_with_http_info(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param ldapgroup: Name of LDAP group (required)
        :type ldapgroup: str
        :param role: Name of role (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ldapgroup',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_from_ldap_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ldapgroup' is set
        if self.api_client.client_side_validation and ('ldapgroup' not in local_var_params or  # noqa: E501
                                                        local_var_params['ldapgroup'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ldapgroup` when calling `delete_role_from_ldap_group`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `delete_role_from_ldap_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ldapgroup' in local_var_params:
            path_params['ldapgroup'] = local_var_params['ldapgroup']  # noqa: E501
        if 'role' in local_var_params:
            path_params['role'] = local_var_params['role']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/ldap/{ldapgroup}/role/{role}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_run_as_user(self, server, agent, user, **kwargs):  # noqa: E501
        """delete Run-as user  # noqa: E501

        Delete Run-as user from server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_run_as_user(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param user: The user name (required)
        :type user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501

    def delete_run_as_user_with_http_info(self, server, agent, user, **kwargs):  # noqa: E501
        """delete Run-as user  # noqa: E501

        Delete Run-as user from server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_run_as_user_with_http_info(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param user: The user name (required)
        :type user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_run_as_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_run_as_user`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `delete_run_as_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in local_var_params or  # noqa: E501
                                                        local_var_params['user'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user` when calling `delete_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/runasuser/{agent}/{user}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_secret(self, name, **kwargs):  # noqa: E501
        """Delete an existing secret  # noqa: E501

        Delete an existing secret from the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_secret(name, async_req=True)
        >>> result = thread.get()

        :param name: The name of the secret to update (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_secret_with_http_info(name, **kwargs)  # noqa: E501

    def delete_secret_with_http_info(self, name, **kwargs):  # noqa: E501
        """Delete an existing secret  # noqa: E501

        Delete an existing secret from the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_secret_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param name: The name of the secret to update (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_secret" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_secret`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/secret/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_ssh_key(self, ctm, key_name, pass_phrase, **kwargs):  # noqa: E501
        """delete an SSH key from the control-m server.  # noqa: E501

        delete an SSH key from the control-m server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ssh_key(ctm, key_name, pass_phrase, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param key_name: The name for the key . REQUIRED. (required)
        :type key_name: str
        :param pass_phrase: The password for the key file . REQUIRED. (required)
        :type pass_phrase: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_ssh_key_with_http_info(ctm, key_name, pass_phrase, **kwargs)  # noqa: E501

    def delete_ssh_key_with_http_info(self, ctm, key_name, pass_phrase, **kwargs):  # noqa: E501
        """delete an SSH key from the control-m server.  # noqa: E501

        delete an SSH key from the control-m server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ssh_key_with_http_info(ctm, key_name, pass_phrase, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param key_name: The name for the key . REQUIRED. (required)
        :type key_name: str
        :param pass_phrase: The password for the key file . REQUIRED. (required)
        :type pass_phrase: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'key_name',
            'pass_phrase'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ssh_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm' is set
        if self.api_client.client_side_validation and ('ctm' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm` when calling `delete_ssh_key`")  # noqa: E501
        # verify the required parameter 'key_name' is set
        if self.api_client.client_side_validation and ('key_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['key_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `key_name` when calling `delete_ssh_key`")  # noqa: E501
        # verify the required parameter 'pass_phrase' is set
        if self.api_client.client_side_validation and ('pass_phrase' not in local_var_params or  # noqa: E501
                                                        local_var_params['pass_phrase'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pass_phrase` when calling `delete_ssh_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm' in local_var_params:
            path_params['ctm'] = local_var_params['ctm']  # noqa: E501
        if 'key_name' in local_var_params:
            path_params['keyName'] = local_var_params['key_name']  # noqa: E501
        if 'pass_phrase' in local_var_params:
            path_params['passPhrase'] = local_var_params['pass_phrase']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctm}/sshkey/{keyName}/{passPhrase}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_user(self, user, **kwargs):  # noqa: E501
        """Delete user  # noqa: E501

        Delete user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user(user, async_req=True)
        >>> result = thread.get()

        :param user: The user name. (required)
        :type user: str
        :param delete_user_tokens: Also delete tokens created by this user.
        :type delete_user_tokens: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_user_with_http_info(user, **kwargs)  # noqa: E501

    def delete_user_with_http_info(self, user, **kwargs):  # noqa: E501
        """Delete user  # noqa: E501

        Delete user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param user: The user name. (required)
        :type user: str
        :param delete_user_tokens: Also delete tokens created by this user.
        :type delete_user_tokens: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user',
            'delete_user_tokens'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in local_var_params or  # noqa: E501
                                                        local_var_params['user'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user` when calling `delete_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []
        if 'delete_user_tokens' in local_var_params and local_var_params['delete_user_tokens'] is not None:  # noqa: E501
            query_params.append(('deleteUserTokens', local_var_params['delete_user_tokens']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/user/{user}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_zos_template(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete z/OS Template  # noqa: E501

        Delete z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_zos_template(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The z/OS Template Name (required)
        :type template_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_zos_template_with_http_info(server, agent, template_name, **kwargs)  # noqa: E501

    def delete_zos_template_with_http_info(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete z/OS Template  # noqa: E501

        Delete z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_zos_template_with_http_info(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param template_name: The z/OS Template Name (required)
        :type template_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'template_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_zos_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_zos_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `delete_zos_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['template_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `template_name` when calling `delete_zos_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'template_name' in local_var_params:
            path_params['templateName'] = local_var_params['template_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/zostemplate/{templateName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def deploy_agent_certificate(self, server, agent, crt_file, ca_chain_file, **kwargs):  # noqa: E501
        """Deploy certificate (CRT).  # noqa: E501

        Deploy certificate (CRT) on SSL configured Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_agent_certificate(server, agent, crt_file, ca_chain_file, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent. (required)
        :type agent: str
        :param crt_file: The CRT file path. (required)
        :type crt_file: file
        :param ca_chain_file: The CA Chain file path. (required)
        :type ca_chain_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.deploy_agent_certificate_with_http_info(server, agent, crt_file, ca_chain_file, **kwargs)  # noqa: E501

    def deploy_agent_certificate_with_http_info(self, server, agent, crt_file, ca_chain_file, **kwargs):  # noqa: E501
        """Deploy certificate (CRT).  # noqa: E501

        Deploy certificate (CRT) on SSL configured Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_agent_certificate_with_http_info(server, agent, crt_file, ca_chain_file, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent. (required)
        :type agent: str
        :param crt_file: The CRT file path. (required)
        :type crt_file: file
        :param ca_chain_file: The CA Chain file path. (required)
        :type ca_chain_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'crt_file',
            'ca_chain_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_agent_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `deploy_agent_certificate`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `deploy_agent_certificate`")  # noqa: E501
        # verify the required parameter 'crt_file' is set
        if self.api_client.client_side_validation and ('crt_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['crt_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `crt_file` when calling `deploy_agent_certificate`")  # noqa: E501
        # verify the required parameter 'ca_chain_file' is set
        if self.api_client.client_side_validation and ('ca_chain_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['ca_chain_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ca_chain_file` when calling `deploy_agent_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'crt_file' in local_var_params:
            local_var_files['crtFile'] = local_var_params['crt_file']  # noqa: E501
        if 'ca_chain_file' in local_var_params:
            local_var_files['caChainFile'] = local_var_params['ca_chain_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/crt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def disable_agent(self, server, agent, **kwargs):  # noqa: E501
        """disable agent from the Server  # noqa: E501

        Disable an Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected too. (required)
        :type server: str
        :param agent: The Agent to be disabled. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.disable_agent_with_http_info(server, agent, **kwargs)  # noqa: E501

    def disable_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """disable agent from the Server  # noqa: E501

        Disable an Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected too. (required)
        :type server: str
        :param agent: The Agent to be disabled. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_agent" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `disable_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `disable_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def disable_agentless_host(self, server, agentlesshost, **kwargs):  # noqa: E501
        """disable agentless host from the Server  # noqa: E501

        disable an Agentless Host. This command does not install or configure the Agentless Host. It only disable existing Agentless Host in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_agentless_host(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected too. (required)
        :type server: str
        :param agentlesshost: The Agentless Host to be disabled. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.disable_agentless_host_with_http_info(server, agentlesshost, **kwargs)  # noqa: E501

    def disable_agentless_host_with_http_info(self, server, agentlesshost, **kwargs):  # noqa: E501
        """disable agentless host from the Server  # noqa: E501

        disable an Agentless Host. This command does not install or configure the Agentless Host. It only disable existing Agentless Host in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_agentless_host_with_http_info(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected too. (required)
        :type server: str
        :param agentlesshost: The Agentless Host to be disabled. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agentlesshost'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_agentless_host" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `disable_agentless_host`")  # noqa: E501
        # verify the required parameter 'agentlesshost' is set
        if self.api_client.client_side_validation and ('agentlesshost' not in local_var_params or  # noqa: E501
                                                        local_var_params['agentlesshost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agentlesshost` when calling `disable_agentless_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agentlesshost' in local_var_params:
            path_params['agentlesshost'] = local_var_params['agentlesshost']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agentlesshost/{agentlesshost}/disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def disable_ctm_server(self, server, **kwargs):  # noqa: E501
        """Set server to disabled state.  # noqa: E501

        Set server to disabled state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_ctm_server(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.disable_ctm_server_with_http_info(server, **kwargs)  # noqa: E501

    def disable_ctm_server_with_http_info(self, server, **kwargs):  # noqa: E501
        """Set server to disabled state.  # noqa: E501

        Set server to disabled state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_ctm_server_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_ctm_server" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `disable_ctm_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def disable_mft_processing_rule_for_site(self, site_name, rule_name, **kwargs):  # noqa: E501
        """Disable MFTE processing rule for site  # noqa: E501

        Disable MFTE processing rule for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_mft_processing_rule_for_site(site_name, rule_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_name: Name of rule (required)
        :type rule_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.disable_mft_processing_rule_for_site_with_http_info(site_name, rule_name, **kwargs)  # noqa: E501

    def disable_mft_processing_rule_for_site_with_http_info(self, site_name, rule_name, **kwargs):  # noqa: E501
        """Disable MFTE processing rule for site  # noqa: E501

        Disable MFTE processing rule for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_mft_processing_rule_for_site_with_http_info(site_name, rule_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_name: Name of rule (required)
        :type rule_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'rule_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_mft_processing_rule_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `disable_mft_processing_rule_for_site`")  # noqa: E501
        # verify the required parameter 'rule_name' is set
        if self.api_client.client_side_validation and ('rule_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_name` when calling `disable_mft_processing_rule_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'rule_name' in local_var_params:
            path_params['ruleName'] = local_var_params['rule_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/processingRule/{ruleName}/disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def em_db_check_space(self, **kwargs):  # noqa: E501
        """Check available space of EM DB  # noqa: E501

        Check available space of EM DB  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.em_db_check_space(async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: SysAdminInfo
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DeviceSpace]
        """
        kwargs['_return_http_data_only'] = True
        return self.em_db_check_space_with_http_info(**kwargs)  # noqa: E501

    def em_db_check_space_with_http_info(self, **kwargs):  # noqa: E501
        """Check available space of EM DB  # noqa: E501

        Check available space of EM DB  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.em_db_check_space_with_http_info(async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: SysAdminInfo
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DeviceSpace], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method em_db_check_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[DeviceSpace]",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/em/db/space', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def em_db_get_details(self, **kwargs):  # noqa: E501
        """Get EM DB Details  # noqa: E501

        Get EM DB Details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.em_db_get_details(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DatabaseDef
        """
        kwargs['_return_http_data_only'] = True
        return self.em_db_get_details_with_http_info(**kwargs)  # noqa: E501

    def em_db_get_details_with_http_info(self, **kwargs):  # noqa: E501
        """Get EM DB Details  # noqa: E501

        Get EM DB Details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.em_db_get_details_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DatabaseDef, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method em_db_get_details" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "DatabaseDef",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/em/db/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def enable_agent(self, server, agent, **kwargs):  # noqa: E501
        """enable agent from the Server  # noqa: E501

        Enable an Agent. This command does not install or configure the agent. It only enable existing agent in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected too. (required)
        :type server: str
        :param agent: The Agent to be enabled. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.enable_agent_with_http_info(server, agent, **kwargs)  # noqa: E501

    def enable_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """enable agent from the Server  # noqa: E501

        Enable an Agent. This command does not install or configure the agent. It only enable existing agent in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected too. (required)
        :type server: str
        :param agent: The Agent to be enabled. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_agent" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `enable_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `enable_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def enable_agentless_host(self, server, agentlesshost, **kwargs):  # noqa: E501
        """enable agentless host from the Server  # noqa: E501

        Enable an Agentless Host. This command does not install or configure the Agentless Host. It only enable existing Agentless Host in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_agentless_host(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected too. (required)
        :type server: str
        :param agentlesshost: The Agentless Host to be enabled. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.enable_agentless_host_with_http_info(server, agentlesshost, **kwargs)  # noqa: E501

    def enable_agentless_host_with_http_info(self, server, agentlesshost, **kwargs):  # noqa: E501
        """enable agentless host from the Server  # noqa: E501

        Enable an Agentless Host. This command does not install or configure the Agentless Host. It only enable existing Agentless Host in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_agentless_host_with_http_info(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host is connected too. (required)
        :type server: str
        :param agentlesshost: The Agentless Host to be enabled. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agentlesshost'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_agentless_host" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `enable_agentless_host`")  # noqa: E501
        # verify the required parameter 'agentlesshost' is set
        if self.api_client.client_side_validation and ('agentlesshost' not in local_var_params or  # noqa: E501
                                                        local_var_params['agentlesshost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agentlesshost` when calling `enable_agentless_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agentlesshost' in local_var_params:
            path_params['agentlesshost'] = local_var_params['agentlesshost']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agentlesshost/{agentlesshost}/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def enable_ctm_server(self, server, **kwargs):  # noqa: E501
        """Set server to enabled state.  # noqa: E501

        Set server to enabled state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_ctm_server(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.enable_ctm_server_with_http_info(server, **kwargs)  # noqa: E501

    def enable_ctm_server_with_http_info(self, server, **kwargs):  # noqa: E501
        """Set server to enabled state.  # noqa: E501

        Set server to enabled state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_ctm_server_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_ctm_server" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `enable_ctm_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def enable_mft_processing_rule_for_site(self, site_name, rule_name, **kwargs):  # noqa: E501
        """Enable MFTE processing rule for site  # noqa: E501

        Enable MFTE processing rule for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_mft_processing_rule_for_site(site_name, rule_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_name: Name of rule (required)
        :type rule_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.enable_mft_processing_rule_for_site_with_http_info(site_name, rule_name, **kwargs)  # noqa: E501

    def enable_mft_processing_rule_for_site_with_http_info(self, site_name, rule_name, **kwargs):  # noqa: E501
        """Enable MFTE processing rule for site  # noqa: E501

        Enable MFTE processing rule for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_mft_processing_rule_for_site_with_http_info(site_name, rule_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param rule_name: Name of rule (required)
        :type rule_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'rule_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_mft_processing_rule_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `enable_mft_processing_rule_for_site`")  # noqa: E501
        # verify the required parameter 'rule_name' is set
        if self.api_client.client_side_validation and ('rule_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_name` when calling `enable_mft_processing_rule_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'rule_name' in local_var_params:
            path_params['ruleName'] = local_var_params['rule_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/processingRule/{ruleName}/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def failover(self, server, **kwargs):  # noqa: E501
        """Perform Control-M/Server failover to the secondary Control-M/Server server.  # noqa: E501

        Perform Control-M/Server failover to the secondary Control-M/Server server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.failover(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param _async: Whether the call performs asynchronously, either true or false. The default is false (call performs synchronously).
        :type _async: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.failover_with_http_info(server, **kwargs)  # noqa: E501

    def failover_with_http_info(self, server, **kwargs):  # noqa: E501
        """Perform Control-M/Server failover to the secondary Control-M/Server server.  # noqa: E501

        Perform Control-M/Server failover to the secondary Control-M/Server server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.failover_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param _async: Whether the call performs asynchronously, either true or false. The default is false (call performs synchronously).
        :type _async: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            '_async'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method failover" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `failover`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []
        if '_async' in local_var_params and local_var_params['_async'] is not None:  # noqa: E501
            query_params.append(('async', local_var_params['_async']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/failover', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def fallback(self, server, **kwargs):  # noqa: E501
        """Perform Control-M/Server fallback to the primary Control-M/Server server.  # noqa: E501

        Perform Control-M/Server fallback to the primary Control-M/Server server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fallback(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.fallback_with_http_info(server, **kwargs)  # noqa: E501

    def fallback_with_http_info(self, server, **kwargs):  # noqa: E501
        """Perform Control-M/Server fallback to the primary Control-M/Server server.  # noqa: E501

        Perform Control-M/Server fallback to the primary Control-M/Server server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fallback_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fallback" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `fallback`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/fallback', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def generate_mft_rsa_ssh_key(self, server, agent, ssh_key_properties, **kwargs):  # noqa: E501
        """Generate RSA SSH Key  # noqa: E501

        Generate RSA SSH Key pair for SFTP account authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_mft_rsa_ssh_key(server, agent, ssh_key_properties, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param ssh_key_properties: Ssh Key pair properites (required)
        :type ssh_key_properties: SshKeyProperties
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.generate_mft_rsa_ssh_key_with_http_info(server, agent, ssh_key_properties, **kwargs)  # noqa: E501

    def generate_mft_rsa_ssh_key_with_http_info(self, server, agent, ssh_key_properties, **kwargs):  # noqa: E501
        """Generate RSA SSH Key  # noqa: E501

        Generate RSA SSH Key pair for SFTP account authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_mft_rsa_ssh_key_with_http_info(server, agent, ssh_key_properties, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param ssh_key_properties: Ssh Key pair properites (required)
        :type ssh_key_properties: SshKeyProperties
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'ssh_key_properties'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_mft_rsa_ssh_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `generate_mft_rsa_ssh_key`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `generate_mft_rsa_ssh_key`")  # noqa: E501
        # verify the required parameter 'ssh_key_properties' is set
        if self.api_client.client_side_validation and ('ssh_key_properties' not in local_var_params or  # noqa: E501
                                                        local_var_params['ssh_key_properties'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ssh_key_properties` when calling `generate_mft_rsa_ssh_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ssh_key_properties' in local_var_params:
            body_params = local_var_params['ssh_key_properties']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/ssh/key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_agent_certificate_expiration_date(self, server, agent, **kwargs):  # noqa: E501
        """Get certificate expiration date.  # noqa: E501

        Get the certificate expiration date of SSL configured Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agent_certificate_expiration_date(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentCertificateExpirationData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_agent_certificate_expiration_date_with_http_info(server, agent, **kwargs)  # noqa: E501

    def get_agent_certificate_expiration_date_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get certificate expiration date.  # noqa: E501

        Get the certificate expiration date of SSL configured Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agent_certificate_expiration_date_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AgentCertificateExpirationData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_certificate_expiration_date" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_agent_certificate_expiration_date`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_agent_certificate_expiration_date`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AgentCertificateExpirationData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/crt/expiration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_agent_parameters(self, server, agent, **kwargs):  # noqa: E501
        """get agent parameters  # noqa: E501

        Get all the parameters of the specified Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agent_parameters(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected to. (required)
        :type server: str
        :param agent: The name of the agent to query. (required)
        :type agent: str
        :param extended_data: True to return more agent parameters. HIDDEN
        :type extended_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[KeyValue]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_agent_parameters_with_http_info(server, agent, **kwargs)  # noqa: E501

    def get_agent_parameters_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """get agent parameters  # noqa: E501

        Get all the parameters of the specified Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agent_parameters_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agent is connected to. (required)
        :type server: str
        :param agent: The name of the agent to query. (required)
        :type agent: str
        :param extended_data: True to return more agent parameters. HIDDEN
        :type extended_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[KeyValue], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'extended_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_parameters" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_agent_parameters`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_agent_parameters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []
        if 'extended_data' in local_var_params and local_var_params['extended_data'] is not None:  # noqa: E501
            query_params.append(('extendedData', local_var_params['extended_data']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[KeyValue]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/params', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_agentless_host_properties(self, server, agentlesshost, **kwargs):  # noqa: E501
        """get an agentless host configuration from Server  # noqa: E501

        Get the agentless host configuration properties from the Server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agentless_host_properties(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host  is connected to. (required)
        :type server: str
        :param agentlesshost: The name of the agentless host. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddRemoteHostParams
        """
        kwargs['_return_http_data_only'] = True
        return self.get_agentless_host_properties_with_http_info(server, agentlesshost, **kwargs)  # noqa: E501

    def get_agentless_host_properties_with_http_info(self, server, agentlesshost, **kwargs):  # noqa: E501
        """get an agentless host configuration from Server  # noqa: E501

        Get the agentless host configuration properties from the Server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agentless_host_properties_with_http_info(server, agentlesshost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the agentless host  is connected to. (required)
        :type server: str
        :param agentlesshost: The name of the agentless host. (required)
        :type agentlesshost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddRemoteHostParams, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agentlesshost'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agentless_host_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_agentless_host_properties`")  # noqa: E501
        # verify the required parameter 'agentlesshost' is set
        if self.api_client.client_side_validation and ('agentlesshost' not in local_var_params or  # noqa: E501
                                                        local_var_params['agentlesshost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agentlesshost` when calling `get_agentless_host_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agentlesshost' in local_var_params:
            path_params['agentlesshost'] = local_var_params['agentlesshost']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AddRemoteHostParams",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agentlesshost/{agentlesshost}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_agentless_hosts(self, server, **kwargs):  # noqa: E501
        """get Server agentless hosts  # noqa: E501

        Get all the agentless hosts of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agentless_hosts(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server to query. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_agentless_hosts_with_http_info(server, **kwargs)  # noqa: E501

    def get_agentless_hosts_with_http_info(self, server, **kwargs):  # noqa: E501
        """get Server agentless hosts  # noqa: E501

        Get all the agentless hosts of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agentless_hosts_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server to query. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agentless_hosts" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_agentless_hosts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agentlesshosts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_agents(self, server, **kwargs):  # noqa: E501
        """get Server agents  # noqa: E501

        Get all the agents of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agents(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server to query. Optionally you can filter agent name of host or alias of the Agent (required)
        :type server: str
        :param agent: Optionally case insensitive agent name filter of host or alias of the Agent. `ctm server:agents::get Server AgentName` returns all agents which names start with `agentname`
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentDetailsList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_agents_with_http_info(server, **kwargs)  # noqa: E501

    def get_agents_with_http_info(self, server, **kwargs):  # noqa: E501
        """get Server agents  # noqa: E501

        Get all the agents of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agents_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server to query. Optionally you can filter agent name of host or alias of the Agent (required)
        :type server: str
        :param agent: Optionally case insensitive agent name filter of host or alias of the Agent. `ctm server:agents::get Server AgentName` returns all agents which names start with `agentname`
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AgentDetailsList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agents" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_agents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AgentDetailsList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_agents_log(self, **kwargs):  # noqa: E501
        """Retrieve Configuration Agents Log  # noqa: E501

        Retrieves the logs of configuration Agents, providing detailed information useful for diagnostics and auditing purposes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agents_log(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AgentLogEntry]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_agents_log_with_http_info(**kwargs)  # noqa: E501

    def get_agents_log_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve Configuration Agents Log  # noqa: E501

        Retrieves the logs of configuration Agents, providing detailed information useful for diagnostics and auditing purposes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_agents_log_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AgentLogEntry], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agents_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[AgentLogEntry]",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/em/agentsLog', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_archive_rules(self, **kwargs):  # noqa: E501
        """Get all Workload Archiving rules  # noqa: E501

        Get all the Archiving rules  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_archive_rules(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveRulesList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_archive_rules_with_http_info(**kwargs)  # noqa: E501

    def get_all_archive_rules_with_http_info(self, **kwargs):  # noqa: E501
        """Get all Workload Archiving rules  # noqa: E501

        Get all the Archiving rules  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_archive_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ArchiveRulesList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_archive_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ArchiveRulesList",
            401: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/archive/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_authorization_roles(self, **kwargs):  # noqa: E501
        """Get Authorization Roles  # noqa: E501

        Get Authorization Roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_authorization_roles(async_req=True)
        >>> result = thread.get()

        :param role: The Role name.
        :type role: str
        :param description: The Role description.
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[RoleHeader]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_authorization_roles_with_http_info(**kwargs)  # noqa: E501

    def get_all_authorization_roles_with_http_info(self, **kwargs):  # noqa: E501
        """Get Authorization Roles  # noqa: E501

        Get Authorization Roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_authorization_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param role: The Role name.
        :type role: str
        :param description: The Role description.
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[RoleHeader], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'role',
            'description'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_authorization_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[RoleHeader]",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_organization_groups(self, **kwargs):  # noqa: E501
        """Get All organization groups  # noqa: E501

        Get All organization groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_organization_groups(async_req=True)
        >>> result = thread.get()

        :param organizationgroup: The organization group name.
        :type organizationgroup: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_organization_groups_with_http_info(**kwargs)  # noqa: E501

    def get_all_organization_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Get All organization groups  # noqa: E501

        Get All organization groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_organization_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param organizationgroup: The organization group name.
        :type organizationgroup: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'organizationgroup'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_organization_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'organizationgroup' in local_var_params and local_var_params['organizationgroup'] is not None:  # noqa: E501
            query_params.append(('organizationgroup', local_var_params['organizationgroup']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/organizationgroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_organization_users(self, **kwargs):  # noqa: E501
        """Get All organization users  # noqa: E501

        Get All organization users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_organization_users(async_req=True)
        >>> result = thread.get()

        :param organization_user: The user name.
        :type organization_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_organization_users_with_http_info(**kwargs)  # noqa: E501

    def get_all_organization_users_with_http_info(self, **kwargs):  # noqa: E501
        """Get All organization users  # noqa: E501

        Get All organization users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_organization_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param organization_user: The user name.
        :type organization_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'organization_user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_organization_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'organization_user' in local_var_params and local_var_params['organization_user'] is not None:  # noqa: E501
            query_params.append(('organizationUser', local_var_params['organization_user']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/organizationusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_roles_associated_with_organization_group(self, organizationgroup, **kwargs):  # noqa: E501
        """Get Authorization Roles associated with an organization group  # noqa: E501

        Get Authorization Roles associated with an organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_roles_associated_with_organization_group(organizationgroup, async_req=True)
        >>> result = thread.get()

        :param organizationgroup: Name of organization group (required)
        :type organizationgroup: str
        :param role: The Role name.
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_roles_associated_with_organization_group_with_http_info(organizationgroup, **kwargs)  # noqa: E501

    def get_all_roles_associated_with_organization_group_with_http_info(self, organizationgroup, **kwargs):  # noqa: E501
        """Get Authorization Roles associated with an organization group  # noqa: E501

        Get Authorization Roles associated with an organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_roles_associated_with_organization_group_with_http_info(organizationgroup, async_req=True)
        >>> result = thread.get()

        :param organizationgroup: Name of organization group (required)
        :type organizationgroup: str
        :param role: The Role name.
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'organizationgroup',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_roles_associated_with_organization_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organizationgroup' is set
        if self.api_client.client_side_validation and ('organizationgroup' not in local_var_params or  # noqa: E501
                                                        local_var_params['organizationgroup'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organizationgroup` when calling `get_all_roles_associated_with_organization_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organizationgroup' in local_var_params:
            path_params['organizationgroup'] = local_var_params['organizationgroup']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/organizationgroup/{organizationgroup}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_roles_associated_with_organization_user(self, user, **kwargs):  # noqa: E501
        """Get Authorization Roles associated with an Organization user  # noqa: E501

        Get Authorization Roles associated with an Organization user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_roles_associated_with_organization_user(user, async_req=True)
        >>> result = thread.get()

        :param user: Name of organization user (required)
        :type user: str
        :param role: The Role name.
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_roles_associated_with_organization_user_with_http_info(user, **kwargs)  # noqa: E501

    def get_all_roles_associated_with_organization_user_with_http_info(self, user, **kwargs):  # noqa: E501
        """Get Authorization Roles associated with an Organization user  # noqa: E501

        Get Authorization Roles associated with an Organization user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_roles_associated_with_organization_user_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param user: Name of organization user (required)
        :type user: str
        :param role: The Role name.
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user',
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_roles_associated_with_organization_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in local_var_params or  # noqa: E501
                                                        local_var_params['user'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user` when calling `get_all_roles_associated_with_organization_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []
        if 'role' in local_var_params and local_var_params['role'] is not None:  # noqa: E501
            query_params.append(('role', local_var_params['role']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/organizationuser/{user}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_users(self, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Get users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_users(async_req=True)
        >>> result = thread.get()

        :param name: The user name.
        :type name: str
        :param full_name: The user full name.
        :type full_name: str
        :param description: The user description.
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[UserHeader]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_users_with_http_info(**kwargs)  # noqa: E501

    def get_all_users_with_http_info(self, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Get users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name: The user name.
        :type name: str
        :param full_name: The user full name.
        :type full_name: str
        :param description: The user description.
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[UserHeader], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name',
            'full_name',
            'description'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'full_name' in local_var_params and local_var_params['full_name'] is not None:  # noqa: E501
            query_params.append(('fullName', local_var_params['full_name']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[UserHeader]",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_archive_statistics(self, **kwargs):  # noqa: E501
        """Get Workload Archiving statistics  # noqa: E501

        Get list of statistical information for each Archiving rule and total information about the number of jobs that have been archived, data size of all job logs and outputs that have been archived, size of the Workload Archiving database including all tables and indexes and percentage of disk space used on the Workload Archiving server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_statistics(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RulesStatisticListSummary
        """
        kwargs['_return_http_data_only'] = True
        return self.get_archive_statistics_with_http_info(**kwargs)  # noqa: E501

    def get_archive_statistics_with_http_info(self, **kwargs):  # noqa: E501
        """Get Workload Archiving statistics  # noqa: E501

        Get list of statistical information for each Archiving rule and total information about the number of jobs that have been archived, data size of all job logs and outputs that have been archived, size of the Workload Archiving database including all tables and indexes and percentage of disk space used on the Workload Archiving server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_statistics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RulesStatisticListSummary, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_archive_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "RulesStatisticListSummary",
            401: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/archive/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_communication_analysis_report_for_agent(self, server, agent, **kwargs):  # noqa: E501
        """analyze communication between an Agent and its Server  # noqa: E501

        Analyze communication between specific Control-M Server and Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_communication_analysis_report_for_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server to which the Agent is connected. (required)
        :type server: str
        :param agent: The Agent to analyze communication with. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CommunicationAnalysisResponseType
        """
        kwargs['_return_http_data_only'] = True
        return self.get_communication_analysis_report_for_agent_with_http_info(server, agent, **kwargs)  # noqa: E501

    def get_communication_analysis_report_for_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """analyze communication between an Agent and its Server  # noqa: E501

        Analyze communication between specific Control-M Server and Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_communication_analysis_report_for_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server to which the Agent is connected. (required)
        :type server: str
        :param agent: The Agent to analyze communication with. (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CommunicationAnalysisResponseType, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_communication_analysis_report_for_agent" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_communication_analysis_report_for_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_communication_analysis_report_for_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "CommunicationAnalysisResponseType",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/analysis', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_ctm_gate_ways(self, name, **kwargs):  # noqa: E501
        """Get details of specific gateway component in the system.  # noqa: E501

        Get details of specific gateway component in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_gate_ways(name, async_req=True)
        >>> result = thread.get()

        :param name: Server logical name (required)
        :type name: str
        :param host: Server host.
        :type host: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[GatewayDetails]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ctm_gate_ways_with_http_info(name, **kwargs)  # noqa: E501

    def get_ctm_gate_ways_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get details of specific gateway component in the system.  # noqa: E501

        Get details of specific gateway component in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_gate_ways_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param name: Server logical name (required)
        :type name: str
        :param host: Server host.
        :type host: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[GatewayDetails], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name',
            'host'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ctm_gate_ways" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_ctm_gate_ways`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[GatewayDetails]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{name}/gateways', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_ctm_high_availability_status(self, server, **kwargs):  # noqa: E501
        """Get Control-M/Server High Availability status  # noqa: E501

        Get Control-M/Server High Availability status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_high_availability_status(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HighAvailabilityStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ctm_high_availability_status_with_http_info(server, **kwargs)  # noqa: E501

    def get_ctm_high_availability_status_with_http_info(self, server, **kwargs):  # noqa: E501
        """Get Control-M/Server High Availability status  # noqa: E501

        Get Control-M/Server High Availability status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_high_availability_status_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HighAvailabilityStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ctm_high_availability_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_ctm_high_availability_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "HighAvailabilityStatus",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/highavailabilitystatus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_ctm_security_attributes(self, ctm_name, entity_name, **kwargs):  # noqa: E501
        """Get Security Attributes by User Or Group name  # noqa: E501

        Get Security Attributes by User Or Group name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_security_attributes(ctm_name, entity_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param entity_name: (required)
        :type entity_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CtmSecSecurityAttributes
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ctm_security_attributes_with_http_info(ctm_name, entity_name, **kwargs)  # noqa: E501

    def get_ctm_security_attributes_with_http_info(self, ctm_name, entity_name, **kwargs):  # noqa: E501
        """Get Security Attributes by User Or Group name  # noqa: E501

        Get Security Attributes by User Or Group name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_security_attributes_with_http_info(ctm_name, entity_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param entity_name: (required)
        :type entity_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CtmSecSecurityAttributes, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name',
            'entity_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ctm_security_attributes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `get_ctm_security_attributes`")  # noqa: E501
        # verify the required parameter 'entity_name' is set
        if self.api_client.client_side_validation and ('entity_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_name` when calling `get_ctm_security_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501
        if 'entity_name' in local_var_params:
            path_params['entityName'] = local_var_params['entity_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "CtmSecSecurityAttributes",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/security/attributes/{entityName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_ctm_security_entities(self, ctm_name, **kwargs):  # noqa: E501
        """Get All Security Users and Groups (Entities)  # noqa: E501

        Get All Security Users and Groups (Entities)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_security_entities(ctm_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CtmSecSecurityEntities
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ctm_security_entities_with_http_info(ctm_name, **kwargs)  # noqa: E501

    def get_ctm_security_entities_with_http_info(self, ctm_name, **kwargs):  # noqa: E501
        """Get All Security Users and Groups (Entities)  # noqa: E501

        Get All Security Users and Groups (Entities)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_security_entities_with_http_info(ctm_name, async_req=True)
        >>> result = thread.get()

        :param ctm_name: (required)
        :type ctm_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CtmSecSecurityEntities, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ctm_security_entities" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm_name' is set
        if self.api_client.client_side_validation and ('ctm_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm_name` when calling `get_ctm_security_entities`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm_name' in local_var_params:
            path_params['ctmName'] = local_var_params['ctm_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "CtmSecSecurityEntities",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctmName}/security/entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_data_assurance_configuration(self, server, agent, **kwargs):  # noqa: E501
        """Get DataAssurance configuration.  # noqa: E501

        set DataAssurance configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_assurance_configuration(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: server name (required)
        :type server: str
        :param agent: agent name (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataAssuranceConfigrationData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_assurance_configuration_with_http_info(server, agent, **kwargs)  # noqa: E501

    def get_data_assurance_configuration_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get DataAssurance configuration.  # noqa: E501

        set DataAssurance configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_assurance_configuration_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: server name (required)
        :type server: str
        :param agent: agent name (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataAssuranceConfigrationData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_assurance_configuration" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_data_assurance_configuration`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_data_assurance_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "DataAssuranceConfigrationData",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/dataAssurance/configuration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_em_component(self, host, type, name, **kwargs):  # noqa: E501
        """Get details for a specific EM component  # noqa: E501

        Get the configuration details of a specific EM component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_em_component(host, type, name, async_req=True)
        >>> result = thread.get()

        :param host: The hostname of the server where the EM component is running. (required)
        :type host: str
        :param type: The type of the EM component (required)
        :type type: str
        :param name: The logical name of the EM component. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EmComponentDef
        """
        kwargs['_return_http_data_only'] = True
        return self.get_em_component_with_http_info(host, type, name, **kwargs)  # noqa: E501

    def get_em_component_with_http_info(self, host, type, name, **kwargs):  # noqa: E501
        """Get details for a specific EM component  # noqa: E501

        Get the configuration details of a specific EM component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_em_component_with_http_info(host, type, name, async_req=True)
        >>> result = thread.get()

        :param host: The hostname of the server where the EM component is running. (required)
        :type host: str
        :param type: The type of the EM component (required)
        :type type: str
        :param name: The logical name of the EM component. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EmComponentDef, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'host',
            'type',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_em_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'host' is set
        if self.api_client.client_side_validation and ('host' not in local_var_params or  # noqa: E501
                                                        local_var_params['host'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `host` when calling `get_em_component`")  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `get_em_component`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_em_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'host' in local_var_params:
            path_params['host'] = local_var_params['host']  # noqa: E501
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "EmComponentDef",
            400: "ErrorList",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/em/component/{host}/{type}/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_em_high_availability_status(self, **kwargs):  # noqa: E501
        """Get EM High Availability status  # noqa: E501

        Get EM High Availability status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_em_high_availability_status(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HighAvailabilityStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.get_em_high_availability_status_with_http_info(**kwargs)  # noqa: E501

    def get_em_high_availability_status_with_http_info(self, **kwargs):  # noqa: E501
        """Get EM High Availability status  # noqa: E501

        Get EM High Availability status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_em_high_availability_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HighAvailabilityStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_em_high_availability_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "HighAvailabilityStatus",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/em/highavailabilitystatus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_external_user_authorized_folders(self, name, **kwargs):  # noqa: E501
        """Get MFT external user authorized folders  # noqa: E501

        Get MFT external user authorized folders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_user_authorized_folders(name, async_req=True)
        >>> result = thread.get()

        :param name: The external user name. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_user_authorized_folders_with_http_info(name, **kwargs)  # noqa: E501

    def get_external_user_authorized_folders_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get MFT external user authorized folders  # noqa: E501

        Get MFT external user authorized folders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_user_authorized_folders_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param name: The external user name. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_user_authorized_folders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_external_user_authorized_folders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/externaluser/{name}/virtualfolders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_external_user_authorized_folders_for_site(self, site_name, name, **kwargs):  # noqa: E501
        """Get MFT external user authorized folders for site  # noqa: E501

        Get MFT external user authorized folders for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_user_authorized_folders_for_site(site_name, name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: The external user name. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_user_authorized_folders_for_site_with_http_info(site_name, name, **kwargs)  # noqa: E501

    def get_external_user_authorized_folders_for_site_with_http_info(self, site_name, name, **kwargs):  # noqa: E501
        """Get MFT external user authorized folders for site  # noqa: E501

        Get MFT external user authorized folders for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_user_authorized_folders_for_site_with_http_info(site_name, name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: The external user name. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_user_authorized_folders_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_external_user_authorized_folders_for_site`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_external_user_authorized_folders_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/externaluser/{name}/virtualfolders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_external_users(self, **kwargs):  # noqa: E501
        """Get MFT external users that match the search criteria.  # noqa: E501

        Get MFT external users that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_users(async_req=True)
        >>> result = thread.get()

        :param name: The user name.
        :type name: str
        :param email: The user email.
        :type email: str
        :param description: The user description.
        :type description: str
        :param company: The user company.
        :type company: str
        :param phone_number: The user phoneNumber.
        :type phone_number: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[ExternalUserData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_users_with_http_info(**kwargs)  # noqa: E501

    def get_external_users_with_http_info(self, **kwargs):  # noqa: E501
        """Get MFT external users that match the search criteria.  # noqa: E501

        Get MFT external users that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name: The user name.
        :type name: str
        :param email: The user email.
        :type email: str
        :param description: The user description.
        :type description: str
        :param company: The user company.
        :type company: str
        :param phone_number: The user phoneNumber.
        :type phone_number: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[ExternalUserData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name',
            'email',
            'description',
            'company',
            'phone_number'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'company' in local_var_params and local_var_params['company'] is not None:  # noqa: E501
            query_params.append(('company', local_var_params['company']))  # noqa: E501
        if 'phone_number' in local_var_params and local_var_params['phone_number'] is not None:  # noqa: E501
            query_params.append(('phoneNumber', local_var_params['phone_number']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[ExternalUserData]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/externalusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_external_users_for_site(self, site_name, **kwargs):  # noqa: E501
        """Get MFT external users for site that match the search criteria.  # noqa: E501

        Get MFT external users for site that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_users_for_site(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param name: The user name.
        :type name: str
        :param email: The user email.
        :type email: str
        :param description: The user description.
        :type description: str
        :param company: The user company.
        :type company: str
        :param phone_number: The user phoneNumber.
        :type phone_number: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[ExternalUserData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_users_for_site_with_http_info(site_name, **kwargs)  # noqa: E501

    def get_external_users_for_site_with_http_info(self, site_name, **kwargs):  # noqa: E501
        """Get MFT external users for site that match the search criteria.  # noqa: E501

        Get MFT external users for site that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_users_for_site_with_http_info(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param name: The user name.
        :type name: str
        :param email: The user email.
        :type email: str
        :param description: The user description.
        :type description: str
        :param company: The user company.
        :type company: str
        :param phone_number: The user phoneNumber.
        :type phone_number: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[ExternalUserData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'name',
            'email',
            'description',
            'company',
            'phone_number'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_users_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_external_users_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'company' in local_var_params and local_var_params['company'] is not None:  # noqa: E501
            query_params.append(('company', local_var_params['company']))  # noqa: E501
        if 'phone_number' in local_var_params and local_var_params['phone_number'] is not None:  # noqa: E501
            query_params.append(('phoneNumber', local_var_params['phone_number']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[ExternalUserData]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/externalusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_fts_settings(self, server, agent, **kwargs):  # noqa: E501
        """Get File Transfer Server (FTS) configuration data.  # noqa: E501

        Get File Transfer Server (FTS) configuration data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fts_settings(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FtsSettingsData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fts_settings_with_http_info(server, agent, **kwargs)  # noqa: E501

    def get_fts_settings_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get File Transfer Server (FTS) configuration data.  # noqa: E501

        Get File Transfer Server (FTS) configuration data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fts_settings_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FtsSettingsData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fts_settings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_fts_settings`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_fts_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "FtsSettingsData",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/fts/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_host_restriction_list(self, ctm, **kwargs):  # noqa: E501
        """Get all host restrictions.  # noqa: E501

        Get all host restrictions of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_restriction_list(ctm, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[HostRestriction]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_host_restriction_list_with_http_info(ctm, **kwargs)  # noqa: E501

    def get_host_restriction_list_with_http_info(self, ctm, **kwargs):  # noqa: E501
        """Get all host restrictions.  # noqa: E501

        Get all host restrictions of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_restriction_list_with_http_info(ctm, async_req=True)
        >>> result = thread.get()

        :param ctm: Name of the Control-M/Server. (required)
        :type ctm: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[HostRestriction], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_restriction_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm' is set
        if self.api_client.client_side_validation and ('ctm' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm` when calling `get_host_restriction_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ctm' in local_var_params:
            path_params['ctm'] = local_var_params['ctm']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[HostRestriction]",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{ctm}/hostRestrictions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_hostgroups(self, server, **kwargs):  # noqa: E501
        """get Server hostgroups  # noqa: E501

        Get all the hostgroups of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hostgroups(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroups belong to. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_hostgroups_with_http_info(server, **kwargs)  # noqa: E501

    def get_hostgroups_with_http_info(self, server, **kwargs):  # noqa: E501
        """get Server hostgroups  # noqa: E501

        Get all the hostgroups of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hostgroups_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroups belong to. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hostgroups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_hostgroups`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/hostgroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_hostgroups_and_agents_with_tag(self, server, **kwargs):  # noqa: E501
        """get Server host groups with their agents  # noqa: E501

        Get all the host groups with their agents of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hostgroups_and_agents_with_tag(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the host groups belong to. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[HostGroupData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_hostgroups_and_agents_with_tag_with_http_info(server, **kwargs)  # noqa: E501

    def get_hostgroups_and_agents_with_tag_with_http_info(self, server, **kwargs):  # noqa: E501
        """get Server host groups with their agents  # noqa: E501

        Get all the host groups with their agents of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hostgroups_and_agents_with_tag_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server the host groups belong to. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[HostGroupData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hostgroups_and_agents_with_tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_hostgroups_and_agents_with_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[HostGroupData]",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/hostgroups/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_hosts_in_group(self, server, hostgroup, **kwargs):  # noqa: E501
        """get hostgroup agents  # noqa: E501

        Get the agents that compose the specified hostgroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hosts_in_group(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroup belongs to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AgentInGroupParams]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_hosts_in_group_with_http_info(server, hostgroup, **kwargs)  # noqa: E501

    def get_hosts_in_group_with_http_info(self, server, hostgroup, **kwargs):  # noqa: E501
        """get hostgroup agents  # noqa: E501

        Get the agents that compose the specified hostgroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hosts_in_group_with_http_info(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param server: The Server the hostgroup belongs to. (required)
        :type server: str
        :param hostgroup: The hostgroup name (required)
        :type hostgroup: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AgentInGroupParams], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'hostgroup'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hosts_in_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_hosts_in_group`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in local_var_params or  # noqa: E501
                                                        local_var_params['hostgroup'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hostgroup` when calling `get_hosts_in_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'hostgroup' in local_var_params:
            path_params['hostgroup'] = local_var_params['hostgroup']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[AgentInGroupParams]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_hub_status_details(self, node_id, **kwargs):  # noqa: E501
        """Get hub status.  # noqa: E501

        Get hub status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hub_status_details(node_id, async_req=True)
        >>> result = thread.get()

        :param node_id: Node ID of the hub (required)
        :type node_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_hub_status_details_with_http_info(node_id, **kwargs)  # noqa: E501

    def get_hub_status_details_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get hub status.  # noqa: E501

        Get hub status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hub_status_details_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param node_id: Node ID of the hub (required)
        :type node_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'node_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hub_status_details" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'node_id' is set
        if self.api_client.client_side_validation and ('node_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['node_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `node_id` when calling `get_hub_status_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in local_var_params:
            path_params['nodeId'] = local_var_params['node_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/hub/{nodeId}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_hub_status_details_for_site(self, site_name, node_id, **kwargs):  # noqa: E501
        """Get hub status in site.  # noqa: E501

        Get hub status in site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hub_status_details_for_site(site_name, node_id, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param node_id: Node ID of the hub (required)
        :type node_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_hub_status_details_for_site_with_http_info(site_name, node_id, **kwargs)  # noqa: E501

    def get_hub_status_details_for_site_with_http_info(self, site_name, node_id, **kwargs):  # noqa: E501
        """Get hub status in site.  # noqa: E501

        Get hub status in site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hub_status_details_for_site_with_http_info(site_name, node_id, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param node_id: Node ID of the hub (required)
        :type node_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'node_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hub_status_details_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_hub_status_details_for_site`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if self.api_client.client_side_validation and ('node_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['node_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `node_id` when calling `get_hub_status_details_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501
        if 'node_id' in local_var_params:
            path_params['nodeId'] = local_var_params['node_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/hub/{nodeId}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_identity_provider_metadata(self, **kwargs):  # noqa: E501
        """Get identity Provider Metadata file  # noqa: E501

        Get identity Provider Metadata file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_identity_provider_metadata(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_identity_provider_metadata_with_http_info(**kwargs)  # noqa: E501

    def get_identity_provider_metadata_with_http_info(self, **kwargs):  # noqa: E501
        """Get identity Provider Metadata file  # noqa: E501

        Get identity Provider Metadata file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_identity_provider_metadata_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_identity_provider_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/systemsettings/saml2identityprovidermetadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_load_balancer_properties(self, server, load_balancer, **kwargs):  # noqa: E501
        """Get loadBalancer parameters  # noqa: E501

        Get loadBalancer parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_load_balancer_properties(server, load_balancer, async_req=True)
        >>> result = thread.get()

        :param server: The Server the loadBalancer is added to. (required)
        :type server: str
        :param load_balancer: The loadBalancer to be retrieved. (required)
        :type load_balancer: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[KeyValueType]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_load_balancer_properties_with_http_info(server, load_balancer, **kwargs)  # noqa: E501

    def get_load_balancer_properties_with_http_info(self, server, load_balancer, **kwargs):  # noqa: E501
        """Get loadBalancer parameters  # noqa: E501

        Get loadBalancer parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_load_balancer_properties_with_http_info(server, load_balancer, async_req=True)
        >>> result = thread.get()

        :param server: The Server the loadBalancer is added to. (required)
        :type server: str
        :param load_balancer: The loadBalancer to be retrieved. (required)
        :type load_balancer: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[KeyValueType], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'load_balancer'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_load_balancer_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_load_balancer_properties`")  # noqa: E501
        # verify the required parameter 'load_balancer' is set
        if self.api_client.client_side_validation and ('load_balancer' not in local_var_params or  # noqa: E501
                                                        local_var_params['load_balancer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `load_balancer` when calling `get_load_balancer_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'load_balancer' in local_var_params:
            path_params['loadBalancer'] = local_var_params['load_balancer']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[KeyValueType]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/loadbalancer/{loadBalancer}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_locked_external_users(self, **kwargs):  # noqa: E501
        """Get MFT locked external users.  # noqa: E501

        Get MFT locked external users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_locked_external_users(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[ExternalUserData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_locked_external_users_with_http_info(**kwargs)  # noqa: E501

    def get_locked_external_users_with_http_info(self, **kwargs):  # noqa: E501
        """Get MFT locked external users.  # noqa: E501

        Get MFT locked external users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_locked_external_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[ExternalUserData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_locked_external_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[ExternalUserData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/externalusers/locked', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_locked_external_users_for_site(self, site_name, **kwargs):  # noqa: E501
        """Get MFT locked external users for site.  # noqa: E501

        Get MFT locked external users for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_locked_external_users_for_site(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name (required)
        :type site_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[ExternalUserData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_locked_external_users_for_site_with_http_info(site_name, **kwargs)  # noqa: E501

    def get_locked_external_users_for_site_with_http_info(self, site_name, **kwargs):  # noqa: E501
        """Get MFT locked external users for site.  # noqa: E501

        Get MFT locked external users for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_locked_external_users_for_site_with_http_info(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name (required)
        :type site_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[ExternalUserData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_locked_external_users_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_locked_external_users_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[ExternalUserData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/externalusers/locked', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_configuration(self, server, agent, **kwargs):  # noqa: E501
        """Get MFT Configuration  # noqa: E501

        Get MFT Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_configuration(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MftConfigurationData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_configuration_with_http_info(server, agent, **kwargs)  # noqa: E501

    def get_mft_configuration_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get MFT Configuration  # noqa: E501

        Get MFT Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_configuration_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MftConfigurationData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_configuration" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_mft_configuration`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_mft_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "MftConfigurationData",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/configuration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_folders(self, **kwargs):  # noqa: E501
        """Get MFT virtual folders that match the search criteria.  # noqa: E501

        Get MFT virtual folders that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_folders(async_req=True)
        >>> result = thread.get()

        :param name: The virtual folder name.
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[FolderPropertiesData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_folders_with_http_info(**kwargs)  # noqa: E501

    def get_mft_folders_with_http_info(self, **kwargs):  # noqa: E501
        """Get MFT virtual folders that match the search criteria.  # noqa: E501

        Get MFT virtual folders that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_folders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name: The virtual folder name.
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[FolderPropertiesData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_folders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[FolderPropertiesData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/virtualfolders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_folders_for_site(self, site_name, **kwargs):  # noqa: E501
        """Get MFT virtual folders that match the search criteria for site.  # noqa: E501

        Get MFT virtual folders that match the search criteria for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_folders_for_site(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: The virtual folder name.
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[FolderPropertiesData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_folders_for_site_with_http_info(site_name, **kwargs)  # noqa: E501

    def get_mft_folders_for_site_with_http_info(self, site_name, **kwargs):  # noqa: E501
        """Get MFT virtual folders that match the search criteria for site.  # noqa: E501

        Get MFT virtual folders that match the search criteria for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_folders_for_site_with_http_info(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: The virtual folder name.
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[FolderPropertiesData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_folders_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_mft_folders_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[FolderPropertiesData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/virtualfolders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_gateways(self, **kwargs):  # noqa: E501
        """Get MFT gateways  # noqa: E501

        Get MFT gateways  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_gateways(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[GatewayData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_gateways_with_http_info(**kwargs)  # noqa: E501

    def get_mft_gateways_with_http_info(self, **kwargs):  # noqa: E501
        """Get MFT gateways  # noqa: E501

        Get MFT gateways  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_gateways_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[GatewayData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_gateways" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[GatewayData]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/gateways', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_gateways_for_site(self, site_name, **kwargs):  # noqa: E501
        """Get MFT gateways for site  # noqa: E501

        Get MFT gateways for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_gateways_for_site(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[GatewayData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_gateways_for_site_with_http_info(site_name, **kwargs)  # noqa: E501

    def get_mft_gateways_for_site_with_http_info(self, site_name, **kwargs):  # noqa: E501
        """Get MFT gateways for site  # noqa: E501

        Get MFT gateways for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_gateways_for_site_with_http_info(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[GatewayData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_gateways_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_mft_gateways_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[GatewayData]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/gateways', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_processing_rules_for_site(self, site_name, **kwargs):  # noqa: E501
        """Get MFTE processing rules that match the search criteria for site.  # noqa: E501

        Get MFTE processing rules that match the search criteria for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_processing_rules_for_site(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param name: The rule name.
        :type name: str
        :param description: The rule description.
        :type description: str
        :param priority: The rule priority.
        :type priority: str
        :param status: The rule status.
        :type status: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[RulePropertiesData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_processing_rules_for_site_with_http_info(site_name, **kwargs)  # noqa: E501

    def get_mft_processing_rules_for_site_with_http_info(self, site_name, **kwargs):  # noqa: E501
        """Get MFTE processing rules that match the search criteria for site.  # noqa: E501

        Get MFTE processing rules that match the search criteria for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_processing_rules_for_site_with_http_info(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: site name (required)
        :type site_name: str
        :param name: The rule name.
        :type name: str
        :param description: The rule description.
        :type description: str
        :param priority: The rule priority.
        :type priority: str
        :param status: The rule status.
        :type status: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[RulePropertiesData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'name',
            'description',
            'priority',
            'status'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_processing_rules_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_mft_processing_rules_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'priority' in local_var_params and local_var_params['priority'] is not None:  # noqa: E501
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[RulePropertiesData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/processingRules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_user_groups(self, **kwargs):  # noqa: E501
        """Get all user groups that match the search criteria.  # noqa: E501

        Get all user groups that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_user_groups(async_req=True)
        >>> result = thread.get()

        :param name: The user group name.
        :type name: str
        :param external_users: external users.
        :type external_users: str
        :param ldap_groups: ldap groups.
        :type ldap_groups: str
        :param ldap_users: ldap users.
        :type ldap_users: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[UserGroupPropertiesData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_user_groups_with_http_info(**kwargs)  # noqa: E501

    def get_mft_user_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Get all user groups that match the search criteria.  # noqa: E501

        Get all user groups that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_user_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name: The user group name.
        :type name: str
        :param external_users: external users.
        :type external_users: str
        :param ldap_groups: ldap groups.
        :type ldap_groups: str
        :param ldap_users: ldap users.
        :type ldap_users: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[UserGroupPropertiesData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name',
            'external_users',
            'ldap_groups',
            'ldap_users'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_user_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'external_users' in local_var_params and local_var_params['external_users'] is not None:  # noqa: E501
            query_params.append(('externalUsers', local_var_params['external_users']))  # noqa: E501
        if 'ldap_groups' in local_var_params and local_var_params['ldap_groups'] is not None:  # noqa: E501
            query_params.append(('ldapGroups', local_var_params['ldap_groups']))  # noqa: E501
        if 'ldap_users' in local_var_params and local_var_params['ldap_users'] is not None:  # noqa: E501
            query_params.append(('ldapUsers', local_var_params['ldap_users']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[UserGroupPropertiesData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mft/usergroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_mft_user_groups_for_site(self, site_name, **kwargs):  # noqa: E501
        """Get all user groups that match the search criteria for site.  # noqa: E501

        Get all user groups that match the search criteria for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_user_groups_for_site(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: The user group name.
        :type name: str
        :param external_users: external users.
        :type external_users: str
        :param ldap_groups: ldap groups.
        :type ldap_groups: str
        :param ldap_users: ldap users.
        :type ldap_users: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[UserGroupPropertiesData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_mft_user_groups_for_site_with_http_info(site_name, **kwargs)  # noqa: E501

    def get_mft_user_groups_for_site_with_http_info(self, site_name, **kwargs):  # noqa: E501
        """Get all user groups that match the search criteria for site.  # noqa: E501

        Get all user groups that match the search criteria for site.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mft_user_groups_for_site_with_http_info(site_name, async_req=True)
        >>> result = thread.get()

        :param site_name: The site name. (required)
        :type site_name: str
        :param name: The user group name.
        :type name: str
        :param external_users: external users.
        :type external_users: str
        :param ldap_groups: ldap groups.
        :type ldap_groups: str
        :param ldap_users: ldap users.
        :type ldap_users: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[UserGroupPropertiesData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_name',
            'name',
            'external_users',
            'ldap_groups',
            'ldap_users'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_user_groups_for_site" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_name' is set
        if self.api_client.client_side_validation and ('site_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_name` when calling `get_mft_user_groups_for_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_name' in local_var_params:
            path_params['siteName'] = local_var_params['site_name']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'external_users' in local_var_params and local_var_params['external_users'] is not None:  # noqa: E501
            query_params.append(('externalUsers', local_var_params['external_users']))  # noqa: E501
        if 'ldap_groups' in local_var_params and local_var_params['ldap_groups'] is not None:  # noqa: E501
            query_params.append(('ldapGroups', local_var_params['ldap_groups']))  # noqa: E501
        if 'ldap_users' in local_var_params and local_var_params['ldap_users'] is not None:  # noqa: E501
            query_params.append(('ldapUsers', local_var_params['ldap_users']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[UserGroupPropertiesData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/mfte/site/{siteName}/usergroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_organization_group_user_simulation(self, user, **kwargs):  # noqa: E501
        """Get organization group user with authorization sumulation  # noqa: E501

        Get organization group user with authorization sumulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organization_group_user_simulation(user, async_req=True)
        >>> result = thread.get()

        :param user: The user name. (required)
        :type user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OrganizationGroupUserAuthorizationSimulationData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_organization_group_user_simulation_with_http_info(user, **kwargs)  # noqa: E501

    def get_organization_group_user_simulation_with_http_info(self, user, **kwargs):  # noqa: E501
        """Get organization group user with authorization sumulation  # noqa: E501

        Get organization group user with authorization sumulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organization_group_user_simulation_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param user: The user name. (required)
        :type user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrganizationGroupUserAuthorizationSimulationData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_group_user_simulation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in local_var_params or  # noqa: E501
                                                        local_var_params['user'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user` when calling `get_organization_group_user_simulation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "OrganizationGroupUserAuthorizationSimulationData",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/organizationgroup/{user}/simulate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_pgp_templates(self, server, agent, **kwargs):  # noqa: E501
        """Get PGP Templates  # noqa: E501

        Get PGP Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pgp_templates(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param name: The PGP Template Name
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[PgpTemplateData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_pgp_templates_with_http_info(server, agent, **kwargs)  # noqa: E501

    def get_pgp_templates_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get PGP Templates  # noqa: E501

        Get PGP Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pgp_templates_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param server: The Server (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param name: The PGP Template Name
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[PgpTemplateData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pgp_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_pgp_templates`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_pgp_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[PgpTemplateData]",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/pgptemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_remote_host_properties(self, server, remotehost, **kwargs):  # noqa: E501
        """get a remote host configuration from Server  # noqa: E501

        Get the remote host configuration properties from the Server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_remote_host_properties(server, remotehost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host  is connected to. (required)
        :type server: str
        :param remotehost: The name of the remote host. (required)
        :type remotehost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddRemoteHostParams
        """
        kwargs['_return_http_data_only'] = True
        return self.get_remote_host_properties_with_http_info(server, remotehost, **kwargs)  # noqa: E501

    def get_remote_host_properties_with_http_info(self, server, remotehost, **kwargs):  # noqa: E501
        """get a remote host configuration from Server  # noqa: E501

        Get the remote host configuration properties from the Server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_remote_host_properties_with_http_info(server, remotehost, async_req=True)
        >>> result = thread.get()

        :param server: The Server the remote host  is connected to. (required)
        :type server: str
        :param remotehost: The name of the remote host. (required)
        :type remotehost: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddRemoteHostParams, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'remotehost'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_remote_host_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_remote_host_properties`")  # noqa: E501
        # verify the required parameter 'remotehost' is set
        if self.api_client.client_side_validation and ('remotehost' not in local_var_params or  # noqa: E501
                                                        local_var_params['remotehost'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `remotehost` when calling `get_remote_host_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'remotehost' in local_var_params:
            path_params['remotehost'] = local_var_params['remotehost']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AddRemoteHostParams",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/remotehost/{remotehost}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_remote_hosts(self, server, **kwargs):  # noqa: E501
        """get Server remote hosts  # noqa: E501

        Get all the remote hosts of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_remote_hosts(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server to query. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_remote_hosts_with_http_info(server, **kwargs)  # noqa: E501

    def get_remote_hosts_with_http_info(self, server, **kwargs):  # noqa: E501
        """get Server remote hosts  # noqa: E501

        Get all the remote hosts of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_remote_hosts_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server to query. (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_remote_hosts" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_remote_hosts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/remotehosts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_role(self, role, **kwargs):  # noqa: E501
        """Get Authorization Role  # noqa: E501

        Get Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_role(role, async_req=True)
        >>> result = thread.get()

        :param role: The Role name. (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RoleData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_role_with_http_info(role, **kwargs)  # noqa: E501

    def get_role_with_http_info(self, role, **kwargs):  # noqa: E501
        """Get Authorization Role  # noqa: E501

        Get Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_role_with_http_info(role, async_req=True)
        >>> result = thread.get()

        :param role: The Role name. (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RoleData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in local_var_params:
            path_params['role'] = local_var_params['role']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "RoleData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/role/{role}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_role_associates(self, role, **kwargs):  # noqa: E501
        """Get all authorization entities associated with role  # noqa: E501

        Get all authorization entities associated with role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_role_associates(role, async_req=True)
        >>> result = thread.get()

        :param role: role name. (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AssociateData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_role_associates_with_http_info(role, **kwargs)  # noqa: E501

    def get_role_associates_with_http_info(self, role, **kwargs):  # noqa: E501
        """Get all authorization entities associated with role  # noqa: E501

        Get all authorization entities associated with role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_role_associates_with_http_info(role, async_req=True)
        >>> result = thread.get()

        :param role: role name. (required)
        :type role: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AssociateData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role_associates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in local_var_params or  # noqa: E501
                                                        local_var_params['role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role` when calling `get_role_associates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in local_var_params:
            path_params['role'] = local_var_params['role']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[AssociateData]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/authorization/role/{role}/associates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_run_as_user(self, server, agent, user, **kwargs):  # noqa: E501
        """Get Run-as user  # noqa: E501

        Get Run-as user details from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_run_as_user(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param user: The user name (required)
        :type user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RunAsUserData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501

    def get_run_as_user_with_http_info(self, server, agent, user, **kwargs):  # noqa: E501
        """Get Run-as user  # noqa: E501

        Get Run-as user details from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_run_as_user_with_http_info(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param agent: The Agent (required)
        :type agent: str
        :param user: The user name (required)
        :type user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RunAsUserData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_as_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_run_as_user`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_run_as_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in local_var_params or  # noqa: E501
                                                        local_var_params['user'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user` when calling `get_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "RunAsUserData",
            400: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/runasuser/{agent}/{user}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_run_as_users_list(self, server, **kwargs):  # noqa: E501
        """Get Run-as user list that match the requested search criteria.  # noqa: E501

        Get Run-as user list that match the requested search criteria from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_run_as_users_list(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param user: The Run-as user.
        :type user: str
        :param agent: The agent.
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[RunAsUserData]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_run_as_users_list_with_http_info(server, **kwargs)  # noqa: E501

    def get_run_as_users_list_with_http_info(self, server, **kwargs):  # noqa: E501
        """Get Run-as user list that match the requested search criteria.  # noqa: E501

        Get Run-as user list that match the requested search criteria from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_run_as_users_list_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: The Server. (required)
        :type server: str
        :param user: The Run-as user.
        :type user: str
        :param agent: The agent.
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[RunAsUserData], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'user',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_as_users_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_run_as_users_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []
        if 'user' in local_var_params and local_var_params['user'] is not None:  # noqa: E501
            query_params.append(('user', local_var_params['user']))  # noqa: E501
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[RunAsUserData]",
            400: "ErrorList",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/runasusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_server_definition(self, server, **kwargs):  # noqa: E501
        """Get Control-M/Server definition.  # noqa: E501

        Get the definition for this specific server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_server_definition(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CtmServerDefinition
        """
        kwargs['_return_http_data_only'] = True
        return self.get_server_definition_with_http_info(server, **kwargs)  # noqa: E501

    def get_server_definition_with_http_info(self, server, **kwargs):  # noqa: E501
        """Get Control-M/Server definition.  # noqa: E501

        Get the definition for this specific server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_server_definition_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param server: (required)
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CtmServerDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_server_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `get_server_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "CtmServerDefinition",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/server/{server}/definition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_server_system_setting(self, **kwargs):  # noqa: E501
        """Get the Control-M server system settings  # noqa: E501

        Get the Control-M server system settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_server_system_setting(async_req=True)
        >>> result = thread.get()

        :param server: Server to obtain the system settings from, not required in Helix
        :type server: str
        :param extended_data: True to return more agent parameters. HIDDEN
        :type extended_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[KeyValue]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_server_system_setting_with_http_info(**kwargs)  # noqa: E501

    def get_server_system_setting_with_http_info(self, **kwargs):  # noqa: E501
        """Get the Control-M server system settings  # noqa: E501

        Get the Control-M server system settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_server_system_setting_with_http_info(async_req=True)
        >>> result = thread.get()

        :param server: Server to obtain the system settings from, not required in Helix
        :type server: str
        :param extended_data: True to return more agent parameters. HIDDEN
        :type extended_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[KeyValue], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'extended_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_server_system_setting" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'extended_data' in local_var_params and local_var_params['extended_data'] is not None:  # noqa: E501
            query_params.append(('extendedData', local_var_params['extended_data']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[KeyValue]",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/config/systemsettings/server', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_servers(self, **kwargs):  # noqa: E501
        """get all the Servers name and hostname in the system  # noqa: E501

        Get the names and hostnames of all Servers in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_servers(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[CtmDetails]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_servers_with_http_info(**kwargs)  # noqa: E501

    def get_servers_with_http_info(self, **kwargs):  # noqa: E501
        """get all the Servers name and hostname in the system  # noqa: E501

        Get the names and hostnames of all Servers in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _conten