# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class AddRemoteHostParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'remotehost': 'str',
        'port': 'int',
        'encrypt_algorithm': 'str',
        'compression': 'bool',
        'authorize': 'bool',
        'agents': 'list[str]',
        'tag': 'str',
        'w_mi_sysout_directory': 'str',
        'connection_type': 'str',
        'convert_existing_agent': 'bool'
    }

    attribute_map = {
        'remotehost': 'remotehost',
        'port': 'port',
        'encrypt_algorithm': 'encryptAlgorithm',
        'compression': 'compression',
        'authorize': 'authorize',
        'agents': 'agents',
        'tag': 'tag',
        'w_mi_sysout_directory': 'wMISysoutDirectory',
        'connection_type': 'connectionType',
        'convert_existing_agent': 'convertExistingAgent'
    }

    def __init__(self, remotehost=None, port=None, encrypt_algorithm=None, compression=None, authorize=False, agents=None, tag=None, w_mi_sysout_directory=None, connection_type=None, convert_existing_agent=None, local_vars_configuration=None):  # noqa: E501
        """AddRemoteHostParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._remotehost = None
        self._port = None
        self._encrypt_algorithm = None
        self._compression = None
        self._authorize = None
        self._agents = None
        self._tag = None
        self._w_mi_sysout_directory = None
        self._connection_type = None
        self._convert_existing_agent = None
        self.discriminator = None

        if remotehost is not None:
            self.remotehost = remotehost
        if port is not None:
            self.port = port
        if encrypt_algorithm is not None:
            self.encrypt_algorithm = encrypt_algorithm
        if compression is not None:
            self.compression = compression
        if authorize is not None:
            self.authorize = authorize
        if agents is not None:
            self.agents = agents
        if tag is not None:
            self.tag = tag
        if w_mi_sysout_directory is not None:
            self.w_mi_sysout_directory = w_mi_sysout_directory
        if connection_type is not None:
            self.connection_type = connection_type
        if convert_existing_agent is not None:
            self.convert_existing_agent = convert_existing_agent

    @property
    def remotehost(self):
        """Gets the remotehost of this AddRemoteHostParams.  # noqa: E501

        The remote host (name) which will execute the commands. REQUIRED.  # noqa: E501

        :return: The remotehost of this AddRemoteHostParams.  # noqa: E501
        :rtype: str
        """
        return self._remotehost

    @remotehost.setter
    def remotehost(self, remotehost):
        """Sets the remotehost of this AddRemoteHostParams.

        The remote host (name) which will execute the commands. REQUIRED.  # noqa: E501

        :param remotehost: The remotehost of this AddRemoteHostParams.  # noqa: E501
        :type remotehost: str
        """

        self._remotehost = remotehost

    @property
    def port(self):
        """Gets the port of this AddRemoteHostParams.  # noqa: E501

        The remote host SSH port.  # noqa: E501

        :return: The port of this AddRemoteHostParams.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this AddRemoteHostParams.

        The remote host SSH port.  # noqa: E501

        :param port: The port of this AddRemoteHostParams.  # noqa: E501
        :type port: int
        """

        self._port = port

    @property
    def encrypt_algorithm(self):
        """Gets the encrypt_algorithm of this AddRemoteHostParams.  # noqa: E501

        The SSH encrypt algorithm to be used. HIDDEN.  # noqa: E501

        :return: The encrypt_algorithm of this AddRemoteHostParams.  # noqa: E501
        :rtype: str
        """
        return self._encrypt_algorithm

    @encrypt_algorithm.setter
    def encrypt_algorithm(self, encrypt_algorithm):
        """Sets the encrypt_algorithm of this AddRemoteHostParams.

        The SSH encrypt algorithm to be used. HIDDEN.  # noqa: E501

        :param encrypt_algorithm: The encrypt_algorithm of this AddRemoteHostParams.  # noqa: E501
        :type encrypt_algorithm: str
        """

        self._encrypt_algorithm = encrypt_algorithm

    @property
    def compression(self):
        """Gets the compression of this AddRemoteHostParams.  # noqa: E501

        Is compression used. HIDDEN.  # noqa: E501

        :return: The compression of this AddRemoteHostParams.  # noqa: E501
        :rtype: bool
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        """Sets the compression of this AddRemoteHostParams.

        Is compression used. HIDDEN.  # noqa: E501

        :param compression: The compression of this AddRemoteHostParams.  # noqa: E501
        :type compression: bool
        """

        self._compression = compression

    @property
    def authorize(self):
        """Gets the authorize of this AddRemoteHostParams.  # noqa: E501

        authorize SSL remote host while creating the remote host. HIDDEN.  # noqa: E501

        :return: The authorize of this AddRemoteHostParams.  # noqa: E501
        :rtype: bool
        """
        return self._authorize

    @authorize.setter
    def authorize(self, authorize):
        """Sets the authorize of this AddRemoteHostParams.

        authorize SSL remote host while creating the remote host. HIDDEN.  # noqa: E501

        :param authorize: The authorize of this AddRemoteHostParams.  # noqa: E501
        :type authorize: bool
        """

        self._authorize = authorize

    @property
    def agents(self):
        """Gets the agents of this AddRemoteHostParams.  # noqa: E501

        Agents to execute the commands on. HIDDEN.  # noqa: E501

        :return: The agents of this AddRemoteHostParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._agents

    @agents.setter
    def agents(self, agents):
        """Sets the agents of this AddRemoteHostParams.

        Agents to execute the commands on. HIDDEN.  # noqa: E501

        :param agents: The agents of this AddRemoteHostParams.  # noqa: E501
        :type agents: list[str]
        """

        self._agents = agents

    @property
    def tag(self):
        """Gets the tag of this AddRemoteHostParams.  # noqa: E501

        tag of the remote host.  # noqa: E501

        :return: The tag of this AddRemoteHostParams.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this AddRemoteHostParams.

        tag of the remote host.  # noqa: E501

        :param tag: The tag of this AddRemoteHostParams.  # noqa: E501
        :type tag: str
        """

        self._tag = tag

    @property
    def w_mi_sysout_directory(self):
        """Gets the w_mi_sysout_directory of this AddRemoteHostParams.  # noqa: E501

        the WMI Sysout Directory.  # noqa: E501

        :return: The w_mi_sysout_directory of this AddRemoteHostParams.  # noqa: E501
        :rtype: str
        """
        return self._w_mi_sysout_directory

    @w_mi_sysout_directory.setter
    def w_mi_sysout_directory(self, w_mi_sysout_directory):
        """Sets the w_mi_sysout_directory of this AddRemoteHostParams.

        the WMI Sysout Directory.  # noqa: E501

        :param w_mi_sysout_directory: The w_mi_sysout_directory of this AddRemoteHostParams.  # noqa: E501
        :type w_mi_sysout_directory: str
        """

        self._w_mi_sysout_directory = w_mi_sysout_directory

    @property
    def connection_type(self):
        """Gets the connection_type of this AddRemoteHostParams.  # noqa: E501

        the connection type.  # noqa: E501

        :return: The connection_type of this AddRemoteHostParams.  # noqa: E501
        :rtype: str
        """
        return self._connection_type

    @connection_type.setter
    def connection_type(self, connection_type):
        """Sets the connection_type of this AddRemoteHostParams.

        the connection type.  # noqa: E501

        :param connection_type: The connection_type of this AddRemoteHostParams.  # noqa: E501
        :type connection_type: str
        """

        self._connection_type = connection_type

    @property
    def convert_existing_agent(self):
        """Gets the convert_existing_agent of this AddRemoteHostParams.  # noqa: E501

        convert existing agent to Agentless host. HIDDEN.  # noqa: E501

        :return: The convert_existing_agent of this AddRemoteHostParams.  # noqa: E501
        :rtype: bool
        """
        return self._convert_existing_agent

    @convert_existing_agent.setter
    def convert_existing_agent(self, convert_existing_agent):
        """Sets the convert_existing_agent of this AddRemoteHostParams.

        convert existing agent to Agentless host. HIDDEN.  # noqa: E501

        :param convert_existing_agent: The convert_existing_agent of this AddRemoteHostParams.  # noqa: E501
        :type convert_existing_agent: bool
        """

        self._convert_existing_agent = convert_existing_agent

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddRemoteHostParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddRemoteHostParams):
            return True

        return self.to_dict() != other.to_dict()
