# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class EmComponentDesiredState(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'host': 'str',
        'type': 'str',
        'name': 'str',
        'desired_state': 'str',
        'extension': 'str'
    }

    attribute_map = {
        'host': 'host',
        'type': 'type',
        'name': 'name',
        'desired_state': 'desiredState',
        'extension': 'extension'
    }

    def __init__(self, host=None, type=None, name=None, desired_state=None, extension=None, local_vars_configuration=None):  # noqa: E501
        """EmComponentDesiredState - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._host = None
        self._type = None
        self._name = None
        self._desired_state = None
        self._extension = None
        self.discriminator = None

        self.host = host
        self.type = type
        self.name = name
        self.desired_state = desired_state
        if extension is not None:
            self.extension = extension

    @property
    def host(self):
        """Gets the host of this EmComponentDesiredState.  # noqa: E501

        The hostname of the server where the EM component is running.  # noqa: E501

        :return: The host of this EmComponentDesiredState.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this EmComponentDesiredState.

        The hostname of the server where the EM component is running.  # noqa: E501

        :param host: The host of this EmComponentDesiredState.  # noqa: E501
        :type host: str
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def type(self):
        """Gets the type of this EmComponentDesiredState.  # noqa: E501

        The type of the EM component (e.g., Gateway, GUI_Server, ARCHIVE).  # noqa: E501

        :return: The type of this EmComponentDesiredState.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this EmComponentDesiredState.

        The type of the EM component (e.g., Gateway, GUI_Server, ARCHIVE).  # noqa: E501

        :param type: The type of this EmComponentDesiredState.  # noqa: E501
        :type type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def name(self):
        """Gets the name of this EmComponentDesiredState.  # noqa: E501

        The logical name of the EM component.  # noqa: E501

        :return: The name of this EmComponentDesiredState.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EmComponentDesiredState.

        The logical name of the EM component.  # noqa: E501

        :param name: The name of this EmComponentDesiredState.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def desired_state(self):
        """Gets the desired_state of this EmComponentDesiredState.  # noqa: E501

        The desired operational state of the EM component (Up, Down, Ignored, Recycle).  # noqa: E501

        :return: The desired_state of this EmComponentDesiredState.  # noqa: E501
        :rtype: str
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this EmComponentDesiredState.

        The desired operational state of the EM component (Up, Down, Ignored, Recycle).  # noqa: E501

        :param desired_state: The desired_state of this EmComponentDesiredState.  # noqa: E501
        :type desired_state: str
        """
        if self.local_vars_configuration.client_side_validation and desired_state is None:  # noqa: E501
            raise ValueError("Invalid value for `desired_state`, must not be `None`")  # noqa: E501

        self._desired_state = desired_state

    @property
    def extension(self):
        """Gets the extension of this EmComponentDesiredState.  # noqa: E501

        The service extension type  # noqa: E501

        :return: The extension of this EmComponentDesiredState.  # noqa: E501
        :rtype: str
        """
        return self._extension

    @extension.setter
    def extension(self, extension):
        """Sets the extension of this EmComponentDesiredState.

        The service extension type  # noqa: E501

        :param extension: The extension of this EmComponentDesiredState.  # noqa: E501
        :type extension: str
        """

        self._extension = extension

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EmComponentDesiredState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EmComponentDesiredState):
            return True

        return self.to_dict() != other.to_dict()
