# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class UpdateGatewayParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'host': 'str',
        'desired_state': 'str',
        'check_interval': 'int',
        'additional_parameters': 'str'
    }

    attribute_map = {
        'name': 'name',
        'host': 'host',
        'desired_state': 'desiredState',
        'check_interval': 'checkInterval',
        'additional_parameters': 'additionalParameters'
    }

    def __init__(self, name=None, host=None, desired_state=None, check_interval=None, additional_parameters=None, local_vars_configuration=None):  # noqa: E501
        """UpdateGatewayParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._host = None
        self._desired_state = None
        self._check_interval = None
        self._additional_parameters = None
        self.discriminator = None

        self.name = name
        self.host = host
        if desired_state is not None:
            self.desired_state = desired_state
        if check_interval is not None:
            self.check_interval = check_interval
        if additional_parameters is not None:
            self.additional_parameters = additional_parameters

    @property
    def name(self):
        """Gets the name of this UpdateGatewayParams.  # noqa: E501

        The CTM Server name.  # noqa: E501

        :return: The name of this UpdateGatewayParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UpdateGatewayParams.

        The CTM Server name.  # noqa: E501

        :param name: The name of this UpdateGatewayParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def host(self):
        """Gets the host of this UpdateGatewayParams.  # noqa: E501

        The Gateway is hosted on.  # noqa: E501

        :return: The host of this UpdateGatewayParams.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this UpdateGatewayParams.

        The Gateway is hosted on.  # noqa: E501

        :param host: The host of this UpdateGatewayParams.  # noqa: E501
        :type host: str
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def desired_state(self):
        """Gets the desired_state of this UpdateGatewayParams.  # noqa: E501

        The desired state for the created gateway (\"Up\" | \"Down\" | \"Ignored\").  # noqa: E501

        :return: The desired_state of this UpdateGatewayParams.  # noqa: E501
        :rtype: str
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this UpdateGatewayParams.

        The desired state for the created gateway (\"Up\" | \"Down\" | \"Ignored\").  # noqa: E501

        :param desired_state: The desired_state of this UpdateGatewayParams.  # noqa: E501
        :type desired_state: str
        """

        self._desired_state = desired_state

    @property
    def check_interval(self):
        """Gets the check_interval of this UpdateGatewayParams.  # noqa: E501

        Gateway check interval time, optional. defaults to 20  # noqa: E501

        :return: The check_interval of this UpdateGatewayParams.  # noqa: E501
        :rtype: int
        """
        return self._check_interval

    @check_interval.setter
    def check_interval(self, check_interval):
        """Sets the check_interval of this UpdateGatewayParams.

        Gateway check interval time, optional. defaults to 20  # noqa: E501

        :param check_interval: The check_interval of this UpdateGatewayParams.  # noqa: E501
        :type check_interval: int
        """

        self._check_interval = check_interval

    @property
    def additional_parameters(self):
        """Gets the additional_parameters of this UpdateGatewayParams.  # noqa: E501

        Optional, additional parameters to send to Gateway.  # noqa: E501

        :return: The additional_parameters of this UpdateGatewayParams.  # noqa: E501
        :rtype: str
        """
        return self._additional_parameters

    @additional_parameters.setter
    def additional_parameters(self, additional_parameters):
        """Sets the additional_parameters of this UpdateGatewayParams.

        Optional, additional parameters to send to Gateway.  # noqa: E501

        :param additional_parameters: The additional_parameters of this UpdateGatewayParams.  # noqa: E501
        :type additional_parameters: str
        """

        self._additional_parameters = additional_parameters

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateGatewayParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdateGatewayParams):
            return True

        return self.to_dict() != other.to_dict()
