"""
    Purpose:
        File for holding custom exception types that will be generated by the
        minio_helpers libraries
"""


###
# Bucket Exceptions
###


class BucketAlreadyExists(Exception):
    """
    Purpose:
        The BucketAlreadyExists will be raised when attempting to create a bucket
        that already exists
    """

    pass


class BucketDoesntExist(Exception):
    """
    Purpose:
        The BucketDoesntExist will be raised when attempting to delete a bucket
        that doesn't exist in Minio
    """

    pass


###
# Object Exceptions
###


class ObjectAlreadyExists(Exception):
    """
    Purpose:
        The ObjectAlreadyExists will be raised when attempting to create an object
        that already exists
    """

    pass


class ObjectDoesntExist(Exception):
    """
    Purpose:
        The ObjectDoesntExist will be raised when attempting to pull an object
        that doesn't exist in Minio
    """

    pass


class ObjectDecodingNotSupported(Exception):
    """
    Purpose:
        The ObjectDecodingNotSupported will be raised when attempting to decode a
        filetype from Minio that is not yet supported (such as .avro)
    """

    pass

