# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['session', 'set_headers', 'get_session', 'set_global_var', 'get_global_var', 'prc_request_cf_data',
           'prc_clean_cf_data', 'prc_get_cf_fields', 'get_cf_info', 'get_cf_options', 'cf_option_name', 'prc_cf_dicts']

# %% ../nbs/00_core.ipynb 5
import requests, json, os

def set_headers(AccessToken:str, #Access Token (API Key) provided by Copper
                 UserEmail:str): #Email associated with your API key
    '''
    Sets global variable to hold header information for Copper API requests.
    This must be set before any requests are made. See documentation for more info.

    Parameters:
    AccessToken: type=str
        This is your Access Token provided by Copper. These can be found and created 
        under Settings > Intergrations > API Keys. 

    UserEmail: type=str
        This is your the email associated with your Copper account.
        
    '''
    global copper_headers
    assert isinstance(AccessToken, str), 'AccessToken must be a string. \nSee help(set_headers) for more info.'
    assert isinstance(UserEmail, str), 'UserEmail must be a string. \nSee help(set_headers) for more info.'

    copper_headers = {
    'X-PW-AccessToken':AccessToken,
    'X-PW-Application':'developer_api',
    'X-PW-UserEmail': UserEmail,
    'Content-Type':'application/json'
    }

# %% ../nbs/00_core.ipynb 6
session = None

def get_session(header_data:dict):
    '''
    Function to get current session or create one if one doesn't exist.

    Parameters:
    header_data: type=dict
    '''
    assert isinstance(header_data, dict), 'header information must be passed in or set with set_headers(). \nSee help(set_headers) for more info.'
    
    global session

    if not session or not isinstance(session, requests.Session):
        # No session exists or the global variable is not of type requests.Session, create a new session
        session = requests.Session()
        session.headers.update(header_data)
    
    return session

# %% ../nbs/00_core.ipynb 11
def set_global_var(value, var_name:str):
    """Function to add a global variable to the Module"""
    globals()[var_name] = value

def get_global_var(var_name:str):
    """
    Retrieves a global variable by its name.

    Parameters:
    var_name (str): The name of the global variable to retrieve.

    Returns:
    The value of the global variable, or None if not found.
    """
    return globals().get(var_name, None)

# %% ../nbs/00_core.ipynb 14
def prc_request_cf_data():
    """
    Helpter function to request the custom field data.
    """
    # Fetching custom fields:
    global copper_headers
    Sess = get_session(copper_headers)

    try:
        cf_request = Sess.get('https://api.copper.com/developer_api/v1/custom_field_definitions')
        cf_request.raise_for_status()
    except requests.exceptions.HTTPError as err:
        raise Exception(f"Failed to fetch custom field data: {err}") from err
    else:
        custom_fields_data = cf_request.json()
        return custom_fields_data

def prc_clean_cf_data(data:json):
    """
    Function to process the custom field data.
    """

    custom_field_dict = {}

    for item in data:
        item_dict = {}

        item_dict['name'] = item.get('name')
        item_dict['data_type'] = item.get('data_type')
        item_dict['available_on'] = item.get('available_on')
        item_dict['is_filterable'] = item.get('is_filterable')
        

        if 'options' in item:
            item_options = {}
            for sub_item in item['options']:
                sub_item_name = sub_item['name']
                sub_item_id = sub_item['id']

                item_options[sub_item_id] = sub_item_name
        
            item_dict['options'] = item_options
        
        item_id = item['id']
        custom_field_dict[item_id] = item_dict

    return custom_field_dict

# %% ../nbs/00_core.ipynb 16
def prc_get_cf_fields():
    """
    Checks if custom_fields has been set and creates it if it hasn't been set.
    """

    if "custom_fields" not in globals():
        global custom_fields
        cf_data = prc_request_cf_data()
        custom_fields = prc_clean_cf_data(cf_data)
        set_global_var(custom_fields, 'custom_fields')

# %% ../nbs/00_core.ipynb 18
def get_cf_info(cf_id:str,     # ID of custom field
                cf_info:list,  # Designed information about field, list if multiple items
)->list: #Returns list if cf_info is list. Otherwise, returns value
    """
    Function to get the custom field information based on the field id.
    Can be supplied with a sigular value for 'cf_info' or multiple as a list.
    """

    prc_get_cf_fields()
    global custom_fields

    if isinstance(cf_id,str):  cf_id = int(cf_id)      

    # Check if cf_info item(s) are valid
    if isinstance(cf_info, list):
        for item_name in cf_info:
            # Remove faulty items:
            if item_name not in ['name','data_type','available_on','is_filterable','options']: cf_info.pop(item_name)
            
            # Cancel function if no valid items
            if len(cf_info) == 0: return None
    elif cf_info not in ['name','data_type','available_on','is_filterable','options']:
        print(f'Invalid cf_info: {cf_info}'); return None

    if isinstance(cf_info,list):
        return_list = []
        for item_name in cf_info:
            value = custom_fields[cf_id].get(item_name)
            return_list.append(value)
        return return_list
    else:
        value = custom_fields[cf_id].get(cf_info)
        return value

def get_cf_options(cf_id:str, #Coppper ID for custom field
)->dict: # Returns dictionary of options for field
    return custom_fields.get(cf_id).get('options')

def cf_option_name(cf_id:str, #Coppper ID for custom field
option_id:str, #Coppper ID for option
)->str: #Returns name/value of option
    return get_cf_options(cf_id).get(option_id)

def prc_cf_dicts():
    """Helper function to get dictionaries and lists of custom fields"""
    prc_get_cf_fields()
    global custom_fields_dict, reverse_cf_lookup, custom_fields_list

    custom_fields_dict = {}
    reverse_cf_lookup = {}

    for item in custom_fields.keys():
        item_name = custom_fields[item].get('name')
        custom_fields_dict[item] = item_name
        reverse_cf_lookup[item_name] = item

    custom_fields_list = list(custom_fields_dict.values())
