__all__ = [
    '__version__',
    'ApiKey',
    'Account',
    'Arpc',
    'BalanceEntry',
    'BillPayment',
    'Card',
    'CardActivation',
    'CardTransaction',
    'CardValidation',
    'CashReference',
    'Clabe',
    'CurpValidation',
    'Commission',
    'Deposit',
    'Endpoint',
    'File',
    'FileBatch',
    'Identity',
    'IdentityEvent',
    'KYCValidation',
    'LimitedWallet',
    'LoginToken',
    'Otp',
    'Platform',
    'Questionnaires',
    'Saving',
    'ServiceProvider',
    'Session',
    'Statement',
    'Transfer',
    'User',
    'UserCredential',
    'UserEvent',
    'UserListsValidation',
    'UserLogin',
    'Verification',
    'WalletTransaction',
    'Webhook',
    'WhatsappTransfer',
    'configure',
    'get_balance',
    'JwtToken',
    'TermsOfService',
    'UserTOSAgreement',
]

from . import http
from .resources import (
    Account,
    ApiKey,
    Arpc,
    BalanceEntry,
    BillPayment,
    Card,
    CardActivation,
    CardTransaction,
    CardValidation,
    CashReference,
    Clabe,
    Commission,
    CurpValidation,
    Deposit,
    Endpoint,
    File,
    FileBatch,
    Identity,
    IdentityEvent,
    JwtToken,
    KYCValidation,
    LimitedWallet,
    LoginToken,
    Otp,
    Platform,
    Questionnaires,
    Saving,
    ServiceProvider,
    Session,
    Statement,
    TermsOfService,
    Transfer,
    User,
    UserCredential,
    UserEvent,
    UserListsValidation,
    UserLogin,
    UserTOSAgreement,
    Verification,
    WalletTransaction,
    Webhook,
    WhatsappTransfer,
)
from .version import __version__

configure = http.session.configure
session = http.session


def get_balance(session: http.Session = session) -> int:
    balance_entry = BalanceEntry.first(session=session)
    return balance_entry.rolling_balance if balance_entry else 0
