# cvg-python-sdk
With the Recording API, client applications can manage recordings that have previously been created using the
Call or Assist APIs.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cvg_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cvg_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import cvg_sdk
from pprint import pprint
from cvg_sdk.api import recording_api
from cvg_sdk.model.dialog_phase import DialogPhase
from cvg_sdk.model.recording_objects_response import RecordingObjectsResponse
# Defining the host is optional and defaults to https://cognitivevoice.io/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = cvg_sdk.Configuration(
    host = "https://cognitivevoice.io/v1"
)



# Enter a context with an instance of the API client
with cvg_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = recording_api.RecordingApi(api_client)
    reseller_token = "eb1c739c-06e0-4f4c-8056-8665e31425e1" # str | 
    dialog_id = "09e59647-5c77-4c02-a1c5-7fb2b47060f1" # str | 
    phase = DialogPhase("BOT") # DialogPhase | Omitting the phase will select the bot dialog (optional)
    id = RecordingId("id_example") # RecordingId | Omitting the recording ID will select the default recording of the selected phase. (optional)

    try:
        # Delete recording
        api_instance.delete_recording(reseller_token, dialog_id, phase=phase, id=id)
    except cvg_sdk.ApiException as e:
        print("Exception when calling RecordingApi->delete_recording: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://cognitivevoice.io/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*RecordingApi* | [**delete_recording**](docs/RecordingApi.md#delete_recording) | **DELETE** /recording/{resellerToken}/{dialogId} | Delete recording
*RecordingApi* | [**get_recording_artifacts**](docs/RecordingApi.md#get_recording_artifacts) | **GET** /recording/{resellerToken}/{dialogId} | Get download URLs for recording


## Documentation For Models

 - [Audio](docs/Audio.md)
 - [AudioAllOf](docs/AudioAllOf.md)
 - [Confidence](docs/Confidence.md)
 - [DialogPhase](docs/DialogPhase.md)
 - [Dtmf](docs/Dtmf.md)
 - [DtmfAllOf](docs/DtmfAllOf.md)
 - [RecordingId](docs/RecordingId.md)
 - [RecordingObjectsResponse](docs/RecordingObjectsResponse.md)
 - [Speaker](docs/Speaker.md)
 - [Text](docs/Text.md)
 - [TextAllOf](docs/TextAllOf.md)
 - [Transcript](docs/Transcript.md)
 - [TranscriptEntry](docs/TranscriptEntry.md)
 - [TranscriptV1](docs/TranscriptV1.md)
 - [TranscriptV1AllOf](docs/TranscriptV1AllOf.md)
 - [Voice](docs/Voice.md)
 - [VoiceAllOf](docs/VoiceAllOf.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

support@vier.ai


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in cvg_sdk.apis and cvg_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from cvg_sdk.api.default_api import DefaultApi`
- `from cvg_sdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import cvg_sdk
from cvg_sdk.apis import *
from cvg_sdk.models import *
```

