"""
    VIER Cognitive Voice Call API

    With the VIER Cognitive Voice Call API you can easily do things like building your voicebots, which can be reached via phone calls. You can receive speech input of the customer as transcripted text in many languages. Let different voices say your text in this call. After the voicebot dialog you may drop the call (call fully completed by bot) or transfer the call e.g. to the relevant service hotline (human agent required to satisfy customer).  On some events, such as receiving an incoming phone call or transcription of a customer's utterance, VIER makes an HTTP request to a URL to be provided by you. This is called a webhook. To handle a webhook, you need to build a small web application that can accept the HTTP requests. The required webhooks are listed as bot endpoints.  The operations defined in this specification can be used by your bot to trigger certain voice and/or telephony related actions on the currently active call.  Most of the available operations are subject to queuing, meaning that the commands, even when triggered simultaneously, will not be executed simultaneously. Instead, these operations will be executed after each other. This is being done to simplify bot development as otherwise the bot would need to hit exact timings for the operations it triggers to not produce overlapping audio in the phone and still be quick enough to feel responsive to the conversation partner.  The queuing mechanism allows the bot to simply trigger several operations after each other and CVG makes sure to to execute them without overlap after each other. Some operations also support a `bargeIn` flag, which makes the operation interruptible by the conversation partner.  All operations that are not subject to queuing will document this fact in their respective description.  # noqa: E501

    The version of the OpenAPI document: 1.24.4
    Contact: support@vier.ai
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cvg_sdk.api_client import ApiClient, Endpoint as _Endpoint
from cvg_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cvg_sdk.model.bridge_parameters import BridgeParameters
from cvg_sdk.model.data_parameters import DataParameters
from cvg_sdk.model.dial_parameters import DialParameters
from cvg_sdk.model.drop_parameters import DropParameters
from cvg_sdk.model.forward_parameters import ForwardParameters
from cvg_sdk.model.inactivity_start_parameters import InactivityStartParameters
from cvg_sdk.model.inactivity_stop_parameters import InactivityStopParameters
from cvg_sdk.model.outbound_call_result import OutboundCallResult
from cvg_sdk.model.play_parameters import PlayParameters
from cvg_sdk.model.prompt_parameters import PromptParameters
from cvg_sdk.model.recording_start_parameters import RecordingStartParameters
from cvg_sdk.model.recording_stop_parameters import RecordingStopParameters
from cvg_sdk.model.say_parameters import SayParameters
from cvg_sdk.model.transcription_switch_parameters import TranscriptionSwitchParameters


class CallApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.bridge_endpoint = _Endpoint(
            settings={
                'response_type': (OutboundCallResult,),
                'auth': [],
                'endpoint_path': '/call/bridge',
                'operation_id': 'bridge',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bridge_parameters',
                ],
                'required': [
                    'bridge_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bridge_parameters':
                        (BridgeParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bridge_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.data_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/data',
                'operation_id': 'data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'data_parameters',
                ],
                'required': [
                    'data_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'data_parameters':
                        (DataParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'data_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.dial_endpoint = _Endpoint(
            settings={
                'response_type': (OutboundCallResult,),
                'auth': [],
                'endpoint_path': '/call/dial',
                'operation_id': 'dial',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dial_parameters',
                ],
                'required': [
                    'dial_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dial_parameters':
                        (DialParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'dial_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.drop_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/drop',
                'operation_id': 'drop',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'drop_parameters',
                ],
                'required': [
                    'drop_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'drop_parameters':
                        (DropParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'drop_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.forward_endpoint = _Endpoint(
            settings={
                'response_type': (OutboundCallResult,),
                'auth': [],
                'endpoint_path': '/call/forward',
                'operation_id': 'forward',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'forward_parameters',
                ],
                'required': [
                    'forward_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'forward_parameters':
                        (ForwardParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'forward_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.play_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/play',
                'operation_id': 'play',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'play_parameters',
                ],
                'required': [
                    'play_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'play_parameters':
                        (PlayParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'play_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.prompt_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/prompt',
                'operation_id': 'prompt',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'prompt_parameters',
                ],
                'required': [
                    'prompt_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'prompt_parameters':
                        (PromptParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'prompt_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.say_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/say',
                'operation_id': 'say',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'say_parameters',
                ],
                'required': [
                    'say_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'say_parameters':
                        (SayParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'say_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.start_inactivity_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/inactivity/start',
                'operation_id': 'start_inactivity',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'inactivity_start_parameters',
                ],
                'required': [
                    'inactivity_start_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'inactivity_start_parameters':
                        (InactivityStartParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'inactivity_start_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.start_recording_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/recording/start',
                'operation_id': 'start_recording',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'recording_start_parameters',
                ],
                'required': [
                    'recording_start_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'recording_start_parameters':
                        (RecordingStartParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'recording_start_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.stop_inactivity_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/inactivity/stop',
                'operation_id': 'stop_inactivity',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'inactivity_stop_parameters',
                ],
                'required': [
                    'inactivity_stop_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'inactivity_stop_parameters':
                        (InactivityStopParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'inactivity_stop_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.stop_recording_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/recording/stop',
                'operation_id': 'stop_recording',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'recording_stop_parameters',
                ],
                'required': [
                    'recording_stop_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'recording_stop_parameters':
                        (RecordingStopParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'recording_stop_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.switch_transcription_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/call/transcription/switch',
                'operation_id': 'switch_transcription',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transcription_switch_parameters',
                ],
                'required': [
                    'transcription_switch_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transcription_switch_parameters':
                        (TranscriptionSwitchParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transcription_switch_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def bridge(
        self,
        bridge_parameters,
        **kwargs
    ):
        """Bridge the call to a different destination for agent assistance  # noqa: E501

        Bridge the call to a different destination for the agent assistance use case.  This request is blocking, i.e. the response will be held until the call has either been accepted or rejected. Make sure HTTP client read timeouts are configured accordingly for requests to this endpoint.  The called number is constructed by appending a random n-digit number to `headNumber` (where n is `extensionLength`). The number is then reserved until the Assist API's `/assist/accept` endpoint is called, which frees the number again. If this doesn't happen within 130 seconds, the allocation times out.  After a successful bridge, the bot is now out of the loop and will neither receive further messages nor can send any commands. If the call is being recorded, the recording will also be stopped automatically.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.bridge(bridge_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            bridge_parameters (BridgeParameters): Parameters for the bridge operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OutboundCallResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['bridge_parameters'] = \
            bridge_parameters
        return self.bridge_endpoint.call_with_http_info(**kwargs)

    def data(
        self,
        data_parameters,
        **kwargs
    ):
        """Deprecated, use the `/dialog/{resellerToken}/{dialogId}/data` endpoint instead.  # noqa: E501

        Deprecated, use the `/dialog/{resellerToken}/{dialogId}/data` endpoint instead. This operation is not subject to queuing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.data(data_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            data_parameters (DataParameters): Parameters for the data operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['data_parameters'] = \
            data_parameters
        return self.data_endpoint.call_with_http_info(**kwargs)

    def dial(
        self,
        dial_parameters,
        **kwargs
    ):
        """Begin a call to an external number  # noqa: E501

        Begin a call to an external number.  This request is blocking, i.e. the response will be held until the call has either been accepted or rejected. Make sure HTTP client read timeouts are configured accordingly for requests to this endpoint.  Due to limitations imposed by the telephony infrastructure, the amount of concurrent outbound calls is rate limited. Since the exact amount of possible concurrent calls depends on many technical and organizational details, the platform does not provide any details on how many calls per unit time can be done, it just informs the client application if a rate limitation was hit. The application driving outbound calls is expected to handle this scenario by applying common retry techniques like e.g. binary exponential backoff.  This operation is not subject to queuing since it happens before a call has been established.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.dial(dial_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            dial_parameters (DialParameters): Parameters for the dial operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OutboundCallResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['dial_parameters'] = \
            dial_parameters
        return self.dial_endpoint.call_with_http_info(**kwargs)

    def drop(
        self,
        drop_parameters,
        **kwargs
    ):
        """Drop the call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.drop(drop_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            drop_parameters (DropParameters): Parameters for the drop operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['drop_parameters'] = \
            drop_parameters
        return self.drop_endpoint.call_with_http_info(**kwargs)

    def forward(
        self,
        forward_parameters,
        **kwargs
    ):
        """Forward the call to a different destination  # noqa: E501

        Forward the call to a different destination.  This request is blocking, i.e. the response will be held until the call has either been accepted or rejected. Make sure HTTP client read timeouts are configured accordingly for requests to this endpoint.  After a successful forward, the bot is now out of the loop and will neither receive further messages nor can send any commands. If the call is being recorded, the recording will also be stopped automatically.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.forward(forward_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            forward_parameters (ForwardParameters): Parameters for the forward operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OutboundCallResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['forward_parameters'] = \
            forward_parameters
        return self.forward_endpoint.call_with_http_info(**kwargs)

    def play(
        self,
        play_parameters,
        **kwargs
    ):
        """Play something to the call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.play(play_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            play_parameters (PlayParameters): Parameters for the play operation.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['play_parameters'] = \
            play_parameters
        return self.play_endpoint.call_with_http_info(**kwargs)

    def prompt(
        self,
        prompt_parameters,
        **kwargs
    ):
        """Say something to the call with a prompt  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.prompt(prompt_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            prompt_parameters (PromptParameters): Prompts are a convenient way to ask for different types of user input. While a prompt is active, the dialog behaves slightly differently than usual:  - No `type = DTMF` events are sent to the Bot API's `/message` endpoint.   `type = SPEECH` events still make it to the bot as long as they don't match one of the `MultipleChoice`   prompt choices. Since `Number` prompts don't accept voice input, they don't block any speech events. - No `/inactivity` events are sent to the bot, since the prompt's own timeout takes precedence over the   inactivity timeout configured in the project settings.  There's three ways a prompt can end:  - A Bot API `/answer` event with type `Timeout` if the prompt timeout has expired. - A Bot API `/answer` event with type `MultipleChoice` or `Number` if one of the stop conditions is met. - `/call/prompt` is called again, which effectively cancels the previously active prompt.   This also discards any input that was already aggregated.  The prompt timeout restarts on user input (transcription results or DTMF).

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['prompt_parameters'] = \
            prompt_parameters
        return self.prompt_endpoint.call_with_http_info(**kwargs)

    def say(
        self,
        say_parameters,
        **kwargs
    ):
        """Say something to the call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.say(say_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            say_parameters (SayParameters): Parameters for the say operation. Use SSML tags to customize and control aspects of speech such as pronunciation, volume, and speech rate. When using SSML enclose the entire text in a `<speak>` tag.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['say_parameters'] = \
            say_parameters
        return self.say_endpoint.call_with_http_info(**kwargs)

    def start_inactivity(
        self,
        inactivity_start_parameters,
        **kwargs
    ):
        """Start inactivity detection  # noqa: E501

        Start inactivity detection with a specified timeout.  The automatic inactivity timeout in the project settings must be disabled for this endpoint to be available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_inactivity(inactivity_start_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            inactivity_start_parameters (InactivityStartParameters): Parameters for the inactivity start operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['inactivity_start_parameters'] = \
            inactivity_start_parameters
        return self.start_inactivity_endpoint.call_with_http_info(**kwargs)

    def start_recording(
        self,
        recording_start_parameters,
        **kwargs
    ):
        """Start or resume recording of the call  # noqa: E501

        Starts or resumes recording of the call.  IMPORTANT: it is the responsibility of the API user to ensure that recording the participants of the call is legal according to the privacy laws and regulations that apply in the respective country.  Recordings can only be made if this has been explicitly allowed in each layer of the hierarchy (reseller, customer, account, project). They are stored for the duration specified in the project settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_recording(recording_start_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            recording_start_parameters (RecordingStartParameters): Parameters for the recording start operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['recording_start_parameters'] = \
            recording_start_parameters
        return self.start_recording_endpoint.call_with_http_info(**kwargs)

    def stop_inactivity(
        self,
        inactivity_stop_parameters,
        **kwargs
    ):
        """Stop inactivity detection  # noqa: E501

        Stop inactivity detection.  The automatic inactivity timeout in the project settings must be disabled for this endpoint to be available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_inactivity(inactivity_stop_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            inactivity_stop_parameters (InactivityStopParameters): Parameters for the inactivity stop operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['inactivity_stop_parameters'] = \
            inactivity_stop_parameters
        return self.stop_inactivity_endpoint.call_with_http_info(**kwargs)

    def stop_recording(
        self,
        recording_stop_parameters,
        **kwargs
    ):
        """Pause or terminate recording of the call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_recording(recording_stop_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            recording_stop_parameters (RecordingStopParameters): Parameters for the recording stop operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['recording_stop_parameters'] = \
            recording_stop_parameters
        return self.stop_recording_endpoint.call_with_http_info(**kwargs)

    def switch_transcription(
        self,
        transcription_switch_parameters,
        **kwargs
    ):
        """Switch transcription vendor/profile and/or language  # noqa: E501

        Switch transcription to a different vendor/profile and/or language.  The `transcribers` and `language` parameters are optional and fall back to the project settings. As a result, you can omit both of them to reset transcription back to the project settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.switch_transcription(transcription_switch_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            transcription_switch_parameters (TranscriptionSwitchParameters): Parameters for the transcription switch operation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transcription_switch_parameters'] = \
            transcription_switch_parameters
        return self.switch_transcription_endpoint.call_with_http_info(**kwargs)

