# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'acquirer_reference_fraud_rate_threshold_exceeded': 'bool',
        'issuer_reference_fraud_rate_threshold_exceeded': 'bool',
        'issuer_reference_fraud_rate_exceeded': 'bool',
        'total_amount_value_exceeded': 'bool',
        'eea_domestic_ind': 'bool',
        'acquirer_reference_fraud_rate_exceeded': 'bool',
        'risk_attributes_present': 'bool',
        'authentication_exemptions_id': 'str'
    }

    attribute_map = {
        'acquirer_reference_fraud_rate_threshold_exceeded': 'acquirerReferenceFraudRateThresholdExceeded',
        'issuer_reference_fraud_rate_threshold_exceeded': 'issuerReferenceFraudRateThresholdExceeded',
        'issuer_reference_fraud_rate_exceeded': 'issuerReferenceFraudRateExceeded',
        'total_amount_value_exceeded': 'totalAmountValueExceeded',
        'eea_domestic_ind': 'eeaDomesticInd',
        'acquirer_reference_fraud_rate_exceeded': 'acquirerReferenceFraudRateExceeded',
        'risk_attributes_present': 'riskAttributesPresent',
        'authentication_exemptions_id': 'authenticationExemptionsId'
    }

    def __init__(self, acquirer_reference_fraud_rate_threshold_exceeded=None, issuer_reference_fraud_rate_threshold_exceeded=None, issuer_reference_fraud_rate_exceeded=None, total_amount_value_exceeded=None, eea_domestic_ind=None, acquirer_reference_fraud_rate_exceeded=None, risk_attributes_present=None, authentication_exemptions_id=None):
        """
        RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication - a model defined in Swagger
        """

        self._acquirer_reference_fraud_rate_threshold_exceeded = None
        self._issuer_reference_fraud_rate_threshold_exceeded = None
        self._issuer_reference_fraud_rate_exceeded = None
        self._total_amount_value_exceeded = None
        self._eea_domestic_ind = None
        self._acquirer_reference_fraud_rate_exceeded = None
        self._risk_attributes_present = None
        self._authentication_exemptions_id = None

        if acquirer_reference_fraud_rate_threshold_exceeded is not None:
          self.acquirer_reference_fraud_rate_threshold_exceeded = acquirer_reference_fraud_rate_threshold_exceeded
        if issuer_reference_fraud_rate_threshold_exceeded is not None:
          self.issuer_reference_fraud_rate_threshold_exceeded = issuer_reference_fraud_rate_threshold_exceeded
        if issuer_reference_fraud_rate_exceeded is not None:
          self.issuer_reference_fraud_rate_exceeded = issuer_reference_fraud_rate_exceeded
        if total_amount_value_exceeded is not None:
          self.total_amount_value_exceeded = total_amount_value_exceeded
        if eea_domestic_ind is not None:
          self.eea_domestic_ind = eea_domestic_ind
        if acquirer_reference_fraud_rate_exceeded is not None:
          self.acquirer_reference_fraud_rate_exceeded = acquirer_reference_fraud_rate_exceeded
        if risk_attributes_present is not None:
          self.risk_attributes_present = risk_attributes_present
        if authentication_exemptions_id is not None:
          self.authentication_exemptions_id = authentication_exemptions_id

    @property
    def acquirer_reference_fraud_rate_threshold_exceeded(self):
        """
        Gets the acquirer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Acquirer has exceeded the RFR for 180 consecutive days. (E.g. “true” if has exceeded, “false” otherwise). 

        :return: The acquirer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: bool
        """
        return self._acquirer_reference_fraud_rate_threshold_exceeded

    @acquirer_reference_fraud_rate_threshold_exceeded.setter
    def acquirer_reference_fraud_rate_threshold_exceeded(self, acquirer_reference_fraud_rate_threshold_exceeded):
        """
        Sets the acquirer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Acquirer has exceeded the RFR for 180 consecutive days. (E.g. “true” if has exceeded, “false” otherwise). 

        :param acquirer_reference_fraud_rate_threshold_exceeded: The acquirer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: bool
        """

        self._acquirer_reference_fraud_rate_threshold_exceeded = acquirer_reference_fraud_rate_threshold_exceeded

    @property
    def issuer_reference_fraud_rate_threshold_exceeded(self):
        """
        Gets the issuer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Issuer has exceeded the RFR for 180 consecutive days. (E.g. “True” if has exceeded, “False” otherwise). 

        :return: The issuer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: bool
        """
        return self._issuer_reference_fraud_rate_threshold_exceeded

    @issuer_reference_fraud_rate_threshold_exceeded.setter
    def issuer_reference_fraud_rate_threshold_exceeded(self, issuer_reference_fraud_rate_threshold_exceeded):
        """
        Sets the issuer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Issuer has exceeded the RFR for 180 consecutive days. (E.g. “True” if has exceeded, “False” otherwise). 

        :param issuer_reference_fraud_rate_threshold_exceeded: The issuer_reference_fraud_rate_threshold_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: bool
        """

        self._issuer_reference_fraud_rate_threshold_exceeded = issuer_reference_fraud_rate_threshold_exceeded

    @property
    def issuer_reference_fraud_rate_exceeded(self):
        """
        Gets the issuer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Issuer’s RFR exceeds the allowable level based on the amount in the request (E.g. “true” if has exceeded, “false” otherwise). 

        :return: The issuer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: bool
        """
        return self._issuer_reference_fraud_rate_exceeded

    @issuer_reference_fraud_rate_exceeded.setter
    def issuer_reference_fraud_rate_exceeded(self, issuer_reference_fraud_rate_exceeded):
        """
        Sets the issuer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Issuer’s RFR exceeds the allowable level based on the amount in the request (E.g. “true” if has exceeded, “false” otherwise). 

        :param issuer_reference_fraud_rate_exceeded: The issuer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: bool
        """

        self._issuer_reference_fraud_rate_exceeded = issuer_reference_fraud_rate_exceeded

    @property
    def total_amount_value_exceeded(self):
        """
        Gets the total_amount_value_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the request amount has exceeded the maximum ETV rate. (E.g. “true” if exceeded, “false” otherwise). 

        :return: The total_amount_value_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: bool
        """
        return self._total_amount_value_exceeded

    @total_amount_value_exceeded.setter
    def total_amount_value_exceeded(self, total_amount_value_exceeded):
        """
        Sets the total_amount_value_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the request amount has exceeded the maximum ETV rate. (E.g. “true” if exceeded, “false” otherwise). 

        :param total_amount_value_exceeded: The total_amount_value_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: bool
        """

        self._total_amount_value_exceeded = total_amount_value_exceeded

    @property
    def eea_domestic_ind(self):
        """
        Gets the eea_domestic_ind of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the input qualifies as an EEA domestic transaction where both the Acquirer Country and Issuer Country are located in the EEA. (E.g. “1” if transaction qualifies, “0” otherwise). 

        :return: The eea_domestic_ind of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: bool
        """
        return self._eea_domestic_ind

    @eea_domestic_ind.setter
    def eea_domestic_ind(self, eea_domestic_ind):
        """
        Sets the eea_domestic_ind of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the input qualifies as an EEA domestic transaction where both the Acquirer Country and Issuer Country are located in the EEA. (E.g. “1” if transaction qualifies, “0” otherwise). 

        :param eea_domestic_ind: The eea_domestic_ind of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: bool
        """

        self._eea_domestic_ind = eea_domestic_ind

    @property
    def acquirer_reference_fraud_rate_exceeded(self):
        """
        Gets the acquirer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Acquirer’s Reference Fraud Rate (RFR) exceeds the allowable level based on the amount in the request (E.g. “True” if has exceeded, “False” otherwise). 

        :return: The acquirer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: bool
        """
        return self._acquirer_reference_fraud_rate_exceeded

    @acquirer_reference_fraud_rate_exceeded.setter
    def acquirer_reference_fraud_rate_exceeded(self, acquirer_reference_fraud_rate_exceeded):
        """
        Sets the acquirer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Indicates if the Acquirer’s Reference Fraud Rate (RFR) exceeds the allowable level based on the amount in the request (E.g. “True” if has exceeded, “False” otherwise). 

        :param acquirer_reference_fraud_rate_exceeded: The acquirer_reference_fraud_rate_exceeded of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: bool
        """

        self._acquirer_reference_fraud_rate_exceeded = acquirer_reference_fraud_rate_exceeded

    @property
    def risk_attributes_present(self):
        """
        Gets the risk_attributes_present of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Risk Attribute Indicator based on required elements from Articles 2 & 18 of the European Banking Authority (EBA) Guidelines (E.g. “True” if risk attributes present, “False” otherwise). 

        :return: The risk_attributes_present of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: bool
        """
        return self._risk_attributes_present

    @risk_attributes_present.setter
    def risk_attributes_present(self, risk_attributes_present):
        """
        Sets the risk_attributes_present of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        Risk Attribute Indicator based on required elements from Articles 2 & 18 of the European Banking Authority (EBA) Guidelines (E.g. “True” if risk attributes present, “False” otherwise). 

        :param risk_attributes_present: The risk_attributes_present of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: bool
        """

        self._risk_attributes_present = risk_attributes_present

    @property
    def authentication_exemptions_id(self):
        """
        Gets the authentication_exemptions_id of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        CYBS generated UUID used to identify the transaction. Note: 36 with hashes. 

        :return: The authentication_exemptions_id of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :rtype: str
        """
        return self._authentication_exemptions_id

    @authentication_exemptions_id.setter
    def authentication_exemptions_id(self, authentication_exemptions_id):
        """
        Sets the authentication_exemptions_id of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        CYBS generated UUID used to identify the transaction. Note: 36 with hashes. 

        :param authentication_exemptions_id: The authentication_exemptions_id of this RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication.
        :type: str
        """
        if authentication_exemptions_id is not None and len(authentication_exemptions_id) > 36:
            raise ValueError("Invalid value for `authentication_exemptions_id`, length must be less than or equal to `36`")

        self._authentication_exemptions_id = authentication_exemptions_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RiskV1AuthenticationExemptionsPost201ResponseConsumerAuthenticationInformationStrongAuthentication):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
