# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Riskv1authenticationresultsConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'acs_rendering_type': 'str',
        'acs_transaction_id': 'str',
        'authentication_transaction_id': 'str',
        'authentication_type': 'str',
        'challenge_cancel_code': 'str',
        'effective_authentication_type': 'str',
        'directory_server_error_code': 'str',
        'directory_server_error_description': 'str',
        'interaction_counter': 'str',
        'signed_pares_status_reason': 'str',
        'sdk_transaction_id': 'str',
        'signed_pares': 'str',
        'three_ds_server_transaction_id': 'str',
        'white_list_status': 'str',
        'white_list_status_source': 'str'
    }

    attribute_map = {
        'acs_rendering_type': 'acsRenderingType',
        'acs_transaction_id': 'acsTransactionId',
        'authentication_transaction_id': 'authenticationTransactionId',
        'authentication_type': 'authenticationType',
        'challenge_cancel_code': 'challengeCancelCode',
        'effective_authentication_type': 'effectiveAuthenticationType',
        'directory_server_error_code': 'directoryServerErrorCode',
        'directory_server_error_description': 'directoryServerErrorDescription',
        'interaction_counter': 'interactionCounter',
        'signed_pares_status_reason': 'signedParesStatusReason',
        'sdk_transaction_id': 'sdkTransactionId',
        'signed_pares': 'signedPares',
        'three_ds_server_transaction_id': 'threeDSServerTransactionId',
        'white_list_status': 'whiteListStatus',
        'white_list_status_source': 'whiteListStatusSource'
    }

    def __init__(self, acs_rendering_type=None, acs_transaction_id=None, authentication_transaction_id=None, authentication_type=None, challenge_cancel_code=None, effective_authentication_type=None, directory_server_error_code=None, directory_server_error_description=None, interaction_counter=None, signed_pares_status_reason=None, sdk_transaction_id=None, signed_pares=None, three_ds_server_transaction_id=None, white_list_status=None, white_list_status_source=None):
        """
        Riskv1authenticationresultsConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._acs_rendering_type = None
        self._acs_transaction_id = None
        self._authentication_transaction_id = None
        self._authentication_type = None
        self._challenge_cancel_code = None
        self._effective_authentication_type = None
        self._directory_server_error_code = None
        self._directory_server_error_description = None
        self._interaction_counter = None
        self._signed_pares_status_reason = None
        self._sdk_transaction_id = None
        self._signed_pares = None
        self._three_ds_server_transaction_id = None
        self._white_list_status = None
        self._white_list_status_source = None

        if acs_rendering_type is not None:
          self.acs_rendering_type = acs_rendering_type
        if acs_transaction_id is not None:
          self.acs_transaction_id = acs_transaction_id
        if authentication_transaction_id is not None:
          self.authentication_transaction_id = authentication_transaction_id
        if authentication_type is not None:
          self.authentication_type = authentication_type
        if challenge_cancel_code is not None:
          self.challenge_cancel_code = challenge_cancel_code
        if effective_authentication_type is not None:
          self.effective_authentication_type = effective_authentication_type
        if directory_server_error_code is not None:
          self.directory_server_error_code = directory_server_error_code
        if directory_server_error_description is not None:
          self.directory_server_error_description = directory_server_error_description
        if interaction_counter is not None:
          self.interaction_counter = interaction_counter
        if signed_pares_status_reason is not None:
          self.signed_pares_status_reason = signed_pares_status_reason
        if sdk_transaction_id is not None:
          self.sdk_transaction_id = sdk_transaction_id
        self.signed_pares = signed_pares
        if three_ds_server_transaction_id is not None:
          self.three_ds_server_transaction_id = three_ds_server_transaction_id
        if white_list_status is not None:
          self.white_list_status = white_list_status
        if white_list_status_source is not None:
          self.white_list_status_source = white_list_status_source

    @property
    def acs_rendering_type(self):
        """
        Gets the acs_rendering_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 

        :return: The acs_rendering_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_rendering_type

    @acs_rendering_type.setter
    def acs_rendering_type(self, acs_rendering_type):
        """
        Sets the acs_rendering_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 

        :param acs_rendering_type: The acs_rendering_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_rendering_type = acs_rendering_type

    @property
    def acs_transaction_id(self):
        """
        Gets the acs_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction. 

        :return: The acs_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_transaction_id

    @acs_transaction_id.setter
    def acs_transaction_id(self, acs_transaction_id):
        """
        Sets the acs_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction. 

        :param acs_transaction_id: The acs_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if acs_transaction_id is not None and len(acs_transaction_id) > 36:
            raise ValueError("Invalid value for `acs_transaction_id`, length must be less than or equal to `36`")

        self._acs_transaction_id = acs_transaction_id

    @property
    def authentication_transaction_id(self):
        """
        Gets the authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. **Note**: Required for Standard integration for enroll service. Required for Hybrid integration for validate service. 

        :return: The authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_transaction_id

    @authentication_transaction_id.setter
    def authentication_transaction_id(self, authentication_transaction_id):
        """
        Sets the authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. **Note**: Required for Standard integration for enroll service. Required for Hybrid integration for validate service. 

        :param authentication_transaction_id: The authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if authentication_transaction_id is not None and len(authentication_transaction_id) > 20:
            raise ValueError("Invalid value for `authentication_transaction_id`, length must be less than or equal to `20`")

        self._authentication_transaction_id = authentication_transaction_id

    @property
    def authentication_type(self):
        """
        Gets the authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time. 

        :return: The authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_type

    @authentication_type.setter
    def authentication_type(self, authentication_type):
        """
        Sets the authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time. 

        :param authentication_type: The authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if authentication_type is not None and len(authentication_type) > 2:
            raise ValueError("Invalid value for `authentication_type`, length must be less than or equal to `2`")

        self._authentication_type = authentication_type

    @property
    def challenge_cancel_code(self):
        """
        Gets the challenge_cancel_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK 

        :return: The challenge_cancel_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_cancel_code

    @challenge_cancel_code.setter
    def challenge_cancel_code(self, challenge_cancel_code):
        """
        Sets the challenge_cancel_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK 

        :param challenge_cancel_code: The challenge_cancel_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if challenge_cancel_code is not None and len(challenge_cancel_code) > 2:
            raise ValueError("Invalid value for `challenge_cancel_code`, length must be less than or equal to `2`")

        self._challenge_cancel_code = challenge_cancel_code

    @property
    def effective_authentication_type(self):
        """
        Gets the effective_authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 

        :return: The effective_authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._effective_authentication_type

    @effective_authentication_type.setter
    def effective_authentication_type(self, effective_authentication_type):
        """
        Sets the effective_authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 

        :param effective_authentication_type: The effective_authentication_type of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if effective_authentication_type is not None and len(effective_authentication_type) > 2:
            raise ValueError("Invalid value for `effective_authentication_type`, length must be less than or equal to `2`")

        self._effective_authentication_type = effective_authentication_type

    @property
    def directory_server_error_code(self):
        """
        Gets the directory_server_error_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        The directory server error code indicating a problem with this transaction. 

        :return: The directory_server_error_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_error_code

    @directory_server_error_code.setter
    def directory_server_error_code(self, directory_server_error_code):
        """
        Sets the directory_server_error_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        The directory server error code indicating a problem with this transaction. 

        :param directory_server_error_code: The directory_server_error_code of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if directory_server_error_code is not None and len(directory_server_error_code) > 3:
            raise ValueError("Invalid value for `directory_server_error_code`, length must be less than or equal to `3`")

        self._directory_server_error_code = directory_server_error_code

    @property
    def directory_server_error_description(self):
        """
        Gets the directory_server_error_description of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Directory server text and additional detail about the error for this transaction. 

        :return: The directory_server_error_description of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_error_description

    @directory_server_error_description.setter
    def directory_server_error_description(self, directory_server_error_description):
        """
        Sets the directory_server_error_description of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Directory server text and additional detail about the error for this transaction. 

        :param directory_server_error_description: The directory_server_error_description of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if directory_server_error_description is not None and len(directory_server_error_description) > 4096:
            raise ValueError("Invalid value for `directory_server_error_description`, length must be less than or equal to `4096`")

        self._directory_server_error_description = directory_server_error_description

    @property
    def interaction_counter(self):
        """
        Gets the interaction_counter of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. 

        :return: The interaction_counter of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._interaction_counter

    @interaction_counter.setter
    def interaction_counter(self, interaction_counter):
        """
        Sets the interaction_counter of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. 

        :param interaction_counter: The interaction_counter of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if interaction_counter is not None and len(interaction_counter) > 2:
            raise ValueError("Invalid value for `interaction_counter`, length must be less than or equal to `2`")

        self._interaction_counter = interaction_counter

    @property
    def signed_pares_status_reason(self):
        """
        Gets the signed_pares_status_reason of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Provides additional information as to why the PAResStatus has a specific value. 

        :return: The signed_pares_status_reason of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._signed_pares_status_reason

    @signed_pares_status_reason.setter
    def signed_pares_status_reason(self, signed_pares_status_reason):
        """
        Sets the signed_pares_status_reason of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Provides additional information as to why the PAResStatus has a specific value. 

        :param signed_pares_status_reason: The signed_pares_status_reason of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if signed_pares_status_reason is not None and len(signed_pares_status_reason) > 2:
            raise ValueError("Invalid value for `signed_pares_status_reason`, length must be less than or equal to `2`")

        self._signed_pares_status_reason = signed_pares_status_reason

    @property
    def sdk_transaction_id(self):
        """
        Gets the sdk_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        SDK unique transaction identifier that is generated on each new transaction. 

        :return: The sdk_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._sdk_transaction_id

    @sdk_transaction_id.setter
    def sdk_transaction_id(self, sdk_transaction_id):
        """
        Sets the sdk_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        SDK unique transaction identifier that is generated on each new transaction. 

        :param sdk_transaction_id: The sdk_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if sdk_transaction_id is not None and len(sdk_transaction_id) > 36:
            raise ValueError("Invalid value for `sdk_transaction_id`, length must be less than or equal to `36`")

        self._sdk_transaction_id = sdk_transaction_id

    @property
    def signed_pares(self):
        """
        Gets the signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication result (PARes) message returned by the card-issuing bank. If you need to show proof of enrollment checking, you may need to decrypt and parse the string for the information required by the payment card company. For more information, see \"Storing Payer Authentication Data,\" page 160. Important The value is in base64. You must remove all carriage returns and line feeds before adding the PARes to the request. 

        :return: The signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._signed_pares

    @signed_pares.setter
    def signed_pares(self, signed_pares):
        """
        Sets the signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication result (PARes) message returned by the card-issuing bank. If you need to show proof of enrollment checking, you may need to decrypt and parse the string for the information required by the payment card company. For more information, see \"Storing Payer Authentication Data,\" page 160. Important The value is in base64. You must remove all carriage returns and line feeds before adding the PARes to the request. 

        :param signed_pares: The signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if signed_pares is None:
            raise ValueError("Invalid value for `signed_pares`, must not be `None`")

        self._signed_pares = signed_pares

    @property
    def three_ds_server_transaction_id(self):
        """
        Gets the three_ds_server_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 

        :return: The three_ds_server_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._three_ds_server_transaction_id

    @three_ds_server_transaction_id.setter
    def three_ds_server_transaction_id(self, three_ds_server_transaction_id):
        """
        Sets the three_ds_server_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 

        :param three_ds_server_transaction_id: The three_ds_server_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if three_ds_server_transaction_id is not None and len(three_ds_server_transaction_id) > 36:
            raise ValueError("Invalid value for `three_ds_server_transaction_id`, length must be less than or equal to `36`")

        self._three_ds_server_transaction_id = three_ds_server_transaction_id

    @property
    def white_list_status(self):
        """
        Gets the white_list_status of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :return: The white_list_status of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status

    @white_list_status.setter
    def white_list_status(self, white_list_status):
        """
        Sets the white_list_status of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :param white_list_status: The white_list_status of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if white_list_status is not None and len(white_list_status) > 1:
            raise ValueError("Invalid value for `white_list_status`, length must be less than or equal to `1`")

        self._white_list_status = white_list_status

    @property
    def white_list_status_source(self):
        """
        Gets the white_list_status_source of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 

        :return: The white_list_status_source of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status_source

    @white_list_status_source.setter
    def white_list_status_source(self, white_list_status_source):
        """
        Sets the white_list_status_source of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 

        :param white_list_status_source: The white_list_status_source of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if white_list_status_source is not None and len(white_list_status_source) > 2:
            raise ValueError("Invalid value for `white_list_status_source`, length must be less than or equal to `2`")

        self._white_list_status_source = white_list_status_source

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1authenticationresultsConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
