# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'acs_rendering_type': 'str',
        'acs_transaction_id': 'str',
        'authentication_result': 'str',
        'authentication_status_msg': 'str',
        'authorization_payload': 'str',
        'cavv': 'str',
        'cavv_algorithm': 'str',
        'directory_server_error_code': 'str',
        'directory_server_error_description': 'str',
        'indicator': 'str',
        'interaction_counter': 'str',
        'eci': 'str',
        'eci_raw': 'str',
        'pares_status': 'str',
        'sdk_transaction_id': 'str',
        'specification_version': 'str',
        'three_ds_server_transaction_id': 'str',
        'ucaf_authentication_data': 'str',
        'ucaf_collection_indicator': 'str',
        'white_list_status': 'str',
        'white_list_status_source': 'str',
        'xid': 'str',
        'directory_server_transaction_id': 'str'
    }

    attribute_map = {
        'acs_rendering_type': 'acsRenderingType',
        'acs_transaction_id': 'acsTransactionId',
        'authentication_result': 'authenticationResult',
        'authentication_status_msg': 'authenticationStatusMsg',
        'authorization_payload': 'authorizationPayload',
        'cavv': 'cavv',
        'cavv_algorithm': 'cavvAlgorithm',
        'directory_server_error_code': 'directoryServerErrorCode',
        'directory_server_error_description': 'directoryServerErrorDescription',
        'indicator': 'indicator',
        'interaction_counter': 'interactionCounter',
        'eci': 'eci',
        'eci_raw': 'eciRaw',
        'pares_status': 'paresStatus',
        'sdk_transaction_id': 'sdkTransactionId',
        'specification_version': 'specificationVersion',
        'three_ds_server_transaction_id': 'threeDSServerTransactionId',
        'ucaf_authentication_data': 'ucafAuthenticationData',
        'ucaf_collection_indicator': 'ucafCollectionIndicator',
        'white_list_status': 'whiteListStatus',
        'white_list_status_source': 'whiteListStatusSource',
        'xid': 'xid',
        'directory_server_transaction_id': 'directoryServerTransactionId'
    }

    def __init__(self, acs_rendering_type=None, acs_transaction_id=None, authentication_result=None, authentication_status_msg=None, authorization_payload=None, cavv=None, cavv_algorithm=None, directory_server_error_code=None, directory_server_error_description=None, indicator=None, interaction_counter=None, eci=None, eci_raw=None, pares_status=None, sdk_transaction_id=None, specification_version=None, three_ds_server_transaction_id=None, ucaf_authentication_data=None, ucaf_collection_indicator=None, white_list_status=None, white_list_status_source=None, xid=None, directory_server_transaction_id=None):
        """
        RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._acs_rendering_type = None
        self._acs_transaction_id = None
        self._authentication_result = None
        self._authentication_status_msg = None
        self._authorization_payload = None
        self._cavv = None
        self._cavv_algorithm = None
        self._directory_server_error_code = None
        self._directory_server_error_description = None
        self._indicator = None
        self._interaction_counter = None
        self._eci = None
        self._eci_raw = None
        self._pares_status = None
        self._sdk_transaction_id = None
        self._specification_version = None
        self._three_ds_server_transaction_id = None
        self._ucaf_authentication_data = None
        self._ucaf_collection_indicator = None
        self._white_list_status = None
        self._white_list_status_source = None
        self._xid = None
        self._directory_server_transaction_id = None

        if acs_rendering_type is not None:
          self.acs_rendering_type = acs_rendering_type
        if acs_transaction_id is not None:
          self.acs_transaction_id = acs_transaction_id
        if authentication_result is not None:
          self.authentication_result = authentication_result
        if authentication_status_msg is not None:
          self.authentication_status_msg = authentication_status_msg
        if authorization_payload is not None:
          self.authorization_payload = authorization_payload
        if cavv is not None:
          self.cavv = cavv
        if cavv_algorithm is not None:
          self.cavv_algorithm = cavv_algorithm
        if directory_server_error_code is not None:
          self.directory_server_error_code = directory_server_error_code
        if directory_server_error_description is not None:
          self.directory_server_error_description = directory_server_error_description
        if indicator is not None:
          self.indicator = indicator
        if interaction_counter is not None:
          self.interaction_counter = interaction_counter
        if eci is not None:
          self.eci = eci
        if eci_raw is not None:
          self.eci_raw = eci_raw
        if pares_status is not None:
          self.pares_status = pares_status
        if sdk_transaction_id is not None:
          self.sdk_transaction_id = sdk_transaction_id
        if specification_version is not None:
          self.specification_version = specification_version
        if three_ds_server_transaction_id is not None:
          self.three_ds_server_transaction_id = three_ds_server_transaction_id
        if ucaf_authentication_data is not None:
          self.ucaf_authentication_data = ucaf_authentication_data
        if ucaf_collection_indicator is not None:
          self.ucaf_collection_indicator = ucaf_collection_indicator
        if white_list_status is not None:
          self.white_list_status = white_list_status
        if white_list_status_source is not None:
          self.white_list_status_source = white_list_status_source
        if xid is not None:
          self.xid = xid
        if directory_server_transaction_id is not None:
          self.directory_server_transaction_id = directory_server_transaction_id

    @property
    def acs_rendering_type(self):
        """
        Gets the acs_rendering_type of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 

        :return: The acs_rendering_type of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_rendering_type

    @acs_rendering_type.setter
    def acs_rendering_type(self, acs_rendering_type):
        """
        Sets the acs_rendering_type of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 

        :param acs_rendering_type: The acs_rendering_type of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_rendering_type = acs_rendering_type

    @property
    def acs_transaction_id(self):
        """
        Gets the acs_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction. 

        :return: The acs_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_transaction_id

    @acs_transaction_id.setter
    def acs_transaction_id(self, acs_transaction_id):
        """
        Sets the acs_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction. 

        :param acs_transaction_id: The acs_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if acs_transaction_id is not None and len(acs_transaction_id) > 36:
            raise ValueError("Invalid value for `acs_transaction_id`, length must be less than or equal to `36`")

        self._acs_transaction_id = acs_transaction_id

    @property
    def authentication_result(self):
        """
        Gets the authentication_result of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Raw authentication data that comes from the cardissuing bank. Primary authentication field that indicates if authentication was successful and if liability shift occurred. You should examine first the result of this field. This field contains one of these values: - `-1`: Invalid PARes. - `0`: Successful validation. - `1`: Cardholder is not participating, but the attempt to authenticate was recorded. - `6`: Issuer unable to perform authentication. - `9`: Cardholder did not complete authentication. 

        :return: The authentication_result of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_result

    @authentication_result.setter
    def authentication_result(self, authentication_result):
        """
        Sets the authentication_result of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Raw authentication data that comes from the cardissuing bank. Primary authentication field that indicates if authentication was successful and if liability shift occurred. You should examine first the result of this field. This field contains one of these values: - `-1`: Invalid PARes. - `0`: Successful validation. - `1`: Cardholder is not participating, but the attempt to authenticate was recorded. - `6`: Issuer unable to perform authentication. - `9`: Cardholder did not complete authentication. 

        :param authentication_result: The authentication_result of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_result = authentication_result

    @property
    def authentication_status_msg(self):
        """
        Gets the authentication_status_msg of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Message that explains the authenticationResult reply field. 

        :return: The authentication_status_msg of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_status_msg

    @authentication_status_msg.setter
    def authentication_status_msg(self, authentication_status_msg):
        """
        Sets the authentication_status_msg of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Message that explains the authenticationResult reply field. 

        :param authentication_status_msg: The authentication_status_msg of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_status_msg = authentication_status_msg

    @property
    def authorization_payload(self):
        """
        Gets the authorization_payload of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow 

        :return: The authorization_payload of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authorization_payload

    @authorization_payload.setter
    def authorization_payload(self, authorization_payload):
        """
        Sets the authorization_payload of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow 

        :param authorization_payload: The authorization_payload of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authorization_payload = authorization_payload

    @property
    def cavv(self):
        """
        Gets the cavv of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 

        :return: The cavv of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv

    @cavv.setter
    def cavv(self, cavv):
        """
        Sets the cavv of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 

        :param cavv: The cavv of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if cavv is not None and len(cavv) > 255:
            raise ValueError("Invalid value for `cavv`, length must be less than or equal to `255`")

        self._cavv = cavv

    @property
    def cavv_algorithm(self):
        """
        Gets the cavv_algorithm of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard 

        :return: The cavv_algorithm of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv_algorithm

    @cavv_algorithm.setter
    def cavv_algorithm(self, cavv_algorithm):
        """
        Sets the cavv_algorithm of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard 

        :param cavv_algorithm: The cavv_algorithm of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if cavv_algorithm is not None and len(cavv_algorithm) > 1:
            raise ValueError("Invalid value for `cavv_algorithm`, length must be less than or equal to `1`")

        self._cavv_algorithm = cavv_algorithm

    @property
    def directory_server_error_code(self):
        """
        Gets the directory_server_error_code of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. 

        :return: The directory_server_error_code of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_error_code

    @directory_server_error_code.setter
    def directory_server_error_code(self, directory_server_error_code):
        """
        Sets the directory_server_error_code of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. 

        :param directory_server_error_code: The directory_server_error_code of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._directory_server_error_code = directory_server_error_code

    @property
    def directory_server_error_description(self):
        """
        Gets the directory_server_error_description of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Directory server text and additional detail about the error for this transaction. 

        :return: The directory_server_error_description of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_error_description

    @directory_server_error_description.setter
    def directory_server_error_description(self, directory_server_error_description):
        """
        Sets the directory_server_error_description of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Directory server text and additional detail about the error for this transaction. 

        :param directory_server_error_description: The directory_server_error_description of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if directory_server_error_description is not None and len(directory_server_error_description) > 4096:
            raise ValueError("Invalid value for `directory_server_error_description`, length must be less than or equal to `4096`")

        self._directory_server_error_description = directory_server_error_description

    @property
    def indicator(self):
        """
        Gets the indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Indicator used to differentiate Internet transactions from other types. The authentication failed if this field is not returned. For Visa, if your payment processor is Streamline, Barclays, AIBMS, or FDC Germany, you receive the value vbv_failure instead of internet when eci is 07. The value of this field is passed automatically to the authorization service if you request the services together. This field contains one of these values: - `aesk`: American Express SafeKey authentication verified successfully. - `aesk_attempted`: Card not enrolled in American Express SafeKey, but the attempt to authenticate was recorded. - `dipb`: Discover ProtectBuy authentication verified successfully. - `dipb_attempted`: Card not enrolled in Discover ProtectBuy, but the attempt to authenticate was recorded. - `internet`: Authentication was not verified successfully. - `js`: J/Secure authentication verified successfully. - `js_attempted`: Card not enrolled in J/Secure, but the attempt to authenticate was recorded. - `moto`: Mail or telephone order. - `pb_attempted`: Card not enrolled in Diners Club ProtectBuy, but the attempt to authenticate was recorded. - `recurring`: Recurring transaction. - `spa`: Mastercard Identity Check authentication verified successfully. - `spa_failure`: Mastercard Identity Check failed authentication. - `vbv`: Visa Secure authentication verified successfully. - `vbv_attempted`: Card not enrolled in Visa Secure, but the attempt to authenticate was recorded. - `vbv_failure`: Visa Secure authentication unavailable. 

        :return: The indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._indicator

    @indicator.setter
    def indicator(self, indicator):
        """
        Sets the indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Indicator used to differentiate Internet transactions from other types. The authentication failed if this field is not returned. For Visa, if your payment processor is Streamline, Barclays, AIBMS, or FDC Germany, you receive the value vbv_failure instead of internet when eci is 07. The value of this field is passed automatically to the authorization service if you request the services together. This field contains one of these values: - `aesk`: American Express SafeKey authentication verified successfully. - `aesk_attempted`: Card not enrolled in American Express SafeKey, but the attempt to authenticate was recorded. - `dipb`: Discover ProtectBuy authentication verified successfully. - `dipb_attempted`: Card not enrolled in Discover ProtectBuy, but the attempt to authenticate was recorded. - `internet`: Authentication was not verified successfully. - `js`: J/Secure authentication verified successfully. - `js_attempted`: Card not enrolled in J/Secure, but the attempt to authenticate was recorded. - `moto`: Mail or telephone order. - `pb_attempted`: Card not enrolled in Diners Club ProtectBuy, but the attempt to authenticate was recorded. - `recurring`: Recurring transaction. - `spa`: Mastercard Identity Check authentication verified successfully. - `spa_failure`: Mastercard Identity Check failed authentication. - `vbv`: Visa Secure authentication verified successfully. - `vbv_attempted`: Card not enrolled in Visa Secure, but the attempt to authenticate was recorded. - `vbv_failure`: Visa Secure authentication unavailable. 

        :param indicator: The indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._indicator = indicator

    @property
    def interaction_counter(self):
        """
        Gets the interaction_counter of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. 

        :return: The interaction_counter of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._interaction_counter

    @interaction_counter.setter
    def interaction_counter(self, interaction_counter):
        """
        Sets the interaction_counter of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. 

        :param interaction_counter: The interaction_counter of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if interaction_counter is not None and len(interaction_counter) > 2:
            raise ValueError("Invalid value for `interaction_counter`, length must be less than or equal to `2`")

        self._interaction_counter = interaction_counter

    @property
    def eci(self):
        """
        Gets the eci of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) 

        :return: The eci of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._eci

    @eci.setter
    def eci(self, eci):
        """
        Sets the eci of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) 

        :param eci: The eci of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._eci = eci

    @property
    def eci_raw(self):
        """
        Gets the eci_raw of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 

        :return: The eci_raw of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._eci_raw

    @eci_raw.setter
    def eci_raw(self, eci_raw):
        """
        Sets the eci_raw of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 

        :param eci_raw: The eci_raw of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._eci_raw = eci_raw

    @property
    def pares_status(self):
        """
        Gets the pares_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `N`: Customer failed or canceled authentication. Transaction denied. - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. 

        :return: The pares_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._pares_status

    @pares_status.setter
    def pares_status(self, pares_status):
        """
        Sets the pares_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `N`: Customer failed or canceled authentication. Transaction denied. - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. 

        :param pares_status: The pares_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._pares_status = pares_status

    @property
    def sdk_transaction_id(self):
        """
        Gets the sdk_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        SDK unique transaction identifier that is generated on each new transaction. 

        :return: The sdk_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._sdk_transaction_id

    @sdk_transaction_id.setter
    def sdk_transaction_id(self, sdk_transaction_id):
        """
        Sets the sdk_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        SDK unique transaction identifier that is generated on each new transaction. 

        :param sdk_transaction_id: The sdk_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if sdk_transaction_id is not None and len(sdk_transaction_id) > 36:
            raise ValueError("Invalid value for `sdk_transaction_id`, length must be less than or equal to `36`")

        self._sdk_transaction_id = sdk_transaction_id

    @property
    def specification_version(self):
        """
        Gets the specification_version of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 

        :return: The specification_version of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._specification_version

    @specification_version.setter
    def specification_version(self, specification_version):
        """
        Sets the specification_version of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 

        :param specification_version: The specification_version of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._specification_version = specification_version

    @property
    def three_ds_server_transaction_id(self):
        """
        Gets the three_ds_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 

        :return: The three_ds_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._three_ds_server_transaction_id

    @three_ds_server_transaction_id.setter
    def three_ds_server_transaction_id(self, three_ds_server_transaction_id):
        """
        Sets the three_ds_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 

        :param three_ds_server_transaction_id: The three_ds_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if three_ds_server_transaction_id is not None and len(three_ds_server_transaction_id) > 36:
            raise ValueError("Invalid value for `three_ds_server_transaction_id`, length must be less than or equal to `36`")

        self._three_ds_server_transaction_id = three_ds_server_transaction_id

    @property
    def ucaf_authentication_data(self):
        """
        Gets the ucaf_authentication_data of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 

        :return: The ucaf_authentication_data of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ucaf_authentication_data

    @ucaf_authentication_data.setter
    def ucaf_authentication_data(self, ucaf_authentication_data):
        """
        Sets the ucaf_authentication_data of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 

        :param ucaf_authentication_data: The ucaf_authentication_data of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._ucaf_authentication_data = ucaf_authentication_data

    @property
    def ucaf_collection_indicator(self):
        """
        Gets the ucaf_collection_indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. 

        :return: The ucaf_collection_indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ucaf_collection_indicator

    @ucaf_collection_indicator.setter
    def ucaf_collection_indicator(self, ucaf_collection_indicator):
        """
        Sets the ucaf_collection_indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. 

        :param ucaf_collection_indicator: The ucaf_collection_indicator of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._ucaf_collection_indicator = ucaf_collection_indicator

    @property
    def white_list_status(self):
        """
        Gets the white_list_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :return: The white_list_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status

    @white_list_status.setter
    def white_list_status(self, white_list_status):
        """
        Sets the white_list_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :param white_list_status: The white_list_status of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if white_list_status is not None and len(white_list_status) > 1:
            raise ValueError("Invalid value for `white_list_status`, length must be less than or equal to `1`")

        self._white_list_status = white_list_status

    @property
    def white_list_status_source(self):
        """
        Gets the white_list_status_source of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 

        :return: The white_list_status_source of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status_source

    @white_list_status_source.setter
    def white_list_status_source(self, white_list_status_source):
        """
        Sets the white_list_status_source of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 

        :param white_list_status_source: The white_list_status_source of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if white_list_status_source is not None and len(white_list_status_source) > 2:
            raise ValueError("Invalid value for `white_list_status_source`, length must be less than or equal to `2`")

        self._white_list_status_source = white_list_status_source

    @property
    def xid(self):
        """
        Gets the xid of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) 

        :return: The xid of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._xid

    @xid.setter
    def xid(self, xid):
        """
        Sets the xid of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) 

        :param xid: The xid of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._xid = xid

    @property
    def directory_server_transaction_id(self):
        """
        Gets the directory_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 

        :return: The directory_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_transaction_id

    @directory_server_transaction_id.setter
    def directory_server_transaction_id(self, directory_server_transaction_id):
        """
        Sets the directory_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 

        :param directory_server_transaction_id: The directory_server_transaction_id of this RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if directory_server_transaction_id is not None and len(directory_server_transaction_id) > 36:
            raise ValueError("Invalid value for `directory_server_transaction_id`, length must be less than or equal to `36`")

        self._directory_server_transaction_id = directory_server_transaction_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RiskV1AuthenticationResultsPost201ResponseConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
