# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Ptsv2creditsProcessingInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'commerce_indicator': 'str',
        'processor_id': 'str',
        'payment_solution': 'str',
        'reconciliation_id': 'str',
        'link_id': 'str',
        'report_group': 'str',
        'visa_checkout_id': 'str',
        'purchase_level': 'str',
        'industry_data_type': 'str',
        'wallet_type': 'str',
        'national_net_domestic_data': 'str',
        'network_routing_order': 'str',
        'recurring_options': 'Ptsv2paymentsidrefundsProcessingInformationRecurringOptions',
        'bank_transfer_options': 'Ptsv2creditsProcessingInformationBankTransferOptions',
        'purchase_options': 'Ptsv2creditsProcessingInformationPurchaseOptions',
        'electronic_benefits_transfer': 'Ptsv2creditsProcessingInformationElectronicBenefitsTransfer',
        'loan_options': 'Ptsv2paymentsProcessingInformationLoanOptions',
        'japan_payment_options': 'Ptsv2creditsProcessingInformationJapanPaymentOptions'
    }

    attribute_map = {
        'commerce_indicator': 'commerceIndicator',
        'processor_id': 'processorId',
        'payment_solution': 'paymentSolution',
        'reconciliation_id': 'reconciliationId',
        'link_id': 'linkId',
        'report_group': 'reportGroup',
        'visa_checkout_id': 'visaCheckoutId',
        'purchase_level': 'purchaseLevel',
        'industry_data_type': 'industryDataType',
        'wallet_type': 'walletType',
        'national_net_domestic_data': 'nationalNetDomesticData',
        'network_routing_order': 'networkRoutingOrder',
        'recurring_options': 'recurringOptions',
        'bank_transfer_options': 'bankTransferOptions',
        'purchase_options': 'purchaseOptions',
        'electronic_benefits_transfer': 'electronicBenefitsTransfer',
        'loan_options': 'loanOptions',
        'japan_payment_options': 'japanPaymentOptions'
    }

    def __init__(self, commerce_indicator=None, processor_id=None, payment_solution=None, reconciliation_id=None, link_id=None, report_group=None, visa_checkout_id=None, purchase_level=None, industry_data_type=None, wallet_type=None, national_net_domestic_data=None, network_routing_order=None, recurring_options=None, bank_transfer_options=None, purchase_options=None, electronic_benefits_transfer=None, loan_options=None, japan_payment_options=None):
        """
        Ptsv2creditsProcessingInformation - a model defined in Swagger
        """

        self._commerce_indicator = None
        self._processor_id = None
        self._payment_solution = None
        self._reconciliation_id = None
        self._link_id = None
        self._report_group = None
        self._visa_checkout_id = None
        self._purchase_level = None
        self._industry_data_type = None
        self._wallet_type = None
        self._national_net_domestic_data = None
        self._network_routing_order = None
        self._recurring_options = None
        self._bank_transfer_options = None
        self._purchase_options = None
        self._electronic_benefits_transfer = None
        self._loan_options = None
        self._japan_payment_options = None

        if commerce_indicator is not None:
          self.commerce_indicator = commerce_indicator
        if processor_id is not None:
          self.processor_id = processor_id
        if payment_solution is not None:
          self.payment_solution = payment_solution
        if reconciliation_id is not None:
          self.reconciliation_id = reconciliation_id
        if link_id is not None:
          self.link_id = link_id
        if report_group is not None:
          self.report_group = report_group
        if visa_checkout_id is not None:
          self.visa_checkout_id = visa_checkout_id
        if purchase_level is not None:
          self.purchase_level = purchase_level
        if industry_data_type is not None:
          self.industry_data_type = industry_data_type
        if wallet_type is not None:
          self.wallet_type = wallet_type
        if national_net_domestic_data is not None:
          self.national_net_domestic_data = national_net_domestic_data
        if network_routing_order is not None:
          self.network_routing_order = network_routing_order
        if recurring_options is not None:
          self.recurring_options = recurring_options
        if bank_transfer_options is not None:
          self.bank_transfer_options = bank_transfer_options
        if purchase_options is not None:
          self.purchase_options = purchase_options
        if electronic_benefits_transfer is not None:
          self.electronic_benefits_transfer = electronic_benefits_transfer
        if loan_options is not None:
          self.loan_options = loan_options
        if japan_payment_options is not None:
          self.japan_payment_options = japan_payment_options

    @property
    def commerce_indicator(self):
        """
        Gets the commerce_indicator of this Ptsv2creditsProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional. Only `internet`, `moto`, `install`, `recurring`, and `recurring_internet` are valid values.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value (listed in Appendix I, \"Commerce Indicators,\" on page 441.)  #### Payer Authentication Transactions For the possible values and requirements, see \"Payer Authentication,\" page 195.  #### Other Types of Transactions See Appendix I, \"Commerce Indicators,\" on page 441.  #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as “moto\" 

        :return: The commerce_indicator of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._commerce_indicator

    @commerce_indicator.setter
    def commerce_indicator(self, commerce_indicator):
        """
        Sets the commerce_indicator of this Ptsv2creditsProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional. Only `internet`, `moto`, `install`, `recurring`, and `recurring_internet` are valid values.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value (listed in Appendix I, \"Commerce Indicators,\" on page 441.)  #### Payer Authentication Transactions For the possible values and requirements, see \"Payer Authentication,\" page 195.  #### Other Types of Transactions See Appendix I, \"Commerce Indicators,\" on page 441.  #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as “moto\" 

        :param commerce_indicator: The commerce_indicator of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._commerce_indicator = commerce_indicator

    @property
    def processor_id(self):
        """
        Gets the processor_id of this Ptsv2creditsProcessingInformation.
        Value that identifies the processor/acquirer to use for the transaction. This value is supported only for **CyberSource through VisaNet**.  Contact CyberSource Customer Support to get the value for this field. 

        :return: The processor_id of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._processor_id

    @processor_id.setter
    def processor_id(self, processor_id):
        """
        Sets the processor_id of this Ptsv2creditsProcessingInformation.
        Value that identifies the processor/acquirer to use for the transaction. This value is supported only for **CyberSource through VisaNet**.  Contact CyberSource Customer Support to get the value for this field. 

        :param processor_id: The processor_id of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._processor_id = processor_id

    @property
    def payment_solution(self):
        """
        Gets the payment_solution of this Ptsv2creditsProcessingInformation.
        Type of digital payment solution for the transaction. Possible Values:   - `visacheckout`: Visa Checkout. This value is required for Visa Checkout transactions. For details, see `payment_solution` field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - `001`: Apple Pay.  - `004`: Cybersource In-App Solution.  - `005`: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \"Masterpass\" in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - `006`: Android Pay.  - `007`: Chase Pay.  - `008`: Samsung Pay.  - `012`: Google Pay.  - `013`: Cybersource P2PE Decryption  - `014`: Mastercard credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `015`: Visa credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `027`: Click to Pay. 

        :return: The payment_solution of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._payment_solution

    @payment_solution.setter
    def payment_solution(self, payment_solution):
        """
        Sets the payment_solution of this Ptsv2creditsProcessingInformation.
        Type of digital payment solution for the transaction. Possible Values:   - `visacheckout`: Visa Checkout. This value is required for Visa Checkout transactions. For details, see `payment_solution` field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - `001`: Apple Pay.  - `004`: Cybersource In-App Solution.  - `005`: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \"Masterpass\" in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - `006`: Android Pay.  - `007`: Chase Pay.  - `008`: Samsung Pay.  - `012`: Google Pay.  - `013`: Cybersource P2PE Decryption  - `014`: Mastercard credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `015`: Visa credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `027`: Click to Pay. 

        :param payment_solution: The payment_solution of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._payment_solution = payment_solution

    @property
    def reconciliation_id(self):
        """
        Gets the reconciliation_id of this Ptsv2creditsProcessingInformation.
        Please check with Cybersource customer support to see if your merchant account is configured correctly so you can include this field in your request. * For Payouts: max length for FDCCompass is String (22). 

        :return: The reconciliation_id of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._reconciliation_id

    @reconciliation_id.setter
    def reconciliation_id(self, reconciliation_id):
        """
        Sets the reconciliation_id of this Ptsv2creditsProcessingInformation.
        Please check with Cybersource customer support to see if your merchant account is configured correctly so you can include this field in your request. * For Payouts: max length for FDCCompass is String (22). 

        :param reconciliation_id: The reconciliation_id of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._reconciliation_id = reconciliation_id

    @property
    def link_id(self):
        """
        Gets the link_id of this Ptsv2creditsProcessingInformation.
        Value that links the current authorization request to the original authorization request. Set this value to the ID that was returned in the reply message from the original authorization request.  This value is used for:  - Partial authorizations - Split shipments  For details, see `link_to_request` field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The link_id of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """
        Sets the link_id of this Ptsv2creditsProcessingInformation.
        Value that links the current authorization request to the original authorization request. Set this value to the ID that was returned in the reply message from the original authorization request.  This value is used for:  - Partial authorizations - Split shipments  For details, see `link_to_request` field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param link_id: The link_id of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._link_id = link_id

    @property
    def report_group(self):
        """
        Gets the report_group of this Ptsv2creditsProcessingInformation.
        Attribute that lets you define custom grouping for your processor reports. This field is supported only for **Worldpay VAP**.  For details, see `report_group` field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The report_group of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._report_group

    @report_group.setter
    def report_group(self, report_group):
        """
        Sets the report_group of this Ptsv2creditsProcessingInformation.
        Attribute that lets you define custom grouping for your processor reports. This field is supported only for **Worldpay VAP**.  For details, see `report_group` field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param report_group: The report_group of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._report_group = report_group

    @property
    def visa_checkout_id(self):
        """
        Gets the visa_checkout_id of this Ptsv2creditsProcessingInformation.
        Identifier for the **Visa Checkout** order. Visa Checkout provides a unique order ID for every transaction in the Visa Checkout **callID** field. 

        :return: The visa_checkout_id of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._visa_checkout_id

    @visa_checkout_id.setter
    def visa_checkout_id(self, visa_checkout_id):
        """
        Sets the visa_checkout_id of this Ptsv2creditsProcessingInformation.
        Identifier for the **Visa Checkout** order. Visa Checkout provides a unique order ID for every transaction in the Visa Checkout **callID** field. 

        :param visa_checkout_id: The visa_checkout_id of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._visa_checkout_id = visa_checkout_id

    @property
    def purchase_level(self):
        """
        Gets the purchase_level of this Ptsv2creditsProcessingInformation.
        Set this field to 3 to indicate that the request includes Level III data.

        :return: The purchase_level of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._purchase_level

    @purchase_level.setter
    def purchase_level(self, purchase_level):
        """
        Sets the purchase_level of this Ptsv2creditsProcessingInformation.
        Set this field to 3 to indicate that the request includes Level III data.

        :param purchase_level: The purchase_level of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._purchase_level = purchase_level

    @property
    def industry_data_type(self):
        """
        Gets the industry_data_type of this Ptsv2creditsProcessingInformation.
        Indicates that the transaction includes industry-specific data.  Possible Values: - `airline` - `restaurant` - `lodging` - `auto_rental` - `transit` - `healthcare_medical` - `healthcare_transit` - `transit`  #### Card Present, Airlines and Auto Rental You must set this field to `airline` in order for airline data to be sent to the processor. For example, if this field is not set to `airline` or is not included in the request, no airline data is sent to the processor.  You must set this field to `restaurant` in order for restaurant data to be sent to the processor. When this field is not set to `restaurant` or is not included in the request, no restaurant data is sent to the processor.  You must set this field to `auto_rental` in order for auto rental data to be sent to the processor. For example, if this field is not set to `auto_rental` or is not included in the request, no auto rental data is sent to the processor.  Restaurant data is supported only on CyberSource through VisaNet. 

        :return: The industry_data_type of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._industry_data_type

    @industry_data_type.setter
    def industry_data_type(self, industry_data_type):
        """
        Sets the industry_data_type of this Ptsv2creditsProcessingInformation.
        Indicates that the transaction includes industry-specific data.  Possible Values: - `airline` - `restaurant` - `lodging` - `auto_rental` - `transit` - `healthcare_medical` - `healthcare_transit` - `transit`  #### Card Present, Airlines and Auto Rental You must set this field to `airline` in order for airline data to be sent to the processor. For example, if this field is not set to `airline` or is not included in the request, no airline data is sent to the processor.  You must set this field to `restaurant` in order for restaurant data to be sent to the processor. When this field is not set to `restaurant` or is not included in the request, no restaurant data is sent to the processor.  You must set this field to `auto_rental` in order for auto rental data to be sent to the processor. For example, if this field is not set to `auto_rental` or is not included in the request, no auto rental data is sent to the processor.  Restaurant data is supported only on CyberSource through VisaNet. 

        :param industry_data_type: The industry_data_type of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._industry_data_type = industry_data_type

    @property
    def wallet_type(self):
        """
        Gets the wallet_type of this Ptsv2creditsProcessingInformation.
        This field carries the wallet type in authorization requests and credit requests. Possible value are: - `101`: Masterpass remote payment. The customer created the wallet by manually interacting with a customer-controlled device such as a computer, tablet, or phone. This value is supported only for Masterpass transactions on Chase Paymentech Solutions and CyberSource through VisaNet. - `102`: Masterpass remote near field communication (NFC) payment. The customer created the wallet by tapping a PayPass card or customer-controlled device at a contactless card reader. This value is supported only for card-present Masterpass transactions on CyberSource through VisaNet. - `103`: Masterpass Apple Pay payment. The payment was made with a combination of Masterpass and Apple Pay. This value is supported only for Masterpass Apple Pay transactions on CyberSource through VisaNet. - `216`: Masterpass Google Pay payment. The payment was made with a combination of Masterpass and Google Pay. This value is supported only for Masterpass Google Pay transactions on CyberSource through VisaNet. - `217`: Masterpass Samsung Pay payment. The payment was made with a combination of Masterpass and Samsung Pay. This value is supported only for Masterpass Samsung Pay transactions on CyberSource through VisaNet. - `SDW`: Staged digital wallet. An issuer or operator created the wallet. This value is supported only for Masterpass transactions on Chase Paymentech Solutions. - `VCIND`: Visa Checkout payment. This value is supported only on CyberSource through VisaNet, FDC Compass, FDC Nashville Global, FDI Australia, and TSYS Acquiring Solutions. See Getting Started with Visa Checkout. For Visa Checkout transactions, the way CyberSource processes the value for this field depends on the processor. See the Visa Checkout section below. For all other values, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. Masterpass (101, 102, 103, 216, and 217): The Masterpass platform generates the wallet type value and passes it to you along with the customer’s checkout information.  Visa Checkout: This field is optional for Visa Checkout authorizations on FDI Australia. For all other processors, this field is required for Visa Checkout authorizations. For Visa Checkout transactions on the following processors, CyberSource sends the value that the processor expects for this field:FDC Compass,FDC Nashville Global,FDI Australia,TSYS Acquiring Solutions For all other processors, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. For incremental authorizations, this field is supported only for Mastercard and the supported values are 101 and 102. Payment card companies can introduce new values without notice. Your order management system should be able to process new values without problems.  CyberSource through VisaNet When the value for this field is 101, 102, 103, 216, or 217, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR6, Position: 88-90,  Field: Mastercard Wallet Identifier. When the value for this field is VCIND, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR8, Position: 72-76, Field: Agent Unique ID. 

        :return: The wallet_type of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._wallet_type

    @wallet_type.setter
    def wallet_type(self, wallet_type):
        """
        Sets the wallet_type of this Ptsv2creditsProcessingInformation.
        This field carries the wallet type in authorization requests and credit requests. Possible value are: - `101`: Masterpass remote payment. The customer created the wallet by manually interacting with a customer-controlled device such as a computer, tablet, or phone. This value is supported only for Masterpass transactions on Chase Paymentech Solutions and CyberSource through VisaNet. - `102`: Masterpass remote near field communication (NFC) payment. The customer created the wallet by tapping a PayPass card or customer-controlled device at a contactless card reader. This value is supported only for card-present Masterpass transactions on CyberSource through VisaNet. - `103`: Masterpass Apple Pay payment. The payment was made with a combination of Masterpass and Apple Pay. This value is supported only for Masterpass Apple Pay transactions on CyberSource through VisaNet. - `216`: Masterpass Google Pay payment. The payment was made with a combination of Masterpass and Google Pay. This value is supported only for Masterpass Google Pay transactions on CyberSource through VisaNet. - `217`: Masterpass Samsung Pay payment. The payment was made with a combination of Masterpass and Samsung Pay. This value is supported only for Masterpass Samsung Pay transactions on CyberSource through VisaNet. - `SDW`: Staged digital wallet. An issuer or operator created the wallet. This value is supported only for Masterpass transactions on Chase Paymentech Solutions. - `VCIND`: Visa Checkout payment. This value is supported only on CyberSource through VisaNet, FDC Compass, FDC Nashville Global, FDI Australia, and TSYS Acquiring Solutions. See Getting Started with Visa Checkout. For Visa Checkout transactions, the way CyberSource processes the value for this field depends on the processor. See the Visa Checkout section below. For all other values, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. Masterpass (101, 102, 103, 216, and 217): The Masterpass platform generates the wallet type value and passes it to you along with the customer’s checkout information.  Visa Checkout: This field is optional for Visa Checkout authorizations on FDI Australia. For all other processors, this field is required for Visa Checkout authorizations. For Visa Checkout transactions on the following processors, CyberSource sends the value that the processor expects for this field:FDC Compass,FDC Nashville Global,FDI Australia,TSYS Acquiring Solutions For all other processors, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. For incremental authorizations, this field is supported only for Mastercard and the supported values are 101 and 102. Payment card companies can introduce new values without notice. Your order management system should be able to process new values without problems.  CyberSource through VisaNet When the value for this field is 101, 102, 103, 216, or 217, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR6, Position: 88-90,  Field: Mastercard Wallet Identifier. When the value for this field is VCIND, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR8, Position: 72-76, Field: Agent Unique ID. 

        :param wallet_type: The wallet_type of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._wallet_type = wallet_type

    @property
    def national_net_domestic_data(self):
        """
        Gets the national_net_domestic_data of this Ptsv2creditsProcessingInformation.
        Supplementary domestic transaction information provided by the acquirer for National Net Settlement Service (NNSS) transactions. NNSS is a settlement service that Visa provides. For transactions on CyberSource through VisaNet in countries that subscribe to NNSS: VisaNet clears transactions; VisaNet transfers funds to the acquirer after deducting processing fees and interchange fees. VisaNet settles transactions in the local pricing currency through a local financial institution. This field is supported only on CyberSource through VisaNet for domestic data in Colombia 

        :return: The national_net_domestic_data of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._national_net_domestic_data

    @national_net_domestic_data.setter
    def national_net_domestic_data(self, national_net_domestic_data):
        """
        Sets the national_net_domestic_data of this Ptsv2creditsProcessingInformation.
        Supplementary domestic transaction information provided by the acquirer for National Net Settlement Service (NNSS) transactions. NNSS is a settlement service that Visa provides. For transactions on CyberSource through VisaNet in countries that subscribe to NNSS: VisaNet clears transactions; VisaNet transfers funds to the acquirer after deducting processing fees and interchange fees. VisaNet settles transactions in the local pricing currency through a local financial institution. This field is supported only on CyberSource through VisaNet for domestic data in Colombia 

        :param national_net_domestic_data: The national_net_domestic_data of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._national_net_domestic_data = national_net_domestic_data

    @property
    def network_routing_order(self):
        """
        Gets the network_routing_order of this Ptsv2creditsProcessingInformation.
        On PIN Debit Gateways: This U.S.-only field is optionally used by  participants (merchants and acquirers) to specify the network access priority. VisaNet checks to determine if there are issuer routing preferences for any of the networks specified by the sharing group code. If an issuer preference exists for one of the specified debit networks, VisaNet makes a routing selection based on the issuer’s preference. If an issuer preference exists for more than one of the specified debit networks, or if no issuer preference exists, VisaNet makes a selection based on the acquirer’s routing priorities.  #### PIN debit Priority order of the networks through which he transaction will be routed. Set this value to a series of one-character network codes in your preferred order. This is a list of the network codes:  | Network | Code | | --- | --- | | Accel | E | | AFFN | U | | Alaska Option | 3 | | CU24 | C | | Interlink | G | | Maestro | 8 | | NETS | P | | NYCE | F | | Pulse | H | | Shazam | 7 | | Star | M | | Visa | V |  For example, if the Star network is your first preference and Pulse is your second preference, set this field to a value of `MH`.  When you do not include this value in your PIN debit request, the list of network codes from your account is used. **Note** This field is supported only for businesses located in the U.S.  Optional field for PIN debit credit or PIN debit purchase. 

        :return: The network_routing_order of this Ptsv2creditsProcessingInformation.
        :rtype: str
        """
        return self._network_routing_order

    @network_routing_order.setter
    def network_routing_order(self, network_routing_order):
        """
        Sets the network_routing_order of this Ptsv2creditsProcessingInformation.
        On PIN Debit Gateways: This U.S.-only field is optionally used by  participants (merchants and acquirers) to specify the network access priority. VisaNet checks to determine if there are issuer routing preferences for any of the networks specified by the sharing group code. If an issuer preference exists for one of the specified debit networks, VisaNet makes a routing selection based on the issuer’s preference. If an issuer preference exists for more than one of the specified debit networks, or if no issuer preference exists, VisaNet makes a selection based on the acquirer’s routing priorities.  #### PIN debit Priority order of the networks through which he transaction will be routed. Set this value to a series of one-character network codes in your preferred order. This is a list of the network codes:  | Network | Code | | --- | --- | | Accel | E | | AFFN | U | | Alaska Option | 3 | | CU24 | C | | Interlink | G | | Maestro | 8 | | NETS | P | | NYCE | F | | Pulse | H | | Shazam | 7 | | Star | M | | Visa | V |  For example, if the Star network is your first preference and Pulse is your second preference, set this field to a value of `MH`.  When you do not include this value in your PIN debit request, the list of network codes from your account is used. **Note** This field is supported only for businesses located in the U.S.  Optional field for PIN debit credit or PIN debit purchase. 

        :param network_routing_order: The network_routing_order of this Ptsv2creditsProcessingInformation.
        :type: str
        """

        self._network_routing_order = network_routing_order

    @property
    def recurring_options(self):
        """
        Gets the recurring_options of this Ptsv2creditsProcessingInformation.

        :return: The recurring_options of this Ptsv2creditsProcessingInformation.
        :rtype: Ptsv2paymentsidrefundsProcessingInformationRecurringOptions
        """
        return self._recurring_options

    @recurring_options.setter
    def recurring_options(self, recurring_options):
        """
        Sets the recurring_options of this Ptsv2creditsProcessingInformation.

        :param recurring_options: The recurring_options of this Ptsv2creditsProcessingInformation.
        :type: Ptsv2paymentsidrefundsProcessingInformationRecurringOptions
        """

        self._recurring_options = recurring_options

    @property
    def bank_transfer_options(self):
        """
        Gets the bank_transfer_options of this Ptsv2creditsProcessingInformation.

        :return: The bank_transfer_options of this Ptsv2creditsProcessingInformation.
        :rtype: Ptsv2creditsProcessingInformationBankTransferOptions
        """
        return self._bank_transfer_options

    @bank_transfer_options.setter
    def bank_transfer_options(self, bank_transfer_options):
        """
        Sets the bank_transfer_options of this Ptsv2creditsProcessingInformation.

        :param bank_transfer_options: The bank_transfer_options of this Ptsv2creditsProcessingInformation.
        :type: Ptsv2creditsProcessingInformationBankTransferOptions
        """

        self._bank_transfer_options = bank_transfer_options

    @property
    def purchase_options(self):
        """
        Gets the purchase_options of this Ptsv2creditsProcessingInformation.

        :return: The purchase_options of this Ptsv2creditsProcessingInformation.
        :rtype: Ptsv2creditsProcessingInformationPurchaseOptions
        """
        return self._purchase_options

    @purchase_options.setter
    def purchase_options(self, purchase_options):
        """
        Sets the purchase_options of this Ptsv2creditsProcessingInformation.

        :param purchase_options: The purchase_options of this Ptsv2creditsProcessingInformation.
        :type: Ptsv2creditsProcessingInformationPurchaseOptions
        """

        self._purchase_options = purchase_options

    @property
    def electronic_benefits_transfer(self):
        """
        Gets the electronic_benefits_transfer of this Ptsv2creditsProcessingInformation.

        :return: The electronic_benefits_transfer of this Ptsv2creditsProcessingInformation.
        :rtype: Ptsv2creditsProcessingInformationElectronicBenefitsTransfer
        """
        return self._electronic_benefits_transfer

    @electronic_benefits_transfer.setter
    def electronic_benefits_transfer(self, electronic_benefits_transfer):
        """
        Sets the electronic_benefits_transfer of this Ptsv2creditsProcessingInformation.

        :param electronic_benefits_transfer: The electronic_benefits_transfer of this Ptsv2creditsProcessingInformation.
        :type: Ptsv2creditsProcessingInformationElectronicBenefitsTransfer
        """

        self._electronic_benefits_transfer = electronic_benefits_transfer

    @property
    def loan_options(self):
        """
        Gets the loan_options of this Ptsv2creditsProcessingInformation.

        :return: The loan_options of this Ptsv2creditsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationLoanOptions
        """
        return self._loan_options

    @loan_options.setter
    def loan_options(self, loan_options):
        """
        Sets the loan_options of this Ptsv2creditsProcessingInformation.

        :param loan_options: The loan_options of this Ptsv2creditsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationLoanOptions
        """

        self._loan_options = loan_options

    @property
    def japan_payment_options(self):
        """
        Gets the japan_payment_options of this Ptsv2creditsProcessingInformation.

        :return: The japan_payment_options of this Ptsv2creditsProcessingInformation.
        :rtype: Ptsv2creditsProcessingInformationJapanPaymentOptions
        """
        return self._japan_payment_options

    @japan_payment_options.setter
    def japan_payment_options(self, japan_payment_options):
        """
        Sets the japan_payment_options of this Ptsv2creditsProcessingInformation.

        :param japan_payment_options: The japan_payment_options of this Ptsv2creditsProcessingInformation.
        :type: Ptsv2creditsProcessingInformationJapanPaymentOptions
        """

        self._japan_payment_options = japan_payment_options

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2creditsProcessingInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
