# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class GenerateUnifiedCheckoutCaptureContextRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'target_origins': 'list[str]',
        'client_version': 'str',
        'allowed_card_networks': 'list[str]',
        'allowed_payment_types': 'list[str]',
        'country': 'str',
        'locale': 'str',
        'capture_mandate': 'Upv1capturecontextsCaptureMandate',
        'order_information': 'Upv1capturecontextsOrderInformation',
        'checkout_api_initialization': 'Upv1capturecontextsCheckoutApiInitialization'
    }

    attribute_map = {
        'target_origins': 'targetOrigins',
        'client_version': 'clientVersion',
        'allowed_card_networks': 'allowedCardNetworks',
        'allowed_payment_types': 'allowedPaymentTypes',
        'country': 'country',
        'locale': 'locale',
        'capture_mandate': 'captureMandate',
        'order_information': 'orderInformation',
        'checkout_api_initialization': 'checkoutApiInitialization'
    }

    def __init__(self, target_origins=None, client_version=None, allowed_card_networks=None, allowed_payment_types=None, country=None, locale=None, capture_mandate=None, order_information=None, checkout_api_initialization=None):
        """
        GenerateUnifiedCheckoutCaptureContextRequest - a model defined in Swagger
        """

        self._target_origins = None
        self._client_version = None
        self._allowed_card_networks = None
        self._allowed_payment_types = None
        self._country = None
        self._locale = None
        self._capture_mandate = None
        self._order_information = None
        self._checkout_api_initialization = None

        if target_origins is not None:
          self.target_origins = target_origins
        if client_version is not None:
          self.client_version = client_version
        if allowed_card_networks is not None:
          self.allowed_card_networks = allowed_card_networks
        if allowed_payment_types is not None:
          self.allowed_payment_types = allowed_payment_types
        if country is not None:
          self.country = country
        if locale is not None:
          self.locale = locale
        if capture_mandate is not None:
          self.capture_mandate = capture_mandate
        if order_information is not None:
          self.order_information = order_information
        if checkout_api_initialization is not None:
          self.checkout_api_initialization = checkout_api_initialization

    @property
    def target_origins(self):
        """
        Gets the target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: list[str]
        """
        return self._target_origins

    @target_origins.setter
    def target_origins(self, target_origins):
        """
        Sets the target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param target_origins: The target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: list[str]
        """

        self._target_origins = target_origins

    @property
    def client_version(self):
        """
        Gets the client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        verson number of Unified Checkout being used

        :return: The client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: str
        """
        return self._client_version

    @client_version.setter
    def client_version(self, client_version):
        """
        Sets the client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        verson number of Unified Checkout being used

        :param client_version: The client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: str
        """

        self._client_version = client_version

    @property
    def allowed_card_networks(self):
        """
        Gets the allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: list[str]
        """
        return self._allowed_card_networks

    @allowed_card_networks.setter
    def allowed_card_networks(self, allowed_card_networks):
        """
        Sets the allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param allowed_card_networks: The allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: list[str]
        """

        self._allowed_card_networks = allowed_card_networks

    @property
    def allowed_payment_types(self):
        """
        Gets the allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: list[str]
        """
        return self._allowed_payment_types

    @allowed_payment_types.setter
    def allowed_payment_types(self, allowed_payment_types):
        """
        Sets the allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param allowed_payment_types: The allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: list[str]
        """

        self._allowed_payment_types = allowed_payment_types

    @property
    def country(self):
        """
        Gets the country of this GenerateUnifiedCheckoutCaptureContextRequest.
        Country the purchase is originating from (e.g. country of the merchant). Use the two- character ISO Standard

        :return: The country of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this GenerateUnifiedCheckoutCaptureContextRequest.
        Country the purchase is originating from (e.g. country of the merchant). Use the two- character ISO Standard

        :param country: The country of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: str
        """

        self._country = country

    @property
    def locale(self):
        """
        Gets the locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        Localization of the User experience conforming to the ISO 639-1 language standards and two-character ISO Standard Country Code

        :return: The locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        Localization of the User experience conforming to the ISO 639-1 language standards and two-character ISO Standard Country Code

        :param locale: The locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: str
        """

        self._locale = locale

    @property
    def capture_mandate(self):
        """
        Gets the capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: Upv1capturecontextsCaptureMandate
        """
        return self._capture_mandate

    @capture_mandate.setter
    def capture_mandate(self, capture_mandate):
        """
        Sets the capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param capture_mandate: The capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: Upv1capturecontextsCaptureMandate
        """

        self._capture_mandate = capture_mandate

    @property
    def order_information(self):
        """
        Gets the order_information of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The order_information of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: Upv1capturecontextsOrderInformation
        """
        return self._order_information

    @order_information.setter
    def order_information(self, order_information):
        """
        Sets the order_information of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param order_information: The order_information of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: Upv1capturecontextsOrderInformation
        """

        self._order_information = order_information

    @property
    def checkout_api_initialization(self):
        """
        Gets the checkout_api_initialization of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The checkout_api_initialization of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: Upv1capturecontextsCheckoutApiInitialization
        """
        return self._checkout_api_initialization

    @checkout_api_initialization.setter
    def checkout_api_initialization(self, checkout_api_initialization):
        """
        Sets the checkout_api_initialization of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param checkout_api_initialization: The checkout_api_initialization of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: Upv1capturecontextsCheckoutApiInitialization
        """

        self._checkout_api_initialization = checkout_api_initialization

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, GenerateUnifiedCheckoutCaptureContextRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
