# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_token': 'str',
        'acs_rendering_type': 'str',
        'acs_transaction_id': 'str',
        'acs_url': 'str',
        'authentication_path': 'str',
        'authorization_payload': 'str',
        'authentication_transaction_id': 'str',
        'cardholder_message': 'str',
        'cavv': 'str',
        'cavv_algorithm': 'str',
        'challenge_cancel_code': 'str',
        'challenge_required': 'str',
        'decoupled_authentication_indicator': 'str',
        'directory_server_error_code': 'str',
        'directory_server_error_description': 'str',
        'ecommerce_indicator': 'str',
        'eci': 'str',
        'eci_raw': 'str',
        'effective_authentication_type': 'str',
        'ivr': 'PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr',
        'strong_authentication': 'PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication',
        'network_score': 'str',
        'pareq': 'str',
        'pares_status': 'str',
        'proof_xml': 'str',
        'proxy_pan': 'str',
        'sdk_transaction_id': 'str',
        'signed_pares_status_reason': 'str',
        'specification_version': 'str',
        'step_up_url': 'str',
        'three_ds_server_transaction_id': 'str',
        'ucaf_authentication_data': 'str',
        'ucaf_collection_indicator': 'str',
        'veres_enrolled': 'str',
        'white_list_status_source': 'str',
        'xid': 'str',
        'directory_server_transaction_id': 'str',
        'authentication_result': 'str',
        'authentication_status_msg': 'str',
        'indicator': 'str',
        'interaction_counter': 'str',
        'white_list_status': 'str'
    }

    attribute_map = {
        'access_token': 'accessToken',
        'acs_rendering_type': 'acsRenderingType',
        'acs_transaction_id': 'acsTransactionId',
        'acs_url': 'acsUrl',
        'authentication_path': 'authenticationPath',
        'authorization_payload': 'authorizationPayload',
        'authentication_transaction_id': 'authenticationTransactionId',
        'cardholder_message': 'cardholderMessage',
        'cavv': 'cavv',
        'cavv_algorithm': 'cavvAlgorithm',
        'challenge_cancel_code': 'challengeCancelCode',
        'challenge_required': 'challengeRequired',
        'decoupled_authentication_indicator': 'decoupledAuthenticationIndicator',
        'directory_server_error_code': 'directoryServerErrorCode',
        'directory_server_error_description': 'directoryServerErrorDescription',
        'ecommerce_indicator': 'ecommerceIndicator',
        'eci': 'eci',
        'eci_raw': 'eciRaw',
        'effective_authentication_type': 'effectiveAuthenticationType',
        'ivr': 'ivr',
        'strong_authentication': 'strongAuthentication',
        'network_score': 'networkScore',
        'pareq': 'pareq',
        'pares_status': 'paresStatus',
        'proof_xml': 'proofXml',
        'proxy_pan': 'proxyPan',
        'sdk_transaction_id': 'sdkTransactionId',
        'signed_pares_status_reason': 'signedParesStatusReason',
        'specification_version': 'specificationVersion',
        'step_up_url': 'stepUpUrl',
        'three_ds_server_transaction_id': 'threeDSServerTransactionId',
        'ucaf_authentication_data': 'ucafAuthenticationData',
        'ucaf_collection_indicator': 'ucafCollectionIndicator',
        'veres_enrolled': 'veresEnrolled',
        'white_list_status_source': 'whiteListStatusSource',
        'xid': 'xid',
        'directory_server_transaction_id': 'directoryServerTransactionId',
        'authentication_result': 'authenticationResult',
        'authentication_status_msg': 'authenticationStatusMsg',
        'indicator': 'indicator',
        'interaction_counter': 'interactionCounter',
        'white_list_status': 'whiteListStatus'
    }

    def __init__(self, access_token=None, acs_rendering_type=None, acs_transaction_id=None, acs_url=None, authentication_path=None, authorization_payload=None, authentication_transaction_id=None, cardholder_message=None, cavv=None, cavv_algorithm=None, challenge_cancel_code=None, challenge_required=None, decoupled_authentication_indicator=None, directory_server_error_code=None, directory_server_error_description=None, ecommerce_indicator=None, eci=None, eci_raw=None, effective_authentication_type=None, ivr=None, strong_authentication=None, network_score=None, pareq=None, pares_status=None, proof_xml=None, proxy_pan=None, sdk_transaction_id=None, signed_pares_status_reason=None, specification_version=None, step_up_url=None, three_ds_server_transaction_id=None, ucaf_authentication_data=None, ucaf_collection_indicator=None, veres_enrolled=None, white_list_status_source=None, xid=None, directory_server_transaction_id=None, authentication_result=None, authentication_status_msg=None, indicator=None, interaction_counter=None, white_list_status=None):
        """
        PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._access_token = None
        self._acs_rendering_type = None
        self._acs_transaction_id = None
        self._acs_url = None
        self._authentication_path = None
        self._authorization_payload = None
        self._authentication_transaction_id = None
        self._cardholder_message = None
        self._cavv = None
        self._cavv_algorithm = None
        self._challenge_cancel_code = None
        self._challenge_required = None
        self._decoupled_authentication_indicator = None
        self._directory_server_error_code = None
        self._directory_server_error_description = None
        self._ecommerce_indicator = None
        self._eci = None
        self._eci_raw = None
        self._effective_authentication_type = None
        self._ivr = None
        self._strong_authentication = None
        self._network_score = None
        self._pareq = None
        self._pares_status = None
        self._proof_xml = None
        self._proxy_pan = None
        self._sdk_transaction_id = None
        self._signed_pares_status_reason = None
        self._specification_version = None
        self._step_up_url = None
        self._three_ds_server_transaction_id = None
        self._ucaf_authentication_data = None
        self._ucaf_collection_indicator = None
        self._veres_enrolled = None
        self._white_list_status_source = None
        self._xid = None
        self._directory_server_transaction_id = None
        self._authentication_result = None
        self._authentication_status_msg = None
        self._indicator = None
        self._interaction_counter = None
        self._white_list_status = None

        if access_token is not None:
          self.access_token = access_token
        if acs_rendering_type is not None:
          self.acs_rendering_type = acs_rendering_type
        if acs_transaction_id is not None:
          self.acs_transaction_id = acs_transaction_id
        if acs_url is not None:
          self.acs_url = acs_url
        if authentication_path is not None:
          self.authentication_path = authentication_path
        if authorization_payload is not None:
          self.authorization_payload = authorization_payload
        if authentication_transaction_id is not None:
          self.authentication_transaction_id = authentication_transaction_id
        if cardholder_message is not None:
          self.cardholder_message = cardholder_message
        if cavv is not None:
          self.cavv = cavv
        if cavv_algorithm is not None:
          self.cavv_algorithm = cavv_algorithm
        if challenge_cancel_code is not None:
          self.challenge_cancel_code = challenge_cancel_code
        if challenge_required is not None:
          self.challenge_required = challenge_required
        if decoupled_authentication_indicator is not None:
          self.decoupled_authentication_indicator = decoupled_authentication_indicator
        if directory_server_error_code is not None:
          self.directory_server_error_code = directory_server_error_code
        if directory_server_error_description is not None:
          self.directory_server_error_description = directory_server_error_description
        if ecommerce_indicator is not None:
          self.ecommerce_indicator = ecommerce_indicator
        if eci is not None:
          self.eci = eci
        if eci_raw is not None:
          self.eci_raw = eci_raw
        if effective_authentication_type is not None:
          self.effective_authentication_type = effective_authentication_type
        if ivr is not None:
          self.ivr = ivr
        if strong_authentication is not None:
          self.strong_authentication = strong_authentication
        if network_score is not None:
          self.network_score = network_score
        if pareq is not None:
          self.pareq = pareq
        if pares_status is not None:
          self.pares_status = pares_status
        if proof_xml is not None:
          self.proof_xml = proof_xml
        if proxy_pan is not None:
          self.proxy_pan = proxy_pan
        if sdk_transaction_id is not None:
          self.sdk_transaction_id = sdk_transaction_id
        if signed_pares_status_reason is not None:
          self.signed_pares_status_reason = signed_pares_status_reason
        if specification_version is not None:
          self.specification_version = specification_version
        if step_up_url is not None:
          self.step_up_url = step_up_url
        if three_ds_server_transaction_id is not None:
          self.three_ds_server_transaction_id = three_ds_server_transaction_id
        if ucaf_authentication_data is not None:
          self.ucaf_authentication_data = ucaf_authentication_data
        if ucaf_collection_indicator is not None:
          self.ucaf_collection_indicator = ucaf_collection_indicator
        if veres_enrolled is not None:
          self.veres_enrolled = veres_enrolled
        if white_list_status_source is not None:
          self.white_list_status_source = white_list_status_source
        if xid is not None:
          self.xid = xid
        if directory_server_transaction_id is not None:
          self.directory_server_transaction_id = directory_server_transaction_id
        if authentication_result is not None:
          self.authentication_result = authentication_result
        if authentication_status_msg is not None:
          self.authentication_status_msg = authentication_status_msg
        if indicator is not None:
          self.indicator = indicator
        if interaction_counter is not None:
          self.interaction_counter = interaction_counter
        if white_list_status is not None:
          self.white_list_status = white_list_status

    @property
    def access_token(self):
        """
        Gets the access_token of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        JSON Web Token (JWT) used to authenticate the consumer with the authentication provider, such as, CardinalCommerce or Rupay. Note - Max Length of this field is 2048 characters. 

        :return: The access_token of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token):
        """
        Sets the access_token of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        JSON Web Token (JWT) used to authenticate the consumer with the authentication provider, such as, CardinalCommerce or Rupay. Note - Max Length of this field is 2048 characters. 

        :param access_token: The access_token of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._access_token = access_token

    @property
    def acs_rendering_type(self):
        """
        Gets the acs_rendering_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 

        :return: The acs_rendering_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_rendering_type

    @acs_rendering_type.setter
    def acs_rendering_type(self, acs_rendering_type):
        """
        Sets the acs_rendering_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 

        :param acs_rendering_type: The acs_rendering_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_rendering_type = acs_rendering_type

    @property
    def acs_transaction_id(self):
        """
        Gets the acs_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction. 

        :return: The acs_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_transaction_id

    @acs_transaction_id.setter
    def acs_transaction_id(self, acs_transaction_id):
        """
        Sets the acs_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction. 

        :param acs_transaction_id: The acs_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_transaction_id = acs_transaction_id

    @property
    def acs_url(self):
        """
        Gets the acs_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        URL for the card-issuing bank’s authentication form that you receive when the card is enrolled. The value can be very large. 

        :return: The acs_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_url

    @acs_url.setter
    def acs_url(self, acs_url):
        """
        Sets the acs_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        URL for the card-issuing bank’s authentication form that you receive when the card is enrolled. The value can be very large. 

        :param acs_url: The acs_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_url = acs_url

    @property
    def authentication_path(self):
        """
        Gets the authentication_path of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates what displays to the customer during the authentication process. This field can contain one of these values: - `ADS`: (Card not enrolled) customer prompted to activate the card during the checkout process. - `ATTEMPTS`: (Attempts processing) Processing briefly displays before the checkout process is completed. - `ENROLLED`: (Card enrolled) the card issuer’s authentication window displays. - `UNKNOWN`: Card enrollment status cannot be determined. - `NOREDIRECT`: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - `RIBA`: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - `RIBA_PASS`: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see `pa_enroll_authentication_path` field description and \"Rules-Based Payer Authentication\" in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 

        :return: The authentication_path of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_path

    @authentication_path.setter
    def authentication_path(self, authentication_path):
        """
        Sets the authentication_path of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates what displays to the customer during the authentication process. This field can contain one of these values: - `ADS`: (Card not enrolled) customer prompted to activate the card during the checkout process. - `ATTEMPTS`: (Attempts processing) Processing briefly displays before the checkout process is completed. - `ENROLLED`: (Card enrolled) the card issuer’s authentication window displays. - `UNKNOWN`: Card enrollment status cannot be determined. - `NOREDIRECT`: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - `RIBA`: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - `RIBA_PASS`: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see `pa_enroll_authentication_path` field description and \"Rules-Based Payer Authentication\" in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 

        :param authentication_path: The authentication_path of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_path = authentication_path

    @property
    def authorization_payload(self):
        """
        Gets the authorization_payload of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow 

        :return: The authorization_payload of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authorization_payload

    @authorization_payload.setter
    def authorization_payload(self, authorization_payload):
        """
        Sets the authorization_payload of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow 

        :param authorization_payload: The authorization_payload of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authorization_payload = authorization_payload

    @property
    def authentication_transaction_id(self):
        """
        Gets the authentication_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication transaction identifier is used to link the check enrollment and validate authentication messages. For Rupay, this field should be passed as request only for Resend OTP use case. 

        :return: The authentication_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_transaction_id

    @authentication_transaction_id.setter
    def authentication_transaction_id(self, authentication_transaction_id):
        """
        Sets the authentication_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication transaction identifier is used to link the check enrollment and validate authentication messages. For Rupay, this field should be passed as request only for Resend OTP use case. 

        :param authentication_transaction_id: The authentication_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_transaction_id = authentication_transaction_id

    @property
    def cardholder_message(self):
        """
        Gets the cardholder_message of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Text provided by the ACS/Issuer to Cardholder during a Frictionless or Decoupled transaction.The Issuer can provide information to Cardholder. For example, “Additional authentication is needed for this transaction, please contact (Issuer Name) at xxx-xxx-xxxx.”. The Issuing Bank can optionally support this value. 

        :return: The cardholder_message of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cardholder_message

    @cardholder_message.setter
    def cardholder_message(self, cardholder_message):
        """
        Sets the cardholder_message of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Text provided by the ACS/Issuer to Cardholder during a Frictionless or Decoupled transaction.The Issuer can provide information to Cardholder. For example, “Additional authentication is needed for this transaction, please contact (Issuer Name) at xxx-xxx-xxxx.”. The Issuing Bank can optionally support this value. 

        :param cardholder_message: The cardholder_message of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._cardholder_message = cardholder_message

    @property
    def cavv(self):
        """
        Gets the cavv of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 

        :return: The cavv of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv

    @cavv.setter
    def cavv(self, cavv):
        """
        Sets the cavv of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 

        :param cavv: The cavv of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._cavv = cavv

    @property
    def cavv_algorithm(self):
        """
        Gets the cavv_algorithm of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard 

        :return: The cavv_algorithm of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv_algorithm

    @cavv_algorithm.setter
    def cavv_algorithm(self, cavv_algorithm):
        """
        Sets the cavv_algorithm of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard 

        :param cavv_algorithm: The cavv_algorithm of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._cavv_algorithm = cavv_algorithm

    @property
    def challenge_cancel_code(self):
        """
        Gets the challenge_cancel_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK 

        :return: The challenge_cancel_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_cancel_code

    @challenge_cancel_code.setter
    def challenge_cancel_code(self, challenge_cancel_code):
        """
        Sets the challenge_cancel_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK 

        :param challenge_cancel_code: The challenge_cancel_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_cancel_code = challenge_cancel_code

    @property
    def challenge_required(self):
        """
        Gets the challenge_required of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates whether a challenge is required in order to complete authentication. **Note** Regional mandates might determine that a challenge is required.  Possible values: - `Y`: Challenge required - `N`: Challenge not required **Note**  Used by the Hybrid integration. 

        :return: The challenge_required of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_required

    @challenge_required.setter
    def challenge_required(self, challenge_required):
        """
        Sets the challenge_required of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates whether a challenge is required in order to complete authentication. **Note** Regional mandates might determine that a challenge is required.  Possible values: - `Y`: Challenge required - `N`: Challenge not required **Note**  Used by the Hybrid integration. 

        :param challenge_required: The challenge_required of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_required = challenge_required

    @property
    def decoupled_authentication_indicator(self):
        """
        Gets the decoupled_authentication_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 

        :return: The decoupled_authentication_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._decoupled_authentication_indicator

    @decoupled_authentication_indicator.setter
    def decoupled_authentication_indicator(self, decoupled_authentication_indicator):
        """
        Sets the decoupled_authentication_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 

        :param decoupled_authentication_indicator: The decoupled_authentication_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._decoupled_authentication_indicator = decoupled_authentication_indicator

    @property
    def directory_server_error_code(self):
        """
        Gets the directory_server_error_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. 

        :return: The directory_server_error_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_error_code

    @directory_server_error_code.setter
    def directory_server_error_code(self, directory_server_error_code):
        """
        Sets the directory_server_error_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. 

        :param directory_server_error_code: The directory_server_error_code of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._directory_server_error_code = directory_server_error_code

    @property
    def directory_server_error_description(self):
        """
        Gets the directory_server_error_description of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Directory server text and additional detail about the error for this transaction. 

        :return: The directory_server_error_description of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_error_description

    @directory_server_error_description.setter
    def directory_server_error_description(self, directory_server_error_description):
        """
        Sets the directory_server_error_description of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Directory server text and additional detail about the error for this transaction. 

        :param directory_server_error_description: The directory_server_error_description of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._directory_server_error_description = directory_server_error_description

    @property
    def ecommerce_indicator(self):
        """
        Gets the ecommerce_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Commerce indicator for cards not enrolled. This field contains one of these values: - `internet`: Card not enrolled, or card type not supported by payer authentication. No liability shift. - `js_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `js_failure`: J/Secure directory service is not available. No liability shift. - `spa`: Mastercard card not enrolled in the SecureCode program. No liability shift. - `vbv_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `vbv_failure`: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa’s directory service is not available. No liability shift. 

        :return: The ecommerce_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ecommerce_indicator

    @ecommerce_indicator.setter
    def ecommerce_indicator(self, ecommerce_indicator):
        """
        Sets the ecommerce_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Commerce indicator for cards not enrolled. This field contains one of these values: - `internet`: Card not enrolled, or card type not supported by payer authentication. No liability shift. - `js_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `js_failure`: J/Secure directory service is not available. No liability shift. - `spa`: Mastercard card not enrolled in the SecureCode program. No liability shift. - `vbv_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `vbv_failure`: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa’s directory service is not available. No liability shift. 

        :param ecommerce_indicator: The ecommerce_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._ecommerce_indicator = ecommerce_indicator

    @property
    def eci(self):
        """
        Gets the eci of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) 

        :return: The eci of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._eci

    @eci.setter
    def eci(self, eci):
        """
        Sets the eci of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) 

        :param eci: The eci of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._eci = eci

    @property
    def eci_raw(self):
        """
        Gets the eci_raw of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 

        :return: The eci_raw of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._eci_raw

    @eci_raw.setter
    def eci_raw(self, eci_raw):
        """
        Sets the eci_raw of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 

        :param eci_raw: The eci_raw of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._eci_raw = eci_raw

    @property
    def effective_authentication_type(self):
        """
        Gets the effective_authentication_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 

        :return: The effective_authentication_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._effective_authentication_type

    @effective_authentication_type.setter
    def effective_authentication_type(self, effective_authentication_type):
        """
        Sets the effective_authentication_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 

        :param effective_authentication_type: The effective_authentication_type of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._effective_authentication_type = effective_authentication_type

    @property
    def ivr(self):
        """
        Gets the ivr of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.

        :return: The ivr of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr
        """
        return self._ivr

    @ivr.setter
    def ivr(self, ivr):
        """
        Sets the ivr of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.

        :param ivr: The ivr of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr
        """

        self._ivr = ivr

    @property
    def strong_authentication(self):
        """
        Gets the strong_authentication of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.

        :return: The strong_authentication of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication
        """
        return self._strong_authentication

    @strong_authentication.setter
    def strong_authentication(self, strong_authentication):
        """
        Sets the strong_authentication of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.

        :param strong_authentication: The strong_authentication of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationStrongAuthentication
        """

        self._strong_authentication = strong_authentication

    @property
    def network_score(self):
        """
        Gets the network_score of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The global score calculated by the CB scoring platform and returned to merchants. 

        :return: The network_score of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._network_score

    @network_score.setter
    def network_score(self, network_score):
        """
        Sets the network_score of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The global score calculated by the CB scoring platform and returned to merchants. 

        :param network_score: The network_score of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._network_score = network_score

    @property
    def pareq(self):
        """
        Gets the pareq of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. 

        :return: The pareq of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._pareq

    @pareq.setter
    def pareq(self, pareq):
        """
        Sets the pareq of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. 

        :param pareq: The pareq of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._pareq = pareq

    @property
    def pares_status(self):
        """
        Gets the pares_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `N`: Customer failed or canceled authentication. Transaction denied. - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. 

        :return: The pares_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._pares_status

    @pares_status.setter
    def pares_status(self, pares_status):
        """
        Sets the pares_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `N`: Customer failed or canceled authentication. Transaction denied. - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. 

        :param pares_status: The pares_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._pares_status = pares_status

    @property
    def proof_xml(self):
        """
        Gets the proof_xml of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the `pa_enroll_proofxml` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. 

        :return: The proof_xml of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._proof_xml

    @proof_xml.setter
    def proof_xml(self, proof_xml):
        """
        Sets the proof_xml of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the `pa_enroll_proofxml` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. 

        :param proof_xml: The proof_xml of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._proof_xml = proof_xml

    @property
    def proxy_pan(self):
        """
        Gets the proxy_pan of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Encrypted version of the card number used in the payer authentication request message. 

        :return: The proxy_pan of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._proxy_pan

    @proxy_pan.setter
    def proxy_pan(self, proxy_pan):
        """
        Sets the proxy_pan of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Encrypted version of the card number used in the payer authentication request message. 

        :param proxy_pan: The proxy_pan of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._proxy_pan = proxy_pan

    @property
    def sdk_transaction_id(self):
        """
        Gets the sdk_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        SDK unique transaction identifier that is generated on each new transaction. 

        :return: The sdk_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._sdk_transaction_id

    @sdk_transaction_id.setter
    def sdk_transaction_id(self, sdk_transaction_id):
        """
        Sets the sdk_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        SDK unique transaction identifier that is generated on each new transaction. 

        :param sdk_transaction_id: The sdk_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._sdk_transaction_id = sdk_transaction_id

    @property
    def signed_pares_status_reason(self):
        """
        Gets the signed_pares_status_reason of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Provides additional information as to why the PAResStatus has a specific value. 

        :return: The signed_pares_status_reason of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._signed_pares_status_reason

    @signed_pares_status_reason.setter
    def signed_pares_status_reason(self, signed_pares_status_reason):
        """
        Sets the signed_pares_status_reason of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Provides additional information as to why the PAResStatus has a specific value. 

        :param signed_pares_status_reason: The signed_pares_status_reason of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._signed_pares_status_reason = signed_pares_status_reason

    @property
    def specification_version(self):
        """
        Gets the specification_version of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 

        :return: The specification_version of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._specification_version

    @specification_version.setter
    def specification_version(self, specification_version):
        """
        Sets the specification_version of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 

        :param specification_version: The specification_version of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._specification_version = specification_version

    @property
    def step_up_url(self):
        """
        Gets the step_up_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The fully qualified URL that the merchant uses to post a form to the cardholder in order to complete the Consumer Authentication transaction for the Cardinal Cruise API integration. 

        :return: The step_up_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._step_up_url

    @step_up_url.setter
    def step_up_url(self, step_up_url):
        """
        Sets the step_up_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The fully qualified URL that the merchant uses to post a form to the cardholder in order to complete the Consumer Authentication transaction for the Cardinal Cruise API integration. 

        :param step_up_url: The step_up_url of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._step_up_url = step_up_url

    @property
    def three_ds_server_transaction_id(self):
        """
        Gets the three_ds_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 

        :return: The three_ds_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._three_ds_server_transaction_id

    @three_ds_server_transaction_id.setter
    def three_ds_server_transaction_id(self, three_ds_server_transaction_id):
        """
        Sets the three_ds_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 

        :param three_ds_server_transaction_id: The three_ds_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._three_ds_server_transaction_id = three_ds_server_transaction_id

    @property
    def ucaf_authentication_data(self):
        """
        Gets the ucaf_authentication_data of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 

        :return: The ucaf_authentication_data of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ucaf_authentication_data

    @ucaf_authentication_data.setter
    def ucaf_authentication_data(self, ucaf_authentication_data):
        """
        Sets the ucaf_authentication_data of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 

        :param ucaf_authentication_data: The ucaf_authentication_data of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._ucaf_authentication_data = ucaf_authentication_data

    @property
    def ucaf_collection_indicator(self):
        """
        Gets the ucaf_collection_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. 

        :return: The ucaf_collection_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ucaf_collection_indicator

    @ucaf_collection_indicator.setter
    def ucaf_collection_indicator(self, ucaf_collection_indicator):
        """
        Sets the ucaf_collection_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. 

        :param ucaf_collection_indicator: The ucaf_collection_indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._ucaf_collection_indicator = ucaf_collection_indicator

    @property
    def veres_enrolled(self):
        """
        Gets the veres_enrolled of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Result of the enrollment check. This field can contain one of these values: - `Y`: Card enrolled or can be enrolled; you must authenticate. Liability shift. - `N`: Card not enrolled; proceed with authorization. Liability shift. - `U`: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - `B`: Indicates that authentication was bypassed.  For details, see `pa_enroll_veres_enrolled` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 

        :return: The veres_enrolled of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._veres_enrolled

    @veres_enrolled.setter
    def veres_enrolled(self, veres_enrolled):
        """
        Sets the veres_enrolled of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Result of the enrollment check. This field can contain one of these values: - `Y`: Card enrolled or can be enrolled; you must authenticate. Liability shift. - `N`: Card not enrolled; proceed with authorization. Liability shift. - `U`: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - `B`: Indicates that authentication was bypassed.  For details, see `pa_enroll_veres_enrolled` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 

        :param veres_enrolled: The veres_enrolled of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._veres_enrolled = veres_enrolled

    @property
    def white_list_status_source(self):
        """
        Gets the white_list_status_source of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 

        :return: The white_list_status_source of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status_source

    @white_list_status_source.setter
    def white_list_status_source(self, white_list_status_source):
        """
        Sets the white_list_status_source of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 

        :param white_list_status_source: The white_list_status_source of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._white_list_status_source = white_list_status_source

    @property
    def xid(self):
        """
        Gets the xid of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) 

        :return: The xid of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._xid

    @xid.setter
    def xid(self, xid):
        """
        Sets the xid of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) 

        :param xid: The xid of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._xid = xid

    @property
    def directory_server_transaction_id(self):
        """
        Gets the directory_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 

        :return: The directory_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_transaction_id

    @directory_server_transaction_id.setter
    def directory_server_transaction_id(self, directory_server_transaction_id):
        """
        Sets the directory_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 

        :param directory_server_transaction_id: The directory_server_transaction_id of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._directory_server_transaction_id = directory_server_transaction_id

    @property
    def authentication_result(self):
        """
        Gets the authentication_result of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Raw authentication data that comes from the cardissuing bank. Primary authentication field that indicates if authentication was successful and if liability shift occurred. You should examine first the result of this field. This field contains one of these values: - `-1`: Invalid PARes. - `0`: Successful validation. - `1`: Cardholder is not participating, but the attempt to authenticate was recorded. - `6`: Issuer unable to perform authentication. - `9`: Cardholder did not complete authentication. 

        :return: The authentication_result of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_result

    @authentication_result.setter
    def authentication_result(self, authentication_result):
        """
        Sets the authentication_result of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Raw authentication data that comes from the cardissuing bank. Primary authentication field that indicates if authentication was successful and if liability shift occurred. You should examine first the result of this field. This field contains one of these values: - `-1`: Invalid PARes. - `0`: Successful validation. - `1`: Cardholder is not participating, but the attempt to authenticate was recorded. - `6`: Issuer unable to perform authentication. - `9`: Cardholder did not complete authentication. 

        :param authentication_result: The authentication_result of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_result = authentication_result

    @property
    def authentication_status_msg(self):
        """
        Gets the authentication_status_msg of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Message that explains the authenticationResult reply field. 

        :return: The authentication_status_msg of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_status_msg

    @authentication_status_msg.setter
    def authentication_status_msg(self, authentication_status_msg):
        """
        Sets the authentication_status_msg of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Message that explains the authenticationResult reply field. 

        :param authentication_status_msg: The authentication_status_msg of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_status_msg = authentication_status_msg

    @property
    def indicator(self):
        """
        Gets the indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicator used to differentiate Internet transactions from other types. The authentication failed if this field is not returned. For Visa, if your payment processor is Streamline, Barclays, AIBMS, or FDC Germany, you receive the value vbv_failure instead of internet when eci is 07. The value of this field is passed automatically to the authorization service if you request the services together. This field contains one of these values: - `aesk`: American Express SafeKey authentication verified successfully. - `aesk_attempted`: Card not enrolled in American Express SafeKey, but the attempt to authenticate was recorded. - `dipb`: Discover ProtectBuy authentication verified successfully. - `dipb_attempted`: Card not enrolled in Discover ProtectBuy, but the attempt to authenticate was recorded. - `internet`: Authentication was not verified successfully. - `js`: J/Secure authentication verified successfully. - `js_attempted`: Card not enrolled in J/Secure, but the attempt to authenticate was recorded. - `moto`: Mail or telephone order. - `pb_attempted`: Card not enrolled in Diners Club ProtectBuy, but the attempt to authenticate was recorded. - `recurring`: Recurring transaction. - `spa`: Mastercard Identity Check authentication verified successfully. - `spa_failure`: Mastercard Identity Check failed authentication. - `vbv`: Visa Secure authentication verified successfully. - `vbv_attempted`: Card not enrolled in Visa Secure, but the attempt to authenticate was recorded. - `vbv_failure`: Visa Secure authentication unavailable. 

        :return: The indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._indicator

    @indicator.setter
    def indicator(self, indicator):
        """
        Sets the indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicator used to differentiate Internet transactions from other types. The authentication failed if this field is not returned. For Visa, if your payment processor is Streamline, Barclays, AIBMS, or FDC Germany, you receive the value vbv_failure instead of internet when eci is 07. The value of this field is passed automatically to the authorization service if you request the services together. This field contains one of these values: - `aesk`: American Express SafeKey authentication verified successfully. - `aesk_attempted`: Card not enrolled in American Express SafeKey, but the attempt to authenticate was recorded. - `dipb`: Discover ProtectBuy authentication verified successfully. - `dipb_attempted`: Card not enrolled in Discover ProtectBuy, but the attempt to authenticate was recorded. - `internet`: Authentication was not verified successfully. - `js`: J/Secure authentication verified successfully. - `js_attempted`: Card not enrolled in J/Secure, but the attempt to authenticate was recorded. - `moto`: Mail or telephone order. - `pb_attempted`: Card not enrolled in Diners Club ProtectBuy, but the attempt to authenticate was recorded. - `recurring`: Recurring transaction. - `spa`: Mastercard Identity Check authentication verified successfully. - `spa_failure`: Mastercard Identity Check failed authentication. - `vbv`: Visa Secure authentication verified successfully. - `vbv_attempted`: Card not enrolled in Visa Secure, but the attempt to authenticate was recorded. - `vbv_failure`: Visa Secure authentication unavailable. 

        :param indicator: The indicator of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._indicator = indicator

    @property
    def interaction_counter(self):
        """
        Gets the interaction_counter of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. 

        :return: The interaction_counter of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._interaction_counter

    @interaction_counter.setter
    def interaction_counter(self, interaction_counter):
        """
        Sets the interaction_counter of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Indicates the number of authentication cycles attempted by the cardholder and is tracked by the Issuing Banks ACS.Example: if customer gets the challenge window and enter in their one time password and hit submit then that interaction counter should just be 1. When customer gets the challenge window and the bank asks if they want to have the one time password  sent to their phone or their email and they have to choose before going to the next screen to enter in their one time password then this interaction count would be 2. One for the selection of how they want the one time password delivered and another with them actually entering in the one time password and hitting the submit button. 

        :param interaction_counter: The interaction_counter of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._interaction_counter = interaction_counter

    @property
    def white_list_status(self):
        """
        Gets the white_list_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :return: The white_list_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status

    @white_list_status.setter
    def white_list_status(self, white_list_status):
        """
        Sets the white_list_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :param white_list_status: The white_list_status of this PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._white_list_status = white_list_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PtsV2PaymentsPost201ResponseConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
