# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory

from ..utilities.tracking.sdk_tracker import SdkTracker
class InstrumentIdentifierApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def delete_instrument_identifier(self, instrument_identifier_id, **kwargs):
        """
        Delete an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing <br>and account numbers.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the <br>Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) <br>or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Deleting an Instrument Identifier**<br>Your system can use this API to delete an existing Instrument Identifier.<br>An Instrument Identifier cannot be deleted if it is linked to any Payment Instruments.<br>You can [retrieve all Payment Instruments associated with an Instrument Identifier](#token-management_instrument-identifier_list-payment-instruments-for-an-instrument-identifier). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_instrument_identifier(instrument_identifier_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `delete_instrument_identifier` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_instrument_identifier_with_http_info(instrument_identifier_id, **kwargs)
        else:
            (data) = self.delete_instrument_identifier_with_http_info(instrument_identifier_id, **kwargs)
            return data

    def delete_instrument_identifier_with_http_info(self, instrument_identifier_id, **kwargs):
        """
        Delete an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing <br>and account numbers.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the <br>Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) <br>or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Deleting an Instrument Identifier**<br>Your system can use this API to delete an existing Instrument Identifier.<br>An Instrument Identifier cannot be deleted if it is linked to any Payment Instruments.<br>You can [retrieve all Payment Instruments associated with an Instrument Identifier](#token-management_instrument-identifier_list-payment-instruments-for-an-instrument-identifier). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_instrument_identifier_with_http_info(instrument_identifier_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_identifier_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrument_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_identifier_id' is set
        if ('instrument_identifier_id' not in params) or (params['instrument_identifier_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `instrument_identifier_id` when calling `delete_instrument_identifier`")
            raise ValueError("Missing the required parameter `instrument_identifier_id` when calling `delete_instrument_identifier`")

        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `delete_instrument_identifier`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `delete_instrument_identifier`, length must be less than or equal to `32`")
        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) < 12:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `delete_instrument_identifier`, length must be greater than or equal to `12`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `delete_instrument_identifier`, length must be greater than or equal to `12`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `delete_instrument_identifier`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `delete_instrument_identifier`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `delete_instrument_identifier`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `delete_instrument_identifier`, length must be greater than or equal to `36`")

        collection_formats = {}

        path_params = {}
        if 'instrument_identifier_id' in params:
            path_params['instrumentIdentifierId'] = params['instrument_identifier_id']
            instrumentIdentifierId=instrument_identifier_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'DELETE' in ('POST'):
            body_params = '{}'
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v1/instrumentidentifiers/{instrumentIdentifierId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_instrument_identifier(self, instrument_identifier_id, **kwargs):
        """
        Retrieve an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).<br><br>**Retrieving an Instrument Identifier**<br>Your system can use this API to retrieve an Instrument Identifier.<br>**Note: the actual card data will be masked.**<br>The Instrument Identifier will also be returned when retrieving a [Customer](#token-management_customer_retrieve-a-customer), [Customer Payment Instrument](#token-management_customer-payment-instrument_retrieve-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_retrieve-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Payment Network Tokens**<br>Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.<br>A Payment Network Token will be automatically created and used in future payments if you are enabled for the service.<br>A Payment Network Token can also be [provisioned for an existing Instrument Identifier](#token-management_instrument-identifier_enroll-an-instrument-identifier-for-payment-network-token).<br>For more information about Payment Network Tokens see the Developer Guide.<br><br>**Payments with Instrument Identifiers**<br>To perform a payment with an Instrument Identifier simply specify the [Instrument Identifier Id in the payments request along with the expiration date, card type, & billing address](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-using-tokens_authorization-with-instrument-identifier-token-id_liveconsole-tab-request-body).<br>When an Instrument Identifier is used in a payment the **_previousTransactionId_** and **_originalAuthorizedAmount_** values are automatically recorded.<br>These values will be added for you to future Merchant Initiated Transaction payments. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instrument_identifier(instrument_identifier_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_instrument_identifier` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_instrument_identifier_with_http_info(instrument_identifier_id, **kwargs)
        else:
            (data) = self.get_instrument_identifier_with_http_info(instrument_identifier_id, **kwargs)
            return data

    def get_instrument_identifier_with_http_info(self, instrument_identifier_id, **kwargs):
        """
        Retrieve an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).<br><br>**Retrieving an Instrument Identifier**<br>Your system can use this API to retrieve an Instrument Identifier.<br>**Note: the actual card data will be masked.**<br>The Instrument Identifier will also be returned when retrieving a [Customer](#token-management_customer_retrieve-a-customer), [Customer Payment Instrument](#token-management_customer-payment-instrument_retrieve-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_retrieve-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Payment Network Tokens**<br>Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.<br>A Payment Network Token will be automatically created and used in future payments if you are enabled for the service.<br>A Payment Network Token can also be [provisioned for an existing Instrument Identifier](#token-management_instrument-identifier_enroll-an-instrument-identifier-for-payment-network-token).<br>For more information about Payment Network Tokens see the Developer Guide.<br><br>**Payments with Instrument Identifiers**<br>To perform a payment with an Instrument Identifier simply specify the [Instrument Identifier Id in the payments request along with the expiration date, card type, & billing address](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-using-tokens_authorization-with-instrument-identifier-token-id_liveconsole-tab-request-body).<br>When an Instrument Identifier is used in a payment the **_previousTransactionId_** and **_originalAuthorizedAmount_** values are automatically recorded.<br>These values will be added for you to future Merchant Initiated Transaction payments. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instrument_identifier_with_http_info(instrument_identifier_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_identifier_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_identifier_id' is set
        if ('instrument_identifier_id' not in params) or (params['instrument_identifier_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `instrument_identifier_id` when calling `get_instrument_identifier`")
            raise ValueError("Missing the required parameter `instrument_identifier_id` when calling `get_instrument_identifier`")

        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier`, length must be less than or equal to `32`")
        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) < 12:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier`, length must be greater than or equal to `12`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier`, length must be greater than or equal to `12`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `get_instrument_identifier`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `get_instrument_identifier`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `get_instrument_identifier`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `get_instrument_identifier`, length must be greater than or equal to `36`")

        collection_formats = {}

        path_params = {}
        if 'instrument_identifier_id' in params:
            path_params['instrumentIdentifierId'] = params['instrument_identifier_id']
            instrumentIdentifierId=instrument_identifier_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v1/instrumentidentifiers/{instrumentIdentifierId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_instrument_identifier_payment_instruments_list(self, instrument_identifier_id, **kwargs):
        """
        List Payment Instruments for an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing <br>and account numbers.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the <br>Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) <br>or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Retrieving all Payment Instruments associated with an Instrument Identifier**<br>Your system can use this API to retrieve all Payment Instruments linked to an Instrument Identifier. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instrument_identifier_payment_instruments_list(instrument_identifier_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param int offset: Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0.
        :param int limit: The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100.
        :return: PaymentInstrumentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_instrument_identifier_payment_instruments_list` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_instrument_identifier_payment_instruments_list_with_http_info(instrument_identifier_id, **kwargs)
        else:
            (data) = self.get_instrument_identifier_payment_instruments_list_with_http_info(instrument_identifier_id, **kwargs)
            return data

    def get_instrument_identifier_payment_instruments_list_with_http_info(self, instrument_identifier_id, **kwargs):
        """
        List Payment Instruments for an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing <br>and account numbers.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the <br>Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) <br>or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Retrieving all Payment Instruments associated with an Instrument Identifier**<br>Your system can use this API to retrieve all Payment Instruments linked to an Instrument Identifier. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instrument_identifier_payment_instruments_list_with_http_info(instrument_identifier_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param int offset: Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0.
        :param int limit: The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100.
        :return: PaymentInstrumentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_identifier_id', 'profile_id', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_identifier_payment_instruments_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_identifier_id' is set
        if ('instrument_identifier_id' not in params) or (params['instrument_identifier_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `instrument_identifier_id` when calling `get_instrument_identifier_payment_instruments_list`")
            raise ValueError("Missing the required parameter `instrument_identifier_id` when calling `get_instrument_identifier_payment_instruments_list`")

        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be less than or equal to `32`")
        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) < 12:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be greater than or equal to `12`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be greater than or equal to `12`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `get_instrument_identifier_payment_instruments_list`, length must be greater than or equal to `36`")
        if 'offset' in params and params['offset'] < 0:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `offset` when calling `get_instrument_identifier_payment_instruments_list`, must be a value greater than or equal to `0`")
            raise ValueError("Invalid value for parameter `offset` when calling `get_instrument_identifier_payment_instruments_list`, must be a value greater than or equal to `0`")
        if 'limit' in params and params['limit'] > 100:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `limit` when calling `get_instrument_identifier_payment_instruments_list`, must be a value less than or equal to `100`")
            raise ValueError("Invalid value for parameter `limit` when calling `get_instrument_identifier_payment_instruments_list`, must be a value less than or equal to `100`")
        if 'limit' in params and params['limit'] < 1:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `limit` when calling `get_instrument_identifier_payment_instruments_list`, must be a value greater than or equal to `1`")
            raise ValueError("Invalid value for parameter `limit` when calling `get_instrument_identifier_payment_instruments_list`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'instrument_identifier_id' in params:
            path_params['instrumentIdentifierId'] = params['instrument_identifier_id']
            instrumentIdentifierId=instrument_identifier_id

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v1/instrumentidentifiers/{instrumentIdentifierId}/paymentinstruments', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PaymentInstrumentList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_instrument_identifier(self, instrument_identifier_id, patch_instrument_identifier_request, **kwargs):
        """
        Update an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Updating an Instrument Identifier**<br>When an Instrument Identifier is used in a payment the **_previousTransactionId_** and **_originalAuthorizedAmount_** values are automatically recorded.<br>These values will be added for you to future Merchant Initiated Transaction payments.<br>Your system can use this API to update these values. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_instrument_identifier(instrument_identifier_id, patch_instrument_identifier_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param PatchInstrumentIdentifierRequest patch_instrument_identifier_request: Specify the previous transaction Id to update. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param str if_match: Contains an ETag value from a GET request to make the request conditional.
        :return: Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `patch_instrument_identifier` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_instrument_identifier_with_http_info(instrument_identifier_id, patch_instrument_identifier_request, **kwargs)
        else:
            (data) = self.patch_instrument_identifier_with_http_info(instrument_identifier_id, patch_instrument_identifier_request, **kwargs)
            return data

    def patch_instrument_identifier_with_http_info(self, instrument_identifier_id, patch_instrument_identifier_request, **kwargs):
        """
        Update an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Updating an Instrument Identifier**<br>When an Instrument Identifier is used in a payment the **_previousTransactionId_** and **_originalAuthorizedAmount_** values are automatically recorded.<br>These values will be added for you to future Merchant Initiated Transaction payments.<br>Your system can use this API to update these values. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_instrument_identifier_with_http_info(instrument_identifier_id, patch_instrument_identifier_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param PatchInstrumentIdentifierRequest patch_instrument_identifier_request: Specify the previous transaction Id to update. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param str if_match: Contains an ETag value from a GET request to make the request conditional.
        :return: Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_identifier_id', 'patch_instrument_identifier_request', 'profile_id', 'if_match']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_instrument_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_identifier_id' is set
        if ('instrument_identifier_id' not in params) or (params['instrument_identifier_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `instrument_identifier_id` when calling `patch_instrument_identifier`")
            raise ValueError("Missing the required parameter `instrument_identifier_id` when calling `patch_instrument_identifier`")
        # verify the required parameter 'patch_instrument_identifier_request' is set
        if ('patch_instrument_identifier_request' not in params) or (params['patch_instrument_identifier_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `patch_instrument_identifier_request` when calling `patch_instrument_identifier`")
            raise ValueError("Missing the required parameter `patch_instrument_identifier_request` when calling `patch_instrument_identifier`")

        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `patch_instrument_identifier`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `patch_instrument_identifier`, length must be less than or equal to `32`")
        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) < 12:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `patch_instrument_identifier`, length must be greater than or equal to `12`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `patch_instrument_identifier`, length must be greater than or equal to `12`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `patch_instrument_identifier`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `patch_instrument_identifier`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `patch_instrument_identifier`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `patch_instrument_identifier`, length must be greater than or equal to `36`")
        if 'if_match' in params and len(params['if_match']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `if_match` when calling `patch_instrument_identifier`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `if_match` when calling `patch_instrument_identifier`, length must be less than or equal to `32`")
        if 'if_match' in params and len(params['if_match']) < 1:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `if_match` when calling `patch_instrument_identifier`, length must be greater than or equal to `1`")
            raise ValueError("Invalid value for parameter `if_match` when calling `patch_instrument_identifier`, length must be greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'instrument_identifier_id' in params:
            path_params['instrumentIdentifierId'] = params['instrument_identifier_id']
            instrumentIdentifierId=instrument_identifier_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']
        if 'if_match' in params:
            header_params['if-match'] = params['if_match']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_instrument_identifier_request' in params:
            body_params = params['patch_instrument_identifier_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'patch_instrument_identifier_request', self.api_client.mconfig.run_environment)
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v1/instrumentidentifiers/{instrumentIdentifierId}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_instrument_identifier(self, post_instrument_identifier_request, **kwargs):
        """
        Create an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).<br><br>**Creating an Instrument Identifier**<br>It is recommended you [create an Instrument Identifier via a Payment Authorization](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-instrument-identifier-token-creation_liveconsole-tab-request-body), this can be for a zero amount.<br>An Instrument Identifier will also be created if you [create a Customer via a Payment Authorization](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-customer-token-creation_liveconsole-tab-request-body)<br>In Europe: You should perform Payer Authentication alongside the Authorization.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Payment Network Tokens**<br>Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.<br>A Payment Network Token will be automatically created and used in future payments if you are enabled for the service.<br>A Payment Network Token can also be [provisioned for an existing Instrument Identifier](#token-management_instrument-identifier_enroll-an-instrument-identifier-for-payment-network-token).<br>For more information about Payment Network Tokens see the Developer Guide.<br><br>**Payments with Instrument Identifiers**<br>To perform a payment with an Instrument Identifier simply specify the [Instrument Identifier Id in the payments request along with the expiration date, card type, & billing address](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-using-tokens_authorization-with-instrument-identifier-token-id_liveconsole-tab-request-body).<br>When an Instrument Identifier is used in a payment the **_previousTransactionId_** and **_originalAuthorizedAmount_** values are automatically recorded.<br>These values will be added for you to future Merchant Initiated Transaction payments. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_instrument_identifier(post_instrument_identifier_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PostInstrumentIdentifierRequest post_instrument_identifier_request: Specify either a Card, Bank Account or Enrollable Card (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `post_instrument_identifier` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_instrument_identifier_with_http_info(post_instrument_identifier_request, **kwargs)
        else:
            (data) = self.post_instrument_identifier_with_http_info(post_instrument_identifier_request, **kwargs)
            return data

    def post_instrument_identifier_with_http_info(self, post_instrument_identifier_request, **kwargs):
        """
        Create an Instrument Identifier
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).<br><br>**Creating an Instrument Identifier**<br>It is recommended you [create an Instrument Identifier via a Payment Authorization](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-instrument-identifier-token-creation_liveconsole-tab-request-body), this can be for a zero amount.<br>An Instrument Identifier will also be created if you [create a Customer via a Payment Authorization](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-customer-token-creation_liveconsole-tab-request-body)<br>In Europe: You should perform Payer Authentication alongside the Authorization.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Payment Network Tokens**<br>Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.<br>A Payment Network Token will be automatically created and used in future payments if you are enabled for the service.<br>A Payment Network Token can also be [provisioned for an existing Instrument Identifier](#token-management_instrument-identifier_enroll-an-instrument-identifier-for-payment-network-token).<br>For more information about Payment Network Tokens see the Developer Guide.<br><br>**Payments with Instrument Identifiers**<br>To perform a payment with an Instrument Identifier simply specify the [Instrument Identifier Id in the payments request along with the expiration date, card type, & billing address](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-using-tokens_authorization-with-instrument-identifier-token-id_liveconsole-tab-request-body).<br>When an Instrument Identifier is used in a payment the **_previousTransactionId_** and **_originalAuthorizedAmount_** values are automatically recorded.<br>These values will be added for you to future Merchant Initiated Transaction payments. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_instrument_identifier_with_http_info(post_instrument_identifier_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PostInstrumentIdentifierRequest post_instrument_identifier_request: Specify either a Card, Bank Account or Enrollable Card (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['post_instrument_identifier_request', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_instrument_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'post_instrument_identifier_request' is set
        if ('post_instrument_identifier_request' not in params) or (params['post_instrument_identifier_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `post_instrument_identifier_request` when calling `post_instrument_identifier`")
            raise ValueError("Missing the required parameter `post_instrument_identifier_request` when calling `post_instrument_identifier`")

        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `post_instrument_identifier`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `post_instrument_identifier`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `post_instrument_identifier`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `post_instrument_identifier`, length must be greater than or equal to `36`")

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_instrument_identifier_request' in params:
            body_params = params['post_instrument_identifier_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'post_instrument_identifier_request', self.api_client.mconfig.run_environment)
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v1/instrumentidentifiers', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Tmsv2customersEmbeddedDefaultPaymentInstrumentEmbeddedInstrumentIdentifier',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_instrument_identifier_enrollment(self, instrument_identifier_id, post_instrument_identifier_enrollment_request, **kwargs):
        """
        Enroll an Instrument Identifier for Payment Network Token
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Enroll an Instrument Identifier for a Payment Network Token**<br>Your system can use this API to provision a Network token for an existing Instrument Identifier.<br>Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.<br>A Network token can be [provisioned when creating an Instrument Identifier](#token-management_instrument-identifier_create-an-instrument-identifier_samplerequests-dropdown_create-instrument-identifier-card-enroll-for-network-token_liveconsole-tab-request-body).This will occur automatically when creating a [Customer](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-customer-token-creation_liveconsole-tab-request-body), [Payment Instrument](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-create-default-payment-instrument-shipping-address-for-existing-customer_liveconsole-tab-request-body) or [Instrument Identifier](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-instrument-identifier-token-creation_liveconsole-tab-request-body) via the Payments API.<br>For more information about Payment Network Tokens see the Developer Guide. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_instrument_identifier_enrollment(instrument_identifier_id, post_instrument_identifier_enrollment_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param PostInstrumentIdentifierEnrollmentRequest post_instrument_identifier_enrollment_request: Specify Enrollable Card details (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `post_instrument_identifier_enrollment` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_instrument_identifier_enrollment_with_http_info(instrument_identifier_id, post_instrument_identifier_enrollment_request, **kwargs)
        else:
            (data) = self.post_instrument_identifier_enrollment_with_http_info(instrument_identifier_id, post_instrument_identifier_enrollment_request, **kwargs)
            return data

    def post_instrument_identifier_enrollment_with_http_info(self, instrument_identifier_id, post_instrument_identifier_enrollment_request, **kwargs):
        """
        Enroll an Instrument Identifier for Payment Network Token
        |  |  |  | | --- | --- | --- | |**Instrument Identifiers**<br>An Instrument Identifier represents either a card number, or in the case of an ACH bank account, the routing and account number.<br>The same token Id is returned for a specific card number or bank account & routing number allowing the Instrument Identifier Id to be used for cross-channel payment tracking.<br>An Instrument Identifier can exist independently but also be associated with a [Customer Payment Instrument](#token-management_customer-payment-instrument_create-a-customer-payment-instrument) or [Standalone Payment Instrument](#token-management_payment-instrument_create-a-payment-instrument).|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Enroll an Instrument Identifier for a Payment Network Token**<br>Your system can use this API to provision a Network token for an existing Instrument Identifier.<br>Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.<br>A Network token can be [provisioned when creating an Instrument Identifier](#token-management_instrument-identifier_create-an-instrument-identifier_samplerequests-dropdown_create-instrument-identifier-card-enroll-for-network-token_liveconsole-tab-request-body).This will occur automatically when creating a [Customer](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-customer-token-creation_liveconsole-tab-request-body), [Payment Instrument](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-create-default-payment-instrument-shipping-address-for-existing-customer_liveconsole-tab-request-body) or [Instrument Identifier](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-with-instrument-identifier-token-creation_liveconsole-tab-request-body) via the Payments API.<br>For more information about Payment Network Tokens see the Developer Guide. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_instrument_identifier_enrollment_with_http_info(instrument_identifier_id, post_instrument_identifier_enrollment_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instrument_identifier_id: The Id of an Instrument Identifier. (required)
        :param PostInstrumentIdentifierEnrollmentRequest post_instrument_identifier_enrollment_request: Specify Enrollable Card details (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_identifier_id', 'post_instrument_identifier_enrollment_request', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_instrument_identifier_enrollment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_identifier_id' is set
        if ('instrument_identifier_id' not in params) or (params['instrument_identifier_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `instrument_identifier_id` when calling `post_instrument_identifier_enrollment`")
            raise ValueError("Missing the required parameter `instrument_identifier_id` when calling `post_instrument_identifier_enrollment`")
        # verify the required parameter 'post_instrument_identifier_enrollment_request' is set
        if ('post_instrument_identifier_enrollment_request' not in params) or (params['post_instrument_identifier_enrollment_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `post_instrument_identifier_enrollment_request` when calling `post_instrument_identifier_enrollment`")
            raise ValueError("Missing the required parameter `post_instrument_identifier_enrollment_request` when calling `post_instrument_identifier_enrollment`")

        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `post_instrument_identifier_enrollment`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `post_instrument_identifier_enrollment`, length must be less than or equal to `32`")
        if 'instrument_identifier_id' in params and len(params['instrument_identifier_id']) < 12:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `instrument_identifier_id` when calling `post_instrument_identifier_enrollment`, length must be greater than or equal to `12`")
            raise ValueError("Invalid value for parameter `instrument_identifier_id` when calling `post_instrument_identifier_enrollment`, length must be greater than or equal to `12`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `post_instrument_identifier_enrollment`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `post_instrument_identifier_enrollment`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `post_instrument_identifier_enrollment`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `post_instrument_identifier_enrollment`, length must be greater than or equal to `36`")

        collection_formats = {}

        path_params = {}
        if 'instrument_identifier_id' in params:
            path_params['instrumentIdentifierId'] = params['instrument_identifier_id']
            instrumentIdentifierId=instrument_identifier_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_instrument_identifier_enrollment_request' in params:
            body_params = params['post_instrument_identifier_enrollment_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'post_instrument_identifier_enrollment_request', self.api_client.mconfig.run_environment)
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v1/instrumentidentifiers/{instrumentIdentifierId}/enrollment', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
