# coding: utf-8

"""
    CyberSource Flex API

    Simple PAN tokenization service

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Ptsv2creditsPointOfSaleInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'emv': 'Ptsv2creditsPointOfSaleInformationEmv',
        'partner_sdk_version': 'str',
        'store_and_forward_indicator': 'str',
        'cardholder_verification_method': 'list[str]',
        'terminal_input_capability': 'list[str]',
        'terminal_serial_number': 'str',
        'terminal_card_capture_capability': 'str',
        'terminal_output_capability': 'str',
        'terminal_pin_capability': 'int',
        'device_id': 'str'
    }

    attribute_map = {
        'emv': 'emv',
        'partner_sdk_version': 'partnerSdkVersion',
        'store_and_forward_indicator': 'storeAndForwardIndicator',
        'cardholder_verification_method': 'cardholderVerificationMethod',
        'terminal_input_capability': 'terminalInputCapability',
        'terminal_serial_number': 'terminalSerialNumber',
        'terminal_card_capture_capability': 'terminalCardCaptureCapability',
        'terminal_output_capability': 'terminalOutputCapability',
        'terminal_pin_capability': 'terminalPinCapability',
        'device_id': 'deviceId'
    }

    def __init__(self, emv=None, partner_sdk_version=None, store_and_forward_indicator=None, cardholder_verification_method=None, terminal_input_capability=None, terminal_serial_number=None, terminal_card_capture_capability=None, terminal_output_capability=None, terminal_pin_capability=None, device_id=None):
        """
        Ptsv2creditsPointOfSaleInformation - a model defined in Swagger
        """

        self._emv = None
        self._partner_sdk_version = None
        self._store_and_forward_indicator = None
        self._cardholder_verification_method = None
        self._terminal_input_capability = None
        self._terminal_serial_number = None
        self._terminal_card_capture_capability = None
        self._terminal_output_capability = None
        self._terminal_pin_capability = None
        self._device_id = None

        if emv is not None:
          self.emv = emv
        if partner_sdk_version is not None:
          self.partner_sdk_version = partner_sdk_version
        if store_and_forward_indicator is not None:
          self.store_and_forward_indicator = store_and_forward_indicator
        if cardholder_verification_method is not None:
          self.cardholder_verification_method = cardholder_verification_method
        if terminal_input_capability is not None:
          self.terminal_input_capability = terminal_input_capability
        if terminal_serial_number is not None:
          self.terminal_serial_number = terminal_serial_number
        if terminal_card_capture_capability is not None:
          self.terminal_card_capture_capability = terminal_card_capture_capability
        if terminal_output_capability is not None:
          self.terminal_output_capability = terminal_output_capability
        if terminal_pin_capability is not None:
          self.terminal_pin_capability = terminal_pin_capability
        if device_id is not None:
          self.device_id = device_id

    @property
    def emv(self):
        """
        Gets the emv of this Ptsv2creditsPointOfSaleInformation.

        :return: The emv of this Ptsv2creditsPointOfSaleInformation.
        :rtype: Ptsv2creditsPointOfSaleInformationEmv
        """
        return self._emv

    @emv.setter
    def emv(self, emv):
        """
        Sets the emv of this Ptsv2creditsPointOfSaleInformation.

        :param emv: The emv of this Ptsv2creditsPointOfSaleInformation.
        :type: Ptsv2creditsPointOfSaleInformationEmv
        """

        self._emv = emv

    @property
    def partner_sdk_version(self):
        """
        Gets the partner_sdk_version of this Ptsv2creditsPointOfSaleInformation.
        Version of the software installed on the POS terminal. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The partner_sdk_version of this Ptsv2creditsPointOfSaleInformation.
        :rtype: str
        """
        return self._partner_sdk_version

    @partner_sdk_version.setter
    def partner_sdk_version(self, partner_sdk_version):
        """
        Sets the partner_sdk_version of this Ptsv2creditsPointOfSaleInformation.
        Version of the software installed on the POS terminal. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param partner_sdk_version: The partner_sdk_version of this Ptsv2creditsPointOfSaleInformation.
        :type: str
        """
        if partner_sdk_version is not None and len(partner_sdk_version) > 32:
            raise ValueError("Invalid value for `partner_sdk_version`, length must be less than or equal to `32`")

        self._partner_sdk_version = partner_sdk_version

    @property
    def store_and_forward_indicator(self):
        """
        Gets the store_and_forward_indicator of this Ptsv2creditsPointOfSaleInformation.
        When connectivity is unavailable, the client software that is installed on the POS terminal can store a transaction in its memory and send it for authorization when connectivity is restored. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  Possible values: - Y: Transaction was stored and then forwarded. - N (default): Transaction was not stored and then forwarded.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The store_and_forward_indicator of this Ptsv2creditsPointOfSaleInformation.
        :rtype: str
        """
        return self._store_and_forward_indicator

    @store_and_forward_indicator.setter
    def store_and_forward_indicator(self, store_and_forward_indicator):
        """
        Sets the store_and_forward_indicator of this Ptsv2creditsPointOfSaleInformation.
        When connectivity is unavailable, the client software that is installed on the POS terminal can store a transaction in its memory and send it for authorization when connectivity is restored. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  Possible values: - Y: Transaction was stored and then forwarded. - N (default): Transaction was not stored and then forwarded.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param store_and_forward_indicator: The store_and_forward_indicator of this Ptsv2creditsPointOfSaleInformation.
        :type: str
        """
        if store_and_forward_indicator is not None and len(store_and_forward_indicator) > 1:
            raise ValueError("Invalid value for `store_and_forward_indicator`, length must be less than or equal to `1`")

        self._store_and_forward_indicator = store_and_forward_indicator

    @property
    def cardholder_verification_method(self):
        """
        Gets the cardholder_verification_method of this Ptsv2creditsPointOfSaleInformation.

        :return: The cardholder_verification_method of this Ptsv2creditsPointOfSaleInformation.
        :rtype: list[str]
        """
        return self._cardholder_verification_method

    @cardholder_verification_method.setter
    def cardholder_verification_method(self, cardholder_verification_method):
        """
        Sets the cardholder_verification_method of this Ptsv2creditsPointOfSaleInformation.

        :param cardholder_verification_method: The cardholder_verification_method of this Ptsv2creditsPointOfSaleInformation.
        :type: list[str]
        """

        self._cardholder_verification_method = cardholder_verification_method

    @property
    def terminal_input_capability(self):
        """
        Gets the terminal_input_capability of this Ptsv2creditsPointOfSaleInformation.

        :return: The terminal_input_capability of this Ptsv2creditsPointOfSaleInformation.
        :rtype: list[str]
        """
        return self._terminal_input_capability

    @terminal_input_capability.setter
    def terminal_input_capability(self, terminal_input_capability):
        """
        Sets the terminal_input_capability of this Ptsv2creditsPointOfSaleInformation.

        :param terminal_input_capability: The terminal_input_capability of this Ptsv2creditsPointOfSaleInformation.
        :type: list[str]
        """

        self._terminal_input_capability = terminal_input_capability

    @property
    def terminal_serial_number(self):
        """
        Gets the terminal_serial_number of this Ptsv2creditsPointOfSaleInformation.
        Terminal serial number assigned by the hardware manufacturer. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The terminal_serial_number of this Ptsv2creditsPointOfSaleInformation.
        :rtype: str
        """
        return self._terminal_serial_number

    @terminal_serial_number.setter
    def terminal_serial_number(self, terminal_serial_number):
        """
        Sets the terminal_serial_number of this Ptsv2creditsPointOfSaleInformation.
        Terminal serial number assigned by the hardware manufacturer. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param terminal_serial_number: The terminal_serial_number of this Ptsv2creditsPointOfSaleInformation.
        :type: str
        """
        if terminal_serial_number is not None and len(terminal_serial_number) > 32:
            raise ValueError("Invalid value for `terminal_serial_number`, length must be less than or equal to `32`")

        self._terminal_serial_number = terminal_serial_number

    @property
    def terminal_card_capture_capability(self):
        """
        Gets the terminal_card_capture_capability of this Ptsv2creditsPointOfSaleInformation.
        Indicates whether the terminal can capture the card.  Possible values: - 1: Terminal can capture card. - 0: Terminal cannot capture card.  This field is supported only on American Express Direct. 

        :return: The terminal_card_capture_capability of this Ptsv2creditsPointOfSaleInformation.
        :rtype: str
        """
        return self._terminal_card_capture_capability

    @terminal_card_capture_capability.setter
    def terminal_card_capture_capability(self, terminal_card_capture_capability):
        """
        Sets the terminal_card_capture_capability of this Ptsv2creditsPointOfSaleInformation.
        Indicates whether the terminal can capture the card.  Possible values: - 1: Terminal can capture card. - 0: Terminal cannot capture card.  This field is supported only on American Express Direct. 

        :param terminal_card_capture_capability: The terminal_card_capture_capability of this Ptsv2creditsPointOfSaleInformation.
        :type: str
        """
        if terminal_card_capture_capability is not None and len(terminal_card_capture_capability) > 1:
            raise ValueError("Invalid value for `terminal_card_capture_capability`, length must be less than or equal to `1`")

        self._terminal_card_capture_capability = terminal_card_capture_capability

    @property
    def terminal_output_capability(self):
        """
        Gets the terminal_output_capability of this Ptsv2creditsPointOfSaleInformation.
        Indicates whether the terminal can print or display messages.  Possible values: - 1: Neither - 2: Print only - 3: Display only - 4: Print and display  This field is supported only on American Express Direct. 

        :return: The terminal_output_capability of this Ptsv2creditsPointOfSaleInformation.
        :rtype: str
        """
        return self._terminal_output_capability

    @terminal_output_capability.setter
    def terminal_output_capability(self, terminal_output_capability):
        """
        Sets the terminal_output_capability of this Ptsv2creditsPointOfSaleInformation.
        Indicates whether the terminal can print or display messages.  Possible values: - 1: Neither - 2: Print only - 3: Display only - 4: Print and display  This field is supported only on American Express Direct. 

        :param terminal_output_capability: The terminal_output_capability of this Ptsv2creditsPointOfSaleInformation.
        :type: str
        """
        if terminal_output_capability is not None and len(terminal_output_capability) > 1:
            raise ValueError("Invalid value for `terminal_output_capability`, length must be less than or equal to `1`")

        self._terminal_output_capability = terminal_output_capability

    @property
    def terminal_pin_capability(self):
        """
        Gets the terminal_pin_capability of this Ptsv2creditsPointOfSaleInformation.
        Maximum PIN length that the terminal can capture.  Possible values: -  0: No PIN capture capability -  1: PIN capture capability unknown -  4: Four characters -  5: Five characters -  6: Six characters -  7: Seven characters -  8: Eight characters -  9: Nine characters - 10: Ten characters - 11: Eleven characters - 12: Twelve characters  This field is supported only on American Express Direct and SIX. 

        :return: The terminal_pin_capability of this Ptsv2creditsPointOfSaleInformation.
        :rtype: int
        """
        return self._terminal_pin_capability

    @terminal_pin_capability.setter
    def terminal_pin_capability(self, terminal_pin_capability):
        """
        Sets the terminal_pin_capability of this Ptsv2creditsPointOfSaleInformation.
        Maximum PIN length that the terminal can capture.  Possible values: -  0: No PIN capture capability -  1: PIN capture capability unknown -  4: Four characters -  5: Five characters -  6: Six characters -  7: Seven characters -  8: Eight characters -  9: Nine characters - 10: Ten characters - 11: Eleven characters - 12: Twelve characters  This field is supported only on American Express Direct and SIX. 

        :param terminal_pin_capability: The terminal_pin_capability of this Ptsv2creditsPointOfSaleInformation.
        :type: int
        """

        self._terminal_pin_capability = terminal_pin_capability

    @property
    def device_id(self):
        """
        Gets the device_id of this Ptsv2creditsPointOfSaleInformation.
        Value created by the client software that uniquely identifies the POS device. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The device_id of this Ptsv2creditsPointOfSaleInformation.
        :rtype: str
        """
        return self._device_id

    @device_id.setter
    def device_id(self, device_id):
        """
        Sets the device_id of this Ptsv2creditsPointOfSaleInformation.
        Value created by the client software that uniquely identifies the POS device. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param device_id: The device_id of this Ptsv2creditsPointOfSaleInformation.
        :type: str
        """
        if device_id is not None and len(device_id) > 32:
            raise ValueError("Invalid value for `device_id`, length must be less than or equal to `32`")

        self._device_id = device_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2creditsPointOfSaleInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
