# coding: utf-8

"""
    CyberSource Flex API

    Simple PAN tokenization service

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsPointOfSaleInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'terminal_id': 'str',
        'terminal_serial_number': 'str',
        'lane_number': 'str',
        'cat_level': 'int',
        'entry_mode': 'str',
        'terminal_capability': 'int',
        'pin_entry_capability': 'int',
        'operating_environment': 'str',
        'emv': 'Ptsv2paymentsPointOfSaleInformationEmv',
        'amex_capn_data': 'str',
        'track_data': 'str',
        'store_and_forward_indicator': 'str',
        'cardholder_verification_method': 'list[str]',
        'terminal_input_capability': 'list[str]',
        'terminal_card_capture_capability': 'str',
        'terminal_output_capability': 'str',
        'terminal_pin_capability': 'int',
        'device_id': 'str',
        'pin_block_encoding_format': 'int',
        'encrypted_pin': 'str',
        'encrypted_key_serial_number': 'str',
        'partner_sdk_version': 'str'
    }

    attribute_map = {
        'terminal_id': 'terminalId',
        'terminal_serial_number': 'terminalSerialNumber',
        'lane_number': 'laneNumber',
        'cat_level': 'catLevel',
        'entry_mode': 'entryMode',
        'terminal_capability': 'terminalCapability',
        'pin_entry_capability': 'pinEntryCapability',
        'operating_environment': 'operatingEnvironment',
        'emv': 'emv',
        'amex_capn_data': 'amexCapnData',
        'track_data': 'trackData',
        'store_and_forward_indicator': 'storeAndForwardIndicator',
        'cardholder_verification_method': 'cardholderVerificationMethod',
        'terminal_input_capability': 'terminalInputCapability',
        'terminal_card_capture_capability': 'terminalCardCaptureCapability',
        'terminal_output_capability': 'terminalOutputCapability',
        'terminal_pin_capability': 'terminalPinCapability',
        'device_id': 'deviceId',
        'pin_block_encoding_format': 'pinBlockEncodingFormat',
        'encrypted_pin': 'encryptedPin',
        'encrypted_key_serial_number': 'encryptedKeySerialNumber',
        'partner_sdk_version': 'partnerSdkVersion'
    }

    def __init__(self, terminal_id=None, terminal_serial_number=None, lane_number=None, cat_level=None, entry_mode=None, terminal_capability=None, pin_entry_capability=None, operating_environment=None, emv=None, amex_capn_data=None, track_data=None, store_and_forward_indicator=None, cardholder_verification_method=None, terminal_input_capability=None, terminal_card_capture_capability=None, terminal_output_capability=None, terminal_pin_capability=None, device_id=None, pin_block_encoding_format=None, encrypted_pin=None, encrypted_key_serial_number=None, partner_sdk_version=None):
        """
        Ptsv2paymentsPointOfSaleInformation - a model defined in Swagger
        """

        self._terminal_id = None
        self._terminal_serial_number = None
        self._lane_number = None
        self._cat_level = None
        self._entry_mode = None
        self._terminal_capability = None
        self._pin_entry_capability = None
        self._operating_environment = None
        self._emv = None
        self._amex_capn_data = None
        self._track_data = None
        self._store_and_forward_indicator = None
        self._cardholder_verification_method = None
        self._terminal_input_capability = None
        self._terminal_card_capture_capability = None
        self._terminal_output_capability = None
        self._terminal_pin_capability = None
        self._device_id = None
        self._pin_block_encoding_format = None
        self._encrypted_pin = None
        self._encrypted_key_serial_number = None
        self._partner_sdk_version = None

        if terminal_id is not None:
          self.terminal_id = terminal_id
        if terminal_serial_number is not None:
          self.terminal_serial_number = terminal_serial_number
        if lane_number is not None:
          self.lane_number = lane_number
        if cat_level is not None:
          self.cat_level = cat_level
        if entry_mode is not None:
          self.entry_mode = entry_mode
        if terminal_capability is not None:
          self.terminal_capability = terminal_capability
        if pin_entry_capability is not None:
          self.pin_entry_capability = pin_entry_capability
        if operating_environment is not None:
          self.operating_environment = operating_environment
        if emv is not None:
          self.emv = emv
        if amex_capn_data is not None:
          self.amex_capn_data = amex_capn_data
        if track_data is not None:
          self.track_data = track_data
        if store_and_forward_indicator is not None:
          self.store_and_forward_indicator = store_and_forward_indicator
        if cardholder_verification_method is not None:
          self.cardholder_verification_method = cardholder_verification_method
        if terminal_input_capability is not None:
          self.terminal_input_capability = terminal_input_capability
        if terminal_card_capture_capability is not None:
          self.terminal_card_capture_capability = terminal_card_capture_capability
        if terminal_output_capability is not None:
          self.terminal_output_capability = terminal_output_capability
        if terminal_pin_capability is not None:
          self.terminal_pin_capability = terminal_pin_capability
        if device_id is not None:
          self.device_id = device_id
        if pin_block_encoding_format is not None:
          self.pin_block_encoding_format = pin_block_encoding_format
        if encrypted_pin is not None:
          self.encrypted_pin = encrypted_pin
        if encrypted_key_serial_number is not None:
          self.encrypted_key_serial_number = encrypted_key_serial_number
        if partner_sdk_version is not None:
          self.partner_sdk_version = partner_sdk_version

    @property
    def terminal_id(self):
        """
        Gets the terminal_id of this Ptsv2paymentsPointOfSaleInformation.
        Identifier for the terminal at your retail location. You can define this value yourself, but consult the processor for requirements.  For Payouts: This field is applicable for CtV. 

        :return: The terminal_id of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._terminal_id

    @terminal_id.setter
    def terminal_id(self, terminal_id):
        """
        Sets the terminal_id of this Ptsv2paymentsPointOfSaleInformation.
        Identifier for the terminal at your retail location. You can define this value yourself, but consult the processor for requirements.  For Payouts: This field is applicable for CtV. 

        :param terminal_id: The terminal_id of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if terminal_id is not None and len(terminal_id) > 8:
            raise ValueError("Invalid value for `terminal_id`, length must be less than or equal to `8`")

        self._terminal_id = terminal_id

    @property
    def terminal_serial_number(self):
        """
        Gets the terminal_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        Terminal serial number assigned by the hardware manufacturer. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The terminal_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._terminal_serial_number

    @terminal_serial_number.setter
    def terminal_serial_number(self, terminal_serial_number):
        """
        Sets the terminal_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        Terminal serial number assigned by the hardware manufacturer. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param terminal_serial_number: The terminal_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if terminal_serial_number is not None and len(terminal_serial_number) > 32:
            raise ValueError("Invalid value for `terminal_serial_number`, length must be less than or equal to `32`")

        self._terminal_serial_number = terminal_serial_number

    @property
    def lane_number(self):
        """
        Gets the lane_number of this Ptsv2paymentsPointOfSaleInformation.
        Identifier for an alternate terminal at your retail location. You define the value for this field.  This field is supported only for MasterCard transactions on FDC Nashville Global. Use the _terminalID_ field to identify the main terminal at your retail location. If your retail location has multiple terminals, use this _alternateTerminalID_ field to identify the terminal used for the transaction.  This field is a pass-through, which means that CyberSource does not check the value or modify the value in any way before sending it to the processor. 

        :return: The lane_number of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._lane_number

    @lane_number.setter
    def lane_number(self, lane_number):
        """
        Sets the lane_number of this Ptsv2paymentsPointOfSaleInformation.
        Identifier for an alternate terminal at your retail location. You define the value for this field.  This field is supported only for MasterCard transactions on FDC Nashville Global. Use the _terminalID_ field to identify the main terminal at your retail location. If your retail location has multiple terminals, use this _alternateTerminalID_ field to identify the terminal used for the transaction.  This field is a pass-through, which means that CyberSource does not check the value or modify the value in any way before sending it to the processor. 

        :param lane_number: The lane_number of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if lane_number is not None and len(lane_number) > 8:
            raise ValueError("Invalid value for `lane_number`, length must be less than or equal to `8`")

        self._lane_number = lane_number

    @property
    def cat_level(self):
        """
        Gets the cat_level of this Ptsv2paymentsPointOfSaleInformation.
        Type of cardholder-activated terminal. Possible values:   - 1: Automated dispensing machine  - 2: Self-service terminal  - 3: Limited amount terminal  - 4: In-flight commerce (IFC) terminal  - 5: Radio frequency device  - 6: Mobile acceptance terminal  - 7: Electronic cash register  - 8: E-commerce device at your location  - 9: Terminal or cash register that uses a dialup connection to connect to the transaction processing network  * Applicable only for CTV for Payouts. 

        :return: The cat_level of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: int
        """
        return self._cat_level

    @cat_level.setter
    def cat_level(self, cat_level):
        """
        Sets the cat_level of this Ptsv2paymentsPointOfSaleInformation.
        Type of cardholder-activated terminal. Possible values:   - 1: Automated dispensing machine  - 2: Self-service terminal  - 3: Limited amount terminal  - 4: In-flight commerce (IFC) terminal  - 5: Radio frequency device  - 6: Mobile acceptance terminal  - 7: Electronic cash register  - 8: E-commerce device at your location  - 9: Terminal or cash register that uses a dialup connection to connect to the transaction processing network  * Applicable only for CTV for Payouts. 

        :param cat_level: The cat_level of this Ptsv2paymentsPointOfSaleInformation.
        :type: int
        """
        if cat_level is not None and cat_level > 9:
            raise ValueError("Invalid value for `cat_level`, must be a value less than or equal to `9`")
        if cat_level is not None and cat_level < 1:
            raise ValueError("Invalid value for `cat_level`, must be a value greater than or equal to `1`")

        self._cat_level = cat_level

    @property
    def entry_mode(self):
        """
        Gets the entry_mode of this Ptsv2paymentsPointOfSaleInformation.
        Method of entering credit card information into the POS terminal. Possible values:   - contact: Read from direct contact with chip card.  - contactless: Read from a contactless interface using chip data.  - keyed: Manually keyed into POS terminal.  - msd: Read from a contactless interface using magnetic stripe data (MSD).  - swiped: Read from credit card magnetic stripe.  The contact, contactless, and msd values are supported only for EMV transactions. * Applicable only for CTV for Payouts. 

        :return: The entry_mode of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._entry_mode

    @entry_mode.setter
    def entry_mode(self, entry_mode):
        """
        Sets the entry_mode of this Ptsv2paymentsPointOfSaleInformation.
        Method of entering credit card information into the POS terminal. Possible values:   - contact: Read from direct contact with chip card.  - contactless: Read from a contactless interface using chip data.  - keyed: Manually keyed into POS terminal.  - msd: Read from a contactless interface using magnetic stripe data (MSD).  - swiped: Read from credit card magnetic stripe.  The contact, contactless, and msd values are supported only for EMV transactions. * Applicable only for CTV for Payouts. 

        :param entry_mode: The entry_mode of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if entry_mode is not None and len(entry_mode) > 11:
            raise ValueError("Invalid value for `entry_mode`, length must be less than or equal to `11`")

        self._entry_mode = entry_mode

    @property
    def terminal_capability(self):
        """
        Gets the terminal_capability of this Ptsv2paymentsPointOfSaleInformation.
        POS terminal’s capability. Possible values:   - 1: Terminal has a magnetic stripe reader only.  - 2: Terminal has a magnetic stripe reader and manual entry capability.  - 3: Terminal has manual entry capability only.  - 4: Terminal can read chip cards.  - 5: Terminal can read contactless chip cards.  The values of 4 and 5 are supported only for EMV transactions. * Applicable only for CTV for Payouts.   

        :return: The terminal_capability of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: int
        """
        return self._terminal_capability

    @terminal_capability.setter
    def terminal_capability(self, terminal_capability):
        """
        Sets the terminal_capability of this Ptsv2paymentsPointOfSaleInformation.
        POS terminal’s capability. Possible values:   - 1: Terminal has a magnetic stripe reader only.  - 2: Terminal has a magnetic stripe reader and manual entry capability.  - 3: Terminal has manual entry capability only.  - 4: Terminal can read chip cards.  - 5: Terminal can read contactless chip cards.  The values of 4 and 5 are supported only for EMV transactions. * Applicable only for CTV for Payouts.   

        :param terminal_capability: The terminal_capability of this Ptsv2paymentsPointOfSaleInformation.
        :type: int
        """
        if terminal_capability is not None and terminal_capability > 5:
            raise ValueError("Invalid value for `terminal_capability`, must be a value less than or equal to `5`")
        if terminal_capability is not None and terminal_capability < 1:
            raise ValueError("Invalid value for `terminal_capability`, must be a value greater than or equal to `1`")

        self._terminal_capability = terminal_capability

    @property
    def pin_entry_capability(self):
        """
        Gets the pin_entry_capability of this Ptsv2paymentsPointOfSaleInformation.
        A one-digit code that identifies the capability of terminal to capture PINs.  This code does not necessarily mean that a PIN was entered or is included in this message.  For Payouts: This field is applicable for CtV. 

        :return: The pin_entry_capability of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: int
        """
        return self._pin_entry_capability

    @pin_entry_capability.setter
    def pin_entry_capability(self, pin_entry_capability):
        """
        Sets the pin_entry_capability of this Ptsv2paymentsPointOfSaleInformation.
        A one-digit code that identifies the capability of terminal to capture PINs.  This code does not necessarily mean that a PIN was entered or is included in this message.  For Payouts: This field is applicable for CtV. 

        :param pin_entry_capability: The pin_entry_capability of this Ptsv2paymentsPointOfSaleInformation.
        :type: int
        """
        if pin_entry_capability is not None and pin_entry_capability > 1:
            raise ValueError("Invalid value for `pin_entry_capability`, must be a value less than or equal to `1`")
        if pin_entry_capability is not None and pin_entry_capability < 1:
            raise ValueError("Invalid value for `pin_entry_capability`, must be a value greater than or equal to `1`")

        self._pin_entry_capability = pin_entry_capability

    @property
    def operating_environment(self):
        """
        Gets the operating_environment of this Ptsv2paymentsPointOfSaleInformation.
        Operating environment. Possible values:   - 0: No terminal used or unknown environment.  - 1: On merchant premises, attended.  - 2: On merchant premises, unattended, or cardholder terminal. Examples: oil, kiosks, self-checkout, home       computer, mobile telephone, personal digital assistant (PDA). Cardholder terminal is supported only for       MasterCard transactions on **CyberSource through VisaNet**.  - 3: Off merchant premises, attended. Examples: portable POS devices at trade shows, at service calls, or in       taxis.  - 4: Off merchant premises, unattended, or cardholder terminal. Examples: vending machines, home computer,       mobile telephone, PDA. Cardholder terminal is supported only for MasterCard transactions on **CyberSource       through VisaNet**.  - 5: On premises of cardholder, unattended.  - 9: Unknown delivery mode.  - S: Electronic delivery of product. Examples: music, software, or eTickets that are downloaded over the       internet.  - T: Physical delivery of product. Examples: music or software that is delivered by mail or by a courier.  This field is supported only for **American Express Direct** and **CyberSource through VisaNet**.  **CyberSource through VisaNet**\\ For MasterCard transactions, the only valid values are 2 and 4. 

        :return: The operating_environment of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._operating_environment

    @operating_environment.setter
    def operating_environment(self, operating_environment):
        """
        Sets the operating_environment of this Ptsv2paymentsPointOfSaleInformation.
        Operating environment. Possible values:   - 0: No terminal used or unknown environment.  - 1: On merchant premises, attended.  - 2: On merchant premises, unattended, or cardholder terminal. Examples: oil, kiosks, self-checkout, home       computer, mobile telephone, personal digital assistant (PDA). Cardholder terminal is supported only for       MasterCard transactions on **CyberSource through VisaNet**.  - 3: Off merchant premises, attended. Examples: portable POS devices at trade shows, at service calls, or in       taxis.  - 4: Off merchant premises, unattended, or cardholder terminal. Examples: vending machines, home computer,       mobile telephone, PDA. Cardholder terminal is supported only for MasterCard transactions on **CyberSource       through VisaNet**.  - 5: On premises of cardholder, unattended.  - 9: Unknown delivery mode.  - S: Electronic delivery of product. Examples: music, software, or eTickets that are downloaded over the       internet.  - T: Physical delivery of product. Examples: music or software that is delivered by mail or by a courier.  This field is supported only for **American Express Direct** and **CyberSource through VisaNet**.  **CyberSource through VisaNet**\\ For MasterCard transactions, the only valid values are 2 and 4. 

        :param operating_environment: The operating_environment of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if operating_environment is not None and len(operating_environment) > 1:
            raise ValueError("Invalid value for `operating_environment`, length must be less than or equal to `1`")

        self._operating_environment = operating_environment

    @property
    def emv(self):
        """
        Gets the emv of this Ptsv2paymentsPointOfSaleInformation.

        :return: The emv of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: Ptsv2paymentsPointOfSaleInformationEmv
        """
        return self._emv

    @emv.setter
    def emv(self, emv):
        """
        Sets the emv of this Ptsv2paymentsPointOfSaleInformation.

        :param emv: The emv of this Ptsv2paymentsPointOfSaleInformation.
        :type: Ptsv2paymentsPointOfSaleInformationEmv
        """

        self._emv = emv

    @property
    def amex_capn_data(self):
        """
        Gets the amex_capn_data of this Ptsv2paymentsPointOfSaleInformation.
        Point-of-sale details for the transaction. This value is returned only for **American Express Direct**. CyberSource generates this value, which consists of a series of codes that identify terminal capability, security data, and specific conditions present at the time the transaction occurred. To comply with the CAPN requirements, this  value must be included in all subsequent follow-on requests, such as captures and follow-on credits.  When you perform authorizations, captures, and credits through CyberSource, CyberSource passes this value from the authorization service to the subsequent services for you. However, when you perform authorizations through CyberSource and perform subsequent services through other financial institutions, you must ensure that your requests for captures and credits include this value. 

        :return: The amex_capn_data of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._amex_capn_data

    @amex_capn_data.setter
    def amex_capn_data(self, amex_capn_data):
        """
        Sets the amex_capn_data of this Ptsv2paymentsPointOfSaleInformation.
        Point-of-sale details for the transaction. This value is returned only for **American Express Direct**. CyberSource generates this value, which consists of a series of codes that identify terminal capability, security data, and specific conditions present at the time the transaction occurred. To comply with the CAPN requirements, this  value must be included in all subsequent follow-on requests, such as captures and follow-on credits.  When you perform authorizations, captures, and credits through CyberSource, CyberSource passes this value from the authorization service to the subsequent services for you. However, when you perform authorizations through CyberSource and perform subsequent services through other financial institutions, you must ensure that your requests for captures and credits include this value. 

        :param amex_capn_data: The amex_capn_data of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if amex_capn_data is not None and len(amex_capn_data) > 12:
            raise ValueError("Invalid value for `amex_capn_data`, length must be less than or equal to `12`")

        self._amex_capn_data = amex_capn_data

    @property
    def track_data(self):
        """
        Gets the track_data of this Ptsv2paymentsPointOfSaleInformation.
        Card’s track 1 and 2 data. For all processors except FDMS Nashville, this value consists of one of the following:   - Track 1 data  - Track 2 data  - Data for both tracks 1 and 2  For FDMS Nashville, this value consists of one of the following:  - Track 1 data  - Data for both tracks 1 and 2  Example: %B4111111111111111^SMITH/JOHN ^1612101976110000868000000?;4111111111111111=16121019761186800000? 

        :return: The track_data of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._track_data

    @track_data.setter
    def track_data(self, track_data):
        """
        Sets the track_data of this Ptsv2paymentsPointOfSaleInformation.
        Card’s track 1 and 2 data. For all processors except FDMS Nashville, this value consists of one of the following:   - Track 1 data  - Track 2 data  - Data for both tracks 1 and 2  For FDMS Nashville, this value consists of one of the following:  - Track 1 data  - Data for both tracks 1 and 2  Example: %B4111111111111111^SMITH/JOHN ^1612101976110000868000000?;4111111111111111=16121019761186800000? 

        :param track_data: The track_data of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """

        self._track_data = track_data

    @property
    def store_and_forward_indicator(self):
        """
        Gets the store_and_forward_indicator of this Ptsv2paymentsPointOfSaleInformation.
        When connectivity is unavailable, the client software that is installed on the POS terminal can store a transaction in its memory and send it for authorization when connectivity is restored. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  Possible values: - Y: Transaction was stored and then forwarded. - N (default): Transaction was not stored and then forwarded.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The store_and_forward_indicator of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._store_and_forward_indicator

    @store_and_forward_indicator.setter
    def store_and_forward_indicator(self, store_and_forward_indicator):
        """
        Sets the store_and_forward_indicator of this Ptsv2paymentsPointOfSaleInformation.
        When connectivity is unavailable, the client software that is installed on the POS terminal can store a transaction in its memory and send it for authorization when connectivity is restored. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  Possible values: - Y: Transaction was stored and then forwarded. - N (default): Transaction was not stored and then forwarded.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param store_and_forward_indicator: The store_and_forward_indicator of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if store_and_forward_indicator is not None and len(store_and_forward_indicator) > 1:
            raise ValueError("Invalid value for `store_and_forward_indicator`, length must be less than or equal to `1`")

        self._store_and_forward_indicator = store_and_forward_indicator

    @property
    def cardholder_verification_method(self):
        """
        Gets the cardholder_verification_method of this Ptsv2paymentsPointOfSaleInformation.

        :return: The cardholder_verification_method of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: list[str]
        """
        return self._cardholder_verification_method

    @cardholder_verification_method.setter
    def cardholder_verification_method(self, cardholder_verification_method):
        """
        Sets the cardholder_verification_method of this Ptsv2paymentsPointOfSaleInformation.

        :param cardholder_verification_method: The cardholder_verification_method of this Ptsv2paymentsPointOfSaleInformation.
        :type: list[str]
        """

        self._cardholder_verification_method = cardholder_verification_method

    @property
    def terminal_input_capability(self):
        """
        Gets the terminal_input_capability of this Ptsv2paymentsPointOfSaleInformation.

        :return: The terminal_input_capability of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: list[str]
        """
        return self._terminal_input_capability

    @terminal_input_capability.setter
    def terminal_input_capability(self, terminal_input_capability):
        """
        Sets the terminal_input_capability of this Ptsv2paymentsPointOfSaleInformation.

        :param terminal_input_capability: The terminal_input_capability of this Ptsv2paymentsPointOfSaleInformation.
        :type: list[str]
        """

        self._terminal_input_capability = terminal_input_capability

    @property
    def terminal_card_capture_capability(self):
        """
        Gets the terminal_card_capture_capability of this Ptsv2paymentsPointOfSaleInformation.
        Indicates whether the terminal can capture the card.  Possible values: - 1: Terminal can capture card. - 0: Terminal cannot capture card.  This field is supported only on American Express Direct. 

        :return: The terminal_card_capture_capability of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._terminal_card_capture_capability

    @terminal_card_capture_capability.setter
    def terminal_card_capture_capability(self, terminal_card_capture_capability):
        """
        Sets the terminal_card_capture_capability of this Ptsv2paymentsPointOfSaleInformation.
        Indicates whether the terminal can capture the card.  Possible values: - 1: Terminal can capture card. - 0: Terminal cannot capture card.  This field is supported only on American Express Direct. 

        :param terminal_card_capture_capability: The terminal_card_capture_capability of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if terminal_card_capture_capability is not None and len(terminal_card_capture_capability) > 1:
            raise ValueError("Invalid value for `terminal_card_capture_capability`, length must be less than or equal to `1`")

        self._terminal_card_capture_capability = terminal_card_capture_capability

    @property
    def terminal_output_capability(self):
        """
        Gets the terminal_output_capability of this Ptsv2paymentsPointOfSaleInformation.
        Indicates whether the terminal can print or display messages.  Possible values: - 1: Neither - 2: Print only - 3: Display only - 4: Print and display  This field is supported only on American Express Direct. 

        :return: The terminal_output_capability of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._terminal_output_capability

    @terminal_output_capability.setter
    def terminal_output_capability(self, terminal_output_capability):
        """
        Sets the terminal_output_capability of this Ptsv2paymentsPointOfSaleInformation.
        Indicates whether the terminal can print or display messages.  Possible values: - 1: Neither - 2: Print only - 3: Display only - 4: Print and display  This field is supported only on American Express Direct. 

        :param terminal_output_capability: The terminal_output_capability of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if terminal_output_capability is not None and len(terminal_output_capability) > 1:
            raise ValueError("Invalid value for `terminal_output_capability`, length must be less than or equal to `1`")

        self._terminal_output_capability = terminal_output_capability

    @property
    def terminal_pin_capability(self):
        """
        Gets the terminal_pin_capability of this Ptsv2paymentsPointOfSaleInformation.
        Maximum PIN length that the terminal can capture.  Possible values: -  0: No PIN capture capability -  1: PIN capture capability unknown -  4: Four characters -  5: Five characters -  6: Six characters -  7: Seven characters -  8: Eight characters -  9: Nine characters - 10: Ten characters - 11: Eleven characters - 12: Twelve characters  This field is supported only on American Express Direct and SIX. 

        :return: The terminal_pin_capability of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: int
        """
        return self._terminal_pin_capability

    @terminal_pin_capability.setter
    def terminal_pin_capability(self, terminal_pin_capability):
        """
        Sets the terminal_pin_capability of this Ptsv2paymentsPointOfSaleInformation.
        Maximum PIN length that the terminal can capture.  Possible values: -  0: No PIN capture capability -  1: PIN capture capability unknown -  4: Four characters -  5: Five characters -  6: Six characters -  7: Seven characters -  8: Eight characters -  9: Nine characters - 10: Ten characters - 11: Eleven characters - 12: Twelve characters  This field is supported only on American Express Direct and SIX. 

        :param terminal_pin_capability: The terminal_pin_capability of this Ptsv2paymentsPointOfSaleInformation.
        :type: int
        """

        self._terminal_pin_capability = terminal_pin_capability

    @property
    def device_id(self):
        """
        Gets the device_id of this Ptsv2paymentsPointOfSaleInformation.
        Value created by the client software that uniquely identifies the POS device. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The device_id of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._device_id

    @device_id.setter
    def device_id(self, device_id):
        """
        Sets the device_id of this Ptsv2paymentsPointOfSaleInformation.
        Value created by the client software that uniquely identifies the POS device. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param device_id: The device_id of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if device_id is not None and len(device_id) > 32:
            raise ValueError("Invalid value for `device_id`, length must be less than or equal to `32`")

        self._device_id = device_id

    @property
    def pin_block_encoding_format(self):
        """
        Gets the pin_block_encoding_format of this Ptsv2paymentsPointOfSaleInformation.
        Format that is used to encode the PIN block. This value is provided by the client software that is installed on the POS terminal.  Possible values: - 0: ISO 9564 format 0 - 1: ISO 9564 format 1 - 2: ISO 9564 format 2 - 3: ISO 9564 format 3  In the Credit Card Guide for the auth service: This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The pin_block_encoding_format of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: int
        """
        return self._pin_block_encoding_format

    @pin_block_encoding_format.setter
    def pin_block_encoding_format(self, pin_block_encoding_format):
        """
        Sets the pin_block_encoding_format of this Ptsv2paymentsPointOfSaleInformation.
        Format that is used to encode the PIN block. This value is provided by the client software that is installed on the POS terminal.  Possible values: - 0: ISO 9564 format 0 - 1: ISO 9564 format 1 - 2: ISO 9564 format 2 - 3: ISO 9564 format 3  In the Credit Card Guide for the auth service: This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param pin_block_encoding_format: The pin_block_encoding_format of this Ptsv2paymentsPointOfSaleInformation.
        :type: int
        """
        if pin_block_encoding_format is not None and pin_block_encoding_format > 9:
            raise ValueError("Invalid value for `pin_block_encoding_format`, must be a value less than or equal to `9`")

        self._pin_block_encoding_format = pin_block_encoding_format

    @property
    def encrypted_pin(self):
        """
        Gets the encrypted_pin of this Ptsv2paymentsPointOfSaleInformation.
        Encrypted PIN.  This value is provided by the client software that is installed on the POS terminal.  In the Credit Card Guide for the auth service: This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The encrypted_pin of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._encrypted_pin

    @encrypted_pin.setter
    def encrypted_pin(self, encrypted_pin):
        """
        Sets the encrypted_pin of this Ptsv2paymentsPointOfSaleInformation.
        Encrypted PIN.  This value is provided by the client software that is installed on the POS terminal.  In the Credit Card Guide for the auth service: This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param encrypted_pin: The encrypted_pin of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if encrypted_pin is not None and len(encrypted_pin) > 16:
            raise ValueError("Invalid value for `encrypted_pin`, length must be less than or equal to `16`")

        self._encrypted_pin = encrypted_pin

    @property
    def encrypted_key_serial_number(self):
        """
        Gets the encrypted_key_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        This is a combination of the device's unique identifier and a transaction counter that is used in the process of decrypting the encrypted PIN.  For all terminals that are using derived unique key per transaction (DUKPT) encryption, this is generated as a single number within the terminal. 

        :return: The encrypted_key_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._encrypted_key_serial_number

    @encrypted_key_serial_number.setter
    def encrypted_key_serial_number(self, encrypted_key_serial_number):
        """
        Sets the encrypted_key_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        This is a combination of the device's unique identifier and a transaction counter that is used in the process of decrypting the encrypted PIN.  For all terminals that are using derived unique key per transaction (DUKPT) encryption, this is generated as a single number within the terminal. 

        :param encrypted_key_serial_number: The encrypted_key_serial_number of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if encrypted_key_serial_number is not None and len(encrypted_key_serial_number) > 20:
            raise ValueError("Invalid value for `encrypted_key_serial_number`, length must be less than or equal to `20`")

        self._encrypted_key_serial_number = encrypted_key_serial_number

    @property
    def partner_sdk_version(self):
        """
        Gets the partner_sdk_version of this Ptsv2paymentsPointOfSaleInformation.
        Version of the software installed on the POS terminal. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :return: The partner_sdk_version of this Ptsv2paymentsPointOfSaleInformation.
        :rtype: str
        """
        return self._partner_sdk_version

    @partner_sdk_version.setter
    def partner_sdk_version(self, partner_sdk_version):
        """
        Sets the partner_sdk_version of this Ptsv2paymentsPointOfSaleInformation.
        Version of the software installed on the POS terminal. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 

        :param partner_sdk_version: The partner_sdk_version of this Ptsv2paymentsPointOfSaleInformation.
        :type: str
        """
        if partner_sdk_version is not None and len(partner_sdk_version) > 32:
            raise ValueError("Invalid value for `partner_sdk_version`, length must be less than or equal to `32`")

        self._partner_sdk_version = partner_sdk_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsPointOfSaleInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
