# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Boardingv1registrationsOrganizationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'organization_id': 'str',
        'parent_organization_id': 'str',
        'child_organizations': 'list[str]',
        'type': 'str',
        'status': 'str',
        'configurable': 'bool',
        'business_information': 'Boardingv1registrationsOrganizationInformationBusinessInformation',
        'kyc': 'Boardingv1registrationsOrganizationInformationKYC',
        'owners': 'list[Boardingv1registrationsOrganizationInformationOwners]'
    }

    attribute_map = {
        'organization_id': 'organizationId',
        'parent_organization_id': 'parentOrganizationId',
        'child_organizations': 'childOrganizations',
        'type': 'type',
        'status': 'status',
        'configurable': 'configurable',
        'business_information': 'businessInformation',
        'kyc': 'KYC',
        'owners': 'owners'
    }

    def __init__(self, organization_id=None, parent_organization_id=None, child_organizations=None, type=None, status=None, configurable=False, business_information=None, kyc=None, owners=None):
        """
        Boardingv1registrationsOrganizationInformation - a model defined in Swagger
        """

        self._organization_id = None
        self._parent_organization_id = None
        self._child_organizations = None
        self._type = None
        self._status = None
        self._configurable = None
        self._business_information = None
        self._kyc = None
        self._owners = None

        if organization_id is not None:
          self.organization_id = organization_id
        if parent_organization_id is not None:
          self.parent_organization_id = parent_organization_id
        if child_organizations is not None:
          self.child_organizations = child_organizations
        if type is not None:
          self.type = type
        if status is not None:
          self.status = status
        if configurable is not None:
          self.configurable = configurable
        self.business_information = business_information
        if kyc is not None:
          self.kyc = kyc
        if owners is not None:
          self.owners = owners

    @property
    def organization_id(self):
        """
        Gets the organization_id of this Boardingv1registrationsOrganizationInformation.

        :return: The organization_id of this Boardingv1registrationsOrganizationInformation.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this Boardingv1registrationsOrganizationInformation.

        :param organization_id: The organization_id of this Boardingv1registrationsOrganizationInformation.
        :type: str
        """
        if organization_id is not None and not re.search('^[0-9a-zA-Z_]+$', organization_id):
            raise ValueError("Invalid value for `organization_id`, must be a follow pattern or equal to `/^[0-9a-zA-Z_]+$/`")

        self._organization_id = organization_id

    @property
    def parent_organization_id(self):
        """
        Gets the parent_organization_id of this Boardingv1registrationsOrganizationInformation.
        This field is required for Organization Types: MERCHANT, TRANSACTING 

        :return: The parent_organization_id of this Boardingv1registrationsOrganizationInformation.
        :rtype: str
        """
        return self._parent_organization_id

    @parent_organization_id.setter
    def parent_organization_id(self, parent_organization_id):
        """
        Sets the parent_organization_id of this Boardingv1registrationsOrganizationInformation.
        This field is required for Organization Types: MERCHANT, TRANSACTING 

        :param parent_organization_id: The parent_organization_id of this Boardingv1registrationsOrganizationInformation.
        :type: str
        """
        if parent_organization_id is not None and not re.search('^[0-9a-zA-Z_]+$', parent_organization_id):
            raise ValueError("Invalid value for `parent_organization_id`, must be a follow pattern or equal to `/^[0-9a-zA-Z_]+$/`")

        self._parent_organization_id = parent_organization_id

    @property
    def child_organizations(self):
        """
        Gets the child_organizations of this Boardingv1registrationsOrganizationInformation.

        :return: The child_organizations of this Boardingv1registrationsOrganizationInformation.
        :rtype: list[str]
        """
        return self._child_organizations

    @child_organizations.setter
    def child_organizations(self, child_organizations):
        """
        Sets the child_organizations of this Boardingv1registrationsOrganizationInformation.

        :param child_organizations: The child_organizations of this Boardingv1registrationsOrganizationInformation.
        :type: list[str]
        """

        self._child_organizations = child_organizations

    @property
    def type(self):
        """
        Gets the type of this Boardingv1registrationsOrganizationInformation.
        Determines the type of organization in the hirarchy that this registration will use to onboard this Organization Possible Values:   - 'TRANSACTING'   - 'STRUCTURAL'   - 'MERCHANT' 

        :return: The type of this Boardingv1registrationsOrganizationInformation.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Boardingv1registrationsOrganizationInformation.
        Determines the type of organization in the hirarchy that this registration will use to onboard this Organization Possible Values:   - 'TRANSACTING'   - 'STRUCTURAL'   - 'MERCHANT' 

        :param type: The type of this Boardingv1registrationsOrganizationInformation.
        :type: str
        """
        allowed_values = ["TRANSACTING", "STRUCTURAL", "MERCHANT"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def status(self):
        """
        Gets the status of this Boardingv1registrationsOrganizationInformation.
        Determines the status that the organization will be after being onboarded Possible Values:             - 'LIVE'             - 'TEST'             - 'DRAFT' 

        :return: The status of this Boardingv1registrationsOrganizationInformation.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Boardingv1registrationsOrganizationInformation.
        Determines the status that the organization will be after being onboarded Possible Values:             - 'LIVE'             - 'TEST'             - 'DRAFT' 

        :param status: The status of this Boardingv1registrationsOrganizationInformation.
        :type: str
        """
        allowed_values = ["LIVE", "TEST", "DRAFT"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def configurable(self):
        """
        Gets the configurable of this Boardingv1registrationsOrganizationInformation.
        This denotes the one organization, with exception to the TRANSACTING types, that is allowed to be used for configuration purposes against products.  Eventually this field will be deprecated and all organizations will be allowed for product configuration.

        :return: The configurable of this Boardingv1registrationsOrganizationInformation.
        :rtype: bool
        """
        return self._configurable

    @configurable.setter
    def configurable(self, configurable):
        """
        Sets the configurable of this Boardingv1registrationsOrganizationInformation.
        This denotes the one organization, with exception to the TRANSACTING types, that is allowed to be used for configuration purposes against products.  Eventually this field will be deprecated and all organizations will be allowed for product configuration.

        :param configurable: The configurable of this Boardingv1registrationsOrganizationInformation.
        :type: bool
        """

        self._configurable = configurable

    @property
    def business_information(self):
        """
        Gets the business_information of this Boardingv1registrationsOrganizationInformation.

        :return: The business_information of this Boardingv1registrationsOrganizationInformation.
        :rtype: Boardingv1registrationsOrganizationInformationBusinessInformation
        """
        return self._business_information

    @business_information.setter
    def business_information(self, business_information):
        """
        Sets the business_information of this Boardingv1registrationsOrganizationInformation.

        :param business_information: The business_information of this Boardingv1registrationsOrganizationInformation.
        :type: Boardingv1registrationsOrganizationInformationBusinessInformation
        """
        if business_information is None:
            raise ValueError("Invalid value for `business_information`, must not be `None`")

        self._business_information = business_information

    @property
    def kyc(self):
        """
        Gets the kyc of this Boardingv1registrationsOrganizationInformation.

        :return: The kyc of this Boardingv1registrationsOrganizationInformation.
        :rtype: Boardingv1registrationsOrganizationInformationKYC
        """
        return self._kyc

    @kyc.setter
    def kyc(self, kyc):
        """
        Sets the kyc of this Boardingv1registrationsOrganizationInformation.

        :param kyc: The kyc of this Boardingv1registrationsOrganizationInformation.
        :type: Boardingv1registrationsOrganizationInformationKYC
        """

        self._kyc = kyc

    @property
    def owners(self):
        """
        Gets the owners of this Boardingv1registrationsOrganizationInformation.

        :return: The owners of this Boardingv1registrationsOrganizationInformation.
        :rtype: list[Boardingv1registrationsOrganizationInformationOwners]
        """
        return self._owners

    @owners.setter
    def owners(self, owners):
        """
        Sets the owners of this Boardingv1registrationsOrganizationInformation.

        :param owners: The owners of this Boardingv1registrationsOrganizationInformation.
        :type: list[Boardingv1registrationsOrganizationInformationOwners]
        """

        self._owners = owners

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Boardingv1registrationsOrganizationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
