# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CardProcessingConfigCommon(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'processors': 'dict(str, CardProcessingConfigCommonProcessors)',
        'amex_vendor_code': 'str',
        'default_auth_type_code': 'str',
        'master_card_assigned_id': 'str',
        'enable_partial_auth': 'bool',
        'merchant_category_code': 'str',
        'sic_code': 'str',
        'food_and_consumer_service_id': 'str',
        'enable_split_shipment': 'bool',
        'enable_interchange_optimization': 'bool',
        'visa_delegated_authentication_id': 'str',
        'credit_card_refund_limit_percent': 'str',
        'business_center_credit_card_refund_limit_percent': 'str',
        'allow_captures_greater_than_authorizations': 'bool',
        'enable_duplicate_merchant_reference_number_blocking': 'bool',
        'domestic_merchant_id': 'bool',
        'process_level3_data': 'str',
        'sub_merchant_id': 'str',
        'sub_merchant_business_name': 'str',
        'prefer_cobadged_secondary_brand': 'bool',
        'merchant_descriptor_information': 'CardProcessingConfigCommonMerchantDescriptorInformation'
    }

    attribute_map = {
        'processors': 'processors',
        'amex_vendor_code': 'amexVendorCode',
        'default_auth_type_code': 'defaultAuthTypeCode',
        'master_card_assigned_id': 'masterCardAssignedId',
        'enable_partial_auth': 'enablePartialAuth',
        'merchant_category_code': 'merchantCategoryCode',
        'sic_code': 'sicCode',
        'food_and_consumer_service_id': 'foodAndConsumerServiceId',
        'enable_split_shipment': 'enableSplitShipment',
        'enable_interchange_optimization': 'enableInterchangeOptimization',
        'visa_delegated_authentication_id': 'visaDelegatedAuthenticationId',
        'credit_card_refund_limit_percent': 'creditCardRefundLimitPercent',
        'business_center_credit_card_refund_limit_percent': 'businessCenterCreditCardRefundLimitPercent',
        'allow_captures_greater_than_authorizations': 'allowCapturesGreaterThanAuthorizations',
        'enable_duplicate_merchant_reference_number_blocking': 'enableDuplicateMerchantReferenceNumberBlocking',
        'domestic_merchant_id': 'domesticMerchantId',
        'process_level3_data': 'processLevel3Data',
        'sub_merchant_id': 'subMerchantId',
        'sub_merchant_business_name': 'subMerchantBusinessName',
        'prefer_cobadged_secondary_brand': 'preferCobadgedSecondaryBrand',
        'merchant_descriptor_information': 'merchantDescriptorInformation'
    }

    def __init__(self, processors=None, amex_vendor_code=None, default_auth_type_code=None, master_card_assigned_id=None, enable_partial_auth=None, merchant_category_code=None, sic_code=None, food_and_consumer_service_id=None, enable_split_shipment=None, enable_interchange_optimization=None, visa_delegated_authentication_id=None, credit_card_refund_limit_percent=None, business_center_credit_card_refund_limit_percent=None, allow_captures_greater_than_authorizations=None, enable_duplicate_merchant_reference_number_blocking=None, domestic_merchant_id=None, process_level3_data=None, sub_merchant_id=None, sub_merchant_business_name=None, prefer_cobadged_secondary_brand=None, merchant_descriptor_information=None):
        """
        CardProcessingConfigCommon - a model defined in Swagger
        """

        self._processors = None
        self._amex_vendor_code = None
        self._default_auth_type_code = None
        self._master_card_assigned_id = None
        self._enable_partial_auth = None
        self._merchant_category_code = None
        self._sic_code = None
        self._food_and_consumer_service_id = None
        self._enable_split_shipment = None
        self._enable_interchange_optimization = None
        self._visa_delegated_authentication_id = None
        self._credit_card_refund_limit_percent = None
        self._business_center_credit_card_refund_limit_percent = None
        self._allow_captures_greater_than_authorizations = None
        self._enable_duplicate_merchant_reference_number_blocking = None
        self._domestic_merchant_id = None
        self._process_level3_data = None
        self._sub_merchant_id = None
        self._sub_merchant_business_name = None
        self._prefer_cobadged_secondary_brand = None
        self._merchant_descriptor_information = None

        if processors is not None:
          self.processors = processors
        if amex_vendor_code is not None:
          self.amex_vendor_code = amex_vendor_code
        if default_auth_type_code is not None:
          self.default_auth_type_code = default_auth_type_code
        if master_card_assigned_id is not None:
          self.master_card_assigned_id = master_card_assigned_id
        if enable_partial_auth is not None:
          self.enable_partial_auth = enable_partial_auth
        if merchant_category_code is not None:
          self.merchant_category_code = merchant_category_code
        if sic_code is not None:
          self.sic_code = sic_code
        if food_and_consumer_service_id is not None:
          self.food_and_consumer_service_id = food_and_consumer_service_id
        if enable_split_shipment is not None:
          self.enable_split_shipment = enable_split_shipment
        if enable_interchange_optimization is not None:
          self.enable_interchange_optimization = enable_interchange_optimization
        if visa_delegated_authentication_id is not None:
          self.visa_delegated_authentication_id = visa_delegated_authentication_id
        if credit_card_refund_limit_percent is not None:
          self.credit_card_refund_limit_percent = credit_card_refund_limit_percent
        if business_center_credit_card_refund_limit_percent is not None:
          self.business_center_credit_card_refund_limit_percent = business_center_credit_card_refund_limit_percent
        if allow_captures_greater_than_authorizations is not None:
          self.allow_captures_greater_than_authorizations = allow_captures_greater_than_authorizations
        if enable_duplicate_merchant_reference_number_blocking is not None:
          self.enable_duplicate_merchant_reference_number_blocking = enable_duplicate_merchant_reference_number_blocking
        if domestic_merchant_id is not None:
          self.domestic_merchant_id = domestic_merchant_id
        if process_level3_data is not None:
          self.process_level3_data = process_level3_data
        if sub_merchant_id is not None:
          self.sub_merchant_id = sub_merchant_id
        if sub_merchant_business_name is not None:
          self.sub_merchant_business_name = sub_merchant_business_name
        if prefer_cobadged_secondary_brand is not None:
          self.prefer_cobadged_secondary_brand = prefer_cobadged_secondary_brand
        if merchant_descriptor_information is not None:
          self.merchant_descriptor_information = merchant_descriptor_information

    @property
    def processors(self):
        """
        Gets the processors of this CardProcessingConfigCommon.
        e.g. * amexdirect * barclays2 * CUP * EFTPOS * fdiglobal * gpx * smartfdc * tsys * vero * VPC  For VPC, CUP and EFTPOS processors, replace the processor name from VPC or CUP or EFTPOS to the actual processor name in the sample request. e.g. replace VPC with &lt;your vpc processor&gt; 

        :return: The processors of this CardProcessingConfigCommon.
        :rtype: dict(str, CardProcessingConfigCommonProcessors)
        """
        return self._processors

    @processors.setter
    def processors(self, processors):
        """
        Sets the processors of this CardProcessingConfigCommon.
        e.g. * amexdirect * barclays2 * CUP * EFTPOS * fdiglobal * gpx * smartfdc * tsys * vero * VPC  For VPC, CUP and EFTPOS processors, replace the processor name from VPC or CUP or EFTPOS to the actual processor name in the sample request. e.g. replace VPC with &lt;your vpc processor&gt; 

        :param processors: The processors of this CardProcessingConfigCommon.
        :type: dict(str, CardProcessingConfigCommonProcessors)
        """

        self._processors = processors

    @property
    def amex_vendor_code(self):
        """
        Gets the amex_vendor_code of this CardProcessingConfigCommon.
        Vendor code assigned by American Express. Applicable for TSYS (tsys) processor.

        :return: The amex_vendor_code of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._amex_vendor_code

    @amex_vendor_code.setter
    def amex_vendor_code(self, amex_vendor_code):
        """
        Sets the amex_vendor_code of this CardProcessingConfigCommon.
        Vendor code assigned by American Express. Applicable for TSYS (tsys) processor.

        :param amex_vendor_code: The amex_vendor_code of this CardProcessingConfigCommon.
        :type: str
        """

        self._amex_vendor_code = amex_vendor_code

    @property
    def default_auth_type_code(self):
        """
        Gets the default_auth_type_code of this CardProcessingConfigCommon.
        Authorization Finality indicator. Please note that the input can be in small case or capitals but response is in small case as of now. It will be made capitals everywhere in the next version. Applicable for Elavon Americas (elavonamericas), TSYS (tsys), Barclays (barclays2), Streamline (streamline2), Six (six), Barclays HISO (barclayshiso), GPN (gpn), FDI Global (fdiglobal), GPX (gpx), Paymentech Tampa (paymentechtampa), FDC Nashville (smartfdc), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>FINAL</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td><td>FINAL</td></tr> </table> 

        :return: The default_auth_type_code of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._default_auth_type_code

    @default_auth_type_code.setter
    def default_auth_type_code(self, default_auth_type_code):
        """
        Sets the default_auth_type_code of this CardProcessingConfigCommon.
        Authorization Finality indicator. Please note that the input can be in small case or capitals but response is in small case as of now. It will be made capitals everywhere in the next version. Applicable for Elavon Americas (elavonamericas), TSYS (tsys), Barclays (barclays2), Streamline (streamline2), Six (six), Barclays HISO (barclayshiso), GPN (gpn), FDI Global (fdiglobal), GPX (gpx), Paymentech Tampa (paymentechtampa), FDC Nashville (smartfdc), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>FINAL</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td><td>FINAL</td></tr> </table> 

        :param default_auth_type_code: The default_auth_type_code of this CardProcessingConfigCommon.
        :type: str
        """
        allowed_values = ["PRE", "FINAL", "UNDEFINED"]
        if default_auth_type_code not in allowed_values:
            raise ValueError(
                "Invalid value for `default_auth_type_code` ({0}), must be one of {1}"
                .format(default_auth_type_code, allowed_values)
            )

        self._default_auth_type_code = default_auth_type_code

    @property
    def master_card_assigned_id(self):
        """
        Gets the master_card_assigned_id of this CardProcessingConfigCommon.
        MAID aka MasterCard assigned ID, MasterCard equivalent of Merchant Verification Value by Visa. Applicable for VPC, GPX (gpx) and FDI Global (fdiglobal) processors.

        :return: The master_card_assigned_id of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._master_card_assigned_id

    @master_card_assigned_id.setter
    def master_card_assigned_id(self, master_card_assigned_id):
        """
        Sets the master_card_assigned_id of this CardProcessingConfigCommon.
        MAID aka MasterCard assigned ID, MasterCard equivalent of Merchant Verification Value by Visa. Applicable for VPC, GPX (gpx) and FDI Global (fdiglobal) processors.

        :param master_card_assigned_id: The master_card_assigned_id of this CardProcessingConfigCommon.
        :type: str
        """

        self._master_card_assigned_id = master_card_assigned_id

    @property
    def enable_partial_auth(self):
        """
        Gets the enable_partial_auth of this CardProcessingConfigCommon.
        Allow merchants to accept partial authorization approvals. Applicable for Elavon Americas (elavonamericas), VPC, GPX (gpx), FDI Global (fdiglobal), FDC Nashville (smartfdc), GPN (gpn), TSYS (tsys), American Express Direct (amexdirect), Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :return: The enable_partial_auth of this CardProcessingConfigCommon.
        :rtype: bool
        """
        return self._enable_partial_auth

    @enable_partial_auth.setter
    def enable_partial_auth(self, enable_partial_auth):
        """
        Sets the enable_partial_auth of this CardProcessingConfigCommon.
        Allow merchants to accept partial authorization approvals. Applicable for Elavon Americas (elavonamericas), VPC, GPX (gpx), FDI Global (fdiglobal), FDC Nashville (smartfdc), GPN (gpn), TSYS (tsys), American Express Direct (amexdirect), Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :param enable_partial_auth: The enable_partial_auth of this CardProcessingConfigCommon.
        :type: bool
        """

        self._enable_partial_auth = enable_partial_auth

    @property
    def merchant_category_code(self):
        """
        Gets the merchant_category_code of this CardProcessingConfigCommon.
        Indicates type of business product or service of the merchant. Applicable for Chase Paymentech Salem (chasepaymentechsalem), FDI Global (fdiglobal), RUPAY, Elavon Americas (elavonamericas), American Express Direct (amexdirect), CMCIC (cmcic), GPX (gpx), VPC, TSYS (tsys), EFTPOS, CUP, Paymentech Tampa (paymentechtampa), CB2A, Barclays (barclays2), Prisma (prisma) and GPN (gpn) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> </table> 

        :return: The merchant_category_code of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._merchant_category_code

    @merchant_category_code.setter
    def merchant_category_code(self, merchant_category_code):
        """
        Sets the merchant_category_code of this CardProcessingConfigCommon.
        Indicates type of business product or service of the merchant. Applicable for Chase Paymentech Salem (chasepaymentechsalem), FDI Global (fdiglobal), RUPAY, Elavon Americas (elavonamericas), American Express Direct (amexdirect), CMCIC (cmcic), GPX (gpx), VPC, TSYS (tsys), EFTPOS, CUP, Paymentech Tampa (paymentechtampa), CB2A, Barclays (barclays2), Prisma (prisma) and GPN (gpn) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> </table> 

        :param merchant_category_code: The merchant_category_code of this CardProcessingConfigCommon.
        :type: str
        """

        self._merchant_category_code = merchant_category_code

    @property
    def sic_code(self):
        """
        Gets the sic_code of this CardProcessingConfigCommon.
        The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.

        :return: The sic_code of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._sic_code

    @sic_code.setter
    def sic_code(self, sic_code):
        """
        Sets the sic_code of this CardProcessingConfigCommon.
        The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.

        :param sic_code: The sic_code of this CardProcessingConfigCommon.
        :type: str
        """

        self._sic_code = sic_code

    @property
    def food_and_consumer_service_id(self):
        """
        Gets the food_and_consumer_service_id of this CardProcessingConfigCommon.
        Food and Consumer Service ID. Identifies the merchant as being certified and approved to accept Food Stamps. Applicable for GPX (gpx) processor.

        :return: The food_and_consumer_service_id of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._food_and_consumer_service_id

    @food_and_consumer_service_id.setter
    def food_and_consumer_service_id(self, food_and_consumer_service_id):
        """
        Sets the food_and_consumer_service_id of this CardProcessingConfigCommon.
        Food and Consumer Service ID. Identifies the merchant as being certified and approved to accept Food Stamps. Applicable for GPX (gpx) processor.

        :param food_and_consumer_service_id: The food_and_consumer_service_id of this CardProcessingConfigCommon.
        :type: str
        """

        self._food_and_consumer_service_id = food_and_consumer_service_id

    @property
    def enable_split_shipment(self):
        """
        Gets the enable_split_shipment of this CardProcessingConfigCommon.
        Enables you to split an order into multiple shipments with multiple captures. This feature is provided by CyberSource and supports three different scenarios:  * multiple authorizations * multiple captures * multiple authorizations with multiple captures  Applicable for VPC processors. 

        :return: The enable_split_shipment of this CardProcessingConfigCommon.
        :rtype: bool
        """
        return self._enable_split_shipment

    @enable_split_shipment.setter
    def enable_split_shipment(self, enable_split_shipment):
        """
        Sets the enable_split_shipment of this CardProcessingConfigCommon.
        Enables you to split an order into multiple shipments with multiple captures. This feature is provided by CyberSource and supports three different scenarios:  * multiple authorizations * multiple captures * multiple authorizations with multiple captures  Applicable for VPC processors. 

        :param enable_split_shipment: The enable_split_shipment of this CardProcessingConfigCommon.
        :type: bool
        """

        self._enable_split_shipment = enable_split_shipment

    @property
    def enable_interchange_optimization(self):
        """
        Gets the enable_interchange_optimization of this CardProcessingConfigCommon.
        Reduces your interchange fees by using automatic authorization refresh and automatic partial authorization reversal. Applicable for VPC processors.

        :return: The enable_interchange_optimization of this CardProcessingConfigCommon.
        :rtype: bool
        """
        return self._enable_interchange_optimization

    @enable_interchange_optimization.setter
    def enable_interchange_optimization(self, enable_interchange_optimization):
        """
        Sets the enable_interchange_optimization of this CardProcessingConfigCommon.
        Reduces your interchange fees by using automatic authorization refresh and automatic partial authorization reversal. Applicable for VPC processors.

        :param enable_interchange_optimization: The enable_interchange_optimization of this CardProcessingConfigCommon.
        :type: bool
        """

        self._enable_interchange_optimization = enable_interchange_optimization

    @property
    def visa_delegated_authentication_id(self):
        """
        Gets the visa_delegated_authentication_id of this CardProcessingConfigCommon.
        Identifier provided to merchants who opt for Visa's delegated authorization program. Applicable for VPC processors.

        :return: The visa_delegated_authentication_id of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._visa_delegated_authentication_id

    @visa_delegated_authentication_id.setter
    def visa_delegated_authentication_id(self, visa_delegated_authentication_id):
        """
        Sets the visa_delegated_authentication_id of this CardProcessingConfigCommon.
        Identifier provided to merchants who opt for Visa's delegated authorization program. Applicable for VPC processors.

        :param visa_delegated_authentication_id: The visa_delegated_authentication_id of this CardProcessingConfigCommon.
        :type: str
        """

        self._visa_delegated_authentication_id = visa_delegated_authentication_id

    @property
    def credit_card_refund_limit_percent(self):
        """
        Gets the credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        Blocks over-refunds when the aggregated refund amount is higher than the percentage set for this field. Applicable for GPX (gpx), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.

        :return: The credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._credit_card_refund_limit_percent

    @credit_card_refund_limit_percent.setter
    def credit_card_refund_limit_percent(self, credit_card_refund_limit_percent):
        """
        Sets the credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        Blocks over-refunds when the aggregated refund amount is higher than the percentage set for this field. Applicable for GPX (gpx), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.

        :param credit_card_refund_limit_percent: The credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        :type: str
        """

        self._credit_card_refund_limit_percent = credit_card_refund_limit_percent

    @property
    def business_center_credit_card_refund_limit_percent(self):
        """
        Gets the business_center_credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        Limits refunds to the percentage set in this field. Applicable for GPX (gpx) and VPC processors.

        :return: The business_center_credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._business_center_credit_card_refund_limit_percent

    @business_center_credit_card_refund_limit_percent.setter
    def business_center_credit_card_refund_limit_percent(self, business_center_credit_card_refund_limit_percent):
        """
        Sets the business_center_credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        Limits refunds to the percentage set in this field. Applicable for GPX (gpx) and VPC processors.

        :param business_center_credit_card_refund_limit_percent: The business_center_credit_card_refund_limit_percent of this CardProcessingConfigCommon.
        :type: str
        """

        self._business_center_credit_card_refund_limit_percent = business_center_credit_card_refund_limit_percent

    @property
    def allow_captures_greater_than_authorizations(self):
        """
        Gets the allow_captures_greater_than_authorizations of this CardProcessingConfigCommon.
        Enables this merchant account to capture amounts greater than the authorization amount. Applicable for GPX (gpx), VPC, Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.

        :return: The allow_captures_greater_than_authorizations of this CardProcessingConfigCommon.
        :rtype: bool
        """
        return self._allow_captures_greater_than_authorizations

    @allow_captures_greater_than_authorizations.setter
    def allow_captures_greater_than_authorizations(self, allow_captures_greater_than_authorizations):
        """
        Sets the allow_captures_greater_than_authorizations of this CardProcessingConfigCommon.
        Enables this merchant account to capture amounts greater than the authorization amount. Applicable for GPX (gpx), VPC, Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.

        :param allow_captures_greater_than_authorizations: The allow_captures_greater_than_authorizations of this CardProcessingConfigCommon.
        :type: bool
        """

        self._allow_captures_greater_than_authorizations = allow_captures_greater_than_authorizations

    @property
    def enable_duplicate_merchant_reference_number_blocking(self):
        """
        Gets the enable_duplicate_merchant_reference_number_blocking of this CardProcessingConfigCommon.
        Helps prevent duplicate transactions. Applicable for VPC, GPX (gpx) and Chase Paymentech Salem (chasepaymentechsalem) processors.

        :return: The enable_duplicate_merchant_reference_number_blocking of this CardProcessingConfigCommon.
        :rtype: bool
        """
        return self._enable_duplicate_merchant_reference_number_blocking

    @enable_duplicate_merchant_reference_number_blocking.setter
    def enable_duplicate_merchant_reference_number_blocking(self, enable_duplicate_merchant_reference_number_blocking):
        """
        Sets the enable_duplicate_merchant_reference_number_blocking of this CardProcessingConfigCommon.
        Helps prevent duplicate transactions. Applicable for VPC, GPX (gpx) and Chase Paymentech Salem (chasepaymentechsalem) processors.

        :param enable_duplicate_merchant_reference_number_blocking: The enable_duplicate_merchant_reference_number_blocking of this CardProcessingConfigCommon.
        :type: bool
        """

        self._enable_duplicate_merchant_reference_number_blocking = enable_duplicate_merchant_reference_number_blocking

    @property
    def domestic_merchant_id(self):
        """
        Gets the domestic_merchant_id of this CardProcessingConfigCommon.
        This is a local merchant ID used by merchants in addition to the conventional merchant ID. This value is sent to the issuer. Applicable for VPC and Prisma (prisma) processors.

        :return: The domestic_merchant_id of this CardProcessingConfigCommon.
        :rtype: bool
        """
        return self._domestic_merchant_id

    @domestic_merchant_id.setter
    def domestic_merchant_id(self, domestic_merchant_id):
        """
        Sets the domestic_merchant_id of this CardProcessingConfigCommon.
        This is a local merchant ID used by merchants in addition to the conventional merchant ID. This value is sent to the issuer. Applicable for VPC and Prisma (prisma) processors.

        :param domestic_merchant_id: The domestic_merchant_id of this CardProcessingConfigCommon.
        :type: bool
        """

        self._domestic_merchant_id = domestic_merchant_id

    @property
    def process_level3_data(self):
        """
        Gets the process_level3_data of this CardProcessingConfigCommon.
        Indicates whether merchant processes Level 3 transactions. Applicable for TSYS (tsys), Barclays (barclays2), Paymentech Tampa (paymentechtampa), FDI Global (fdiglobal), Elavon Americas (elavonamericas) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td></tr> </table> 

        :return: The process_level3_data of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._process_level3_data

    @process_level3_data.setter
    def process_level3_data(self, process_level3_data):
        """
        Sets the process_level3_data of this CardProcessingConfigCommon.
        Indicates whether merchant processes Level 3 transactions. Applicable for TSYS (tsys), Barclays (barclays2), Paymentech Tampa (paymentechtampa), FDI Global (fdiglobal), Elavon Americas (elavonamericas) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td></tr> </table> 

        :param process_level3_data: The process_level3_data of this CardProcessingConfigCommon.
        :type: str
        """

        self._process_level3_data = process_level3_data

    @property
    def sub_merchant_id(self):
        """
        Gets the sub_merchant_id of this CardProcessingConfigCommon.
        The ID assigned to the sub-merchant. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>20</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> 

        :return: The sub_merchant_id of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._sub_merchant_id

    @sub_merchant_id.setter
    def sub_merchant_id(self, sub_merchant_id):
        """
        Sets the sub_merchant_id of this CardProcessingConfigCommon.
        The ID assigned to the sub-merchant. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>20</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> 

        :param sub_merchant_id: The sub_merchant_id of this CardProcessingConfigCommon.
        :type: str
        """

        self._sub_merchant_id = sub_merchant_id

    @property
    def sub_merchant_business_name(self):
        """
        Gets the sub_merchant_business_name of this CardProcessingConfigCommon.
        Sub-merchant's business name. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>37</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> 

        :return: The sub_merchant_business_name of this CardProcessingConfigCommon.
        :rtype: str
        """
        return self._sub_merchant_business_name

    @sub_merchant_business_name.setter
    def sub_merchant_business_name(self, sub_merchant_business_name):
        """
        Sets the sub_merchant_business_name of this CardProcessingConfigCommon.
        Sub-merchant's business name. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>37</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> 

        :param sub_merchant_business_name: The sub_merchant_business_name of this CardProcessingConfigCommon.
        :type: str
        """

        self._sub_merchant_business_name = sub_merchant_business_name

    @property
    def prefer_cobadged_secondary_brand(self):
        """
        Gets the prefer_cobadged_secondary_brand of this CardProcessingConfigCommon.
        It denotes merchant's preference on secondary brand for routing in case of co-branded cards. Applicable for EFTPOS processors.

        :return: The prefer_cobadged_secondary_brand of this CardProcessingConfigCommon.
        :rtype: bool
        """
        return self._prefer_cobadged_secondary_brand

    @prefer_cobadged_secondary_brand.setter
    def prefer_cobadged_secondary_brand(self, prefer_cobadged_secondary_brand):
        """
        Sets the prefer_cobadged_secondary_brand of this CardProcessingConfigCommon.
        It denotes merchant's preference on secondary brand for routing in case of co-branded cards. Applicable for EFTPOS processors.

        :param prefer_cobadged_secondary_brand: The prefer_cobadged_secondary_brand of this CardProcessingConfigCommon.
        :type: bool
        """

        self._prefer_cobadged_secondary_brand = prefer_cobadged_secondary_brand

    @property
    def merchant_descriptor_information(self):
        """
        Gets the merchant_descriptor_information of this CardProcessingConfigCommon.

        :return: The merchant_descriptor_information of this CardProcessingConfigCommon.
        :rtype: CardProcessingConfigCommonMerchantDescriptorInformation
        """
        return self._merchant_descriptor_information

    @merchant_descriptor_information.setter
    def merchant_descriptor_information(self, merchant_descriptor_information):
        """
        Sets the merchant_descriptor_information of this CardProcessingConfigCommon.

        :param merchant_descriptor_information: The merchant_descriptor_information of this CardProcessingConfigCommon.
        :type: CardProcessingConfigCommonMerchantDescriptorInformation
        """

        self._merchant_descriptor_information = merchant_descriptor_information

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CardProcessingConfigCommon):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
