# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CreateSearchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'save': 'bool',
        'name': 'str',
        'timezone': 'str',
        'query': 'str',
        'offset': 'int',
        'limit': 'int',
        'sort': 'str'
    }

    attribute_map = {
        'save': 'save',
        'name': 'name',
        'timezone': 'timezone',
        'query': 'query',
        'offset': 'offset',
        'limit': 'limit',
        'sort': 'sort'
    }

    def __init__(self, save=None, name=None, timezone=None, query=None, offset=None, limit=None, sort=None):
        """
        CreateSearchRequest - a model defined in Swagger
        """

        self._save = None
        self._name = None
        self._timezone = None
        self._query = None
        self._offset = None
        self._limit = None
        self._sort = None

        if save is not None:
          self.save = save
        if name is not None:
          self.name = name
        if timezone is not None:
          self.timezone = timezone
        if query is not None:
          self.query = query
        if offset is not None:
          self.offset = offset
        if limit is not None:
          self.limit = limit
        if sort is not None:
          self.sort = sort

    @property
    def save(self):
        """
        Gets the save of this CreateSearchRequest.
        Indicates whether or not you want to save this search request for future use. The options are:  * `true` * `false` (default value)  If set to `true`, this field returns `searchID` in the response. You can use this value to retrieve the details of the saved search. 

        :return: The save of this CreateSearchRequest.
        :rtype: bool
        """
        return self._save

    @save.setter
    def save(self, save):
        """
        Sets the save of this CreateSearchRequest.
        Indicates whether or not you want to save this search request for future use. The options are:  * `true` * `false` (default value)  If set to `true`, this field returns `searchID` in the response. You can use this value to retrieve the details of the saved search. 

        :param save: The save of this CreateSearchRequest.
        :type: bool
        """

        self._save = save

    @property
    def name(self):
        """
        Gets the name of this CreateSearchRequest.
        Name of this search. When `save` is set to `true`, this search is saved with this name. 

        :return: The name of this CreateSearchRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateSearchRequest.
        Name of this search. When `save` is set to `true`, this search is saved with this name. 

        :param name: The name of this CreateSearchRequest.
        :type: str
        """

        self._name = name

    @property
    def timezone(self):
        """
        Gets the timezone of this CreateSearchRequest.
        Merchant's time zone in ISO standard, using the TZ database format. For example: `America/Chicago` 

        :return: The timezone of this CreateSearchRequest.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this CreateSearchRequest.
        Merchant's time zone in ISO standard, using the TZ database format. For example: `America/Chicago` 

        :param timezone: The timezone of this CreateSearchRequest.
        :type: str
        """

        self._timezone = timezone

    @property
    def query(self):
        """
        Gets the query of this CreateSearchRequest.
        String that contains the filters and variables for which you want to search. For information about supported field-filters and operators, see the [Query Filters]( https://developer.cybersource.com/api/developer-guides/dita-txn-search-details-rest-api-dev-guide-102718/txn-search-intro/txn-filtering.html) section of the Transaction Search Developer Guide. 

        :return: The query of this CreateSearchRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this CreateSearchRequest.
        String that contains the filters and variables for which you want to search. For information about supported field-filters and operators, see the [Query Filters]( https://developer.cybersource.com/api/developer-guides/dita-txn-search-details-rest-api-dev-guide-102718/txn-search-intro/txn-filtering.html) section of the Transaction Search Developer Guide. 

        :param query: The query of this CreateSearchRequest.
        :type: str
        """

        self._query = query

    @property
    def offset(self):
        """
        Gets the offset of this CreateSearchRequest.
        Controls the starting point within the collection of results, which defaults to 0. The first item in the collection is retrieved by setting a zero offset.  For example, if you have a collection of 15 items to be retrieved from a resource and you specify limit=5, you can retrieve the entire set of results in 3 successive requests by varying the offset value like this:  `offset=0` `offset=5` `offset=10`  **Note:** If an offset larger than the number of results is provided, this will result in no embedded object being returned. 

        :return: The offset of this CreateSearchRequest.
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this CreateSearchRequest.
        Controls the starting point within the collection of results, which defaults to 0. The first item in the collection is retrieved by setting a zero offset.  For example, if you have a collection of 15 items to be retrieved from a resource and you specify limit=5, you can retrieve the entire set of results in 3 successive requests by varying the offset value like this:  `offset=0` `offset=5` `offset=10`  **Note:** If an offset larger than the number of results is provided, this will result in no embedded object being returned. 

        :param offset: The offset of this CreateSearchRequest.
        :type: int
        """

        self._offset = offset

    @property
    def limit(self):
        """
        Gets the limit of this CreateSearchRequest.
        Controls the maximum number of items that may be returned for a single request. The default is 20, the maximum is 2500. 

        :return: The limit of this CreateSearchRequest.
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """
        Sets the limit of this CreateSearchRequest.
        Controls the maximum number of items that may be returned for a single request. The default is 20, the maximum is 2500. 

        :param limit: The limit of this CreateSearchRequest.
        :type: int
        """

        self._limit = limit

    @property
    def sort(self):
        """
        Gets the sort of this CreateSearchRequest.
        A comma separated list of the following form:  `submitTimeUtc:desc` 

        :return: The sort of this CreateSearchRequest.
        :rtype: str
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """
        Sets the sort of this CreateSearchRequest.
        A comma separated list of the following form:  `submitTimeUtc:desc` 

        :param sort: The sort of this CreateSearchRequest.
        :type: str
        """

        self._sort = sort

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CreateSearchRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
