# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PtsV2PaymentsPost201ResponseIssuerInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'country': 'str',
        'discretionary_data': 'str',
        'country_specific_discretionary_data': 'str',
        'response_code': 'str',
        'pin_request_indicator': 'str'
    }

    attribute_map = {
        'country': 'country',
        'discretionary_data': 'discretionaryData',
        'country_specific_discretionary_data': 'countrySpecificDiscretionaryData',
        'response_code': 'responseCode',
        'pin_request_indicator': 'pinRequestIndicator'
    }

    def __init__(self, country=None, discretionary_data=None, country_specific_discretionary_data=None, response_code=None, pin_request_indicator=None):
        """
        PtsV2PaymentsPost201ResponseIssuerInformation - a model defined in Swagger
        """

        self._country = None
        self._discretionary_data = None
        self._country_specific_discretionary_data = None
        self._response_code = None
        self._pin_request_indicator = None

        if country is not None:
          self.country = country
        if discretionary_data is not None:
          self.discretionary_data = discretionary_data
        if country_specific_discretionary_data is not None:
          self.country_specific_discretionary_data = country_specific_discretionary_data
        if response_code is not None:
          self.response_code = response_code
        if pin_request_indicator is not None:
          self.pin_request_indicator = pin_request_indicator

    @property
    def country(self):
        """
        Gets the country of this PtsV2PaymentsPost201ResponseIssuerInformation.
        Country in which the card was issued. This information enables you to determine whether the card was issued domestically or internationally. Use the two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).  This field is supported for Visa, Mastercard, Discover, Diners Club, JCB, and Maestro (International) on Chase Paymentech Solutions.  For details, see `auth_card_issuer_country` field description in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The country of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this PtsV2PaymentsPost201ResponseIssuerInformation.
        Country in which the card was issued. This information enables you to determine whether the card was issued domestically or internationally. Use the two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).  This field is supported for Visa, Mastercard, Discover, Diners Club, JCB, and Maestro (International) on Chase Paymentech Solutions.  For details, see `auth_card_issuer_country` field description in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param country: The country of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :type: str
        """

        self._country = country

    @property
    def discretionary_data(self):
        """
        Gets the discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        Data defined by the issuer.  The value for this reply field will probably be the same as the value that you submitted in the authorization request, but it is possible for the processor, issuer, or acquirer to modify the value.  This field is supported only for Visa transactions on **CyberSource through VisaNet**.  For details, see `issuer_additional_data` field description in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :rtype: str
        """
        return self._discretionary_data

    @discretionary_data.setter
    def discretionary_data(self, discretionary_data):
        """
        Sets the discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        Data defined by the issuer.  The value for this reply field will probably be the same as the value that you submitted in the authorization request, but it is possible for the processor, issuer, or acquirer to modify the value.  This field is supported only for Visa transactions on **CyberSource through VisaNet**.  For details, see `issuer_additional_data` field description in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param discretionary_data: The discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :type: str
        """

        self._discretionary_data = discretionary_data

    @property
    def country_specific_discretionary_data(self):
        """
        Gets the country_specific_discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        Data defined by the issuer.  This national use field contains two subfields for information unique to the processing of Visa transactions by members in Japan. This subfield contains the Katakana text to be printed on the receipt. For details, see `jpo_issuer_message` field description in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The country_specific_discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :rtype: str
        """
        return self._country_specific_discretionary_data

    @country_specific_discretionary_data.setter
    def country_specific_discretionary_data(self, country_specific_discretionary_data):
        """
        Sets the country_specific_discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        Data defined by the issuer.  This national use field contains two subfields for information unique to the processing of Visa transactions by members in Japan. This subfield contains the Katakana text to be printed on the receipt. For details, see `jpo_issuer_message` field description in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param country_specific_discretionary_data: The country_specific_discretionary_data of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :type: str
        """

        self._country_specific_discretionary_data = country_specific_discretionary_data

    @property
    def response_code(self):
        """
        Gets the response_code of this PtsV2PaymentsPost201ResponseIssuerInformation.
        This is the raw Association/Issuer Response Codes. You can use 'issuer/association' response codes to identify when you can retry to authorize a declined transaction and increase successful transaction volumes. You'll receive an association/issuer response code for the majority of transactions.  #### Processors supported:   - HSBC   - FDC Nashville Global   - SIX  Currently SIX is not receiving Association/Issuer Response Codes here it receives the additional authorization code that must be printed on the receipt when returned by the processor.  #### Possible values: | Card Type   | Response Code | Description                                                                    | | ----------- | ------------- | ------------------------------------------------------------------------------ | | VISA        | 000           | Successful approval/completion or that V.I.P. PIN verification is successful   | | VISA        | 001           | Refer to card issuer                                                           | | VISA        | 002           | Refer to card issuer, special condition                                        | | VISA        | 003           | Invalid merchant or service provider                                           | | VISA        | 004           | Pickup card                                                                    |   | MasterCard  | 000           | Approved or completed successfully                                             | | MasterCard  | 001           | Refer to card issuer                                                           | | MasterCard  | 003           | Invalid merchant                                                               | | MasterCard  | 004           | Capture card                                                                   | | MasterCard  | 005           | Do not honor                                                                   | | AMEX        | 000           | Approved                                                                       | | AMEX        | 001           | Approve with ID                                                                | | AMEX        | 002           | Partial Approval (Prepaid Cards only)                                          | | AMEX        | 100           | Deny                                                                           | | AMEX        | 101           | Expired Card/Invalid Expiration Date                                           | | Discover    | 000           | Approved or completed successfully                                             | | Discover    | 001           | Reserved for future USE                                                        | | Discover    | 002           | Reserved for future USE                                                        | | Discover    | 003           | Invalid Merchant                                                               | | Discover    | 004           | Capture Card                                                                   | | ....        | ...           | For details, see `issuerInformation. responseCode` field description in the [Credit Card Service Using the SCMP API Guide.] (https://developer.cybersource.com/content/dam/docs/cybs/en-us/api-fields/reference/all/rest/api-fields.pdf)|    

        :return: The response_code of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :rtype: str
        """
        return self._response_code

    @response_code.setter
    def response_code(self, response_code):
        """
        Sets the response_code of this PtsV2PaymentsPost201ResponseIssuerInformation.
        This is the raw Association/Issuer Response Codes. You can use 'issuer/association' response codes to identify when you can retry to authorize a declined transaction and increase successful transaction volumes. You'll receive an association/issuer response code for the majority of transactions.  #### Processors supported:   - HSBC   - FDC Nashville Global   - SIX  Currently SIX is not receiving Association/Issuer Response Codes here it receives the additional authorization code that must be printed on the receipt when returned by the processor.  #### Possible values: | Card Type   | Response Code | Description                                                                    | | ----------- | ------------- | ------------------------------------------------------------------------------ | | VISA        | 000           | Successful approval/completion or that V.I.P. PIN verification is successful   | | VISA        | 001           | Refer to card issuer                                                           | | VISA        | 002           | Refer to card issuer, special condition                                        | | VISA        | 003           | Invalid merchant or service provider                                           | | VISA        | 004           | Pickup card                                                                    |   | MasterCard  | 000           | Approved or completed successfully                                             | | MasterCard  | 001           | Refer to card issuer                                                           | | MasterCard  | 003           | Invalid merchant                                                               | | MasterCard  | 004           | Capture card                                                                   | | MasterCard  | 005           | Do not honor                                                                   | | AMEX        | 000           | Approved                                                                       | | AMEX        | 001           | Approve with ID                                                                | | AMEX        | 002           | Partial Approval (Prepaid Cards only)                                          | | AMEX        | 100           | Deny                                                                           | | AMEX        | 101           | Expired Card/Invalid Expiration Date                                           | | Discover    | 000           | Approved or completed successfully                                             | | Discover    | 001           | Reserved for future USE                                                        | | Discover    | 002           | Reserved for future USE                                                        | | Discover    | 003           | Invalid Merchant                                                               | | Discover    | 004           | Capture Card                                                                   | | ....        | ...           | For details, see `issuerInformation. responseCode` field description in the [Credit Card Service Using the SCMP API Guide.] (https://developer.cybersource.com/content/dam/docs/cybs/en-us/api-fields/reference/all/rest/api-fields.pdf)|    

        :param response_code: The response_code of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :type: str
        """

        self._response_code = response_code

    @property
    def pin_request_indicator(self):
        """
        Gets the pin_request_indicator of this PtsV2PaymentsPost201ResponseIssuerInformation.
        This field contains value '1' which is sent by Issuer in the response when PIN is requested by issuer,   This field is only supported for Visa Platform Connect. 

        :return: The pin_request_indicator of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :rtype: str
        """
        return self._pin_request_indicator

    @pin_request_indicator.setter
    def pin_request_indicator(self, pin_request_indicator):
        """
        Sets the pin_request_indicator of this PtsV2PaymentsPost201ResponseIssuerInformation.
        This field contains value '1' which is sent by Issuer in the response when PIN is requested by issuer,   This field is only supported for Visa Platform Connect. 

        :param pin_request_indicator: The pin_request_indicator of this PtsV2PaymentsPost201ResponseIssuerInformation.
        :type: str
        """

        self._pin_request_indicator = pin_request_indicator

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PtsV2PaymentsPost201ResponseIssuerInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
