# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PtsV2PaymentsPost201ResponseOrderInformationAmountDetails(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'total_amount': 'str',
        'authorized_amount': 'str',
        'currency': 'str',
        'processor_transaction_fee': 'str',
        'exchange_rate': 'str',
        'foreign_currency': 'str',
        'foreign_amount': 'str',
        'discount_amount': 'str'
    }

    attribute_map = {
        'total_amount': 'totalAmount',
        'authorized_amount': 'authorizedAmount',
        'currency': 'currency',
        'processor_transaction_fee': 'processorTransactionFee',
        'exchange_rate': 'exchangeRate',
        'foreign_currency': 'foreignCurrency',
        'foreign_amount': 'foreignAmount',
        'discount_amount': 'discountAmount'
    }

    def __init__(self, total_amount=None, authorized_amount=None, currency=None, processor_transaction_fee=None, exchange_rate=None, foreign_currency=None, foreign_amount=None, discount_amount=None):
        """
        PtsV2PaymentsPost201ResponseOrderInformationAmountDetails - a model defined in Swagger
        """

        self._total_amount = None
        self._authorized_amount = None
        self._currency = None
        self._processor_transaction_fee = None
        self._exchange_rate = None
        self._foreign_currency = None
        self._foreign_amount = None
        self._discount_amount = None

        if total_amount is not None:
          self.total_amount = total_amount
        if authorized_amount is not None:
          self.authorized_amount = authorized_amount
        if currency is not None:
          self.currency = currency
        if processor_transaction_fee is not None:
          self.processor_transaction_fee = processor_transaction_fee
        if exchange_rate is not None:
          self.exchange_rate = exchange_rate
        if foreign_currency is not None:
          self.foreign_currency = foreign_currency
        if foreign_amount is not None:
          self.foreign_amount = foreign_amount
        if discount_amount is not None:
          self.discount_amount = discount_amount

    @property
    def total_amount(self):
        """
        Gets the total_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Amount you requested for the payment or capture.  This value is returned for partial authorizations. This field is also returned on incremental authorizations will contain the aggregated amount from the original authorizations and all the incremental authorizations. 

        :return: The total_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """
        Sets the total_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Amount you requested for the payment or capture.  This value is returned for partial authorizations. This field is also returned on incremental authorizations will contain the aggregated amount from the original authorizations and all the incremental authorizations. 

        :param total_amount: The total_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._total_amount = total_amount

    @property
    def authorized_amount(self):
        """
        Gets the authorized_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Amount that was authorized.  Returned by authorization service.  #### PIN debit Amount of the purchase.  Returned by PIN debit purchase.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in Merchant Descriptors Using the SCMP API. 

        :return: The authorized_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._authorized_amount

    @authorized_amount.setter
    def authorized_amount(self, authorized_amount):
        """
        Sets the authorized_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Amount that was authorized.  Returned by authorization service.  #### PIN debit Amount of the purchase.  Returned by PIN debit purchase.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in Merchant Descriptors Using the SCMP API. 

        :param authorized_amount: The authorized_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._authorized_amount = authorized_amount

    @property
    def currency(self):
        """
        Gets the currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Currency used for the order. Use the three-character [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)  #### Used by **Authorization** Required field.  **Authorization Reversal** For an authorization reversal (`reversalInformation`) or a capture (`processingOptions.capture` is set to `true`), you must use the same currency that you used in your payment authorization request.  #### PIN Debit Currency for the amount you requested for the PIN debit purchase. This value is returned for partial authorizations. The issuing bank can approve a partial amount if the balance on the debit card is less than the requested transaction amount. For the possible values, see the [ISO Standard Currency Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/currencies.pdf). Returned by PIN debit purchase.  For PIN debit reversal requests, you must use the same currency that was used for the PIN debit purchase or PIN debit credit that you are reversing. For the possible values, see the [ISO Standard Currency Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/currencies.pdf).  Required field for PIN Debit purchase and PIN Debit credit requests. Optional field for PIN Debit reversal requests.  #### GPX This field is optional for reversing an authorization or credit.  #### DCC for First Data Your local currency. For details, see the `currency` field description in [Dynamic Currency Conversion For First Data Using the SCMP API](http://apps.cybersource.com/library/documentation/dev_guides/DCC_FirstData_SCMP/DCC_FirstData_SCMP_API.pdf).  #### Tax Calculation Required for international tax and value added tax only. Optional for U.S. and Canadian taxes. Your local currency. 

        :return: The currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Currency used for the order. Use the three-character [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)  #### Used by **Authorization** Required field.  **Authorization Reversal** For an authorization reversal (`reversalInformation`) or a capture (`processingOptions.capture` is set to `true`), you must use the same currency that you used in your payment authorization request.  #### PIN Debit Currency for the amount you requested for the PIN debit purchase. This value is returned for partial authorizations. The issuing bank can approve a partial amount if the balance on the debit card is less than the requested transaction amount. For the possible values, see the [ISO Standard Currency Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/currencies.pdf). Returned by PIN debit purchase.  For PIN debit reversal requests, you must use the same currency that was used for the PIN debit purchase or PIN debit credit that you are reversing. For the possible values, see the [ISO Standard Currency Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/currencies.pdf).  Required field for PIN Debit purchase and PIN Debit credit requests. Optional field for PIN Debit reversal requests.  #### GPX This field is optional for reversing an authorization or credit.  #### DCC for First Data Your local currency. For details, see the `currency` field description in [Dynamic Currency Conversion For First Data Using the SCMP API](http://apps.cybersource.com/library/documentation/dev_guides/DCC_FirstData_SCMP/DCC_FirstData_SCMP_API.pdf).  #### Tax Calculation Required for international tax and value added tax only. Optional for U.S. and Canadian taxes. Your local currency. 

        :param currency: The currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._currency = currency

    @property
    def processor_transaction_fee(self):
        """
        Gets the processor_transaction_fee of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Amount up to N digit after the decimals separator as defined in ISO 4217 for the appropriate currency code. 

        :return: The processor_transaction_fee of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._processor_transaction_fee

    @processor_transaction_fee.setter
    def processor_transaction_fee(self, processor_transaction_fee):
        """
        Sets the processor_transaction_fee of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Amount up to N digit after the decimals separator as defined in ISO 4217 for the appropriate currency code. 

        :param processor_transaction_fee: The processor_transaction_fee of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._processor_transaction_fee = processor_transaction_fee

    @property
    def exchange_rate(self):
        """
        Gets the exchange_rate of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        The rate of conversion of the currency given in the request to CNY. The conversion happens at the time when Alipay's trade order is created 

        :return: The exchange_rate of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._exchange_rate

    @exchange_rate.setter
    def exchange_rate(self, exchange_rate):
        """
        Sets the exchange_rate of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        The rate of conversion of the currency given in the request to CNY. The conversion happens at the time when Alipay's trade order is created 

        :param exchange_rate: The exchange_rate of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._exchange_rate = exchange_rate

    @property
    def foreign_currency(self):
        """
        Gets the foreign_currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Currency code for the transaction performed in cross border currency. 

        :return: The foreign_currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._foreign_currency

    @foreign_currency.setter
    def foreign_currency(self, foreign_currency):
        """
        Sets the foreign_currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        Currency code for the transaction performed in cross border currency. 

        :param foreign_currency: The foreign_currency of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._foreign_currency = foreign_currency

    @property
    def foreign_amount(self):
        """
        Gets the foreign_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        The transaction amount in CNY. 

        :return: The foreign_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._foreign_amount

    @foreign_amount.setter
    def foreign_amount(self, foreign_amount):
        """
        Sets the foreign_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        The transaction amount in CNY. 

        :param foreign_amount: The foreign_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._foreign_amount = foreign_amount

    @property
    def discount_amount(self):
        """
        Gets the discount_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        If coupons/vouchers are used in the transaction, the discount amount redeemed in the settlement currency will be returned. Otherwise, no return. 

        :return: The discount_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :rtype: str
        """
        return self._discount_amount

    @discount_amount.setter
    def discount_amount(self, discount_amount):
        """
        Sets the discount_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        If coupons/vouchers are used in the transaction, the discount amount redeemed in the settlement currency will be returned. Otherwise, no return. 

        :param discount_amount: The discount_amount of this PtsV2PaymentsPost201ResponseOrderInformationAmountDetails.
        :type: str
        """

        self._discount_amount = discount_amount

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PtsV2PaymentsPost201ResponseOrderInformationAmountDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
