# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Ptsv2creditsSenderInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'first_name': 'str',
        'last_name': 'str',
        'address1': 'str',
        'locality': 'str',
        'country_code': 'str',
        'account': 'Ptsv2creditsSenderInformationAccount'
    }

    attribute_map = {
        'first_name': 'firstName',
        'last_name': 'lastName',
        'address1': 'address1',
        'locality': 'locality',
        'country_code': 'countryCode',
        'account': 'account'
    }

    def __init__(self, first_name=None, last_name=None, address1=None, locality=None, country_code=None, account=None):
        """
        Ptsv2creditsSenderInformation - a model defined in Swagger
        """

        self._first_name = None
        self._last_name = None
        self._address1 = None
        self._locality = None
        self._country_code = None
        self._account = None

        if first_name is not None:
          self.first_name = first_name
        if last_name is not None:
          self.last_name = last_name
        if address1 is not None:
          self.address1 = address1
        if locality is not None:
          self.locality = locality
        if country_code is not None:
          self.country_code = country_code
        if account is not None:
          self.account = account

    @property
    def first_name(self):
        """
        Gets the first_name of this Ptsv2creditsSenderInformation.
        First name of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 35 characters including spaces. * Required for POW on Barclays. 

        :return: The first_name of this Ptsv2creditsSenderInformation.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this Ptsv2creditsSenderInformation.
        First name of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 35 characters including spaces. * Required for POW on Barclays. 

        :param first_name: The first_name of this Ptsv2creditsSenderInformation.
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this Ptsv2creditsSenderInformation.
        Last name of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Optional for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 35 characters including spaces. * Optional for POW on Barclays. 

        :return: The last_name of this Ptsv2creditsSenderInformation.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this Ptsv2creditsSenderInformation.
        Last name of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Optional for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 35 characters including spaces. * Optional for POW on Barclays. 

        :param last_name: The last_name of this Ptsv2creditsSenderInformation.
        :type: str
        """

        self._last_name = last_name

    @property
    def address1(self):
        """
        Gets the address1 of this Ptsv2creditsSenderInformation.
        Street address of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 50 characters including spaces. * Required for POW on Barclays. 

        :return: The address1 of this Ptsv2creditsSenderInformation.
        :rtype: str
        """
        return self._address1

    @address1.setter
    def address1(self, address1):
        """
        Sets the address1 of this Ptsv2creditsSenderInformation.
        Street address of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 50 characters including spaces. * Required for POW on Barclays. 

        :param address1: The address1 of this Ptsv2creditsSenderInformation.
        :type: str
        """

        self._address1 = address1

    @property
    def locality(self):
        """
        Gets the locality of this Ptsv2creditsSenderInformation.
        City of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 25 characters including spaces. * Required for POW on Barclays. 

        :return: The locality of this Ptsv2creditsSenderInformation.
        :rtype: str
        """
        return self._locality

    @locality.setter
    def locality(self, locality):
        """
        Sets the locality of this Ptsv2creditsSenderInformation.
        City of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must not be all numeric. * Must contain only ASCII characters in range 32-122. * Must not be greater than 25 characters including spaces. * Required for POW on Barclays. 

        :param locality: The locality of this Ptsv2creditsSenderInformation.
        :type: str
        """

        self._locality = locality

    @property
    def country_code(self):
        """
        Gets the country_code of this Ptsv2creditsSenderInformation.
        Country of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must be a valid three character ISO country code as defined by ISO 3166. * Must not be greater than 3 characters. * Required for POW on Barclays. 

        :return: The country_code of this Ptsv2creditsSenderInformation.
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """
        Sets the country_code of this Ptsv2creditsSenderInformation.
        Country of the sender of the funds. For Gaming Payment of Winnings transactions these are the merchant details. * Required for Mastercard Payment of Winnings (POW) transactions. * Must be a valid three character ISO country code as defined by ISO 3166. * Must not be greater than 3 characters. * Required for POW on Barclays. 

        :param country_code: The country_code of this Ptsv2creditsSenderInformation.
        :type: str
        """

        self._country_code = country_code

    @property
    def account(self):
        """
        Gets the account of this Ptsv2creditsSenderInformation.

        :return: The account of this Ptsv2creditsSenderInformation.
        :rtype: Ptsv2creditsSenderInformationAccount
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this Ptsv2creditsSenderInformation.

        :param account: The account of this Ptsv2creditsSenderInformation.
        :type: Ptsv2creditsSenderInformationAccount
        """

        self._account = account

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2creditsSenderInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
