# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cavv': 'str',
        'transaction_flow_indicator': 'str',
        'cavv_algorithm': 'str',
        'eci_raw': 'str',
        'pares_status': 'str',
        'veres_enrolled': 'str',
        'xid': 'str',
        'ucaf_collection_indicator': 'str',
        'ucaf_authentication_data': 'str',
        'strong_authentication': 'Ptsv2paymentsConsumerAuthenticationInformationStrongAuthentication',
        'directory_server_transaction_id': 'str',
        'pa_specification_version': 'str',
        'authentication_type': 'str',
        'response_access_token': 'str',
        'acs_transaction_id': 'str',
        'acs_window_size': 'str',
        'alternate_authentication_data': 'str',
        'alternate_authentication_date': 'str',
        'alternate_authentication_method': 'str',
        'authentication_date': 'str',
        'authentication_transaction_id': 'str',
        'challenge_cancel_code': 'str',
        'challenge_code': 'str',
        'challenge_status': 'str',
        'customer_card_alias': 'str',
        'decoupled_authentication_indicator': 'str',
        'decoupled_authentication_max_time': 'str',
        'default_card': 'bool',
        'device_channel': 'str',
        'installment_total_count': 'int',
        'merchant_fraud_rate': 'str',
        'marketing_opt_in': 'bool',
        'marketing_source': 'str',
        'mcc': 'str',
        'merchant_score': 'int',
        'message_category': 'str',
        'network_score': 'str',
        'npa_code': 'str',
        'override_payment_method': 'str',
        'override_country_code': 'str',
        'prior_authentication_data': 'str',
        'prior_authentication_method': 'str',
        'prior_authentication_reference_id': 'str',
        'prior_authentication_time': 'str',
        'product_code': 'str',
        'return_url': 'str',
        'requestor_id': 'str',
        'requestor_initiated_authentication_indicator': 'str',
        'requestor_name': 'str',
        'reference_id': 'str',
        'sdk_max_timeout': 'str',
        'secure_corporate_payment_indicator': 'str',
        'transaction_mode': 'str',
        'white_list_status': 'str',
        'effective_authentication_type': 'str',
        'signed_pares_status_reason': 'str',
        'signed_pares': 'str'
    }

    attribute_map = {
        'cavv': 'cavv',
        'transaction_flow_indicator': 'transactionFlowIndicator',
        'cavv_algorithm': 'cavvAlgorithm',
        'eci_raw': 'eciRaw',
        'pares_status': 'paresStatus',
        'veres_enrolled': 'veresEnrolled',
        'xid': 'xid',
        'ucaf_collection_indicator': 'ucafCollectionIndicator',
        'ucaf_authentication_data': 'ucafAuthenticationData',
        'strong_authentication': 'strongAuthentication',
        'directory_server_transaction_id': 'directoryServerTransactionId',
        'pa_specification_version': 'paSpecificationVersion',
        'authentication_type': 'authenticationType',
        'response_access_token': 'responseAccessToken',
        'acs_transaction_id': 'acsTransactionId',
        'acs_window_size': 'acsWindowSize',
        'alternate_authentication_data': 'alternateAuthenticationData',
        'alternate_authentication_date': 'alternateAuthenticationDate',
        'alternate_authentication_method': 'alternateAuthenticationMethod',
        'authentication_date': 'authenticationDate',
        'authentication_transaction_id': 'authenticationTransactionId',
        'challenge_cancel_code': 'challengeCancelCode',
        'challenge_code': 'challengeCode',
        'challenge_status': 'challengeStatus',
        'customer_card_alias': 'customerCardAlias',
        'decoupled_authentication_indicator': 'decoupledAuthenticationIndicator',
        'decoupled_authentication_max_time': 'decoupledAuthenticationMaxTime',
        'default_card': 'defaultCard',
        'device_channel': 'deviceChannel',
        'installment_total_count': 'installmentTotalCount',
        'merchant_fraud_rate': 'merchantFraudRate',
        'marketing_opt_in': 'marketingOptIn',
        'marketing_source': 'marketingSource',
        'mcc': 'mcc',
        'merchant_score': 'merchantScore',
        'message_category': 'messageCategory',
        'network_score': 'networkScore',
        'npa_code': 'npaCode',
        'override_payment_method': 'overridePaymentMethod',
        'override_country_code': 'overrideCountryCode',
        'prior_authentication_data': 'priorAuthenticationData',
        'prior_authentication_method': 'priorAuthenticationMethod',
        'prior_authentication_reference_id': 'priorAuthenticationReferenceId',
        'prior_authentication_time': 'priorAuthenticationTime',
        'product_code': 'productCode',
        'return_url': 'returnUrl',
        'requestor_id': 'requestorId',
        'requestor_initiated_authentication_indicator': 'requestorInitiatedAuthenticationIndicator',
        'requestor_name': 'requestorName',
        'reference_id': 'referenceId',
        'sdk_max_timeout': 'sdkMaxTimeout',
        'secure_corporate_payment_indicator': 'secureCorporatePaymentIndicator',
        'transaction_mode': 'transactionMode',
        'white_list_status': 'whiteListStatus',
        'effective_authentication_type': 'effectiveAuthenticationType',
        'signed_pares_status_reason': 'signedParesStatusReason',
        'signed_pares': 'signedPares'
    }

    def __init__(self, cavv=None, transaction_flow_indicator=None, cavv_algorithm=None, eci_raw=None, pares_status=None, veres_enrolled=None, xid=None, ucaf_collection_indicator=None, ucaf_authentication_data=None, strong_authentication=None, directory_server_transaction_id=None, pa_specification_version=None, authentication_type=None, response_access_token=None, acs_transaction_id=None, acs_window_size=None, alternate_authentication_data=None, alternate_authentication_date=None, alternate_authentication_method=None, authentication_date=None, authentication_transaction_id=None, challenge_cancel_code=None, challenge_code=None, challenge_status=None, customer_card_alias=None, decoupled_authentication_indicator=None, decoupled_authentication_max_time=None, default_card=None, device_channel=None, installment_total_count=None, merchant_fraud_rate=None, marketing_opt_in=None, marketing_source=None, mcc=None, merchant_score=None, message_category=None, network_score=None, npa_code=None, override_payment_method=None, override_country_code=None, prior_authentication_data=None, prior_authentication_method=None, prior_authentication_reference_id=None, prior_authentication_time=None, product_code=None, return_url=None, requestor_id=None, requestor_initiated_authentication_indicator=None, requestor_name=None, reference_id=None, sdk_max_timeout=None, secure_corporate_payment_indicator=None, transaction_mode=None, white_list_status=None, effective_authentication_type=None, signed_pares_status_reason=None, signed_pares=None):
        """
        Ptsv2paymentsConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._cavv = None
        self._transaction_flow_indicator = None
        self._cavv_algorithm = None
        self._eci_raw = None
        self._pares_status = None
        self._veres_enrolled = None
        self._xid = None
        self._ucaf_collection_indicator = None
        self._ucaf_authentication_data = None
        self._strong_authentication = None
        self._directory_server_transaction_id = None
        self._pa_specification_version = None
        self._authentication_type = None
        self._response_access_token = None
        self._acs_transaction_id = None
        self._acs_window_size = None
        self._alternate_authentication_data = None
        self._alternate_authentication_date = None
        self._alternate_authentication_method = None
        self._authentication_date = None
        self._authentication_transaction_id = None
        self._challenge_cancel_code = None
        self._challenge_code = None
        self._challenge_status = None
        self._customer_card_alias = None
        self._decoupled_authentication_indicator = None
        self._decoupled_authentication_max_time = None
        self._default_card = None
        self._device_channel = None
        self._installment_total_count = None
        self._merchant_fraud_rate = None
        self._marketing_opt_in = None
        self._marketing_source = None
        self._mcc = None
        self._merchant_score = None
        self._message_category = None
        self._network_score = None
        self._npa_code = None
        self._override_payment_method = None
        self._override_country_code = None
        self._prior_authentication_data = None
        self._prior_authentication_method = None
        self._prior_authentication_reference_id = None
        self._prior_authentication_time = None
        self._product_code = None
        self._return_url = None
        self._requestor_id = None
        self._requestor_initiated_authentication_indicator = None
        self._requestor_name = None
        self._reference_id = None
        self._sdk_max_timeout = None
        self._secure_corporate_payment_indicator = None
        self._transaction_mode = None
        self._white_list_status = None
        self._effective_authentication_type = None
        self._signed_pares_status_reason = None
        self._signed_pares = None

        if cavv is not None:
          self.cavv = cavv
        if transaction_flow_indicator is not None:
          self.transaction_flow_indicator = transaction_flow_indicator
        if cavv_algorithm is not None:
          self.cavv_algorithm = cavv_algorithm
        if eci_raw is not None:
          self.eci_raw = eci_raw
        if pares_status is not None:
          self.pares_status = pares_status
        if veres_enrolled is not None:
          self.veres_enrolled = veres_enrolled
        if xid is not None:
          self.xid = xid
        if ucaf_collection_indicator is not None:
          self.ucaf_collection_indicator = ucaf_collection_indicator
        if ucaf_authentication_data is not None:
          self.ucaf_authentication_data = ucaf_authentication_data
        if strong_authentication is not None:
          self.strong_authentication = strong_authentication
        if directory_server_transaction_id is not None:
          self.directory_server_transaction_id = directory_server_transaction_id
        if pa_specification_version is not None:
          self.pa_specification_version = pa_specification_version
        if authentication_type is not None:
          self.authentication_type = authentication_type
        if response_access_token is not None:
          self.response_access_token = response_access_token
        if acs_transaction_id is not None:
          self.acs_transaction_id = acs_transaction_id
        if acs_window_size is not None:
          self.acs_window_size = acs_window_size
        if alternate_authentication_data is not None:
          self.alternate_authentication_data = alternate_authentication_data
        if alternate_authentication_date is not None:
          self.alternate_authentication_date = alternate_authentication_date
        if alternate_authentication_method is not None:
          self.alternate_authentication_method = alternate_authentication_method
        if authentication_date is not None:
          self.authentication_date = authentication_date
        if authentication_transaction_id is not None:
          self.authentication_transaction_id = authentication_transaction_id
        if challenge_cancel_code is not None:
          self.challenge_cancel_code = challenge_cancel_code
        if challenge_code is not None:
          self.challenge_code = challenge_code
        if challenge_status is not None:
          self.challenge_status = challenge_status
        if customer_card_alias is not None:
          self.customer_card_alias = customer_card_alias
        if decoupled_authentication_indicator is not None:
          self.decoupled_authentication_indicator = decoupled_authentication_indicator
        if decoupled_authentication_max_time is not None:
          self.decoupled_authentication_max_time = decoupled_authentication_max_time
        if default_card is not None:
          self.default_card = default_card
        if device_channel is not None:
          self.device_channel = device_channel
        if installment_total_count is not None:
          self.installment_total_count = installment_total_count
        if merchant_fraud_rate is not None:
          self.merchant_fraud_rate = merchant_fraud_rate
        if marketing_opt_in is not None:
          self.marketing_opt_in = marketing_opt_in
        if marketing_source is not None:
          self.marketing_source = marketing_source
        if mcc is not None:
          self.mcc = mcc
        if merchant_score is not None:
          self.merchant_score = merchant_score
        if message_category is not None:
          self.message_category = message_category
        if network_score is not None:
          self.network_score = network_score
        if npa_code is not None:
          self.npa_code = npa_code
        if override_payment_method is not None:
          self.override_payment_method = override_payment_method
        if override_country_code is not None:
          self.override_country_code = override_country_code
        if prior_authentication_data is not None:
          self.prior_authentication_data = prior_authentication_data
        if prior_authentication_method is not None:
          self.prior_authentication_method = prior_authentication_method
        if prior_authentication_reference_id is not None:
          self.prior_authentication_reference_id = prior_authentication_reference_id
        if prior_authentication_time is not None:
          self.prior_authentication_time = prior_authentication_time
        if product_code is not None:
          self.product_code = product_code
        if return_url is not None:
          self.return_url = return_url
        if requestor_id is not None:
          self.requestor_id = requestor_id
        if requestor_initiated_authentication_indicator is not None:
          self.requestor_initiated_authentication_indicator = requestor_initiated_authentication_indicator
        if requestor_name is not None:
          self.requestor_name = requestor_name
        if reference_id is not None:
          self.reference_id = reference_id
        if sdk_max_timeout is not None:
          self.sdk_max_timeout = sdk_max_timeout
        if secure_corporate_payment_indicator is not None:
          self.secure_corporate_payment_indicator = secure_corporate_payment_indicator
        if transaction_mode is not None:
          self.transaction_mode = transaction_mode
        if white_list_status is not None:
          self.white_list_status = white_list_status
        if effective_authentication_type is not None:
          self.effective_authentication_type = effective_authentication_type
        if signed_pares_status_reason is not None:
          self.signed_pares_status_reason = signed_pares_status_reason
        if signed_pares is not None:
          self.signed_pares = signed_pares

    @property
    def cavv(self):
        """
        Gets the cavv of this Ptsv2paymentsConsumerAuthenticationInformation.
        Cardholder authentication verification value (CAVV).

        :return: The cavv of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv

    @cavv.setter
    def cavv(self, cavv):
        """
        Sets the cavv of this Ptsv2paymentsConsumerAuthenticationInformation.
        Cardholder authentication verification value (CAVV).

        :param cavv: The cavv of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._cavv = cavv

    @property
    def transaction_flow_indicator(self):
        """
        Gets the transaction_flow_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field details out the type of transaction. Below are the possible values. 08:GC- Guest Checkout. 

        :return: The transaction_flow_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._transaction_flow_indicator

    @transaction_flow_indicator.setter
    def transaction_flow_indicator(self, transaction_flow_indicator):
        """
        Sets the transaction_flow_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field details out the type of transaction. Below are the possible values. 08:GC- Guest Checkout. 

        :param transaction_flow_indicator: The transaction_flow_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._transaction_flow_indicator = transaction_flow_indicator

    @property
    def cavv_algorithm(self):
        """
        Gets the cavv_algorithm of this Ptsv2paymentsConsumerAuthenticationInformation.
        Algorithm used to generate the CAVV for Visa Secure or the UCAF authentication data for Mastercard Identity Check. 

        :return: The cavv_algorithm of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv_algorithm

    @cavv_algorithm.setter
    def cavv_algorithm(self, cavv_algorithm):
        """
        Sets the cavv_algorithm of this Ptsv2paymentsConsumerAuthenticationInformation.
        Algorithm used to generate the CAVV for Visa Secure or the UCAF authentication data for Mastercard Identity Check. 

        :param cavv_algorithm: The cavv_algorithm of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._cavv_algorithm = cavv_algorithm

    @property
    def eci_raw(self):
        """
        Gets the eci_raw of this Ptsv2paymentsConsumerAuthenticationInformation.
        Raw electronic commerce indicator (ECI).  For details, see `eci_raw` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The eci_raw of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._eci_raw

    @eci_raw.setter
    def eci_raw(self, eci_raw):
        """
        Sets the eci_raw of this Ptsv2paymentsConsumerAuthenticationInformation.
        Raw electronic commerce indicator (ECI).  For details, see `eci_raw` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param eci_raw: The eci_raw of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._eci_raw = eci_raw

    @property
    def pares_status(self):
        """
        Gets the pares_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        Payer authentication response status.  For details, see `pares_status` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The pares_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._pares_status

    @pares_status.setter
    def pares_status(self, pares_status):
        """
        Sets the pares_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        Payer authentication response status.  For details, see `pares_status` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param pares_status: The pares_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._pares_status = pares_status

    @property
    def veres_enrolled(self):
        """
        Gets the veres_enrolled of this Ptsv2paymentsConsumerAuthenticationInformation.
        Verification response enrollment status.  For details, see `veres_enrolled` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The veres_enrolled of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._veres_enrolled

    @veres_enrolled.setter
    def veres_enrolled(self, veres_enrolled):
        """
        Sets the veres_enrolled of this Ptsv2paymentsConsumerAuthenticationInformation.
        Verification response enrollment status.  For details, see `veres_enrolled` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param veres_enrolled: The veres_enrolled of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._veres_enrolled = veres_enrolled

    @property
    def xid(self):
        """
        Gets the xid of this Ptsv2paymentsConsumerAuthenticationInformation.
        Transaction identifier.  For details, see `xid` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The xid of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._xid

    @xid.setter
    def xid(self, xid):
        """
        Sets the xid of this Ptsv2paymentsConsumerAuthenticationInformation.
        Transaction identifier.  For details, see `xid` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param xid: The xid of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._xid = xid

    @property
    def ucaf_collection_indicator(self):
        """
        Gets the ucaf_collection_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Universal cardholder authentication field (UCAF) collection indicator.  For details, see `ucaf_collection_indicator` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  #### CyberSource through VisaNet The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR7 - Position: 5 - Field: Mastercard Electronic Commerce Indicators—UCAF Collection Indicator 

        :return: The ucaf_collection_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ucaf_collection_indicator

    @ucaf_collection_indicator.setter
    def ucaf_collection_indicator(self, ucaf_collection_indicator):
        """
        Sets the ucaf_collection_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Universal cardholder authentication field (UCAF) collection indicator.  For details, see `ucaf_collection_indicator` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  #### CyberSource through VisaNet The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR7 - Position: 5 - Field: Mastercard Electronic Commerce Indicators—UCAF Collection Indicator 

        :param ucaf_collection_indicator: The ucaf_collection_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._ucaf_collection_indicator = ucaf_collection_indicator

    @property
    def ucaf_authentication_data(self):
        """
        Gets the ucaf_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        Universal cardholder authentication field (UCAF) data.  For details, see `ucaf_authentication_data` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The ucaf_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ucaf_authentication_data

    @ucaf_authentication_data.setter
    def ucaf_authentication_data(self, ucaf_authentication_data):
        """
        Sets the ucaf_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        Universal cardholder authentication field (UCAF) data.  For details, see `ucaf_authentication_data` request field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param ucaf_authentication_data: The ucaf_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._ucaf_authentication_data = ucaf_authentication_data

    @property
    def strong_authentication(self):
        """
        Gets the strong_authentication of this Ptsv2paymentsConsumerAuthenticationInformation.

        :return: The strong_authentication of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: Ptsv2paymentsConsumerAuthenticationInformationStrongAuthentication
        """
        return self._strong_authentication

    @strong_authentication.setter
    def strong_authentication(self, strong_authentication):
        """
        Sets the strong_authentication of this Ptsv2paymentsConsumerAuthenticationInformation.

        :param strong_authentication: The strong_authentication of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: Ptsv2paymentsConsumerAuthenticationInformationStrongAuthentication
        """

        self._strong_authentication = strong_authentication

    @property
    def directory_server_transaction_id(self):
        """
        Gets the directory_server_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 

        :return: The directory_server_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._directory_server_transaction_id

    @directory_server_transaction_id.setter
    def directory_server_transaction_id(self, directory_server_transaction_id):
        """
        Sets the directory_server_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 

        :param directory_server_transaction_id: The directory_server_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._directory_server_transaction_id = directory_server_transaction_id

    @property
    def pa_specification_version(self):
        """
        Gets the pa_specification_version of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field contains 3DS version that was used for Secured Consumer Authentication (SCA). For example 3DS secure version 1.0.2 or 2.0.0 is used for Secured Consumer Authentication. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 113 , Field: MC AVV Verification—Program Protocol It will contain one of the following values: - `1` (3D Secure Version 1.0 (3DS 1.0)) - `2` (EMV 3-D Secure (3DS 2.0))  For Cybersource connection through Visanet, below are additional values to be supported.  - `2.1.0` (EMV 3D Secure Version 2.1) - `2.2.0` (EMV 3D Secure Version 2.2) - `2.3.0` (EMV 3D Secure Version 2.3) - `2.4.0` (EMV 3D Secure Version 2.4) - `2.5.0` (EMV 3D Secure Version 2.5) - `2.6.0` (EMV 3D Secure Version 2.6) - `2.7.0` (EMV 3D Secure Version 2.7) - `2.8.0` (EMV 3D Secure Version 2.8) - `2.9.0` (EMV 3D Secure Version 2.9) 

        :return: The pa_specification_version of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._pa_specification_version

    @pa_specification_version.setter
    def pa_specification_version(self, pa_specification_version):
        """
        Sets the pa_specification_version of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field contains 3DS version that was used for Secured Consumer Authentication (SCA). For example 3DS secure version 1.0.2 or 2.0.0 is used for Secured Consumer Authentication. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 113 , Field: MC AVV Verification—Program Protocol It will contain one of the following values: - `1` (3D Secure Version 1.0 (3DS 1.0)) - `2` (EMV 3-D Secure (3DS 2.0))  For Cybersource connection through Visanet, below are additional values to be supported.  - `2.1.0` (EMV 3D Secure Version 2.1) - `2.2.0` (EMV 3D Secure Version 2.2) - `2.3.0` (EMV 3D Secure Version 2.3) - `2.4.0` (EMV 3D Secure Version 2.4) - `2.5.0` (EMV 3D Secure Version 2.5) - `2.6.0` (EMV 3D Secure Version 2.6) - `2.7.0` (EMV 3D Secure Version 2.7) - `2.8.0` (EMV 3D Secure Version 2.8) - `2.9.0` (EMV 3D Secure Version 2.9) 

        :param pa_specification_version: The pa_specification_version of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._pa_specification_version = pa_specification_version

    @property
    def authentication_type(self):
        """
        Gets the authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled  20 - OTP hosted at merchant end. (Rupay S2S flow) **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time. 

        :return: The authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_type

    @authentication_type.setter
    def authentication_type(self, authentication_type):
        """
        Sets the authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled  20 - OTP hosted at merchant end. (Rupay S2S flow) **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time. 

        :param authentication_type: The authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_type = authentication_type

    @property
    def response_access_token(self):
        """
        Gets the response_access_token of this Ptsv2paymentsConsumerAuthenticationInformation.
        JWT returned by the 3D Secure provider when the authentication is complete. Required for Hybrid integration if you use the Cybersource-generated access token. Note: Max. length of this field is 2048 characters. 

        :return: The response_access_token of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._response_access_token

    @response_access_token.setter
    def response_access_token(self, response_access_token):
        """
        Sets the response_access_token of this Ptsv2paymentsConsumerAuthenticationInformation.
        JWT returned by the 3D Secure provider when the authentication is complete. Required for Hybrid integration if you use the Cybersource-generated access token. Note: Max. length of this field is 2048 characters. 

        :param response_access_token: The response_access_token of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._response_access_token = response_access_token

    @property
    def acs_transaction_id(self):
        """
        Gets the acs_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. 

        :return: The acs_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_transaction_id

    @acs_transaction_id.setter
    def acs_transaction_id(self, acs_transaction_id):
        """
        Sets the acs_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Unique transaction identifier assigned by the ACS to identify a single transaction.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. 

        :param acs_transaction_id: The acs_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_transaction_id = acs_transaction_id

    @property
    def acs_window_size(self):
        """
        Gets the acs_window_size of this Ptsv2paymentsConsumerAuthenticationInformation.
        An override field that a merchant can pass in to set the challenge window size to display to the end cardholder.  The ACS (Active Control Server) will reply with content that is formatted appropriately to this window size to allow for the best user experience.  The sizes are width x height in pixels of the window displayed in the cardholder browser window.  01 - 250x400  02 - 390x400  03 - 500x600  04 - 600x400  05 - Full page 

        :return: The acs_window_size of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_window_size

    @acs_window_size.setter
    def acs_window_size(self, acs_window_size):
        """
        Sets the acs_window_size of this Ptsv2paymentsConsumerAuthenticationInformation.
        An override field that a merchant can pass in to set the challenge window size to display to the end cardholder.  The ACS (Active Control Server) will reply with content that is formatted appropriately to this window size to allow for the best user experience.  The sizes are width x height in pixels of the window displayed in the cardholder browser window.  01 - 250x400  02 - 390x400  03 - 500x600  04 - 600x400  05 - Full page 

        :param acs_window_size: The acs_window_size of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._acs_window_size = acs_window_size

    @property
    def alternate_authentication_data(self):
        """
        Gets the alternate_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        Data that documents and supports a specific authentication process. 

        :return: The alternate_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_data

    @alternate_authentication_data.setter
    def alternate_authentication_data(self, alternate_authentication_data):
        """
        Sets the alternate_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        Data that documents and supports a specific authentication process. 

        :param alternate_authentication_data: The alternate_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._alternate_authentication_data = alternate_authentication_data

    @property
    def alternate_authentication_date(self):
        """
        Gets the alternate_authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM 

        :return: The alternate_authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_date

    @alternate_authentication_date.setter
    def alternate_authentication_date(self, alternate_authentication_date):
        """
        Sets the alternate_authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM 

        :param alternate_authentication_date: The alternate_authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._alternate_authentication_date = alternate_authentication_date

    @property
    def alternate_authentication_method(self):
        """
        Gets the alternate_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using issuer credentials - `05`: Login using third-party authenticator - `06`: Login using FIDO Authenticator 

        :return: The alternate_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_method

    @alternate_authentication_method.setter
    def alternate_authentication_method(self, alternate_authentication_method):
        """
        Sets the alternate_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using issuer credentials - `05`: Login using third-party authenticator - `06`: Login using FIDO Authenticator 

        :param alternate_authentication_method: The alternate_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._alternate_authentication_method = alternate_authentication_method

    @property
    def authentication_date(self):
        """
        Gets the authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        The date/time of the authentication at the 3DS servers. RISK update authorization service in auth request payload with value returned in `consumerAuthenticationInformation.alternateAuthenticationData` if merchant calls via CYBS or field can be provided by merchant in authorization request if calling an external 3DS provider.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. Format: YYYYMMDDHHMMSS 

        :return: The authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_date

    @authentication_date.setter
    def authentication_date(self, authentication_date):
        """
        Sets the authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        The date/time of the authentication at the 3DS servers. RISK update authorization service in auth request payload with value returned in `consumerAuthenticationInformation.alternateAuthenticationData` if merchant calls via CYBS or field can be provided by merchant in authorization request if calling an external 3DS provider.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. Format: YYYYMMDDHHMMSS 

        :param authentication_date: The authentication_date of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_date = authentication_date

    @property
    def authentication_transaction_id(self):
        """
        Gets the authentication_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages.For Rupay,this is passed only in Re-Send OTP usecase. **Note**: Required for Standard integration, Rupay Seamless server to server integration for enroll service. Required for Hybrid integration for validate service. 

        :return: The authentication_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_transaction_id

    @authentication_transaction_id.setter
    def authentication_transaction_id(self, authentication_transaction_id):
        """
        Sets the authentication_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages.For Rupay,this is passed only in Re-Send OTP usecase. **Note**: Required for Standard integration, Rupay Seamless server to server integration for enroll service. Required for Hybrid integration for validate service. 

        :param authentication_transaction_id: The authentication_transaction_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_transaction_id = authentication_transaction_id

    @property
    def challenge_cancel_code(self):
        """
        Gets the challenge_cancel_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK 

        :return: The challenge_cancel_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_cancel_code

    @challenge_cancel_code.setter
    def challenge_cancel_code(self, challenge_cancel_code):
        """
        Sets the challenge_cancel_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK 

        :param challenge_cancel_code: The challenge_cancel_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_cancel_code = challenge_cancel_code

    @property
    def challenge_code(self):
        """
        Gets the challenge_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05`: No challenge requested (transactional risk analysis is already performed) - `06`: No challenge requested (Data share only) - `07`: No challenge requested (strong consumer authentication is already performed) - `08`: No challenge requested (utilize whitelist exemption if no challenge required) - `09`: Challenge requested (whitelist prompt requested if challenge required) **Note** This field will default to `01` on merchant configuration and can be overridden by the merchant. EMV 3D Secure version 2.1.0 supports values `01-04`. Version 2.2.0 supports values `01-09`.  For details, see `pa_challenge_code` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html) 

        :return: The challenge_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_code

    @challenge_code.setter
    def challenge_code(self, challenge_code):
        """
        Sets the challenge_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05`: No challenge requested (transactional risk analysis is already performed) - `06`: No challenge requested (Data share only) - `07`: No challenge requested (strong consumer authentication is already performed) - `08`: No challenge requested (utilize whitelist exemption if no challenge required) - `09`: Challenge requested (whitelist prompt requested if challenge required) **Note** This field will default to `01` on merchant configuration and can be overridden by the merchant. EMV 3D Secure version 2.1.0 supports values `01-04`. Version 2.2.0 supports values `01-09`.  For details, see `pa_challenge_code` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html) 

        :param challenge_code: The challenge_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_code = challenge_code

    @property
    def challenge_status(self):
        """
        Gets the challenge_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        The `consumerAuthenticationInformation.challengeCode` indicates the authentication type/level, or challenge, that was presented to the cardholder at checkout by the merchant when calling the Carte Bancaire 3DS servers via CYBS RISK services. It conveys to the issuer the alternative authentication methods that the consumer used. 

        :return: The challenge_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_status

    @challenge_status.setter
    def challenge_status(self, challenge_status):
        """
        Sets the challenge_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        The `consumerAuthenticationInformation.challengeCode` indicates the authentication type/level, or challenge, that was presented to the cardholder at checkout by the merchant when calling the Carte Bancaire 3DS servers via CYBS RISK services. It conveys to the issuer the alternative authentication methods that the consumer used. 

        :param challenge_status: The challenge_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_status = challenge_status

    @property
    def customer_card_alias(self):
        """
        Gets the customer_card_alias of this Ptsv2paymentsConsumerAuthenticationInformation.
        An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings. 

        :return: The customer_card_alias of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._customer_card_alias

    @customer_card_alias.setter
    def customer_card_alias(self, customer_card_alias):
        """
        Sets the customer_card_alias of this Ptsv2paymentsConsumerAuthenticationInformation.
        An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings. 

        :param customer_card_alias: The customer_card_alias of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._customer_card_alias = customer_card_alias

    @property
    def decoupled_authentication_indicator(self):
        """
        Gets the decoupled_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 

        :return: The decoupled_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._decoupled_authentication_indicator

    @decoupled_authentication_indicator.setter
    def decoupled_authentication_indicator(self, decoupled_authentication_indicator):
        """
        Sets the decoupled_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 

        :param decoupled_authentication_indicator: The decoupled_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._decoupled_authentication_indicator = decoupled_authentication_indicator

    @property
    def decoupled_authentication_max_time(self):
        """
        Gets the decoupled_authentication_max_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates the maximum amount of time that the 3DS Requestor will wait for an ACS (Active control server) to provide the results of a Decoupled Authentication transaction (in minutes). Possible Values: Numeric values between 1 and 10080 accepted. 

        :return: The decoupled_authentication_max_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._decoupled_authentication_max_time

    @decoupled_authentication_max_time.setter
    def decoupled_authentication_max_time(self, decoupled_authentication_max_time):
        """
        Sets the decoupled_authentication_max_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates the maximum amount of time that the 3DS Requestor will wait for an ACS (Active control server) to provide the results of a Decoupled Authentication transaction (in minutes). Possible Values: Numeric values between 1 and 10080 accepted. 

        :param decoupled_authentication_max_time: The decoupled_authentication_max_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._decoupled_authentication_max_time = decoupled_authentication_max_time

    @property
    def default_card(self):
        """
        Gets the default_card of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy. 

        :return: The default_card of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: bool
        """
        return self._default_card

    @default_card.setter
    def default_card(self, default_card):
        """
        Sets the default_card of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy. 

        :param default_card: The default_card of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: bool
        """

        self._default_card = default_card

    @property
    def device_channel(self):
        """
        Gets the device_channel of this Ptsv2paymentsConsumerAuthenticationInformation.
        Determines the channel that the transaction came through. Possible Values: SDK/Browser/3RI. 3RI - 3DS request initiated. 

        :return: The device_channel of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._device_channel

    @device_channel.setter
    def device_channel(self, device_channel):
        """
        Sets the device_channel of this Ptsv2paymentsConsumerAuthenticationInformation.
        Determines the channel that the transaction came through. Possible Values: SDK/Browser/3RI. 3RI - 3DS request initiated. 

        :param device_channel: The device_channel of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._device_channel = device_channel

    @property
    def installment_total_count(self):
        """
        Gets the installment_total_count of this Ptsv2paymentsConsumerAuthenticationInformation.
        An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments. 

        :return: The installment_total_count of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: int
        """
        return self._installment_total_count

    @installment_total_count.setter
    def installment_total_count(self, installment_total_count):
        """
        Sets the installment_total_count of this Ptsv2paymentsConsumerAuthenticationInformation.
        An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments. 

        :param installment_total_count: The installment_total_count of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: int
        """

        self._installment_total_count = installment_total_count

    @property
    def merchant_fraud_rate(self):
        """
        Gets the merchant_fraud_rate of this Ptsv2paymentsConsumerAuthenticationInformation.
        Calculated by merchants as per PSD2** RTS** (EEA** card fraud divided by all EEA card volumes). Possible Values: 1 = Represents fraud rate <=1  2 = Represents fraud rate >1 and <=6  3 = Represents fraud rate >6 and <=13  4 = Represents fraud rate >13 and <=25  5 = Represents fraud rate >25  EEA** = European Economic Area RTS** = Regulatory Technical Standards PSD2** = Payment Services Directive 

        :return: The merchant_fraud_rate of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._merchant_fraud_rate

    @merchant_fraud_rate.setter
    def merchant_fraud_rate(self, merchant_fraud_rate):
        """
        Sets the merchant_fraud_rate of this Ptsv2paymentsConsumerAuthenticationInformation.
        Calculated by merchants as per PSD2** RTS** (EEA** card fraud divided by all EEA card volumes). Possible Values: 1 = Represents fraud rate <=1  2 = Represents fraud rate >1 and <=6  3 = Represents fraud rate >6 and <=13  4 = Represents fraud rate >13 and <=25  5 = Represents fraud rate >25  EEA** = European Economic Area RTS** = Regulatory Technical Standards PSD2** = Payment Services Directive 

        :param merchant_fraud_rate: The merchant_fraud_rate of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._merchant_fraud_rate = merchant_fraud_rate

    @property
    def marketing_opt_in(self):
        """
        Gets the marketing_opt_in of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy. 

        :return: The marketing_opt_in of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: bool
        """
        return self._marketing_opt_in

    @marketing_opt_in.setter
    def marketing_opt_in(self, marketing_opt_in):
        """
        Sets the marketing_opt_in of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy. 

        :param marketing_opt_in: The marketing_opt_in of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: bool
        """

        self._marketing_opt_in = marketing_opt_in

    @property
    def marketing_source(self):
        """
        Gets the marketing_source of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates origin of the marketing offer. Recommended for Discover ProtectBuy. 

        :return: The marketing_source of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._marketing_source

    @marketing_source.setter
    def marketing_source(self, marketing_source):
        """
        Sets the marketing_source of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates origin of the marketing offer. Recommended for Discover ProtectBuy. 

        :param marketing_source: The marketing_source of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._marketing_source = marketing_source

    @property
    def mcc(self):
        """
        Gets the mcc of this Ptsv2paymentsConsumerAuthenticationInformation.
        Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The mcc of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._mcc

    @mcc.setter
    def mcc(self, mcc):
        """
        Sets the mcc of this Ptsv2paymentsConsumerAuthenticationInformation.
        Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param mcc: The mcc of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._mcc = mcc

    @property
    def merchant_score(self):
        """
        Gets the merchant_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        Risk Score provided by merchants. This is specific for CB transactions. 

        :return: The merchant_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: int
        """
        return self._merchant_score

    @merchant_score.setter
    def merchant_score(self, merchant_score):
        """
        Sets the merchant_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        Risk Score provided by merchants. This is specific for CB transactions. 

        :param merchant_score: The merchant_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: int
        """

        self._merchant_score = merchant_score

    @property
    def message_category(self):
        """
        Gets the message_category of this Ptsv2paymentsConsumerAuthenticationInformation.
        Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use 

        :return: The message_category of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._message_category

    @message_category.setter
    def message_category(self, message_category):
        """
        Sets the message_category of this Ptsv2paymentsConsumerAuthenticationInformation.
        Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use 

        :param message_category: The message_category of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._message_category = message_category

    @property
    def network_score(self):
        """
        Gets the network_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        The global score calculated by the CB scoring platform and returned to merchants.  Possible values:  - '00' - '99'  When you request the payer authentication and authorization services separately, get the value for this field from the pa_network_score reply field.         This field is supported only for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. 

        :return: The network_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._network_score

    @network_score.setter
    def network_score(self, network_score):
        """
        Sets the network_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        The global score calculated by the CB scoring platform and returned to merchants.  Possible values:  - '00' - '99'  When you request the payer authentication and authorization services separately, get the value for this field from the pa_network_score reply field.         This field is supported only for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. 

        :param network_score: The network_score of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._network_score = network_score

    @property
    def npa_code(self):
        """
        Gets the npa_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS 

        :return: The npa_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._npa_code

    @npa_code.setter
    def npa_code(self, npa_code):
        """
        Sets the npa_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS 

        :param npa_code: The npa_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._npa_code = npa_code

    @property
    def override_payment_method(self):
        """
        Gets the override_payment_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The override_payment_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._override_payment_method

    @override_payment_method.setter
    def override_payment_method(self, override_payment_method):
        """
        Sets the override_payment_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param override_payment_method: The override_payment_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._override_payment_method = override_payment_method

    @property
    def override_country_code(self):
        """
        Gets the override_country_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).. 

        :return: The override_country_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._override_country_code

    @override_country_code.setter
    def override_country_code(self, override_country_code):
        """
        Sets the override_country_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf).. 

        :param override_country_code: The override_country_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._override_country_code = override_country_code

    @property
    def prior_authentication_data(self):
        """
        Gets the prior_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field carry data that the ACS can use to verify the authentication process. 

        :return: The prior_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_data

    @prior_authentication_data.setter
    def prior_authentication_data(self, prior_authentication_data):
        """
        Sets the prior_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field carry data that the ACS can use to verify the authentication process. 

        :param prior_authentication_data: The prior_authentication_data of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_data = prior_authentication_data

    @property
    def prior_authentication_method(self):
        """
        Gets the prior_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        Mechanism used by the Cardholder to previously authenticate to the 3DS Requestor.  01 - Frictionless authentication occurred by ACS  02 - Cardholder challenge occurred by ACS  03 - AVS verified  04 - Other issuer methods  05-79 - Reserved for EMVCo future use (values invalid until defined by EMVCo)  80-99 - Reserved for DS use 

        :return: The prior_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_method

    @prior_authentication_method.setter
    def prior_authentication_method(self, prior_authentication_method):
        """
        Sets the prior_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        Mechanism used by the Cardholder to previously authenticate to the 3DS Requestor.  01 - Frictionless authentication occurred by ACS  02 - Cardholder challenge occurred by ACS  03 - AVS verified  04 - Other issuer methods  05-79 - Reserved for EMVCo future use (values invalid until defined by EMVCo)  80-99 - Reserved for DS use 

        :param prior_authentication_method: The prior_authentication_method of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_method = prior_authentication_method

    @property
    def prior_authentication_reference_id(self):
        """
        Gets the prior_authentication_reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        This data element contains a ACS Transaction ID for a prior authenticated transaction. For example, the first recurring transaction that was authenticated with the cardholder 

        :return: The prior_authentication_reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_reference_id

    @prior_authentication_reference_id.setter
    def prior_authentication_reference_id(self, prior_authentication_reference_id):
        """
        Sets the prior_authentication_reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        This data element contains a ACS Transaction ID for a prior authenticated transaction. For example, the first recurring transaction that was authenticated with the cardholder 

        :param prior_authentication_reference_id: The prior_authentication_reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_reference_id = prior_authentication_reference_id

    @property
    def prior_authentication_time(self):
        """
        Gets the prior_authentication_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        Date and time in UTC of the prior cardholder authentication. Format – YYYYMMDDHHMM 

        :return: The prior_authentication_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._prior_authentication_time

    @prior_authentication_time.setter
    def prior_authentication_time(self, prior_authentication_time):
        """
        Sets the prior_authentication_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        Date and time in UTC of the prior cardholder authentication. Format – YYYYMMDDHHMM 

        :param prior_authentication_time: The prior_authentication_time of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._prior_authentication_time = prior_authentication_time

    @property
    def product_code(self):
        """
        Gets the product_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The product_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """
        Sets the product_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param product_code: The product_code of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._product_code = product_code

    @property
    def return_url(self):
        """
        Gets the return_url of this Ptsv2paymentsConsumerAuthenticationInformation.
        The URL of the merchant's return page. CyberSource adds this return URL to the step-up JWT and returns it in the response of the Payer Authentication enrollment call. The merchant's return URL page serves as a listening URL. Once the bank session completes, the merchant receives a POST to their URL. This response contains the completed bank session's transactionId. The merchant's return page should capture the transaction ID and send it in the Payer Authentication validation call. 

        :return: The return_url of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._return_url

    @return_url.setter
    def return_url(self, return_url):
        """
        Sets the return_url of this Ptsv2paymentsConsumerAuthenticationInformation.
        The URL of the merchant's return page. CyberSource adds this return URL to the step-up JWT and returns it in the response of the Payer Authentication enrollment call. The merchant's return URL page serves as a listening URL. Once the bank session completes, the merchant receives a POST to their URL. This response contains the completed bank session's transactionId. The merchant's return page should capture the transaction ID and send it in the Payer Authentication validation call. 

        :param return_url: The return_url of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._return_url = return_url

    @property
    def requestor_id(self):
        """
        Gets the requestor_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor ID value

        :return: The requestor_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_id

    @requestor_id.setter
    def requestor_id(self, requestor_id):
        """
        Sets the requestor_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor ID value

        :param requestor_id: The requestor_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._requestor_id = requestor_id

    @property
    def requestor_initiated_authentication_indicator(self):
        """
        Gets the requestor_initiated_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates the type of 3RI request.  Possible Values:  01 - Recurring transaction  02 - Installment transaction  03 - Add card  04 - Maintain card  05 - Account verification  06 - Split/delayed shipment  07 - Top-up  08 - Mail Order  09 - Telephone Order  10 - Whitelist status check  11 - Other payment 

        :return: The requestor_initiated_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_initiated_authentication_indicator

    @requestor_initiated_authentication_indicator.setter
    def requestor_initiated_authentication_indicator(self, requestor_initiated_authentication_indicator):
        """
        Sets the requestor_initiated_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates the type of 3RI request.  Possible Values:  01 - Recurring transaction  02 - Installment transaction  03 - Add card  04 - Maintain card  05 - Account verification  06 - Split/delayed shipment  07 - Top-up  08 - Mail Order  09 - Telephone Order  10 - Whitelist status check  11 - Other payment 

        :param requestor_initiated_authentication_indicator: The requestor_initiated_authentication_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._requestor_initiated_authentication_indicator = requestor_initiated_authentication_indicator

    @property
    def requestor_name(self):
        """
        Gets the requestor_name of this Ptsv2paymentsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor Name value

        :return: The requestor_name of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_name

    @requestor_name.setter
    def requestor_name(self, requestor_name):
        """
        Sets the requestor_name of this Ptsv2paymentsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor Name value

        :param requestor_name: The requestor_name of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._requestor_name = requestor_name

    @property
    def reference_id(self):
        """
        Gets the reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration. 

        :return: The reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._reference_id

    @reference_id.setter
    def reference_id(self, reference_id):
        """
        Sets the reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration. 

        :param reference_id: The reference_id of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._reference_id = reference_id

    @property
    def sdk_max_timeout(self):
        """
        Gets the sdk_max_timeout of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field indicates the maximum amount of time for all 3DS 2.0 messages to be communicated between all components (in minutes).  Possible Values:  Greater than or equal to 05 (05 is the minimum timeout to set)  Cardinal Default is set to 15  NOTE: This field is a required 3DS 2.0 field and Cardinal sends in a default of 15 if nothing is passed 

        :return: The sdk_max_timeout of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._sdk_max_timeout

    @sdk_max_timeout.setter
    def sdk_max_timeout(self, sdk_max_timeout):
        """
        Sets the sdk_max_timeout of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field indicates the maximum amount of time for all 3DS 2.0 messages to be communicated between all components (in minutes).  Possible Values:  Greater than or equal to 05 (05 is the minimum timeout to set)  Cardinal Default is set to 15  NOTE: This field is a required 3DS 2.0 field and Cardinal sends in a default of 15 if nothing is passed 

        :param sdk_max_timeout: The sdk_max_timeout of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._sdk_max_timeout = sdk_max_timeout

    @property
    def secure_corporate_payment_indicator(self):
        """
        Gets the secure_corporate_payment_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates dedicated payment processes and procedures were used, potential secure corporate payment exemption applies. Possible Values : 0/1 

        :return: The secure_corporate_payment_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._secure_corporate_payment_indicator

    @secure_corporate_payment_indicator.setter
    def secure_corporate_payment_indicator(self, secure_corporate_payment_indicator):
        """
        Sets the secure_corporate_payment_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        Indicates dedicated payment processes and procedures were used, potential secure corporate payment exemption applies. Possible Values : 0/1 

        :param secure_corporate_payment_indicator: The secure_corporate_payment_indicator of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._secure_corporate_payment_indicator = secure_corporate_payment_indicator

    @property
    def transaction_mode(self):
        """
        Gets the transaction_mode of this Ptsv2paymentsConsumerAuthenticationInformation.
        Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values:  - `M`: MOTO (Mail Order Telephone Order) - `R`: Retail - `S`: eCommerce - `P`: Mobile Device - `T`: Tablet 

        :return: The transaction_mode of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._transaction_mode

    @transaction_mode.setter
    def transaction_mode(self, transaction_mode):
        """
        Sets the transaction_mode of this Ptsv2paymentsConsumerAuthenticationInformation.
        Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values:  - `M`: MOTO (Mail Order Telephone Order) - `R`: Retail - `S`: eCommerce - `P`: Mobile Device - `T`: Tablet 

        :param transaction_mode: The transaction_mode of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._transaction_mode = transaction_mode

    @property
    def white_list_status(self):
        """
        Gets the white_list_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :return: The white_list_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._white_list_status

    @white_list_status.setter
    def white_list_status(self, white_list_status):
        """
        Sets the white_list_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder 

        :param white_list_status: The white_list_status of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._white_list_status = white_list_status

    @property
    def effective_authentication_type(self):
        """
        Gets the effective_authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 

        :return: The effective_authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._effective_authentication_type

    @effective_authentication_type.setter
    def effective_authentication_type(self, effective_authentication_type):
        """
        Sets the effective_authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 

        :param effective_authentication_type: The effective_authentication_type of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._effective_authentication_type = effective_authentication_type

    @property
    def signed_pares_status_reason(self):
        """
        Gets the signed_pares_status_reason of this Ptsv2paymentsConsumerAuthenticationInformation.
        Provides additional information as to why the PAResStatus has a specific value. 

        :return: The signed_pares_status_reason of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._signed_pares_status_reason

    @signed_pares_status_reason.setter
    def signed_pares_status_reason(self, signed_pares_status_reason):
        """
        Sets the signed_pares_status_reason of this Ptsv2paymentsConsumerAuthenticationInformation.
        Provides additional information as to why the PAResStatus has a specific value. 

        :param signed_pares_status_reason: The signed_pares_status_reason of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._signed_pares_status_reason = signed_pares_status_reason

    @property
    def signed_pares(self):
        """
        Gets the signed_pares of this Ptsv2paymentsConsumerAuthenticationInformation.
        Payer authentication result (PARes) message returned by the card-issuing bank. If you need to show proof of enrollment checking, you may need to decrypt and parse the string for the information required by the payment card company. For more information, see \"Storing Payer Authentication Data,\" page 160. Important The value is in base64. You must remove all carriage returns and line feeds before adding the PARes to the request. 

        :return: The signed_pares of this Ptsv2paymentsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._signed_pares

    @signed_pares.setter
    def signed_pares(self, signed_pares):
        """
        Sets the signed_pares of this Ptsv2paymentsConsumerAuthenticationInformation.
        Payer authentication result (PARes) message returned by the card-issuing bank. If you need to show proof of enrollment checking, you may need to decrypt and parse the string for the information required by the payment card company. For more information, see \"Storing Payer Authentication Data,\" page 160. Important The value is in base64. You must remove all carriage returns and line feeds before adding the PARes to the request. 

        :param signed_pares: The signed_pares of this Ptsv2paymentsConsumerAuthenticationInformation.
        :type: str
        """

        self._signed_pares = signed_pares

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
