# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsProcessingInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action_list': 'list[str]',
        'enable_escrow_option': 'bool',
        'action_token_types': 'list[str]',
        'bin_source': 'str',
        'capture': 'bool',
        'processor_id': 'str',
        'business_application_id': 'str',
        'commerce_indicator': 'str',
        'commerce_indicator_label': 'str',
        'payment_solution': 'str',
        'reconciliation_id': 'str',
        'link_id': 'str',
        'purchase_level': 'str',
        'transaction_timeout': 'int',
        'intents_id': 'str',
        'payment_id': 'str',
        'report_group': 'str',
        'visa_checkout_id': 'str',
        'industry_data_type': 'str',
        'authorization_options': 'Ptsv2paymentsProcessingInformationAuthorizationOptions',
        'capture_options': 'Ptsv2paymentsProcessingInformationCaptureOptions',
        'recurring_options': 'Ptsv2paymentsProcessingInformationRecurringOptions',
        'bank_transfer_options': 'Ptsv2paymentsProcessingInformationBankTransferOptions',
        'purchase_options': 'Ptsv2paymentsProcessingInformationPurchaseOptions',
        'electronic_benefits_transfer': 'Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer',
        'loan_options': 'Ptsv2paymentsProcessingInformationLoanOptions',
        'wallet_type': 'str',
        'national_net_domestic_data': 'str',
        'japan_payment_options': 'Ptsv2paymentsProcessingInformationJapanPaymentOptions',
        'mobile_remote_payment_type': 'str',
        'extended_credit_total_count': 'str',
        'network_routing_order': 'str',
        'pay_by_points_indicator': 'bool',
        'timeout': 'int',
        'is_return_auth_record_enabled': 'bool',
        'network_partner_id': 'str',
        'payment_type': 'str'
    }

    attribute_map = {
        'action_list': 'actionList',
        'enable_escrow_option': 'enableEscrowOption',
        'action_token_types': 'actionTokenTypes',
        'bin_source': 'binSource',
        'capture': 'capture',
        'processor_id': 'processorId',
        'business_application_id': 'businessApplicationId',
        'commerce_indicator': 'commerceIndicator',
        'commerce_indicator_label': 'commerceIndicatorLabel',
        'payment_solution': 'paymentSolution',
        'reconciliation_id': 'reconciliationId',
        'link_id': 'linkId',
        'purchase_level': 'purchaseLevel',
        'transaction_timeout': 'transactionTimeout',
        'intents_id': 'intentsId',
        'payment_id': 'paymentId',
        'report_group': 'reportGroup',
        'visa_checkout_id': 'visaCheckoutId',
        'industry_data_type': 'industryDataType',
        'authorization_options': 'authorizationOptions',
        'capture_options': 'captureOptions',
        'recurring_options': 'recurringOptions',
        'bank_transfer_options': 'bankTransferOptions',
        'purchase_options': 'purchaseOptions',
        'electronic_benefits_transfer': 'electronicBenefitsTransfer',
        'loan_options': 'loanOptions',
        'wallet_type': 'walletType',
        'national_net_domestic_data': 'nationalNetDomesticData',
        'japan_payment_options': 'japanPaymentOptions',
        'mobile_remote_payment_type': 'mobileRemotePaymentType',
        'extended_credit_total_count': 'extendedCreditTotalCount',
        'network_routing_order': 'networkRoutingOrder',
        'pay_by_points_indicator': 'payByPointsIndicator',
        'timeout': 'timeout',
        'is_return_auth_record_enabled': 'isReturnAuthRecordEnabled',
        'network_partner_id': 'networkPartnerId',
        'payment_type': 'paymentType'
    }

    def __init__(self, action_list=None, enable_escrow_option=None, action_token_types=None, bin_source=None, capture=False, processor_id=None, business_application_id=None, commerce_indicator=None, commerce_indicator_label=None, payment_solution=None, reconciliation_id=None, link_id=None, purchase_level=None, transaction_timeout=None, intents_id=None, payment_id=None, report_group=None, visa_checkout_id=None, industry_data_type=None, authorization_options=None, capture_options=None, recurring_options=None, bank_transfer_options=None, purchase_options=None, electronic_benefits_transfer=None, loan_options=None, wallet_type=None, national_net_domestic_data=None, japan_payment_options=None, mobile_remote_payment_type=None, extended_credit_total_count=None, network_routing_order=None, pay_by_points_indicator=None, timeout=None, is_return_auth_record_enabled=None, network_partner_id=None, payment_type=None):
        """
        Ptsv2paymentsProcessingInformation - a model defined in Swagger
        """

        self._action_list = None
        self._enable_escrow_option = None
        self._action_token_types = None
        self._bin_source = None
        self._capture = None
        self._processor_id = None
        self._business_application_id = None
        self._commerce_indicator = None
        self._commerce_indicator_label = None
        self._payment_solution = None
        self._reconciliation_id = None
        self._link_id = None
        self._purchase_level = None
        self._transaction_timeout = None
        self._intents_id = None
        self._payment_id = None
        self._report_group = None
        self._visa_checkout_id = None
        self._industry_data_type = None
        self._authorization_options = None
        self._capture_options = None
        self._recurring_options = None
        self._bank_transfer_options = None
        self._purchase_options = None
        self._electronic_benefits_transfer = None
        self._loan_options = None
        self._wallet_type = None
        self._national_net_domestic_data = None
        self._japan_payment_options = None
        self._mobile_remote_payment_type = None
        self._extended_credit_total_count = None
        self._network_routing_order = None
        self._pay_by_points_indicator = None
        self._timeout = None
        self._is_return_auth_record_enabled = None
        self._network_partner_id = None
        self._payment_type = None

        if action_list is not None:
          self.action_list = action_list
        if enable_escrow_option is not None:
          self.enable_escrow_option = enable_escrow_option
        if action_token_types is not None:
          self.action_token_types = action_token_types
        if bin_source is not None:
          self.bin_source = bin_source
        if capture is not None:
          self.capture = capture
        if processor_id is not None:
          self.processor_id = processor_id
        if business_application_id is not None:
          self.business_application_id = business_application_id
        if commerce_indicator is not None:
          self.commerce_indicator = commerce_indicator
        if commerce_indicator_label is not None:
          self.commerce_indicator_label = commerce_indicator_label
        if payment_solution is not None:
          self.payment_solution = payment_solution
        if reconciliation_id is not None:
          self.reconciliation_id = reconciliation_id
        if link_id is not None:
          self.link_id = link_id
        if purchase_level is not None:
          self.purchase_level = purchase_level
        if transaction_timeout is not None:
          self.transaction_timeout = transaction_timeout
        if intents_id is not None:
          self.intents_id = intents_id
        if payment_id is not None:
          self.payment_id = payment_id
        if report_group is not None:
          self.report_group = report_group
        if visa_checkout_id is not None:
          self.visa_checkout_id = visa_checkout_id
        if industry_data_type is not None:
          self.industry_data_type = industry_data_type
        if authorization_options is not None:
          self.authorization_options = authorization_options
        if capture_options is not None:
          self.capture_options = capture_options
        if recurring_options is not None:
          self.recurring_options = recurring_options
        if bank_transfer_options is not None:
          self.bank_transfer_options = bank_transfer_options
        if purchase_options is not None:
          self.purchase_options = purchase_options
        if electronic_benefits_transfer is not None:
          self.electronic_benefits_transfer = electronic_benefits_transfer
        if loan_options is not None:
          self.loan_options = loan_options
        if wallet_type is not None:
          self.wallet_type = wallet_type
        if national_net_domestic_data is not None:
          self.national_net_domestic_data = national_net_domestic_data
        if japan_payment_options is not None:
          self.japan_payment_options = japan_payment_options
        if mobile_remote_payment_type is not None:
          self.mobile_remote_payment_type = mobile_remote_payment_type
        if extended_credit_total_count is not None:
          self.extended_credit_total_count = extended_credit_total_count
        if network_routing_order is not None:
          self.network_routing_order = network_routing_order
        if pay_by_points_indicator is not None:
          self.pay_by_points_indicator = pay_by_points_indicator
        if timeout is not None:
          self.timeout = timeout
        if is_return_auth_record_enabled is not None:
          self.is_return_auth_record_enabled = is_return_auth_record_enabled
        if network_partner_id is not None:
          self.network_partner_id = network_partner_id
        if payment_type is not None:
          self.payment_type = payment_type

    @property
    def action_list(self):
        """
        Gets the action_list of this Ptsv2paymentsProcessingInformation.
        Array of actions (one or more) to be included in the payment to invoke bundled services along with payment.  Possible values are one or more of follows:   - `DECISION_SKIP`: Use this when you want to skip Decision Manager service(s).   - `TOKEN_CREATE`: Use this when you want to create a token from the card/bank data in your payment request.   - `CONSUMER_AUTHENTICATION`: Use this when you want to check if a card is enrolled in Payer Authentication along with your payment request.   - `VALIDATE_CONSUMER_AUTHENTICATION`: Use this after you acquire a Payer Authentication result that needs to be included for your payment request.    - `AP_INITIATE`: Use this when Alternative Payment Initiate service is requested.   - `WATCHLIST_SCREENING` : Use this when you want to call Watchlist Screening service.   - `AP_SALE` : Use this when Alternative Payment Sale service is requested.    - `AP_AUTH` : Use this when Alternative Payment Authorize service is requested. 

        :return: The action_list of this Ptsv2paymentsProcessingInformation.
        :rtype: list[str]
        """
        return self._action_list

    @action_list.setter
    def action_list(self, action_list):
        """
        Sets the action_list of this Ptsv2paymentsProcessingInformation.
        Array of actions (one or more) to be included in the payment to invoke bundled services along with payment.  Possible values are one or more of follows:   - `DECISION_SKIP`: Use this when you want to skip Decision Manager service(s).   - `TOKEN_CREATE`: Use this when you want to create a token from the card/bank data in your payment request.   - `CONSUMER_AUTHENTICATION`: Use this when you want to check if a card is enrolled in Payer Authentication along with your payment request.   - `VALIDATE_CONSUMER_AUTHENTICATION`: Use this after you acquire a Payer Authentication result that needs to be included for your payment request.    - `AP_INITIATE`: Use this when Alternative Payment Initiate service is requested.   - `WATCHLIST_SCREENING` : Use this when you want to call Watchlist Screening service.   - `AP_SALE` : Use this when Alternative Payment Sale service is requested.    - `AP_AUTH` : Use this when Alternative Payment Authorize service is requested. 

        :param action_list: The action_list of this Ptsv2paymentsProcessingInformation.
        :type: list[str]
        """

        self._action_list = action_list

    @property
    def enable_escrow_option(self):
        """
        Gets the enable_escrow_option of this Ptsv2paymentsProcessingInformation.
        Indicates whether to use the customer's escrow agreement. Possible values: - `true`: yes, use the customer's escrow agreement. - `false`: no, do not use the customer's escrow agreement.  

        :return: The enable_escrow_option of this Ptsv2paymentsProcessingInformation.
        :rtype: bool
        """
        return self._enable_escrow_option

    @enable_escrow_option.setter
    def enable_escrow_option(self, enable_escrow_option):
        """
        Sets the enable_escrow_option of this Ptsv2paymentsProcessingInformation.
        Indicates whether to use the customer's escrow agreement. Possible values: - `true`: yes, use the customer's escrow agreement. - `false`: no, do not use the customer's escrow agreement.  

        :param enable_escrow_option: The enable_escrow_option of this Ptsv2paymentsProcessingInformation.
        :type: bool
        """

        self._enable_escrow_option = enable_escrow_option

    @property
    def action_token_types(self):
        """
        Gets the action_token_types of this Ptsv2paymentsProcessingInformation.
        CyberSource tokens types you are performing a create on. If not supplied the default token type for the merchants token vault will be used.  Valid values: - customer - paymentInstrument - instrumentIdentifier - shippingAddress 

        :return: The action_token_types of this Ptsv2paymentsProcessingInformation.
        :rtype: list[str]
        """
        return self._action_token_types

    @action_token_types.setter
    def action_token_types(self, action_token_types):
        """
        Sets the action_token_types of this Ptsv2paymentsProcessingInformation.
        CyberSource tokens types you are performing a create on. If not supplied the default token type for the merchants token vault will be used.  Valid values: - customer - paymentInstrument - instrumentIdentifier - shippingAddress 

        :param action_token_types: The action_token_types of this Ptsv2paymentsProcessingInformation.
        :type: list[str]
        """

        self._action_token_types = action_token_types

    @property
    def bin_source(self):
        """
        Gets the bin_source of this Ptsv2paymentsProcessingInformation.
        Bin Source File Identifier. Possible values: - itmx - rupay 

        :return: The bin_source of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._bin_source

    @bin_source.setter
    def bin_source(self, bin_source):
        """
        Sets the bin_source of this Ptsv2paymentsProcessingInformation.
        Bin Source File Identifier. Possible values: - itmx - rupay 

        :param bin_source: The bin_source of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._bin_source = bin_source

    @property
    def capture(self):
        """
        Gets the capture of this Ptsv2paymentsProcessingInformation.
        Indicates whether to also include a capture  in the submitted authorization request or not.  Possible values: - `true`: Include a capture with an authorization request. - `false`: (default) Do not include a capture with an authorization request.  #### Used by **Authorization and Capture** Optional field. 

        :return: The capture of this Ptsv2paymentsProcessingInformation.
        :rtype: bool
        """
        return self._capture

    @capture.setter
    def capture(self, capture):
        """
        Sets the capture of this Ptsv2paymentsProcessingInformation.
        Indicates whether to also include a capture  in the submitted authorization request or not.  Possible values: - `true`: Include a capture with an authorization request. - `false`: (default) Do not include a capture with an authorization request.  #### Used by **Authorization and Capture** Optional field. 

        :param capture: The capture of this Ptsv2paymentsProcessingInformation.
        :type: bool
        """

        self._capture = capture

    @property
    def processor_id(self):
        """
        Gets the processor_id of this Ptsv2paymentsProcessingInformation.
        Value that identifies the processor/acquirer to use for the transaction. This value is supported only for **CyberSource through VisaNet**.  Contact CyberSource Customer Support to get the value for this field. 

        :return: The processor_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._processor_id

    @processor_id.setter
    def processor_id(self, processor_id):
        """
        Sets the processor_id of this Ptsv2paymentsProcessingInformation.
        Value that identifies the processor/acquirer to use for the transaction. This value is supported only for **CyberSource through VisaNet**.  Contact CyberSource Customer Support to get the value for this field. 

        :param processor_id: The processor_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._processor_id = processor_id

    @property
    def business_application_id(self):
        """
        Gets the business_application_id of this Ptsv2paymentsProcessingInformation.
        Payouts transaction type. Required for OCT transactions. This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor. **Note** When the request includes this field, this value overrides the information in your CyberSource account. 

        :return: The business_application_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._business_application_id

    @business_application_id.setter
    def business_application_id(self, business_application_id):
        """
        Sets the business_application_id of this Ptsv2paymentsProcessingInformation.
        Payouts transaction type. Required for OCT transactions. This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor. **Note** When the request includes this field, this value overrides the information in your CyberSource account. 

        :param business_application_id: The business_application_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._business_application_id = business_application_id

    @property
    def commerce_indicator(self):
        """
        Gets the commerce_indicator of this Ptsv2paymentsProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as \"moto\" 

        :return: The commerce_indicator of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._commerce_indicator

    @commerce_indicator.setter
    def commerce_indicator(self, commerce_indicator):
        """
        Sets the commerce_indicator of this Ptsv2paymentsProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as \"moto\" 

        :param commerce_indicator: The commerce_indicator of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._commerce_indicator = commerce_indicator

    @property
    def commerce_indicator_label(self):
        """
        Gets the commerce_indicator_label of this Ptsv2paymentsProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as `moto` 

        :return: The commerce_indicator_label of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._commerce_indicator_label

    @commerce_indicator_label.setter
    def commerce_indicator_label(self, commerce_indicator_label):
        """
        Sets the commerce_indicator_label of this Ptsv2paymentsProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as `moto` 

        :param commerce_indicator_label: The commerce_indicator_label of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._commerce_indicator_label = commerce_indicator_label

    @property
    def payment_solution(self):
        """
        Gets the payment_solution of this Ptsv2paymentsProcessingInformation.
        Type of digital payment solution for the transaction. Possible Values:   - `visacheckout`: Visa Checkout. This value is required for Visa Checkout transactions. For details, see `payment_solution` field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - `001`: Apple Pay.  - `004`: Cybersource In-App Solution.  - `005`: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \"Masterpass\" in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - `006`: Android Pay.  - `007`: Chase Pay.  - `008`: Samsung Pay.  - `012`: Google Pay.  - `013`: Cybersource P2PE Decryption  - `014`: Mastercard credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `015`: Visa credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `027`: Click to Pay. 

        :return: The payment_solution of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._payment_solution

    @payment_solution.setter
    def payment_solution(self, payment_solution):
        """
        Sets the payment_solution of this Ptsv2paymentsProcessingInformation.
        Type of digital payment solution for the transaction. Possible Values:   - `visacheckout`: Visa Checkout. This value is required for Visa Checkout transactions. For details, see `payment_solution` field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - `001`: Apple Pay.  - `004`: Cybersource In-App Solution.  - `005`: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \"Masterpass\" in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - `006`: Android Pay.  - `007`: Chase Pay.  - `008`: Samsung Pay.  - `012`: Google Pay.  - `013`: Cybersource P2PE Decryption  - `014`: Mastercard credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `015`: Visa credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `027`: Click to Pay. 

        :param payment_solution: The payment_solution of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._payment_solution = payment_solution

    @property
    def reconciliation_id(self):
        """
        Gets the reconciliation_id of this Ptsv2paymentsProcessingInformation.
        Please check with Cybersource customer support to see if your merchant account is configured correctly so you can include this field in your request. * For Payouts: max length for FDCCompass is String (22). 

        :return: The reconciliation_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._reconciliation_id

    @reconciliation_id.setter
    def reconciliation_id(self, reconciliation_id):
        """
        Sets the reconciliation_id of this Ptsv2paymentsProcessingInformation.
        Please check with Cybersource customer support to see if your merchant account is configured correctly so you can include this field in your request. * For Payouts: max length for FDCCompass is String (22). 

        :param reconciliation_id: The reconciliation_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._reconciliation_id = reconciliation_id

    @property
    def link_id(self):
        """
        Gets the link_id of this Ptsv2paymentsProcessingInformation.
        Value that links the current authorization request to the original authorization request. Set this value to the ID that was returned in the reply message from the original authorization request.  This value is used for:  - Partial authorizations - Split shipments 

        :return: The link_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """
        Sets the link_id of this Ptsv2paymentsProcessingInformation.
        Value that links the current authorization request to the original authorization request. Set this value to the ID that was returned in the reply message from the original authorization request.  This value is used for:  - Partial authorizations - Split shipments 

        :param link_id: The link_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._link_id = link_id

    @property
    def purchase_level(self):
        """
        Gets the purchase_level of this Ptsv2paymentsProcessingInformation.
        Set this field to 3 to indicate that the request includes Level III data.

        :return: The purchase_level of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._purchase_level

    @purchase_level.setter
    def purchase_level(self, purchase_level):
        """
        Sets the purchase_level of this Ptsv2paymentsProcessingInformation.
        Set this field to 3 to indicate that the request includes Level III data.

        :param purchase_level: The purchase_level of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._purchase_level = purchase_level

    @property
    def transaction_timeout(self):
        """
        Gets the transaction_timeout of this Ptsv2paymentsProcessingInformation.
        The time-out limit in seconds for the transaction. The time-out limit starts when the customer is directed to the merchant URL that is included in the sale service response. The maximum value is 99999 (about 27 hours). When the transaction times out, the payment system changes the status to abandoned.

        :return: The transaction_timeout of this Ptsv2paymentsProcessingInformation.
        :rtype: int
        """
        return self._transaction_timeout

    @transaction_timeout.setter
    def transaction_timeout(self, transaction_timeout):
        """
        Sets the transaction_timeout of this Ptsv2paymentsProcessingInformation.
        The time-out limit in seconds for the transaction. The time-out limit starts when the customer is directed to the merchant URL that is included in the sale service response. The maximum value is 99999 (about 27 hours). When the transaction times out, the payment system changes the status to abandoned.

        :param transaction_timeout: The transaction_timeout of this Ptsv2paymentsProcessingInformation.
        :type: int
        """

        self._transaction_timeout = transaction_timeout

    @property
    def intents_id(self):
        """
        Gets the intents_id of this Ptsv2paymentsProcessingInformation.
        Set to the value of the requestID field returned in the order service response.

        :return: The intents_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._intents_id

    @intents_id.setter
    def intents_id(self, intents_id):
        """
        Sets the intents_id of this Ptsv2paymentsProcessingInformation.
        Set to the value of the requestID field returned in the order service response.

        :param intents_id: The intents_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._intents_id = intents_id

    @property
    def payment_id(self):
        """
        Gets the payment_id of this Ptsv2paymentsProcessingInformation.
        This field is to accept the id of credit/capture in the body of L1 requests so the type of void can be identified and processed correctly downstream.

        :return: The payment_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._payment_id

    @payment_id.setter
    def payment_id(self, payment_id):
        """
        Sets the payment_id of this Ptsv2paymentsProcessingInformation.
        This field is to accept the id of credit/capture in the body of L1 requests so the type of void can be identified and processed correctly downstream.

        :param payment_id: The payment_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._payment_id = payment_id

    @property
    def report_group(self):
        """
        Gets the report_group of this Ptsv2paymentsProcessingInformation.
        Attribute that lets you define custom grouping for your processor reports. This field is supported only for **Worldpay VAP**. 

        :return: The report_group of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._report_group

    @report_group.setter
    def report_group(self, report_group):
        """
        Sets the report_group of this Ptsv2paymentsProcessingInformation.
        Attribute that lets you define custom grouping for your processor reports. This field is supported only for **Worldpay VAP**. 

        :param report_group: The report_group of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._report_group = report_group

    @property
    def visa_checkout_id(self):
        """
        Gets the visa_checkout_id of this Ptsv2paymentsProcessingInformation.
        Identifier for the **Visa Checkout** order. Visa Checkout provides a unique order ID for every transaction in the Visa Checkout **callID** field. 

        :return: The visa_checkout_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._visa_checkout_id

    @visa_checkout_id.setter
    def visa_checkout_id(self, visa_checkout_id):
        """
        Sets the visa_checkout_id of this Ptsv2paymentsProcessingInformation.
        Identifier for the **Visa Checkout** order. Visa Checkout provides a unique order ID for every transaction in the Visa Checkout **callID** field. 

        :param visa_checkout_id: The visa_checkout_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._visa_checkout_id = visa_checkout_id

    @property
    def industry_data_type(self):
        """
        Gets the industry_data_type of this Ptsv2paymentsProcessingInformation.
        Indicates that the transaction includes industry-specific data.  Possible Values: - `airline` - `restaurant` - `lodging` - `auto_rental` - `transit` - `healthcare_medical` - `healthcare_transit` - `transit`  #### Card Present, Airlines and Auto Rental You must set this field to `airline` in order for airline data to be sent to the processor. For example, if this field is not set to `airline` or is not included in the request, no airline data is sent to the processor.  You must set this field to `restaurant` in order for restaurant data to be sent to the processor. When this field is not set to `restaurant` or is not included in the request, no restaurant data is sent to the processor.  You must set this field to `auto_rental` in order for auto rental data to be sent to the processor. For example, if this field is not set to `auto_rental` or is not included in the request, no auto rental data is sent to the processor.  Restaurant data is supported only on CyberSource through VisaNet. 

        :return: The industry_data_type of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._industry_data_type

    @industry_data_type.setter
    def industry_data_type(self, industry_data_type):
        """
        Sets the industry_data_type of this Ptsv2paymentsProcessingInformation.
        Indicates that the transaction includes industry-specific data.  Possible Values: - `airline` - `restaurant` - `lodging` - `auto_rental` - `transit` - `healthcare_medical` - `healthcare_transit` - `transit`  #### Card Present, Airlines and Auto Rental You must set this field to `airline` in order for airline data to be sent to the processor. For example, if this field is not set to `airline` or is not included in the request, no airline data is sent to the processor.  You must set this field to `restaurant` in order for restaurant data to be sent to the processor. When this field is not set to `restaurant` or is not included in the request, no restaurant data is sent to the processor.  You must set this field to `auto_rental` in order for auto rental data to be sent to the processor. For example, if this field is not set to `auto_rental` or is not included in the request, no auto rental data is sent to the processor.  Restaurant data is supported only on CyberSource through VisaNet. 

        :param industry_data_type: The industry_data_type of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._industry_data_type = industry_data_type

    @property
    def authorization_options(self):
        """
        Gets the authorization_options of this Ptsv2paymentsProcessingInformation.

        :return: The authorization_options of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationAuthorizationOptions
        """
        return self._authorization_options

    @authorization_options.setter
    def authorization_options(self, authorization_options):
        """
        Sets the authorization_options of this Ptsv2paymentsProcessingInformation.

        :param authorization_options: The authorization_options of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationAuthorizationOptions
        """

        self._authorization_options = authorization_options

    @property
    def capture_options(self):
        """
        Gets the capture_options of this Ptsv2paymentsProcessingInformation.

        :return: The capture_options of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationCaptureOptions
        """
        return self._capture_options

    @capture_options.setter
    def capture_options(self, capture_options):
        """
        Sets the capture_options of this Ptsv2paymentsProcessingInformation.

        :param capture_options: The capture_options of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationCaptureOptions
        """

        self._capture_options = capture_options

    @property
    def recurring_options(self):
        """
        Gets the recurring_options of this Ptsv2paymentsProcessingInformation.

        :return: The recurring_options of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationRecurringOptions
        """
        return self._recurring_options

    @recurring_options.setter
    def recurring_options(self, recurring_options):
        """
        Sets the recurring_options of this Ptsv2paymentsProcessingInformation.

        :param recurring_options: The recurring_options of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationRecurringOptions
        """

        self._recurring_options = recurring_options

    @property
    def bank_transfer_options(self):
        """
        Gets the bank_transfer_options of this Ptsv2paymentsProcessingInformation.

        :return: The bank_transfer_options of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationBankTransferOptions
        """
        return self._bank_transfer_options

    @bank_transfer_options.setter
    def bank_transfer_options(self, bank_transfer_options):
        """
        Sets the bank_transfer_options of this Ptsv2paymentsProcessingInformation.

        :param bank_transfer_options: The bank_transfer_options of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationBankTransferOptions
        """

        self._bank_transfer_options = bank_transfer_options

    @property
    def purchase_options(self):
        """
        Gets the purchase_options of this Ptsv2paymentsProcessingInformation.

        :return: The purchase_options of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationPurchaseOptions
        """
        return self._purchase_options

    @purchase_options.setter
    def purchase_options(self, purchase_options):
        """
        Sets the purchase_options of this Ptsv2paymentsProcessingInformation.

        :param purchase_options: The purchase_options of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationPurchaseOptions
        """

        self._purchase_options = purchase_options

    @property
    def electronic_benefits_transfer(self):
        """
        Gets the electronic_benefits_transfer of this Ptsv2paymentsProcessingInformation.

        :return: The electronic_benefits_transfer of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer
        """
        return self._electronic_benefits_transfer

    @electronic_benefits_transfer.setter
    def electronic_benefits_transfer(self, electronic_benefits_transfer):
        """
        Sets the electronic_benefits_transfer of this Ptsv2paymentsProcessingInformation.

        :param electronic_benefits_transfer: The electronic_benefits_transfer of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer
        """

        self._electronic_benefits_transfer = electronic_benefits_transfer

    @property
    def loan_options(self):
        """
        Gets the loan_options of this Ptsv2paymentsProcessingInformation.

        :return: The loan_options of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationLoanOptions
        """
        return self._loan_options

    @loan_options.setter
    def loan_options(self, loan_options):
        """
        Sets the loan_options of this Ptsv2paymentsProcessingInformation.

        :param loan_options: The loan_options of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationLoanOptions
        """

        self._loan_options = loan_options

    @property
    def wallet_type(self):
        """
        Gets the wallet_type of this Ptsv2paymentsProcessingInformation.
        This field carries the wallet type in authorization requests and credit requests. Possible value are: - `101`: Masterpass remote payment. The customer created the wallet by manually interacting with a customer-controlled device such as a computer, tablet, or phone. This value is supported only for Masterpass transactions on Chase Paymentech Solutions and CyberSource through VisaNet. - `102`: Masterpass remote near field communication (NFC) payment. The customer created the wallet by tapping a PayPass card or customer-controlled device at a contactless card reader. This value is supported only for card-present Masterpass transactions on CyberSource through VisaNet. - `103`: Masterpass Apple Pay payment. The payment was made with a combination of Masterpass and Apple Pay. This value is supported only for Masterpass Apple Pay transactions on CyberSource through VisaNet. - `216`: Masterpass Google Pay payment. The payment was made with a combination of Masterpass and Google Pay. This value is supported only for Masterpass Google Pay transactions on CyberSource through VisaNet. - `217`: Masterpass Samsung Pay payment. The payment was made with a combination of Masterpass and Samsung Pay. This value is supported only for Masterpass Samsung Pay transactions on CyberSource through VisaNet. - `SDW`: Staged digital wallet. An issuer or operator created the wallet. This value is supported only for Masterpass transactions on Chase Paymentech Solutions. - `VCIND`: Visa Checkout payment. This value is supported only on CyberSource through VisaNet, FDC Compass, FDC Nashville Global, FDI Australia, and TSYS Acquiring Solutions. See Getting Started with Visa Checkout. For Visa Checkout transactions, the way CyberSource processes the value for this field depends on the processor. See the Visa Checkout section below. For all other values, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. Masterpass (101, 102, 103, 216, and 217): The Masterpass platform generates the wallet type value and passes it to you along with the customer's checkout information.  Visa Checkout: This field is optional for Visa Checkout authorizations on FDI Australia. For all other processors, this field is required for Visa Checkout authorizations. For Visa Checkout transactions on the following processors, CyberSource sends the value that the processor expects for this field:FDC Compass,FDC Nashville Global,FDI Australia,TSYS Acquiring Solutions For all other processors, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. For incremental authorizations, this field is supported only for Mastercard and the supported values are 101 and 102. Payment card companies can introduce new values without notice. Your order management system should be able to process new values without problems.  CyberSource through VisaNet When the value for this field is 101, 102, 103, 216, or 217, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR6, Position: 88-90,  Field: Mastercard Wallet Identifier. When the value for this field is VCIND, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR8, Position: 72-76, Field: Agent Unique ID. 

        :return: The wallet_type of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._wallet_type

    @wallet_type.setter
    def wallet_type(self, wallet_type):
        """
        Sets the wallet_type of this Ptsv2paymentsProcessingInformation.
        This field carries the wallet type in authorization requests and credit requests. Possible value are: - `101`: Masterpass remote payment. The customer created the wallet by manually interacting with a customer-controlled device such as a computer, tablet, or phone. This value is supported only for Masterpass transactions on Chase Paymentech Solutions and CyberSource through VisaNet. - `102`: Masterpass remote near field communication (NFC) payment. The customer created the wallet by tapping a PayPass card or customer-controlled device at a contactless card reader. This value is supported only for card-present Masterpass transactions on CyberSource through VisaNet. - `103`: Masterpass Apple Pay payment. The payment was made with a combination of Masterpass and Apple Pay. This value is supported only for Masterpass Apple Pay transactions on CyberSource through VisaNet. - `216`: Masterpass Google Pay payment. The payment was made with a combination of Masterpass and Google Pay. This value is supported only for Masterpass Google Pay transactions on CyberSource through VisaNet. - `217`: Masterpass Samsung Pay payment. The payment was made with a combination of Masterpass and Samsung Pay. This value is supported only for Masterpass Samsung Pay transactions on CyberSource through VisaNet. - `SDW`: Staged digital wallet. An issuer or operator created the wallet. This value is supported only for Masterpass transactions on Chase Paymentech Solutions. - `VCIND`: Visa Checkout payment. This value is supported only on CyberSource through VisaNet, FDC Compass, FDC Nashville Global, FDI Australia, and TSYS Acquiring Solutions. See Getting Started with Visa Checkout. For Visa Checkout transactions, the way CyberSource processes the value for this field depends on the processor. See the Visa Checkout section below. For all other values, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. Masterpass (101, 102, 103, 216, and 217): The Masterpass platform generates the wallet type value and passes it to you along with the customer's checkout information.  Visa Checkout: This field is optional for Visa Checkout authorizations on FDI Australia. For all other processors, this field is required for Visa Checkout authorizations. For Visa Checkout transactions on the following processors, CyberSource sends the value that the processor expects for this field:FDC Compass,FDC Nashville Global,FDI Australia,TSYS Acquiring Solutions For all other processors, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. For incremental authorizations, this field is supported only for Mastercard and the supported values are 101 and 102. Payment card companies can introduce new values without notice. Your order management system should be able to process new values without problems.  CyberSource through VisaNet When the value for this field is 101, 102, 103, 216, or 217, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR6, Position: 88-90,  Field: Mastercard Wallet Identifier. When the value for this field is VCIND, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR8, Position: 72-76, Field: Agent Unique ID. 

        :param wallet_type: The wallet_type of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._wallet_type = wallet_type

    @property
    def national_net_domestic_data(self):
        """
        Gets the national_net_domestic_data of this Ptsv2paymentsProcessingInformation.
        Supplementary domestic transaction information provided by the acquirer for National Net Settlement Service (NNSS) transactions. NNSS is a settlement service that Visa provides. For transactions on CyberSource through VisaNet in countries that subscribe to NNSS: VisaNet clears transactions; VisaNet transfers funds to the acquirer after deducting processing fees and interchange fees. VisaNet settles transactions in the local pricing currency through a local financial institution. This field is supported only on CyberSource through VisaNet for domestic data in Colombia 

        :return: The national_net_domestic_data of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._national_net_domestic_data

    @national_net_domestic_data.setter
    def national_net_domestic_data(self, national_net_domestic_data):
        """
        Sets the national_net_domestic_data of this Ptsv2paymentsProcessingInformation.
        Supplementary domestic transaction information provided by the acquirer for National Net Settlement Service (NNSS) transactions. NNSS is a settlement service that Visa provides. For transactions on CyberSource through VisaNet in countries that subscribe to NNSS: VisaNet clears transactions; VisaNet transfers funds to the acquirer after deducting processing fees and interchange fees. VisaNet settles transactions in the local pricing currency through a local financial institution. This field is supported only on CyberSource through VisaNet for domestic data in Colombia 

        :param national_net_domestic_data: The national_net_domestic_data of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._national_net_domestic_data = national_net_domestic_data

    @property
    def japan_payment_options(self):
        """
        Gets the japan_payment_options of this Ptsv2paymentsProcessingInformation.

        :return: The japan_payment_options of this Ptsv2paymentsProcessingInformation.
        :rtype: Ptsv2paymentsProcessingInformationJapanPaymentOptions
        """
        return self._japan_payment_options

    @japan_payment_options.setter
    def japan_payment_options(self, japan_payment_options):
        """
        Sets the japan_payment_options of this Ptsv2paymentsProcessingInformation.

        :param japan_payment_options: The japan_payment_options of this Ptsv2paymentsProcessingInformation.
        :type: Ptsv2paymentsProcessingInformationJapanPaymentOptions
        """

        self._japan_payment_options = japan_payment_options

    @property
    def mobile_remote_payment_type(self):
        """
        Gets the mobile_remote_payment_type of this Ptsv2paymentsProcessingInformation.
        Type of payment initiated from a cardholder's mobile device. Possible values: - `1` :  Consumer-initiated remote purchase, face-to-face - `2` :  Consumer-initiated remote purchase, e-commerce - `3` :  Consumer-initiated remote purchase, mail order / telephone order - `4` :  Consumer-initiated bill pay - `5` :  Consumer-initiated top up - `6` :  Consumer-initiated cash out - `7` :  ATM triggered or agent-initiated cash out - `8` :  Merchant-initiated remote purchase, face-to-face - `9` :  Merchant-initiated remote purchase, e-commerce  This field is supported only for Mastercard transactions on CyberSource through VisaNet.  Optional field.  **Note** On CyberSource through VisaNet, the value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 94 - Field: Mastercard Mobile Remote Payment Program Indicator  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. 

        :return: The mobile_remote_payment_type of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._mobile_remote_payment_type

    @mobile_remote_payment_type.setter
    def mobile_remote_payment_type(self, mobile_remote_payment_type):
        """
        Sets the mobile_remote_payment_type of this Ptsv2paymentsProcessingInformation.
        Type of payment initiated from a cardholder's mobile device. Possible values: - `1` :  Consumer-initiated remote purchase, face-to-face - `2` :  Consumer-initiated remote purchase, e-commerce - `3` :  Consumer-initiated remote purchase, mail order / telephone order - `4` :  Consumer-initiated bill pay - `5` :  Consumer-initiated top up - `6` :  Consumer-initiated cash out - `7` :  ATM triggered or agent-initiated cash out - `8` :  Merchant-initiated remote purchase, face-to-face - `9` :  Merchant-initiated remote purchase, e-commerce  This field is supported only for Mastercard transactions on CyberSource through VisaNet.  Optional field.  **Note** On CyberSource through VisaNet, the value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 94 - Field: Mastercard Mobile Remote Payment Program Indicator  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. 

        :param mobile_remote_payment_type: The mobile_remote_payment_type of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._mobile_remote_payment_type = mobile_remote_payment_type

    @property
    def extended_credit_total_count(self):
        """
        Gets the extended_credit_total_count of this Ptsv2paymentsProcessingInformation.
        A private national-use field submitted by acquirers and issuers in South Africa for South Africa-domestic (intra-country) authorizations and financial requests. Values for this field are 00 through 99. 

        :return: The extended_credit_total_count of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._extended_credit_total_count

    @extended_credit_total_count.setter
    def extended_credit_total_count(self, extended_credit_total_count):
        """
        Sets the extended_credit_total_count of this Ptsv2paymentsProcessingInformation.
        A private national-use field submitted by acquirers and issuers in South Africa for South Africa-domestic (intra-country) authorizations and financial requests. Values for this field are 00 through 99. 

        :param extended_credit_total_count: The extended_credit_total_count of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._extended_credit_total_count = extended_credit_total_count

    @property
    def network_routing_order(self):
        """
        Gets the network_routing_order of this Ptsv2paymentsProcessingInformation.
        On PIN Debit Gateways: This U.S.-only field is optionally used by  participants (merchants and acquirers) to specify the network access priority. VisaNet checks to determine if there are issuer routing preferences for any of the networks specified by the sharing group code. If an issuer preference exists for one of the specified debit networks, VisaNet makes a routing selection based on the issuer's preference. If an issuer preference exists for more than one of the specified debit networks, or if no issuer preference exists, VisaNet makes a selection based on the acquirer's routing priorities.  #### PIN debit Priority order of the networks through which he transaction will be routed. Set this value to a series of one-character network codes in your preferred order. This is a list of the network codes:  | Network | Code | | --- | --- | | Accel | E | | AFFN | U | | Alaska Option | 3 | | CU24 | C | | Interlink | G | | Maestro | 8 | | NETS | P | | NYCE | F | | Pulse | H | | Shazam | 7 | | Star | M | | Visa | V |  For example, if the Star network is your first preference and Pulse is your second preference, set this field to a value of `MH`.  When you do not include this value in your PIN debit request, the list of network codes from your account is used. **Note** This field is supported only for businesses located in the U.S.  Optional field for PIN debit credit or PIN debit purchase. 

        :return: The network_routing_order of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._network_routing_order

    @network_routing_order.setter
    def network_routing_order(self, network_routing_order):
        """
        Sets the network_routing_order of this Ptsv2paymentsProcessingInformation.
        On PIN Debit Gateways: This U.S.-only field is optionally used by  participants (merchants and acquirers) to specify the network access priority. VisaNet checks to determine if there are issuer routing preferences for any of the networks specified by the sharing group code. If an issuer preference exists for one of the specified debit networks, VisaNet makes a routing selection based on the issuer's preference. If an issuer preference exists for more than one of the specified debit networks, or if no issuer preference exists, VisaNet makes a selection based on the acquirer's routing priorities.  #### PIN debit Priority order of the networks through which he transaction will be routed. Set this value to a series of one-character network codes in your preferred order. This is a list of the network codes:  | Network | Code | | --- | --- | | Accel | E | | AFFN | U | | Alaska Option | 3 | | CU24 | C | | Interlink | G | | Maestro | 8 | | NETS | P | | NYCE | F | | Pulse | H | | Shazam | 7 | | Star | M | | Visa | V |  For example, if the Star network is your first preference and Pulse is your second preference, set this field to a value of `MH`.  When you do not include this value in your PIN debit request, the list of network codes from your account is used. **Note** This field is supported only for businesses located in the U.S.  Optional field for PIN debit credit or PIN debit purchase. 

        :param network_routing_order: The network_routing_order of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._network_routing_order = network_routing_order

    @property
    def pay_by_points_indicator(self):
        """
        Gets the pay_by_points_indicator of this Ptsv2paymentsProcessingInformation.
        Flag that indicates if the transaction is pay by points transaction true: Transaction uses loyalty points false: Transaction does not use loyalty points Default: false 

        :return: The pay_by_points_indicator of this Ptsv2paymentsProcessingInformation.
        :rtype: bool
        """
        return self._pay_by_points_indicator

    @pay_by_points_indicator.setter
    def pay_by_points_indicator(self, pay_by_points_indicator):
        """
        Sets the pay_by_points_indicator of this Ptsv2paymentsProcessingInformation.
        Flag that indicates if the transaction is pay by points transaction true: Transaction uses loyalty points false: Transaction does not use loyalty points Default: false 

        :param pay_by_points_indicator: The pay_by_points_indicator of this Ptsv2paymentsProcessingInformation.
        :type: bool
        """

        self._pay_by_points_indicator = pay_by_points_indicator

    @property
    def timeout(self):
        """
        Gets the timeout of this Ptsv2paymentsProcessingInformation.
        Minutes until a pending MyBank transaction will be timed out. Value must be between 5 and 30. Default is 5. 

        :return: The timeout of this Ptsv2paymentsProcessingInformation.
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """
        Sets the timeout of this Ptsv2paymentsProcessingInformation.
        Minutes until a pending MyBank transaction will be timed out. Value must be between 5 and 30. Default is 5. 

        :param timeout: The timeout of this Ptsv2paymentsProcessingInformation.
        :type: int
        """

        self._timeout = timeout

    @property
    def is_return_auth_record_enabled(self):
        """
        Gets the is_return_auth_record_enabled of this Ptsv2paymentsProcessingInformation.
        Flag that indicates the functionality we are having for merchants for which auth is done through Cybersource but settlement is done by themselves. true: functionality is supported. Processor should send raw processor auth response to Merchant. false: functionality is not supported. Default: false 

        :return: The is_return_auth_record_enabled of this Ptsv2paymentsProcessingInformation.
        :rtype: bool
        """
        return self._is_return_auth_record_enabled

    @is_return_auth_record_enabled.setter
    def is_return_auth_record_enabled(self, is_return_auth_record_enabled):
        """
        Sets the is_return_auth_record_enabled of this Ptsv2paymentsProcessingInformation.
        Flag that indicates the functionality we are having for merchants for which auth is done through Cybersource but settlement is done by themselves. true: functionality is supported. Processor should send raw processor auth response to Merchant. false: functionality is not supported. Default: false 

        :param is_return_auth_record_enabled: The is_return_auth_record_enabled of this Ptsv2paymentsProcessingInformation.
        :type: bool
        """

        self._is_return_auth_record_enabled = is_return_auth_record_enabled

    @property
    def network_partner_id(self):
        """
        Gets the network_partner_id of this Ptsv2paymentsProcessingInformation.
        Merchant payment gateway ID that is assigned by Mastercard and is provided by the acquirer when a registered merchant payment gateway service provider is involved in the transaction.  This field is supported for Visa Platform Connect. 

        :return: The network_partner_id of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._network_partner_id

    @network_partner_id.setter
    def network_partner_id(self, network_partner_id):
        """
        Sets the network_partner_id of this Ptsv2paymentsProcessingInformation.
        Merchant payment gateway ID that is assigned by Mastercard and is provided by the acquirer when a registered merchant payment gateway service provider is involved in the transaction.  This field is supported for Visa Platform Connect. 

        :param network_partner_id: The network_partner_id of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._network_partner_id = network_partner_id

    @property
    def payment_type(self):
        """
        Gets the payment_type of this Ptsv2paymentsProcessingInformation.
        Identifier for the payment type. 

        :return: The payment_type of this Ptsv2paymentsProcessingInformation.
        :rtype: str
        """
        return self._payment_type

    @payment_type.setter
    def payment_type(self, payment_type):
        """
        Sets the payment_type of this Ptsv2paymentsProcessingInformation.
        Identifier for the payment type. 

        :param payment_type: The payment_type of this Ptsv2paymentsProcessingInformation.
        :type: str
        """

        self._payment_type = payment_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsProcessingInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
