# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Riskv1authenticationsOrderInformationLineItems(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'total_amount': 'str',
        'unit_price': 'str',
        'quantity': 'int',
        'gift_card_currency': 'int',
        'product_sku': 'str',
        'product_description': 'str',
        'product_name': 'str',
        'passenger': 'Ptsv2paymentsOrderInformationPassenger',
        'shipping_destination_types': 'str',
        'tax_amount': 'str',
        'shipping_address1': 'str',
        'shipping_address2': 'str',
        'shipping_city': 'str',
        'shipping_country_code': 'str',
        'shipping_first_name': 'str',
        'shipping_last_name': 'str',
        'shipping_middle_name': 'str',
        'shipping_phone': 'int',
        'shipping_postal_code': 'int',
        'shipping_state': 'str'
    }

    attribute_map = {
        'total_amount': 'totalAmount',
        'unit_price': 'unitPrice',
        'quantity': 'quantity',
        'gift_card_currency': 'giftCardCurrency',
        'product_sku': 'productSKU',
        'product_description': 'productDescription',
        'product_name': 'productName',
        'passenger': 'passenger',
        'shipping_destination_types': 'shippingDestinationTypes',
        'tax_amount': 'taxAmount',
        'shipping_address1': 'shippingAddress1',
        'shipping_address2': 'shippingAddress2',
        'shipping_city': 'shippingCity',
        'shipping_country_code': 'shippingCountryCode',
        'shipping_first_name': 'shippingFirstName',
        'shipping_last_name': 'shippingLastName',
        'shipping_middle_name': 'shippingMiddleName',
        'shipping_phone': 'shippingPhone',
        'shipping_postal_code': 'shippingPostalCode',
        'shipping_state': 'shippingState'
    }

    def __init__(self, total_amount=None, unit_price=None, quantity=None, gift_card_currency=None, product_sku=None, product_description=None, product_name=None, passenger=None, shipping_destination_types=None, tax_amount=None, shipping_address1=None, shipping_address2=None, shipping_city=None, shipping_country_code=None, shipping_first_name=None, shipping_last_name=None, shipping_middle_name=None, shipping_phone=None, shipping_postal_code=None, shipping_state=None):
        """
        Riskv1authenticationsOrderInformationLineItems - a model defined in Swagger
        """

        self._total_amount = None
        self._unit_price = None
        self._quantity = None
        self._gift_card_currency = None
        self._product_sku = None
        self._product_description = None
        self._product_name = None
        self._passenger = None
        self._shipping_destination_types = None
        self._tax_amount = None
        self._shipping_address1 = None
        self._shipping_address2 = None
        self._shipping_city = None
        self._shipping_country_code = None
        self._shipping_first_name = None
        self._shipping_last_name = None
        self._shipping_middle_name = None
        self._shipping_phone = None
        self._shipping_postal_code = None
        self._shipping_state = None

        if total_amount is not None:
          self.total_amount = total_amount
        self.unit_price = unit_price
        if quantity is not None:
          self.quantity = quantity
        if gift_card_currency is not None:
          self.gift_card_currency = gift_card_currency
        if product_sku is not None:
          self.product_sku = product_sku
        if product_description is not None:
          self.product_description = product_description
        if product_name is not None:
          self.product_name = product_name
        if passenger is not None:
          self.passenger = passenger
        if shipping_destination_types is not None:
          self.shipping_destination_types = shipping_destination_types
        if tax_amount is not None:
          self.tax_amount = tax_amount
        if shipping_address1 is not None:
          self.shipping_address1 = shipping_address1
        if shipping_address2 is not None:
          self.shipping_address2 = shipping_address2
        if shipping_city is not None:
          self.shipping_city = shipping_city
        if shipping_country_code is not None:
          self.shipping_country_code = shipping_country_code
        if shipping_first_name is not None:
          self.shipping_first_name = shipping_first_name
        if shipping_last_name is not None:
          self.shipping_last_name = shipping_last_name
        if shipping_middle_name is not None:
          self.shipping_middle_name = shipping_middle_name
        if shipping_phone is not None:
          self.shipping_phone = shipping_phone
        if shipping_postal_code is not None:
          self.shipping_postal_code = shipping_postal_code
        if shipping_state is not None:
          self.shipping_state = shipping_state

    @property
    def total_amount(self):
        """
        Gets the total_amount of this Riskv1authenticationsOrderInformationLineItems.
        Total amount for the item. Normally calculated as the unit price times quantity.  When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the purchase amount total for prepaid gift cards in major units.  Example: 123.45 USD = 123 

        :return: The total_amount of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """
        Sets the total_amount of this Riskv1authenticationsOrderInformationLineItems.
        Total amount for the item. Normally calculated as the unit price times quantity.  When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the purchase amount total for prepaid gift cards in major units.  Example: 123.45 USD = 123 

        :param total_amount: The total_amount of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._total_amount = total_amount

    @property
    def unit_price(self):
        """
        Gets the unit_price of this Riskv1authenticationsOrderInformationLineItems.
        Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in the [Merchant Descriptors Using the SCMP API Guide.] (https://apps.cybersource.com/library/documentation/dev_guides/Merchant_Descriptors_SCMP_API/html/)  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15) 

        :return: The unit_price of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """
        Sets the unit_price of this Riskv1authenticationsOrderInformationLineItems.
        Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### FDMS South If you accept IDR or CLP currencies, see the entry for FDMS South in the [Merchant Descriptors Using the SCMP API Guide.] (https://apps.cybersource.com/library/documentation/dev_guides/Merchant_Descriptors_SCMP_API/html/)  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15) 

        :param unit_price: The unit_price of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._unit_price = unit_price

    @property
    def quantity(self):
        """
        Gets the quantity of this Riskv1authenticationsOrderInformationLineItems.
        Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :return: The quantity of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """
        Sets the quantity of this Riskv1authenticationsOrderInformationLineItems.
        Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :param quantity: The quantity of this Riskv1authenticationsOrderInformationLineItems.
        :type: int
        """

        self._quantity = quantity

    @property
    def gift_card_currency(self):
        """
        Gets the gift_card_currency of this Riskv1authenticationsOrderInformationLineItems.
        When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the currency used for the gift card purchase.  For details, see `pa_gift_card_currency` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/Payer_Authentication_SCMP_API.pdf)  For the possible values, see the [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf) 

        :return: The gift_card_currency of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: int
        """
        return self._gift_card_currency

    @gift_card_currency.setter
    def gift_card_currency(self, gift_card_currency):
        """
        Sets the gift_card_currency of this Riskv1authenticationsOrderInformationLineItems.
        When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the currency used for the gift card purchase.  For details, see `pa_gift_card_currency` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/Payer_Authentication_SCMP_API.pdf)  For the possible values, see the [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf) 

        :param gift_card_currency: The gift_card_currency of this Riskv1authenticationsOrderInformationLineItems.
        :type: int
        """

        self._gift_card_currency = gift_card_currency

    @property
    def product_sku(self):
        """
        Gets the product_sku of this Riskv1authenticationsOrderInformationLineItems.
        Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling. 

        :return: The product_sku of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._product_sku

    @product_sku.setter
    def product_sku(self, product_sku):
        """
        Sets the product_sku of this Riskv1authenticationsOrderInformationLineItems.
        Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling. 

        :param product_sku: The product_sku of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._product_sku = product_sku

    @property
    def product_description(self):
        """
        Gets the product_description of this Riskv1authenticationsOrderInformationLineItems.
        Brief description of item.

        :return: The product_description of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._product_description

    @product_description.setter
    def product_description(self, product_description):
        """
        Sets the product_description of this Riskv1authenticationsOrderInformationLineItems.
        Brief description of item.

        :param product_description: The product_description of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._product_description = product_description

    @property
    def product_name(self):
        """
        Gets the product_name of this Riskv1authenticationsOrderInformationLineItems.
        For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :return: The product_name of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this Riskv1authenticationsOrderInformationLineItems.
        For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. 

        :param product_name: The product_name of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._product_name = product_name

    @property
    def passenger(self):
        """
        Gets the passenger of this Riskv1authenticationsOrderInformationLineItems.

        :return: The passenger of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: Ptsv2paymentsOrderInformationPassenger
        """
        return self._passenger

    @passenger.setter
    def passenger(self, passenger):
        """
        Sets the passenger of this Riskv1authenticationsOrderInformationLineItems.

        :param passenger: The passenger of this Riskv1authenticationsOrderInformationLineItems.
        :type: Ptsv2paymentsOrderInformationPassenger
        """

        self._passenger = passenger

    @property
    def shipping_destination_types(self):
        """
        Gets the shipping_destination_types of this Riskv1authenticationsOrderInformationLineItems.
        Destination to where the item will be shipped. Example: Commercial, Residential, Store 

        :return: The shipping_destination_types of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_destination_types

    @shipping_destination_types.setter
    def shipping_destination_types(self, shipping_destination_types):
        """
        Sets the shipping_destination_types of this Riskv1authenticationsOrderInformationLineItems.
        Destination to where the item will be shipped. Example: Commercial, Residential, Store 

        :param shipping_destination_types: The shipping_destination_types of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_destination_types = shipping_destination_types

    @property
    def tax_amount(self):
        """
        Gets the tax_amount of this Riskv1authenticationsOrderInformationLineItems.
        Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine 

        :return: The tax_amount of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount):
        """
        Sets the tax_amount of this Riskv1authenticationsOrderInformationLineItems.
        Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine 

        :param tax_amount: The tax_amount of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._tax_amount = tax_amount

    @property
    def shipping_address1(self):
        """
        Gets the shipping_address1 of this Riskv1authenticationsOrderInformationLineItems.
        Address where item will be shipped

        :return: The shipping_address1 of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_address1

    @shipping_address1.setter
    def shipping_address1(self, shipping_address1):
        """
        Sets the shipping_address1 of this Riskv1authenticationsOrderInformationLineItems.
        Address where item will be shipped

        :param shipping_address1: The shipping_address1 of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_address1 = shipping_address1

    @property
    def shipping_address2(self):
        """
        Gets the shipping_address2 of this Riskv1authenticationsOrderInformationLineItems.
        Address where item will be shipped

        :return: The shipping_address2 of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_address2

    @shipping_address2.setter
    def shipping_address2(self, shipping_address2):
        """
        Sets the shipping_address2 of this Riskv1authenticationsOrderInformationLineItems.
        Address where item will be shipped

        :param shipping_address2: The shipping_address2 of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_address2 = shipping_address2

    @property
    def shipping_city(self):
        """
        Gets the shipping_city of this Riskv1authenticationsOrderInformationLineItems.
        City where item will be shipped

        :return: The shipping_city of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_city

    @shipping_city.setter
    def shipping_city(self, shipping_city):
        """
        Sets the shipping_city of this Riskv1authenticationsOrderInformationLineItems.
        City where item will be shipped

        :param shipping_city: The shipping_city of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_city = shipping_city

    @property
    def shipping_country_code(self):
        """
        Gets the shipping_country_code of this Riskv1authenticationsOrderInformationLineItems.
        Country where item will be shipped

        :return: The shipping_country_code of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_country_code

    @shipping_country_code.setter
    def shipping_country_code(self, shipping_country_code):
        """
        Sets the shipping_country_code of this Riskv1authenticationsOrderInformationLineItems.
        Country where item will be shipped

        :param shipping_country_code: The shipping_country_code of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_country_code = shipping_country_code

    @property
    def shipping_first_name(self):
        """
        Gets the shipping_first_name of this Riskv1authenticationsOrderInformationLineItems.
        Customer's first name

        :return: The shipping_first_name of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_first_name

    @shipping_first_name.setter
    def shipping_first_name(self, shipping_first_name):
        """
        Sets the shipping_first_name of this Riskv1authenticationsOrderInformationLineItems.
        Customer's first name

        :param shipping_first_name: The shipping_first_name of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_first_name = shipping_first_name

    @property
    def shipping_last_name(self):
        """
        Gets the shipping_last_name of this Riskv1authenticationsOrderInformationLineItems.
        Customer's last name

        :return: The shipping_last_name of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_last_name

    @shipping_last_name.setter
    def shipping_last_name(self, shipping_last_name):
        """
        Sets the shipping_last_name of this Riskv1authenticationsOrderInformationLineItems.
        Customer's last name

        :param shipping_last_name: The shipping_last_name of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_last_name = shipping_last_name

    @property
    def shipping_middle_name(self):
        """
        Gets the shipping_middle_name of this Riskv1authenticationsOrderInformationLineItems.
        Customer's middle name

        :return: The shipping_middle_name of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_middle_name

    @shipping_middle_name.setter
    def shipping_middle_name(self, shipping_middle_name):
        """
        Sets the shipping_middle_name of this Riskv1authenticationsOrderInformationLineItems.
        Customer's middle name

        :param shipping_middle_name: The shipping_middle_name of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_middle_name = shipping_middle_name

    @property
    def shipping_phone(self):
        """
        Gets the shipping_phone of this Riskv1authenticationsOrderInformationLineItems.
        Phone number where item will be shipped

        :return: The shipping_phone of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: int
        """
        return self._shipping_phone

    @shipping_phone.setter
    def shipping_phone(self, shipping_phone):
        """
        Sets the shipping_phone of this Riskv1authenticationsOrderInformationLineItems.
        Phone number where item will be shipped

        :param shipping_phone: The shipping_phone of this Riskv1authenticationsOrderInformationLineItems.
        :type: int
        """

        self._shipping_phone = shipping_phone

    @property
    def shipping_postal_code(self):
        """
        Gets the shipping_postal_code of this Riskv1authenticationsOrderInformationLineItems.
        Postal code where item will be shipped

        :return: The shipping_postal_code of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: int
        """
        return self._shipping_postal_code

    @shipping_postal_code.setter
    def shipping_postal_code(self, shipping_postal_code):
        """
        Sets the shipping_postal_code of this Riskv1authenticationsOrderInformationLineItems.
        Postal code where item will be shipped

        :param shipping_postal_code: The shipping_postal_code of this Riskv1authenticationsOrderInformationLineItems.
        :type: int
        """

        self._shipping_postal_code = shipping_postal_code

    @property
    def shipping_state(self):
        """
        Gets the shipping_state of this Riskv1authenticationsOrderInformationLineItems.
        State where item will be shipped

        :return: The shipping_state of this Riskv1authenticationsOrderInformationLineItems.
        :rtype: str
        """
        return self._shipping_state

    @shipping_state.setter
    def shipping_state(self, shipping_state):
        """
        Sets the shipping_state of this Riskv1authenticationsOrderInformationLineItems.
        State where item will be shipped

        :param shipping_state: The shipping_state of this Riskv1authenticationsOrderInformationLineItems.
        :type: str
        """

        self._shipping_state = shipping_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1authenticationsOrderInformationLineItems):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
