# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class SearchTransactionsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config) 


    def create_search(self, create_search_request, **kwargs):
        """
        Create a search request
        Create a search request. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_search(create_search_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateSearchRequest create_search_request: (required)
        :return: TssV2TransactionsPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_search_with_http_info(create_search_request, **kwargs)
        else:
            (data) = self.create_search_with_http_info(create_search_request, **kwargs)
            return data

    def create_search_with_http_info(self, create_search_request, **kwargs):
        """
        Create a search request
        Create a search request. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_search_with_http_info(create_search_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateSearchRequest create_search_request: (required)
        :return: TssV2TransactionsPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_search_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_search_request' is set
        if ('create_search_request' not in params) or (params['create_search_request'] is None):
            raise ValueError("Missing the required parameter `create_search_request` when calling `create_search`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_search_request' in params:
            body_params = params['create_search_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/tss/v2/searches', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TssV2TransactionsPost201Response',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_search(self, search_id, **kwargs):
        """
        Get Search results
        Include the Search ID in the GET request to retrieve the search results. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_search(search_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str search_id: Search ID. (required)
        :return: TssV2TransactionsPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_search_with_http_info(search_id, **kwargs)
        else:
            (data) = self.get_search_with_http_info(search_id, **kwargs)
            return data

    def get_search_with_http_info(self, search_id, **kwargs):
        """
        Get Search results
        Include the Search ID in the GET request to retrieve the search results. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_search_with_http_info(search_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str search_id: Search ID. (required)
        :return: TssV2TransactionsPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'search_id' is set
        if ('search_id' not in params) or (params['search_id'] is None):
            raise ValueError("Missing the required parameter `search_id` when calling `get_search`")


        collection_formats = {}

        path_params = {}
        if 'search_id' in params:
            path_params['searchId'] = params['search_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/tss/v2/searches/' + search_id, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TssV2TransactionsPost201Response',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
