# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Riskv1decisionsCardVerification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'result_code': 'str'
    }

    attribute_map = {
        'result_code': 'resultCode'
    }

    def __init__(self, result_code=None):
        """
        Riskv1decisionsCardVerification - a model defined in Swagger
        """

        self._result_code = None

        if result_code is not None:
          self.result_code = result_code

    @property
    def result_code(self):
        """
        Gets the result_code of this Riskv1decisionsCardVerification.
        Result of card verification. Returned by the authorization service in the `processorInformation.cardVerification.resultCode` reply field. If ics_auth and ics_score are requested at the same time, the value is automatically passed from ics_auth to ics_score. For more information on using this field, see \"\"Sending the Results of Address and Card Verification Tests,\"\" page 16. The field contains one of the following values:   - `I`: Card verification number failed processor's data   validation check.   - `M`: Card verification number matched.   - `N`: Card verification number not matched.   - `P`: Card verification number not processed.   - `S`: Card verification number is on the card but was not included in the request.   - `U`: Card verification is not supported by the issuing bank.   - `X`: Card verification is not supported by the payment card company.   - Space Character: Deprecated. Ignore this value.   - `1`: CyberSource does not support card verification for this processor or card type.   - `2`: Processor returned value unrecognized for card verification response.   - `3`: Processor did not return card verification result code. 

        :return: The result_code of this Riskv1decisionsCardVerification.
        :rtype: str
        """
        return self._result_code

    @result_code.setter
    def result_code(self, result_code):
        """
        Sets the result_code of this Riskv1decisionsCardVerification.
        Result of card verification. Returned by the authorization service in the `processorInformation.cardVerification.resultCode` reply field. If ics_auth and ics_score are requested at the same time, the value is automatically passed from ics_auth to ics_score. For more information on using this field, see \"\"Sending the Results of Address and Card Verification Tests,\"\" page 16. The field contains one of the following values:   - `I`: Card verification number failed processor's data   validation check.   - `M`: Card verification number matched.   - `N`: Card verification number not matched.   - `P`: Card verification number not processed.   - `S`: Card verification number is on the card but was not included in the request.   - `U`: Card verification is not supported by the issuing bank.   - `X`: Card verification is not supported by the payment card company.   - Space Character: Deprecated. Ignore this value.   - `1`: CyberSource does not support card verification for this processor or card type.   - `2`: Processor returned value unrecognized for card verification response.   - `3`: Processor did not return card verification result code. 

        :param result_code: The result_code of this Riskv1decisionsCardVerification.
        :type: str
        """
        if result_code is not None and len(result_code) > 1:
            raise ValueError("Invalid value for `result_code`, length must be less than or equal to `1`")

        self._result_code = result_code

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1decisionsCardVerification):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
