# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Riskv1decisionsOrderInformationLineItems(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'unit_price': 'str',
        'quantity': 'float',
        'product_sku': 'str',
        'product_risk': 'str',
        'product_name': 'str',
        'product_code': 'str',
        'gift': 'str',
        'distributor_product_sku': 'str',
        'passenger': 'Riskv1decisionsOrderInformationPassenger'
    }

    attribute_map = {
        'unit_price': 'unitPrice',
        'quantity': 'quantity',
        'product_sku': 'productSKU',
        'product_risk': 'productRisk',
        'product_name': 'productName',
        'product_code': 'productCode',
        'gift': 'gift',
        'distributor_product_sku': 'distributorProductSku',
        'passenger': 'passenger'
    }

    def __init__(self, unit_price=None, quantity=None, product_sku=None, product_risk=None, product_name=None, product_code=None, gift='no', distributor_product_sku=None, passenger=None):
        """
        Riskv1decisionsOrderInformationLineItems - a model defined in Swagger
        """

        self._unit_price = None
        self._quantity = None
        self._product_sku = None
        self._product_risk = None
        self._product_name = None
        self._product_code = None
        self._gift = None
        self._distributor_product_sku = None
        self._passenger = None

        if unit_price is not None:
          self.unit_price = unit_price
        if quantity is not None:
          self.quantity = quantity
        if product_sku is not None:
          self.product_sku = product_sku
        if product_risk is not None:
          self.product_risk = product_risk
        if product_name is not None:
          self.product_name = product_name
        if product_code is not None:
          self.product_code = product_code
        if gift is not None:
          self.gift = gift
        if distributor_product_sku is not None:
          self.distributor_product_sku = distributor_product_sku
        if passenger is not None:
          self.passenger = passenger

    @property
    def unit_price(self):
        """
        Gets the unit_price of this Riskv1decisionsOrderInformationLineItems.
        Per-item price of the product. This value cannot be negative. You can include a decimal point (.), but you cannot include any other special characters. CyberSource truncates the amount to the correct number of decimal places.  For processor-specific information, see the amount field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html)  **Important** Some processors have specific requirements and limitations, such as maximum amounts and maximum field lengths. This information is covered in: - Table 12, \"Authorization Information for Specific Processors,\" on page 36 - Table 16, \"Capture Information for Specific Processors,\" on page 51 - Table 20, \"Credit Information for Specific Processors,\" on page 65  **DCC for First Data**\\ This value is the original amount in your local currency. You must include this field. You cannot use grand_total_amount. See \"Dynamic Currency Conversion for First Data,\" page 113.  **FDMS South**\\ If you accept IDR or CLP currencies, see the entry for FDMS South in Table 12, \"Authorization Information for Specific Processors,\" on page 36.  **Zero Amount Authorizations**\\ If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen. See \"Zero Amount Authorizations,\" page 220. 

        :return: The unit_price of this Riskv1decisionsOrderInformationLineItems.
        :rtype: str
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """
        Sets the unit_price of this Riskv1decisionsOrderInformationLineItems.
        Per-item price of the product. This value cannot be negative. You can include a decimal point (.), but you cannot include any other special characters. CyberSource truncates the amount to the correct number of decimal places.  For processor-specific information, see the amount field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html)  **Important** Some processors have specific requirements and limitations, such as maximum amounts and maximum field lengths. This information is covered in: - Table 12, \"Authorization Information for Specific Processors,\" on page 36 - Table 16, \"Capture Information for Specific Processors,\" on page 51 - Table 20, \"Credit Information for Specific Processors,\" on page 65  **DCC for First Data**\\ This value is the original amount in your local currency. You must include this field. You cannot use grand_total_amount. See \"Dynamic Currency Conversion for First Data,\" page 113.  **FDMS South**\\ If you accept IDR or CLP currencies, see the entry for FDMS South in Table 12, \"Authorization Information for Specific Processors,\" on page 36.  **Zero Amount Authorizations**\\ If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen. See \"Zero Amount Authorizations,\" page 220. 

        :param unit_price: The unit_price of this Riskv1decisionsOrderInformationLineItems.
        :type: str
        """
        if unit_price is not None and len(unit_price) > 15:
            raise ValueError("Invalid value for `unit_price`, length must be less than or equal to `15`")

        self._unit_price = unit_price

    @property
    def quantity(self):
        """
        Gets the quantity of this Riskv1decisionsOrderInformationLineItems.
        Number of units for this order. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to `default` or one of the other values that are related to shipping and/or handling. When `orderInformation.lineItems[].productCode` is `gift_card`, this is the total count of individual prepaid gift cards purchased. 

        :return: The quantity of this Riskv1decisionsOrderInformationLineItems.
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """
        Sets the quantity of this Riskv1decisionsOrderInformationLineItems.
        Number of units for this order. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to `default` or one of the other values that are related to shipping and/or handling. When `orderInformation.lineItems[].productCode` is `gift_card`, this is the total count of individual prepaid gift cards purchased. 

        :param quantity: The quantity of this Riskv1decisionsOrderInformationLineItems.
        :type: float
        """
        if quantity is not None and quantity > 9999999999:
            raise ValueError("Invalid value for `quantity`, must be a value less than or equal to `9999999999`")
        if quantity is not None and quantity < 1:
            raise ValueError("Invalid value for `quantity`, must be a value greater than or equal to `1`")

        self._quantity = quantity

    @property
    def product_sku(self):
        """
        Gets the product_sku of this Riskv1decisionsOrderInformationLineItems.
        Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when _orderInformation.lineItems[].productCode_ is not set to **default** or one of the other values that are related to shipping and/or handling. 

        :return: The product_sku of this Riskv1decisionsOrderInformationLineItems.
        :rtype: str
        """
        return self._product_sku

    @product_sku.setter
    def product_sku(self, product_sku):
        """
        Sets the product_sku of this Riskv1decisionsOrderInformationLineItems.
        Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when _orderInformation.lineItems[].productCode_ is not set to **default** or one of the other values that are related to shipping and/or handling. 

        :param product_sku: The product_sku of this Riskv1decisionsOrderInformationLineItems.
        :type: str
        """
        if product_sku is not None and len(product_sku) > 255:
            raise ValueError("Invalid value for `product_sku`, length must be less than or equal to `255`")

        self._product_sku = product_sku

    @property
    def product_risk(self):
        """
        Gets the product_risk of this Riskv1decisionsOrderInformationLineItems.
        Indicates the level of risk for the product. This field can contain one of the following values: - `low`: The product is associated with few chargebacks. - `normal`: The product is associated with a normal number of chargebacks. - `high`: The product is associated with many chargebacks. 

        :return: The product_risk of this Riskv1decisionsOrderInformationLineItems.
        :rtype: str
        """
        return self._product_risk

    @product_risk.setter
    def product_risk(self, product_risk):
        """
        Sets the product_risk of this Riskv1decisionsOrderInformationLineItems.
        Indicates the level of risk for the product. This field can contain one of the following values: - `low`: The product is associated with few chargebacks. - `normal`: The product is associated with a normal number of chargebacks. - `high`: The product is associated with many chargebacks. 

        :param product_risk: The product_risk of this Riskv1decisionsOrderInformationLineItems.
        :type: str
        """
        if product_risk is not None and len(product_risk) > 6:
            raise ValueError("Invalid value for `product_risk`, length must be less than or equal to `6`")

        self._product_risk = product_risk

    @property
    def product_name(self):
        """
        Gets the product_name of this Riskv1decisionsOrderInformationLineItems.
        For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to `default` or one of the other values that are related to shipping and/or handling. 

        :return: The product_name of this Riskv1decisionsOrderInformationLineItems.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this Riskv1decisionsOrderInformationLineItems.
        For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to `default` or one of the other values that are related to shipping and/or handling. 

        :param product_name: The product_name of this Riskv1decisionsOrderInformationLineItems.
        :type: str
        """
        if product_name is not None and len(product_name) > 255:
            raise ValueError("Invalid value for `product_name`, length must be less than or equal to `255`")

        self._product_name = product_name

    @property
    def product_code(self):
        """
        Gets the product_code of this Riskv1decisionsOrderInformationLineItems.
        Type of product. This value is used to determine the category that the product is in: electronic, handling, physical, service, or shipping. The default value is **default**. If you are performing an authorization transaction (`processingOptions.capture` is set to `false`), and you set this field to a value other than default or any of the values related to shipping and handling, then the fields `quantity`, `productName`, and `productSku` are required. It can also have a value of \"gift_card\".  See Appendix O, \"Product Codes,\" on page 373 for a list of valid values. For a payment, when you set this field to a value other than default or any of the values related to shipping and handling, below fields _quantity_, _productName_, and _productSKU_ are required. 

        :return: The product_code of this Riskv1decisionsOrderInformationLineItems.
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """
        Sets the product_code of this Riskv1decisionsOrderInformationLineItems.
        Type of product. This value is used to determine the category that the product is in: electronic, handling, physical, service, or shipping. The default value is **default**. If you are performing an authorization transaction (`processingOptions.capture` is set to `false`), and you set this field to a value other than default or any of the values related to shipping and handling, then the fields `quantity`, `productName`, and `productSku` are required. It can also have a value of \"gift_card\".  See Appendix O, \"Product Codes,\" on page 373 for a list of valid values. For a payment, when you set this field to a value other than default or any of the values related to shipping and handling, below fields _quantity_, _productName_, and _productSKU_ are required. 

        :param product_code: The product_code of this Riskv1decisionsOrderInformationLineItems.
        :type: str
        """
        if product_code is not None and len(product_code) > 255:
            raise ValueError("Invalid value for `product_code`, length must be less than or equal to `255`")

        self._product_code = product_code

    @property
    def gift(self):
        """
        Gets the gift of this Riskv1decisionsOrderInformationLineItems.
        Determines whether to assign risk to the order if the billing and shipping addresses specify different cities, states, or countries. This field can contain one of the following values: - `yes`: Orders are assigned only slight additional risk if billing and shipping addresses are different. - `no` (default): Orders are assigned higher additional risk if billing and shipping addresses are different. - `off`: Differences between billing and shipping addresses do not affect the score. 

        :return: The gift of this Riskv1decisionsOrderInformationLineItems.
        :rtype: str
        """
        return self._gift

    @gift.setter
    def gift(self, gift):
        """
        Sets the gift of this Riskv1decisionsOrderInformationLineItems.
        Determines whether to assign risk to the order if the billing and shipping addresses specify different cities, states, or countries. This field can contain one of the following values: - `yes`: Orders are assigned only slight additional risk if billing and shipping addresses are different. - `no` (default): Orders are assigned higher additional risk if billing and shipping addresses are different. - `off`: Differences between billing and shipping addresses do not affect the score. 

        :param gift: The gift of this Riskv1decisionsOrderInformationLineItems.
        :type: str
        """
        if gift is not None and len(gift) > 3:
            raise ValueError("Invalid value for `gift`, length must be less than or equal to `3`")

        self._gift = gift

    @property
    def distributor_product_sku(self):
        """
        Gets the distributor_product_sku of this Riskv1decisionsOrderInformationLineItems.
        Product’s identifier code. This field is inserted into the outgoing message without being parsed or formatted. This field is included as Distributor product SKU (Offer) in the list of API fields with which you can create custom rules. 

        :return: The distributor_product_sku of this Riskv1decisionsOrderInformationLineItems.
        :rtype: str
        """
        return self._distributor_product_sku

    @distributor_product_sku.setter
    def distributor_product_sku(self, distributor_product_sku):
        """
        Sets the distributor_product_sku of this Riskv1decisionsOrderInformationLineItems.
        Product’s identifier code. This field is inserted into the outgoing message without being parsed or formatted. This field is included as Distributor product SKU (Offer) in the list of API fields with which you can create custom rules. 

        :param distributor_product_sku: The distributor_product_sku of this Riskv1decisionsOrderInformationLineItems.
        :type: str
        """
        if distributor_product_sku is not None and len(distributor_product_sku) > 15:
            raise ValueError("Invalid value for `distributor_product_sku`, length must be less than or equal to `15`")

        self._distributor_product_sku = distributor_product_sku

    @property
    def passenger(self):
        """
        Gets the passenger of this Riskv1decisionsOrderInformationLineItems.

        :return: The passenger of this Riskv1decisionsOrderInformationLineItems.
        :rtype: Riskv1decisionsOrderInformationPassenger
        """
        return self._passenger

    @passenger.setter
    def passenger(self, passenger):
        """
        Sets the passenger of this Riskv1decisionsOrderInformationLineItems.

        :param passenger: The passenger of this Riskv1decisionsOrderInformationLineItems.
        :type: Riskv1decisionsOrderInformationPassenger
        """

        self._passenger = passenger

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1decisionsOrderInformationLineItems):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
