# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class GenerateUnifiedCheckoutCaptureContextRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'client_version': 'str',
        'target_origins': 'list[str]',
        'allowed_card_networks': 'list[str]',
        'allowed_payment_types': 'list[str]',
        'country': 'str',
        'locale': 'str',
        'capture_mandate': 'Upv1capturecontextsCaptureMandate',
        'order_information': 'Upv1capturecontextsOrderInformation'
    }

    attribute_map = {
        'client_version': 'clientVersion',
        'target_origins': 'targetOrigins',
        'allowed_card_networks': 'allowedCardNetworks',
        'allowed_payment_types': 'allowedPaymentTypes',
        'country': 'country',
        'locale': 'locale',
        'capture_mandate': 'captureMandate',
        'order_information': 'orderInformation'
    }

    def __init__(self, client_version=None, target_origins=None, allowed_card_networks=None, allowed_payment_types=None, country=None, locale=None, capture_mandate=None, order_information=None):
        """
        GenerateUnifiedCheckoutCaptureContextRequest - a model defined in Swagger
        """

        self._client_version = None
        self._target_origins = None
        self._allowed_card_networks = None
        self._allowed_payment_types = None
        self._country = None
        self._locale = None
        self._capture_mandate = None
        self._order_information = None

        if client_version is not None:
          self.client_version = client_version
        if target_origins is not None:
          self.target_origins = target_origins
        if allowed_card_networks is not None:
          self.allowed_card_networks = allowed_card_networks
        if allowed_payment_types is not None:
          self.allowed_payment_types = allowed_payment_types
        if country is not None:
          self.country = country
        if locale is not None:
          self.locale = locale
        if capture_mandate is not None:
          self.capture_mandate = capture_mandate
        if order_information is not None:
          self.order_information = order_information

    @property
    def client_version(self):
        """
        Gets the client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        Specify the version of Unified Checkout that you want to use.

        :return: The client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: str
        """
        return self._client_version

    @client_version.setter
    def client_version(self, client_version):
        """
        Sets the client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        Specify the version of Unified Checkout that you want to use.

        :param client_version: The client_version of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: str
        """

        self._client_version = client_version

    @property
    def target_origins(self):
        """
        Gets the target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.
        The [target origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the website on which you will be launching Unified Checkout is defined by the scheme (protocol), hostname (domain) and port number (if used).    You must use https://hostname (unless you use http://localhost) Wildcards are NOT supported.  Ensure that subdomains are included. Any valid top-level domain is supported (e.g. .com, .co.uk, .gov.br etc)  Examples:   - https://example.com   - https://subdomain.example.com   - https://example.com:8080<br><br>  If you are embedding within multiple nested iframes you need to specify the origins of all the browser contexts used, for example:    targetOrigins: [     \"https://example.com\",     \"https://basket.example.com\",     \"https://ecom.example.com\"   ] 

        :return: The target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: list[str]
        """
        return self._target_origins

    @target_origins.setter
    def target_origins(self, target_origins):
        """
        Sets the target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.
        The [target origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the website on which you will be launching Unified Checkout is defined by the scheme (protocol), hostname (domain) and port number (if used).    You must use https://hostname (unless you use http://localhost) Wildcards are NOT supported.  Ensure that subdomains are included. Any valid top-level domain is supported (e.g. .com, .co.uk, .gov.br etc)  Examples:   - https://example.com   - https://subdomain.example.com   - https://example.com:8080<br><br>  If you are embedding within multiple nested iframes you need to specify the origins of all the browser contexts used, for example:    targetOrigins: [     \"https://example.com\",     \"https://basket.example.com\",     \"https://ecom.example.com\"   ] 

        :param target_origins: The target_origins of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: list[str]
        """

        self._target_origins = target_origins

    @property
    def allowed_card_networks(self):
        """
        Gets the allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.
        The list of card networks you want to use for this Unified Checkout transaction.  Unified Checkout currently supports the following card networks:     - VISA     - MASTERCARD     - AMEX     - CARNET     - CARTESBANCAIRES     - CUP     - DINERSCLUB     - DISCOVER     - EFTPOS     - ELO     - JCB     - JCREW     - MADA     - MAESTRO     - MEEZA 

        :return: The allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: list[str]
        """
        return self._allowed_card_networks

    @allowed_card_networks.setter
    def allowed_card_networks(self, allowed_card_networks):
        """
        Sets the allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.
        The list of card networks you want to use for this Unified Checkout transaction.  Unified Checkout currently supports the following card networks:     - VISA     - MASTERCARD     - AMEX     - CARNET     - CARTESBANCAIRES     - CUP     - DINERSCLUB     - DISCOVER     - EFTPOS     - ELO     - JCB     - JCREW     - MADA     - MAESTRO     - MEEZA 

        :param allowed_card_networks: The allowed_card_networks of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: list[str]
        """

        self._allowed_card_networks = allowed_card_networks

    @property
    def allowed_payment_types(self):
        """
        Gets the allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.
        The payment types that are allowed for the merchant.    Possible values when launching Unified Checkout:   - APPLEPAY   - CHECK   - CLICKTOPAY   - GOOGLEPAY   - PANENTRY                 - PAZE <br><br>  Possible values when launching Click To Pay Drop-In UI: - CLICKTOPAY <br><br>  **Important:**    - CLICKTOPAY only available for Visa, Mastercard and AMEX for saved cards.   - Visa and Mastercard will look to tokenize using network tokenization for all Click to Pay requests.  Click to Pay uses Click to Pay token requester IDs and not the merchant's existing token requester.   - Apple Pay, Google Pay, Check, and Paze can be used independently without requiring PAN entry in the allowedPaymentTypes field. 

        :return: The allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: list[str]
        """
        return self._allowed_payment_types

    @allowed_payment_types.setter
    def allowed_payment_types(self, allowed_payment_types):
        """
        Sets the allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.
        The payment types that are allowed for the merchant.    Possible values when launching Unified Checkout:   - APPLEPAY   - CHECK   - CLICKTOPAY   - GOOGLEPAY   - PANENTRY                 - PAZE <br><br>  Possible values when launching Click To Pay Drop-In UI: - CLICKTOPAY <br><br>  **Important:**    - CLICKTOPAY only available for Visa, Mastercard and AMEX for saved cards.   - Visa and Mastercard will look to tokenize using network tokenization for all Click to Pay requests.  Click to Pay uses Click to Pay token requester IDs and not the merchant's existing token requester.   - Apple Pay, Google Pay, Check, and Paze can be used independently without requiring PAN entry in the allowedPaymentTypes field. 

        :param allowed_payment_types: The allowed_payment_types of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: list[str]
        """

        self._allowed_payment_types = allowed_payment_types

    @property
    def country(self):
        """
        Gets the country of this GenerateUnifiedCheckoutCaptureContextRequest.
        Country the purchase is originating from (e.g. country of the merchant).  Use the two-character ISO Standard 

        :return: The country of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this GenerateUnifiedCheckoutCaptureContextRequest.
        Country the purchase is originating from (e.g. country of the merchant).  Use the two-character ISO Standard 

        :param country: The country of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: str
        """

        self._country = country

    @property
    def locale(self):
        """
        Gets the locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        Localization of the User experience conforming to the ISO 639-1 language standards and two-character ISO Standard Country Code.  Please refer to list of [supported locales through Unified Checkout](https://developer.cybersource.com/docs/cybs/en-us/unified-checkout/developer/all/rest/unified-checkout/uc-appendix-languages.html) 

        :return: The locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        Localization of the User experience conforming to the ISO 639-1 language standards and two-character ISO Standard Country Code.  Please refer to list of [supported locales through Unified Checkout](https://developer.cybersource.com/docs/cybs/en-us/unified-checkout/developer/all/rest/unified-checkout/uc-appendix-languages.html) 

        :param locale: The locale of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: str
        """

        self._locale = locale

    @property
    def capture_mandate(self):
        """
        Gets the capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: Upv1capturecontextsCaptureMandate
        """
        return self._capture_mandate

    @capture_mandate.setter
    def capture_mandate(self, capture_mandate):
        """
        Sets the capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param capture_mandate: The capture_mandate of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: Upv1capturecontextsCaptureMandate
        """

        self._capture_mandate = capture_mandate

    @property
    def order_information(self):
        """
        Gets the order_information of this GenerateUnifiedCheckoutCaptureContextRequest.

        :return: The order_information of this GenerateUnifiedCheckoutCaptureContextRequest.
        :rtype: Upv1capturecontextsOrderInformation
        """
        return self._order_information

    @order_information.setter
    def order_information(self, order_information):
        """
        Sets the order_information of this GenerateUnifiedCheckoutCaptureContextRequest.

        :param order_information: The order_information of this GenerateUnifiedCheckoutCaptureContextRequest.
        :type: Upv1capturecontextsOrderInformation
        """

        self._order_information = order_information

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, GenerateUnifiedCheckoutCaptureContextRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
