# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class TmsNetworkTokenServicesMastercardDigitalEnablementService(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enable_service': 'bool',
        'enable_transactional_tokens': 'bool',
        'token_requestor_id': 'str'
    }

    attribute_map = {
        'enable_service': 'enableService',
        'enable_transactional_tokens': 'enableTransactionalTokens',
        'token_requestor_id': 'tokenRequestorId'
    }

    def __init__(self, enable_service=None, enable_transactional_tokens=None, token_requestor_id=None):
        """
        TmsNetworkTokenServicesMastercardDigitalEnablementService - a model defined in Swagger
        """

        self._enable_service = None
        self._enable_transactional_tokens = None
        self._token_requestor_id = None

        if enable_service is not None:
          self.enable_service = enable_service
        if enable_transactional_tokens is not None:
          self.enable_transactional_tokens = enable_transactional_tokens
        if token_requestor_id is not None:
          self.token_requestor_id = token_requestor_id

    @property
    def enable_service(self):
        """
        Gets the enable_service of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        Indicates if the service for network tokens for the Mastercard card association are enabled

        :return: The enable_service of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        :rtype: bool
        """
        return self._enable_service

    @enable_service.setter
    def enable_service(self, enable_service):
        """
        Sets the enable_service of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        Indicates if the service for network tokens for the Mastercard card association are enabled

        :param enable_service: The enable_service of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        :type: bool
        """

        self._enable_service = enable_service

    @property
    def enable_transactional_tokens(self):
        """
        Gets the enable_transactional_tokens of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        Indicates if network tokens for the Mastercard card association are enabled for transactions

        :return: The enable_transactional_tokens of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        :rtype: bool
        """
        return self._enable_transactional_tokens

    @enable_transactional_tokens.setter
    def enable_transactional_tokens(self, enable_transactional_tokens):
        """
        Sets the enable_transactional_tokens of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        Indicates if network tokens for the Mastercard card association are enabled for transactions

        :param enable_transactional_tokens: The enable_transactional_tokens of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        :type: bool
        """

        self._enable_transactional_tokens = enable_transactional_tokens

    @property
    def token_requestor_id(self):
        """
        Gets the token_requestor_id of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        Token Requestor ID provided by Mastercard during the registration process for the Tokenization Service  Pattern: ^[0-9]{11}\\\\z$\" Min Length: 11 Max Length: 11 Example:  \"50162233570\" 

        :return: The token_requestor_id of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        :rtype: str
        """
        return self._token_requestor_id

    @token_requestor_id.setter
    def token_requestor_id(self, token_requestor_id):
        """
        Sets the token_requestor_id of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        Token Requestor ID provided by Mastercard during the registration process for the Tokenization Service  Pattern: ^[0-9]{11}\\\\z$\" Min Length: 11 Max Length: 11 Example:  \"50162233570\" 

        :param token_requestor_id: The token_requestor_id of this TmsNetworkTokenServicesMastercardDigitalEnablementService.
        :type: str
        """

        self._token_requestor_id = token_requestor_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TmsNetworkTokenServicesMastercardDigitalEnablementService):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
