# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class UpdateWebhookRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'organization_id': 'str',
        'product_id': 'str',
        'event_types': 'list[str]',
        'webhook_url': 'str',
        'health_check_url': 'str',
        'status': 'str',
        'notification_scope': 'Notificationsubscriptionsv1webhooksNotificationScope',
        'retry_policy': 'Notificationsubscriptionsv1webhooksRetryPolicy',
        'security_policy': 'Notificationsubscriptionsv1webhooksSecurityPolicy',
        'additional_attributes': 'list[dict(str, str)]'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'organization_id': 'organizationId',
        'product_id': 'productId',
        'event_types': 'eventTypes',
        'webhook_url': 'webhookUrl',
        'health_check_url': 'healthCheckUrl',
        'status': 'status',
        'notification_scope': 'notificationScope',
        'retry_policy': 'retryPolicy',
        'security_policy': 'securityPolicy',
        'additional_attributes': 'additionalAttributes'
    }

    def __init__(self, name=None, description=None, organization_id=None, product_id=None, event_types=None, webhook_url=None, health_check_url=None, status='INACTIVE', notification_scope=None, retry_policy=None, security_policy=None, additional_attributes=None):
        """
        UpdateWebhookRequest - a model defined in Swagger
        """

        self._name = None
        self._description = None
        self._organization_id = None
        self._product_id = None
        self._event_types = None
        self._webhook_url = None
        self._health_check_url = None
        self._status = None
        self._notification_scope = None
        self._retry_policy = None
        self._security_policy = None
        self._additional_attributes = None

        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if organization_id is not None:
          self.organization_id = organization_id
        if product_id is not None:
          self.product_id = product_id
        if event_types is not None:
          self.event_types = event_types
        if webhook_url is not None:
          self.webhook_url = webhook_url
        if health_check_url is not None:
          self.health_check_url = health_check_url
        if status is not None:
          self.status = status
        if notification_scope is not None:
          self.notification_scope = notification_scope
        if retry_policy is not None:
          self.retry_policy = retry_policy
        if security_policy is not None:
          self.security_policy = security_policy
        if additional_attributes is not None:
          self.additional_attributes = additional_attributes

    @property
    def name(self):
        """
        Gets the name of this UpdateWebhookRequest.
        Client friendly webhook name.

        :return: The name of this UpdateWebhookRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UpdateWebhookRequest.
        Client friendly webhook name.

        :param name: The name of this UpdateWebhookRequest.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this UpdateWebhookRequest.
        Client friendly webhook description.\\

        :return: The description of this UpdateWebhookRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateWebhookRequest.
        Client friendly webhook description.\\

        :param description: The description of this UpdateWebhookRequest.
        :type: str
        """

        self._description = description

    @property
    def organization_id(self):
        """
        Gets the organization_id of this UpdateWebhookRequest.
        Organization Id.

        :return: The organization_id of this UpdateWebhookRequest.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this UpdateWebhookRequest.
        Organization Id.

        :param organization_id: The organization_id of this UpdateWebhookRequest.
        :type: str
        """

        self._organization_id = organization_id

    @property
    def product_id(self):
        """
        Gets the product_id of this UpdateWebhookRequest.
        The product you are receiving a webhook for.

        :return: The product_id of this UpdateWebhookRequest.
        :rtype: str
        """
        return self._product_id

    @product_id.setter
    def product_id(self, product_id):
        """
        Sets the product_id of this UpdateWebhookRequest.
        The product you are receiving a webhook for.

        :param product_id: The product_id of this UpdateWebhookRequest.
        :type: str
        """

        self._product_id = product_id

    @property
    def event_types(self):
        """
        Gets the event_types of this UpdateWebhookRequest.
        Array of the different events for a given product id.

        :return: The event_types of this UpdateWebhookRequest.
        :rtype: list[str]
        """
        return self._event_types

    @event_types.setter
    def event_types(self, event_types):
        """
        Sets the event_types of this UpdateWebhookRequest.
        Array of the different events for a given product id.

        :param event_types: The event_types of this UpdateWebhookRequest.
        :type: list[str]
        """

        self._event_types = event_types

    @property
    def webhook_url(self):
        """
        Gets the webhook_url of this UpdateWebhookRequest.
        The client's endpoint (URL) to receive webhooks.

        :return: The webhook_url of this UpdateWebhookRequest.
        :rtype: str
        """
        return self._webhook_url

    @webhook_url.setter
    def webhook_url(self, webhook_url):
        """
        Sets the webhook_url of this UpdateWebhookRequest.
        The client's endpoint (URL) to receive webhooks.

        :param webhook_url: The webhook_url of this UpdateWebhookRequest.
        :type: str
        """

        self._webhook_url = webhook_url

    @property
    def health_check_url(self):
        """
        Gets the health_check_url of this UpdateWebhookRequest.
        The client's health check endpoint (URL). This should be as close as possible to the actual webhookUrl.

        :return: The health_check_url of this UpdateWebhookRequest.
        :rtype: str
        """
        return self._health_check_url

    @health_check_url.setter
    def health_check_url(self, health_check_url):
        """
        Sets the health_check_url of this UpdateWebhookRequest.
        The client's health check endpoint (URL). This should be as close as possible to the actual webhookUrl.

        :param health_check_url: The health_check_url of this UpdateWebhookRequest.
        :type: str
        """

        self._health_check_url = health_check_url

    @property
    def status(self):
        """
        Gets the status of this UpdateWebhookRequest.
        Webhook status.

        :return: The status of this UpdateWebhookRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UpdateWebhookRequest.
        Webhook status.

        :param status: The status of this UpdateWebhookRequest.
        :type: str
        """

        self._status = status

    @property
    def notification_scope(self):
        """
        Gets the notification_scope of this UpdateWebhookRequest.

        :return: The notification_scope of this UpdateWebhookRequest.
        :rtype: Notificationsubscriptionsv1webhooksNotificationScope
        """
        return self._notification_scope

    @notification_scope.setter
    def notification_scope(self, notification_scope):
        """
        Sets the notification_scope of this UpdateWebhookRequest.

        :param notification_scope: The notification_scope of this UpdateWebhookRequest.
        :type: Notificationsubscriptionsv1webhooksNotificationScope
        """

        self._notification_scope = notification_scope

    @property
    def retry_policy(self):
        """
        Gets the retry_policy of this UpdateWebhookRequest.

        :return: The retry_policy of this UpdateWebhookRequest.
        :rtype: Notificationsubscriptionsv1webhooksRetryPolicy
        """
        return self._retry_policy

    @retry_policy.setter
    def retry_policy(self, retry_policy):
        """
        Sets the retry_policy of this UpdateWebhookRequest.

        :param retry_policy: The retry_policy of this UpdateWebhookRequest.
        :type: Notificationsubscriptionsv1webhooksRetryPolicy
        """

        self._retry_policy = retry_policy

    @property
    def security_policy(self):
        """
        Gets the security_policy of this UpdateWebhookRequest.

        :return: The security_policy of this UpdateWebhookRequest.
        :rtype: Notificationsubscriptionsv1webhooksSecurityPolicy
        """
        return self._security_policy

    @security_policy.setter
    def security_policy(self, security_policy):
        """
        Sets the security_policy of this UpdateWebhookRequest.

        :param security_policy: The security_policy of this UpdateWebhookRequest.
        :type: Notificationsubscriptionsv1webhooksSecurityPolicy
        """

        self._security_policy = security_policy

    @property
    def additional_attributes(self):
        """
        Gets the additional_attributes of this UpdateWebhookRequest.
        Additional, free form configuration data.

        :return: The additional_attributes of this UpdateWebhookRequest.
        :rtype: list[dict(str, str)]
        """
        return self._additional_attributes

    @additional_attributes.setter
    def additional_attributes(self, additional_attributes):
        """
        Sets the additional_attributes of this UpdateWebhookRequest.
        Additional, free form configuration data.

        :param additional_attributes: The additional_attributes of this UpdateWebhookRequest.
        :type: list[dict(str, str)]
        """

        self._additional_attributes = additional_attributes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UpdateWebhookRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
