# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Upv1capturecontextsCaptureMandate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'billing_type': 'str',
        'request_email': 'bool',
        'request_phone': 'bool',
        'request_shipping': 'bool',
        'ship_to_countries': 'list[str]',
        'show_accepted_network_icons': 'bool',
        'request_save_card': 'bool',
        'combo_card': 'bool'
    }

    attribute_map = {
        'billing_type': 'billingType',
        'request_email': 'requestEmail',
        'request_phone': 'requestPhone',
        'request_shipping': 'requestShipping',
        'ship_to_countries': 'shipToCountries',
        'show_accepted_network_icons': 'showAcceptedNetworkIcons',
        'request_save_card': 'requestSaveCard',
        'combo_card': 'comboCard'
    }

    def __init__(self, billing_type=None, request_email=None, request_phone=None, request_shipping=None, ship_to_countries=None, show_accepted_network_icons=None, request_save_card=None, combo_card=None):
        """
        Upv1capturecontextsCaptureMandate - a model defined in Swagger
        """

        self._billing_type = None
        self._request_email = None
        self._request_phone = None
        self._request_shipping = None
        self._ship_to_countries = None
        self._show_accepted_network_icons = None
        self._request_save_card = None
        self._combo_card = None

        if billing_type is not None:
          self.billing_type = billing_type
        if request_email is not None:
          self.request_email = request_email
        if request_phone is not None:
          self.request_phone = request_phone
        if request_shipping is not None:
          self.request_shipping = request_shipping
        if ship_to_countries is not None:
          self.ship_to_countries = ship_to_countries
        if show_accepted_network_icons is not None:
          self.show_accepted_network_icons = show_accepted_network_icons
        if request_save_card is not None:
          self.request_save_card = request_save_card
        if combo_card is not None:
          self.combo_card = combo_card

    @property
    def billing_type(self):
        """
        Gets the billing_type of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture billing address information.  Possible values: - FULL: Capture complete billing address information. - PARTIAL: Capture first name, last name, country and postal/zip code only. - NONE: Capture only first name and last name. 

        :return: The billing_type of this Upv1capturecontextsCaptureMandate.
        :rtype: str
        """
        return self._billing_type

    @billing_type.setter
    def billing_type(self, billing_type):
        """
        Sets the billing_type of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture billing address information.  Possible values: - FULL: Capture complete billing address information. - PARTIAL: Capture first name, last name, country and postal/zip code only. - NONE: Capture only first name and last name. 

        :param billing_type: The billing_type of this Upv1capturecontextsCaptureMandate.
        :type: str
        """

        self._billing_type = billing_type

    @property
    def request_email(self):
        """
        Gets the request_email of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture customer email address.  Possible values:  - True  - False 

        :return: The request_email of this Upv1capturecontextsCaptureMandate.
        :rtype: bool
        """
        return self._request_email

    @request_email.setter
    def request_email(self, request_email):
        """
        Sets the request_email of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture customer email address.  Possible values:  - True  - False 

        :param request_email: The request_email of this Upv1capturecontextsCaptureMandate.
        :type: bool
        """

        self._request_email = request_email

    @property
    def request_phone(self):
        """
        Gets the request_phone of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture customer phone number.  Possible values: - True - False 

        :return: The request_phone of this Upv1capturecontextsCaptureMandate.
        :rtype: bool
        """
        return self._request_phone

    @request_phone.setter
    def request_phone(self, request_phone):
        """
        Sets the request_phone of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture customer phone number.  Possible values: - True - False 

        :param request_phone: The request_phone of this Upv1capturecontextsCaptureMandate.
        :type: bool
        """

        self._request_phone = request_phone

    @property
    def request_shipping(self):
        """
        Gets the request_shipping of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture customer shipping details.  Possible values: - True - False 

        :return: The request_shipping of this Upv1capturecontextsCaptureMandate.
        :rtype: bool
        """
        return self._request_shipping

    @request_shipping.setter
    def request_shipping(self, request_shipping):
        """
        Sets the request_shipping of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to capture customer shipping details.  Possible values: - True - False 

        :param request_shipping: The request_shipping of this Upv1capturecontextsCaptureMandate.
        :type: bool
        """

        self._request_shipping = request_shipping

    @property
    def ship_to_countries(self):
        """
        Gets the ship_to_countries of this Upv1capturecontextsCaptureMandate.
        List of countries available to ship to.   Use the two-character ISO Standard Country Codes. 

        :return: The ship_to_countries of this Upv1capturecontextsCaptureMandate.
        :rtype: list[str]
        """
        return self._ship_to_countries

    @ship_to_countries.setter
    def ship_to_countries(self, ship_to_countries):
        """
        Sets the ship_to_countries of this Upv1capturecontextsCaptureMandate.
        List of countries available to ship to.   Use the two-character ISO Standard Country Codes. 

        :param ship_to_countries: The ship_to_countries of this Upv1capturecontextsCaptureMandate.
        :type: list[str]
        """

        self._ship_to_countries = ship_to_countries

    @property
    def show_accepted_network_icons(self):
        """
        Gets the show_accepted_network_icons of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to display the list of accepted card networks beneath the payment button  Possible values: - True - False 

        :return: The show_accepted_network_icons of this Upv1capturecontextsCaptureMandate.
        :rtype: bool
        """
        return self._show_accepted_network_icons

    @show_accepted_network_icons.setter
    def show_accepted_network_icons(self, show_accepted_network_icons):
        """
        Sets the show_accepted_network_icons of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to display the list of accepted card networks beneath the payment button  Possible values: - True - False 

        :param show_accepted_network_icons: The show_accepted_network_icons of this Upv1capturecontextsCaptureMandate.
        :type: bool
        """

        self._show_accepted_network_icons = show_accepted_network_icons

    @property
    def request_save_card(self):
        """
        Gets the request_save_card of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to display the \"Save card for future use\" checkbox.<br>  Configurable check box that will show in a Manual card entry flow to allow a Cardholder to give consent to store their manually entered credential with the Merchant that they are paying.<br>  Applicable when manually entering the details and not enrolling in Click to Pay.  Possible values:  - True   - False<br><br>  **Use Cases:**  **Offer consumers option to save their card in Unified Checkout:**  - Include the captureMandate.requestSaveCard field in the capture context request and set it to true. - When set to true, this will show a checkbox with the message 'Save card for future use' in Unified Checkout. - When selected this provides a response in both the Transient Token and Get Credentials API response.<br><br>  **Do not offer consumers the option to save their card in Unified Checkout:**  - Include the captureMandate.requestSaveCard field in the capture context request and set it to false OR omit the field from the capture context request. - When set to false, the save card option is not shown to consumers when manually entering card details. 

        :return: The request_save_card of this Upv1capturecontextsCaptureMandate.
        :rtype: bool
        """
        return self._request_save_card

    @request_save_card.setter
    def request_save_card(self, request_save_card):
        """
        Sets the request_save_card of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to display the \"Save card for future use\" checkbox.<br>  Configurable check box that will show in a Manual card entry flow to allow a Cardholder to give consent to store their manually entered credential with the Merchant that they are paying.<br>  Applicable when manually entering the details and not enrolling in Click to Pay.  Possible values:  - True   - False<br><br>  **Use Cases:**  **Offer consumers option to save their card in Unified Checkout:**  - Include the captureMandate.requestSaveCard field in the capture context request and set it to true. - When set to true, this will show a checkbox with the message 'Save card for future use' in Unified Checkout. - When selected this provides a response in both the Transient Token and Get Credentials API response.<br><br>  **Do not offer consumers the option to save their card in Unified Checkout:**  - Include the captureMandate.requestSaveCard field in the capture context request and set it to false OR omit the field from the capture context request. - When set to false, the save card option is not shown to consumers when manually entering card details. 

        :param request_save_card: The request_save_card of this Upv1capturecontextsCaptureMandate.
        :type: bool
        """

        self._request_save_card = request_save_card

    @property
    def combo_card(self):
        """
        Gets the combo_card of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to display combo card at checkout.<br>  A combo debit/credit card is a single card that functions both as a Debit/Credit card.  Unified Checkout / Click to Pay Drop-in UI allows the Cardholder to choose whether they would like the transaction to be paid for using either debit or credit card. **Important:** This is applicable to Visa cards only.  Possible values: - True  - False<br><br>  **Use Cases:**  **Offer Combo Card at Checkout:**  - Include the captureMandate.comboCard field in the capture context request and set it to true. - When set to true, Combo Card selection is shown at checkout <br><br>  **Do not offer Combo Card at Checkout:**  - Include the captureMandate.comboCard field in the capture context request and set it to false OR omit the field from the capture context request. - The Combo Card selection is not shown at checkout. 

        :return: The combo_card of this Upv1capturecontextsCaptureMandate.
        :rtype: bool
        """
        return self._combo_card

    @combo_card.setter
    def combo_card(self, combo_card):
        """
        Sets the combo_card of this Upv1capturecontextsCaptureMandate.
        Configure Unified Checkout to display combo card at checkout.<br>  A combo debit/credit card is a single card that functions both as a Debit/Credit card.  Unified Checkout / Click to Pay Drop-in UI allows the Cardholder to choose whether they would like the transaction to be paid for using either debit or credit card. **Important:** This is applicable to Visa cards only.  Possible values: - True  - False<br><br>  **Use Cases:**  **Offer Combo Card at Checkout:**  - Include the captureMandate.comboCard field in the capture context request and set it to true. - When set to true, Combo Card selection is shown at checkout <br><br>  **Do not offer Combo Card at Checkout:**  - Include the captureMandate.comboCard field in the capture context request and set it to false OR omit the field from the capture context request. - The Combo Card selection is not shown at checkout. 

        :param combo_card: The combo_card of this Upv1capturecontextsCaptureMandate.
        :type: bool
        """

        self._combo_card = combo_card

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Upv1capturecontextsCaptureMandate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
