# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class ManageWebhooksApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def notification_subscriptions_v1_webhooks_webhook_id_post(self, webhook_id, **kwargs):
        """
        Test a Webhook Configuration
        Test the webhook configuration by sending a sample webhook. Calling this endpoint sends a sample webhook to the endpoint identified in the user's subscription.   It will contain sample values for the product & eventType based on values present in your subscription along with a sample message in the payload.   Based on the webhook response users can make any necessary modifications or rest assured knowing their setup is configured correctly. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v1_webhooks_webhook_id_post(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :return: InlineResponse2014
                 If the method is called asynchronously,
                 returns the request thread.

        DISCLAIMER:
                Cybersource may allow Customer to access, use, and/or test a Cybersource product or service that may still be in development or has not been market-tested ("Beta Product") solely for the purpose of evaluating the functionality or marketability of the Beta Product (a "Beta Evaluation"). Notwithstanding any language to the contrary, the following terms shall apply with respect to Customer's participation in any Beta Evaluation (and the Beta Product(s)) accessed thereunder): The Parties will enter into a separate form agreement detailing the scope of the Beta Evaluation, requirements, pricing, the length of the beta evaluation period ("Beta Product Form"). Beta Products are not, and may not become, Transaction Services and have not yet been publicly released and are offered for the sole purpose of internal testing and non-commercial evaluation. Customer's use of the Beta Product shall be solely for the purpose of conducting the Beta Evaluation. Customer accepts all risks arising out of the access and use of the Beta Products. Cybersource may, in its sole discretion, at any time, terminate or discontinue the Beta Evaluation. Customer acknowledges and agrees that any Beta Product may still be in development and that Beta Product is provided "AS IS" and may not perform at the level of a commercially available service, may not operate as expected and may be modified prior to release. CYBERSOURCE SHALL NOT BE RESPONSIBLE OR LIABLE UNDER ANY CONTRACT, TORT (INCLUDING NEGLIGENCE), OR OTHERWISE RELATING TO A BETA PRODUCT OR THE BETA EVALUATION (A) FOR LOSS OR INACCURACY OF DATA OR COST OF PROCUREMENT OF SUBSTITUTE GOODS, SERVICES OR TECHNOLOGY, (B) ANY CLAIM, LOSSES, DAMAGES, OR CAUSE OF ACTION ARISING IN CONNECTION WITH THE BETA PRODUCT; OR (C) FOR ANY INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES INCLUDING, BUT NOT LIMITED TO, LOSS OF REVENUES AND LOSS OF PROFITS.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `notification_subscriptions_v1_webhooks_webhook_id_post` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(webhook_id, **kwargs)
        else:
            (data) = self.notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(webhook_id, **kwargs)
            return data

    def notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(self, webhook_id, **kwargs):
        """
        Test a Webhook Configuration
        Test the webhook configuration by sending a sample webhook. Calling this endpoint sends a sample webhook to the endpoint identified in the user's subscription.   It will contain sample values for the product & eventType based on values present in your subscription along with a sample message in the payload.   Based on the webhook response users can make any necessary modifications or rest assured knowing their setup is configured correctly. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :return: InlineResponse2014
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_subscriptions_v1_webhooks_webhook_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params) or (params['webhook_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `webhook_id` when calling `notification_subscriptions_v1_webhooks_webhook_id_post`")
            raise ValueError("Missing the required parameter `webhook_id` when calling `notification_subscriptions_v1_webhooks_webhook_id_post`")


        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']
            webhookId=webhook_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'POST' in ('POST'):
            body_params = '{}'

        if 'POST' == GlobalLabelParameters.POST or 'POST' == GlobalLabelParameters.PUT or 'POST' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "notification_subscriptions_v1_webhooks_webhook_id_post,notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v1/webhooks/{webhookId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InlineResponse2014',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def save_asym_egress_key(self, v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs):
        """
        Message Level Encryption
        Store and manage certificates that will be used to preform Message Level Encryption (MLE). Each new webhook will need its own unique asymmetric certificate. You can either use a digital certificate issued/signed by a CA or self-sign your own using the documentation available on the Developer Guide. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_asym_egress_key(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str v_c_sender_organization_id: Sender organization id (required)
        :param str v_c_permissions: Encoded user permissions returned by the CGK, for the entity user who initiated the boarding (required)
        :param SaveAsymEgressKey save_asym_egress_key: Provide egress Asymmetric key information to save (create or store) (required)
        :param str v_c_correlation_id: A globally unique id associated with your request
        :return: InlineResponse2015
                 If the method is called asynchronously,
                 returns the request thread.

        DISCLAIMER:
                Cybersource may allow Customer to access, use, and/or test a Cybersource product or service that may still be in development or has not been market-tested ("Beta Product") solely for the purpose of evaluating the functionality or marketability of the Beta Product (a "Beta Evaluation"). Notwithstanding any language to the contrary, the following terms shall apply with respect to Customer's participation in any Beta Evaluation (and the Beta Product(s)) accessed thereunder): The Parties will enter into a separate form agreement detailing the scope of the Beta Evaluation, requirements, pricing, the length of the beta evaluation period ("Beta Product Form"). Beta Products are not, and may not become, Transaction Services and have not yet been publicly released and are offered for the sole purpose of internal testing and non-commercial evaluation. Customer's use of the Beta Product shall be solely for the purpose of conducting the Beta Evaluation. Customer accepts all risks arising out of the access and use of the Beta Products. Cybersource may, in its sole discretion, at any time, terminate or discontinue the Beta Evaluation. Customer acknowledges and agrees that any Beta Product may still be in development and that Beta Product is provided "AS IS" and may not perform at the level of a commercially available service, may not operate as expected and may be modified prior to release. CYBERSOURCE SHALL NOT BE RESPONSIBLE OR LIABLE UNDER ANY CONTRACT, TORT (INCLUDING NEGLIGENCE), OR OTHERWISE RELATING TO A BETA PRODUCT OR THE BETA EVALUATION (A) FOR LOSS OR INACCURACY OF DATA OR COST OF PROCUREMENT OF SUBSTITUTE GOODS, SERVICES OR TECHNOLOGY, (B) ANY CLAIM, LOSSES, DAMAGES, OR CAUSE OF ACTION ARISING IN CONNECTION WITH THE BETA PRODUCT; OR (C) FOR ANY INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES INCLUDING, BUT NOT LIMITED TO, LOSS OF REVENUES AND LOSS OF PROFITS.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `save_asym_egress_key` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.save_asym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs)
        else:
            (data) = self.save_asym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs)
            return data

    def save_asym_egress_key_with_http_info(self, v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs):
        """
        Message Level Encryption
        Store and manage certificates that will be used to preform Message Level Encryption (MLE). Each new webhook will need its own unique asymmetric certificate. You can either use a digital certificate issued/signed by a CA or self-sign your own using the documentation available on the Developer Guide. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_asym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str v_c_sender_organization_id: Sender organization id (required)
        :param str v_c_permissions: Encoded user permissions returned by the CGK, for the entity user who initiated the boarding (required)
        :param SaveAsymEgressKey save_asym_egress_key: Provide egress Asymmetric key information to save (create or store) (required)
        :param str v_c_correlation_id: A globally unique id associated with your request
        :return: InlineResponse2015
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['v_c_sender_organization_id', 'v_c_permissions', 'save_asym_egress_key', 'v_c_correlation_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_asym_egress_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'v_c_sender_organization_id' is set
        if ('v_c_sender_organization_id' not in params) or (params['v_c_sender_organization_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_sender_organization_id` when calling `save_asym_egress_key`")
            raise ValueError("Missing the required parameter `v_c_sender_organization_id` when calling `save_asym_egress_key`")
        # verify the required parameter 'v_c_permissions' is set
        if ('v_c_permissions' not in params) or (params['v_c_permissions'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_permissions` when calling `save_asym_egress_key`")
            raise ValueError("Missing the required parameter `v_c_permissions` when calling `save_asym_egress_key`")
        # verify the required parameter 'save_asym_egress_key' is set
        if ('save_asym_egress_key' not in params) or (params['save_asym_egress_key'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `save_asym_egress_key` when calling `save_asym_egress_key`")
            raise ValueError("Missing the required parameter `save_asym_egress_key` when calling `save_asym_egress_key`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'v_c_correlation_id' in params:
            header_params['v-c-correlation-id'] = params['v_c_correlation_id']
        if 'v_c_sender_organization_id' in params:
            header_params['v-c-sender-organization-id'] = params['v_c_sender_organization_id']
        if 'v_c_permissions' in params:
            header_params['v-c-permissions'] = params['v_c_permissions']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'save_asym_egress_key' in params:
            body_params = params['save_asym_egress_key']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'save_asym_egress_key', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)

        if 'POST' == GlobalLabelParameters.POST or 'POST' == GlobalLabelParameters.PUT or 'POST' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "save_asym_egress_key,save_asym_egress_key_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/kms/egress/v2/keys-asym', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InlineResponse2015',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
